/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.trace.appender;

import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.appender.Parameters;
import com.cognos.xqe.trace.appender.XQELogAppender;
import com.cognos.xqe.trace.logger.LogEvent;
import com.cognos.xqe.util.Pair;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XQESLF4JAppender
extends XQELogAppender {
    private final ConcurrentMap<Pair, Logger> loggerCache = new ConcurrentHashMap<Pair, Logger>();

    public XQESLF4JAppender(Parameters param) {
        super(param);
    }

    @Override
    public void addEvent(LogEvent event) {
        Logger logger = this.getSLF4JLogger(event.getComponent(), event.getEventGroup());
        LogLevel level = event.getLevel();
        switch (level) {
            case TRACE: {
                logger.trace(event.getLogMessage().getMessage());
                break;
            }
            case INFO: {
                logger.info(event.getLogMessage().getMessage());
                break;
            }
            case WARN: {
                logger.warn(event.getLogMessage().getMessage());
                break;
            }
            case ERROR: 
            case CRITICAL: {
                logger.error(event.getLogMessage().getMessage());
                break;
            }
        }
    }

    @Override
    public void commit() {
    }

    @Override
    public boolean useAppenderIsOn() {
        return true;
    }

    @Override
    public boolean isOn(String component, String eventGroup, LogLevel level) {
        Logger logger = this.getSLF4JLogger(component, eventGroup);
        switch (level) {
            case TRACE: {
                return logger.isTraceEnabled() || logger.isDebugEnabled();
            }
            case INFO: {
                return logger.isInfoEnabled();
            }
            case WARN: {
                return logger.isWarnEnabled();
            }
            case ERROR: 
            case CRITICAL: {
                return logger.isErrorEnabled();
            }
        }
        return false;
    }

    private Logger getSLF4JLogger(String component, String eventGroup) {
        Logger conflict;
        Pair cacheKey = new Pair(component, eventGroup);
        Logger logger = (Logger)this.loggerCache.get(cacheKey);
        if (null == logger && null != (conflict = this.loggerCache.putIfAbsent(cacheKey, logger = LoggerFactory.getLogger((String)XQESLF4JAppender.getLoggerName(component, eventGroup))))) {
            return conflict;
        }
        return logger;
    }

    private static String getLoggerName(String component, String eventGroup) {
        return new StringBuilder(component.length() + eventGroup.length() + ".".length()).append(component).append(".").append(eventGroup).toString();
    }
}

