/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.decomposition;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5JoinOperation;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5QueryOperation;
import com.cognos.xqe.ast.v5.query.V5QueryRef;
import com.cognos.xqe.ast.v5.query.V5Source;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;

public class BindQueryOperationReferences
extends Transformation {
    public BindQueryOperationReferences() {
        this.mName = "Bind query operation references data items.";
        this.mPassNumbers = new int[]{7};
        this.mTypes = new int[]{101006};
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        V5Query query = (V5Query)node;
        V5Source source = query.getV5Source();
        V5QueryOperation queryOperation = (V5QueryOperation)source.getFirstChildByType(101018);
        V5QuerySet querySet = (V5QuerySet)query.getAncestorOfType(101002);
        if (queryOperation != null) {
            IXQEQueryNode[] v5QueryRefOperands;
            for (IXQEQueryNode iter : v5QueryRefOperands = queryOperation.getChildrenOfType(101023)) {
                V5QueryRef v5QueryRefOperand = (V5QueryRef)iter;
                String queryName = (String)v5QueryRefOperand.getPropertyValue("refQuery");
                V5Query operand = querySet.getV5Query(queryName);
                if (!operand.isTabular()) continue;
                this.traceQueryCondition(false, "The query does not have query operation with only olap operands.", trace);
                return false;
            }
            this.traceQueryCondition(true, "Bind query operation refs with only olap operands.", trace);
            return true;
        }
        V5JoinOperation joinOperation = (V5JoinOperation)source.getFirstChildByType(101019);
        if (joinOperation != null) {
            IXQEQueryNode[] v5JoinOperands;
            for (IXQEQueryNode iter : v5JoinOperands = joinOperation.getChildrenOfType(101021)) {
                String joinQueryName = (String)iter.getPropertyValue("queryRef");
                V5Query joinQuery = querySet.getV5QueryExternal(joinQueryName);
                if (!joinQuery.isTabular()) continue;
                this.traceQueryCondition(false, "The query does not have join operation with only olap operands.", trace);
                return false;
            }
            this.traceQueryCondition(true, "Bind join operation refs with only olap operands.", trace);
            return true;
        }
        this.traceQueryCondition(false, "The query does not have query operation.", trace);
        return false;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        V5Query query = (V5Query)node;
        query.setPropertyValue("hasOlapOperand", true);
        query.setPropertyValue("relationalSubquerySource", V5Query.RelationalSubquerySource.REL_DECOMPOSITION_FROM_OLAP.getName());
    }
}

