/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.decomposition;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Selection;
import com.cognos.xqe.ast.v5.result.V5QueryResultDefinition;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.ast.v5Exp.V5CastFunction;
import com.cognos.xqe.ast.v5Exp.V5CastTarget;
import com.cognos.xqe.ast.v5Exp.V5SimpleNode;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.metadata.IQueryItem;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5.binding.IdentifyGroupedProperties;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.ArrayList;
import java.util.List;

public class CastGroupedProperties
extends Transformation {
    public CastGroupedProperties() {
        this.mName = "Insert cast function on data items value expressions based on properties projected in valuesets which are grouping the result.";
        this.mPassNumbers = new int[]{9};
        this.mTypes = new int[]{101055};
        this.mApplicableIterations = QTEAbstractTransformation.ApplicableIterations.INITIAL;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        V5QueryResultDefinition qrd = (V5QueryResultDefinition)node;
        if (CastGroupedProperties.getGroupedDataItems(qrd).size() > 0) {
            this.traceNodeCondition(true, "There are grouped data items in the qrd.", trace);
            return true;
        }
        this.traceNodeCondition(false, "There are no grouped data items in the qrd.", trace);
        return false;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        V5QueryResultDefinition qrd = (V5QueryResultDefinition)node;
        List<V5DataItem> items = CastGroupedProperties.getGroupedDataItems(qrd);
        for (V5DataItem dataItem : items) {
            IXQEQueryNode valueExpression = dataItem.getChild(0);
            while (!valueExpression.isOfCategory(201120)) {
                valueExpression = valueExpression.getChild(0);
            }
            IQueryItem property = IdentifyGroupedProperties.getPropertyMetadata(dataItem.getChild(0));
            if (dataItem.getPropertyValue("label") == null) {
                String label = property.getCaption();
                dataItem.setPropertyValue("label", label);
                dataItem.setPropertyValue("isLabelFromModel", Boolean.TRUE);
            }
            V5CastFunction castFunction = (V5CastFunction)nodeFactory.createNode(201051);
            castFunction.setPropertyValue("forceDMRtoRQP", Boolean.TRUE);
            valueExpression.insertParent(castFunction);
            V5CastTarget castTarget = (V5CastTarget)nodeFactory.createNode(201052);
            IDataType dataType = ((V5SimpleNode)valueExpression).getDataType();
            castTarget.setDataType(dataType);
            castFunction.addChild(castTarget);
        }
    }

    public static List<V5DataItem> getGroupedDataItems(V5QueryResultDefinition qrd) {
        IXQEQueryNode[] edges;
        ArrayList<V5DataItem> items = new ArrayList<V5DataItem>();
        String qName = qrd.getRefQueryProperty();
        V5QuerySet querySet = (V5QuerySet)qrd.getAncestorOfType(101002);
        V5Query query = querySet.getV5Query(qName);
        V5Selection selection = query.getV5Selection();
        for (IXQEQueryNode edge : edges = qrd.getChildrenOfType(101049)) {
            for (IXQEQueryNode valueSetNode : edge.getDescendantsOfType(101057, false)) {
                String refDataItemName;
                V5DataItem dataItem;
                V5ValueSet valueSet = (V5ValueSet)valueSetNode;
                if (valueSet.getPropertyValue("isGroupedProperty") != Boolean.TRUE || (dataItem = selection.getDataItemByRefName(refDataItemName = valueSet.getRefDataItemProperty())) == null) continue;
                items.add(dataItem);
            }
        }
        return items;
    }
}

