/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.decomposition;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5QueryOperation;
import com.cognos.xqe.ast.v5Exp.V5BoundDataItemReference;
import com.cognos.xqe.ast.v5Exp.util.V5ExpressionCheck;
import com.cognos.xqe.ast.v5Exp.util.V5ExpressionTypeEnum;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5.ExpandDataItemReferences;
import com.cognos.xqeqte.QTEAbstractTransformation;

public class CoerceQueryOperationDataItems
extends Transformation {
    public CoerceQueryOperationDataItems() {
        this.mName = "Coerce set operation data items.";
        this.mPassNumbers = new int[]{21};
        this.mTypes = new int[]{101018};
        this.mMode = QTEAbstractTransformation.Mode.BOTTOM_UP;
        this.mApplicableIterations = QTEAbstractTransformation.ApplicableIterations.INITIAL;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        V5QueryOperation queryOperation = (V5QueryOperation)node;
        V5Query[] v5Queries = queryOperation.getReferencedV5Queries(environment);
        IXQEQueryNode[][] querySelectionsDataItems = new IXQEQueryNode[v5Queries.length][];
        for (int i = 0; i < v5Queries.length; ++i) {
            querySelectionsDataItems[i] = v5Queries[i].getV5Selection().getChildrenOfTypeOrdered(101003);
        }
        Boolean coerced = Boolean.FALSE;
        for (int i = 0; i < querySelectionsDataItems[0].length; ++i) {
            for (int j = 0; j < v5Queries.length; ++j) {
                if (!this.isItemToCoerce(V5ExpressionCheck.getExpressionType(querySelectionsDataItems[j][i]))) continue;
                this.expandDataItemReferences(environment, (V5DataItem)querySelectionsDataItems[j][i]);
                IXQEQueryNode v5MembersNode = factory.createNode(201086);
                querySelectionsDataItems[j][i].getChild(0).getChild(0).insertParent(v5MembersNode);
                coerced = Boolean.TRUE;
            }
        }
        queryOperation.setPropertyValue("member_coerced", coerced);
    }

    void expandDataItemReferences(PlanningEnvironment environment, V5DataItem item) {
        IXQEQueryNode[] refs;
        IXQEQueryNode query = item.getAncestorOfType(101006);
        for (IXQEQueryNode ref : refs = query.getDescendantsOfType(201060, false)) {
            V5BoundDataItemReference dataItemRef = (V5BoundDataItemReference)ref;
            V5DataItem refDataItem = dataItemRef.getRefDataItem();
            if (!refDataItem.equals(item)) continue;
            ExpandDataItemReferences.processNode(dataItemRef, environment);
        }
    }

    boolean isItemToCoerce(V5ExpressionTypeEnum type) {
        return type == V5ExpressionTypeEnum.HIERARCHY || type == V5ExpressionTypeEnum.LEVEL;
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = true;
        V5QueryOperation queryOperation = (V5QueryOperation)node;
        V5Query[] v5Queries = queryOperation.getReferencedV5Queries(environment);
        if (v5Queries.length == 0) {
            this.traceQueryCondition(false, "Not decomposed copy of Query operation.", trace);
            return false;
        }
        int itemNumber = v5Queries[0].getV5Selection().getChildrenOfType(101003).length;
        for (int i = 0; i < v5Queries.length; ++i) {
            if (v5Queries[i].isTabular()) {
                this.traceQueryCondition(false, "Not all queries in Query operation are OLAP.", trace);
                return false;
            }
            if (i == 0 || itemNumber == v5Queries[i].getV5Selection().getChildrenOfType(101003).length) continue;
            this.traceQueryCondition(false, "Different number of items in the set operation queries.", trace);
            return false;
        }
        return status;
    }
}

