/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.decomposition;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.result.V5DataItemRef;
import com.cognos.xqe.ast.v5.result.V5QueryResultDefinition;
import com.cognos.xqe.ast.v5.result.V5SortItem;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.ast.v5Exp.V5LiteralValue;
import com.cognos.xqe.ast.v5Exp.V5MembersFunction;
import com.cognos.xqe.ast.v5Exp.V5RoleValueFunction;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IQueryItem;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.metadata.MetadataUtil;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.decomposition.DecomposeScalarFunction;
import com.cognos.xqeqte.QTEAbstractTransformation;

public class ConvertCustomPropertyToRoleValue
extends Transformation {
    private static final String IS_NOT_APPLICABLE = "Convert custom member property to roleValue function is not applicable.";

    public ConvertCustomPropertyToRoleValue() {
        this.mName = "Convert custom member property to roleValue function.";
        this.mPassNumbers = new int[]{9};
        this.mTypes = new int[]{201116};
        this.mApplicableIterations = QTEAbstractTransformation.ApplicableIterations.INITIAL;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        V5BoundModelIdentifier pIdentifier = (V5BoundModelIdentifier)node;
        IMetadata metadata = pIdentifier.getMetadata();
        V5RoleValueFunction roleValue = (V5RoleValueFunction)nodeFactory.createNode(201098);
        V5LiteralValue propertyName = (V5LiteralValue)nodeFactory.createNode(201026);
        String pName = metadata.getName();
        propertyName.setDataType(DataTypeFactory.getVarcharType(pName.length()));
        propertyName.setValue(pName);
        roleValue.addChild(propertyName);
        V5MembersFunction members = (V5MembersFunction)nodeFactory.createNode(201086);
        IHierarchy hierarchy = MetadataUtil.getHierarchy(metadata);
        V5BoundModelIdentifier mIdentifier = (V5BoundModelIdentifier)nodeFactory.createNode(201116);
        if (hierarchy.isParentChild()) {
            mIdentifier.setMetadata(hierarchy);
            mIdentifier.setIdentifier(hierarchy.getUniqueName());
        } else {
            ILevel level = MetadataUtil.getLevel(metadata);
            mIdentifier.setMetadata(level);
            mIdentifier.setIdentifier(level.getUniqueName());
        }
        members.addChild(mIdentifier);
        roleValue.addChild(members);
        pIdentifier.getParent().exchangeChildNode(pIdentifier, roleValue);
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        V5BoundModelIdentifier identifier = (V5BoundModelIdentifier)node;
        V5Query query = (V5Query)identifier.getAncestorOfType(101006);
        boolean status = ConvertCustomPropertyToRoleValue.isListOfSingleSortedMemberProperty(identifier, query);
        if (!status) {
            this.traceQueryCondition(false, IS_NOT_APPLICABLE, trace);
            return status;
        }
        status = DecomposeScalarFunction.passesQueryAndSubqueryCondition(query);
        if (status) {
            this.traceQueryCondition(true, "Convert custom member property to roleValue function is applicable.", trace);
        } else {
            this.traceQueryCondition(false, IS_NOT_APPLICABLE, trace);
        }
        return status;
    }

    public static boolean isListOfSingleSortedMemberProperty(V5BoundModelIdentifier identifier, V5Query query) {
        if (identifier.getParent().getType() != 101004 || !ConvertCustomPropertyToRoleValue.isMemberProperty(identifier)) {
            return false;
        }
        V5DataItem v5DataItem = (V5DataItem)identifier.getAncestorOfType(101003);
        IXQEQueryNode[] qrds = query.getParent().getChildrenOfType(101055);
        boolean foundQRD = false;
        for (IXQEQueryNode qrd : qrds) {
            if (!((V5QueryResultDefinition)qrd).getV5Query().equals(query)) continue;
            foundQRD = true;
            if (!((V5QueryResultDefinition)qrd).isList()) {
                return false;
            }
            boolean found = false;
            IXQEQueryNode[] groupBodies = qrd.getDescendantsOfType(101051, false);
            IXQEQueryNode[] valueSets = qrd.getDescendantsOfType(101057, false);
            if (groupBodies.length != 1 || groupBodies[0] == null || valueSets.length != 1 || valueSets[0] == null) {
                return false;
            }
            IXQEQueryNode[] dataItemRefs = groupBodies[0].getDescendantsOfType(101015, false);
            if (dataItemRefs.length != 1 || dataItemRefs[0] == null) {
                return false;
            }
            if (((V5DataItemRef)dataItemRefs[0]).getDataItemRefProperty().equals(v5DataItem.getNameProperty())) {
                found = true;
            }
            if (found) {
                found = false;
                V5ValueSet valueSet = (V5ValueSet)groupBodies[0].getParent();
                String asc = "ascending";
                String desc = "descending";
                String sort = "sort";
                if (valueSet.getNumberChildren() == 2) {
                    IXQEQueryNode[] v5SortItems = valueSet.getChildrenOfType(101056);
                    if (v5SortItems.length == 1 && v5SortItems[0] != null && ((V5SortItem)v5SortItems[0]).getRefDataItem().equals(v5DataItem.getNameProperty())) {
                        found = true;
                    }
                } else if (valueSet.getNumberChildren() == 1 && v5DataItem.getPropertyValue("sort") != null && (v5DataItem.getPropertyValue("sort").equals("ascending") || v5DataItem.getPropertyValue("sort").equals("descending"))) {
                    found = true;
                }
            }
            if (found) continue;
            return false;
        }
        return foundQRD;
    }

    public static boolean isMemberProperty(V5BoundModelIdentifier identifier) {
        MetadataType mType = identifier.getMetadata().getObjectType();
        if (mType == MetadataType.QUERY_ITEM) {
            IQueryItem queryItem = (IQueryItem)identifier.getMetadata();
            if (queryItem.getHierarchy() == null) {
                return false;
            }
            ICube cube = queryItem.getHierarchy().getDimension().getCube();
            try {
                cube.getType();
            }
            catch (Throwable t) {
                return false;
            }
            return queryItem.isProperty();
        }
        return false;
    }
}

