/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.decomposition;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.sql.SQLJoin;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5JoinOperation;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Selection;
import com.cognos.xqe.ast.v5.query.V5Source;
import com.cognos.xqe.ast.v5.result.V5QueryResultDefinition;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.ast.v5Exp.V5BoundDataItemReference;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.ResponseMessage;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5.util.V5SubQueryBuilder;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public final class DecomposeQRD
extends Transformation {
    private static int[] setTypes = new int[]{201101};
    public static final String ZERO_NUMBER = "0";
    public static final String ZERO_STRING = "zero";
    public static final String SUBQUERY_QRD_NAME = "_subQueryQrd";

    public DecomposeQRD() {
        this.mName = "DecomposeQRD";
        this.mPassNumbers = new int[]{19};
        this.mTypes = new int[]{101006};
        this.mMode = QTEAbstractTransformation.Mode.TOP_DOWN_FAST;
        this.mApplicableIterations = QTEAbstractTransformation.ApplicableIterations.UNLIMITED;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        V5Query v5Query = (V5Query)node;
        v5Query.initializeCount();
        V5Source source = (V5Source)v5Query.getFirstChildByType(101007);
        for (int i = 0; i < source.getNumberChildren(); ++i) {
            if (source.getChild(i).getType() == 101019) {
                this.resolveJoinNode(v5Query, (V5JoinOperation)source.getChild(i), environment);
                continue;
            }
            if (source.getChild(i).getType() != 101018) continue;
            this.resolveQueryOperationNode(v5Query, source.getChild(i), environment);
        }
        V5QuerySet rootV5QuerySet = (V5QuerySet)environment.getRoot();
        rootV5QuerySet.addResolvedQuery(v5Query.getV5QueryName());
        v5Query.setPropertyValue("isResolved", true);
        if (v5Query.getPropertyValue("referencedByRootQRD") == null) {
            V5QueryResultDefinition qrd = DecomposeQRD.generateQRDForSubQuery(v5Query, environment);
            v5Query.addChild(qrd);
        }
    }

    private void resolveJoinNode(V5Query v5Query, V5JoinOperation v5JoinNode, PlanningEnvironment environment) {
        IXQEQueryNode[] joinOperands = v5JoinNode.getChildrenOfTypeOrdered(101021);
        if (joinOperands.length != 2) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Invalid queryspec: join operation requires 2 join operands.");
        }
        String[] queryRefs = new String[joinOperands.length];
        for (int i = 0; i < joinOperands.length; ++i) {
            queryRefs[i] = (String)joinOperands[i].getPropertyValue("queryRef");
        }
        this.checkJoinExpression(v5JoinNode, queryRefs, v5Query, environment);
        this.setJoinType(joinOperands);
    }

    private void checkJoinExpression(V5JoinOperation v5JoinNode, String[] queryRefs, V5Query v5Query, PlanningEnvironment environment) {
        IXQEQueryNode filterExpression = v5JoinNode.getFirstChildByType(101013);
        if (filterExpression == null) {
            return;
        }
        IXQEQueryNode[] boundDataItemRefs = filterExpression.getDescendantsOfType(201060, false);
        if (boundDataItemRefs.length == 0) {
            ResponseMessage joinWarning = new ResponseMessage(1, ResponseMessage.ResponseMessageType.TYPE_PLAN_STAT_INT, XQEMessageKeys.WRN_ConstantJoinFilterExpressioin, queryRefs[0], queryRefs[1]);
            environment.getResponseMessageFolder().appendPlanningResponseMessage(joinWarning);
        } else {
            for (String queryRef : queryRefs) {
                boolean expressionHasBoundDataItem = false;
                for (int i = 0; i < boundDataItemRefs.length; ++i) {
                    V5BoundDataItemReference boundDIRef = (V5BoundDataItemReference)boundDataItemRefs[i];
                    if (!boundDIRef.isQueryRefItem() || !boundDIRef.getNameParts()[0].equals(queryRef)) continue;
                    expressionHasBoundDataItem = true;
                    break;
                }
                if (expressionHasBoundDataItem) continue;
                throw new XQERuntimeException(XQEMessageKeys.PLN_QueryNotFound, (Object)v5Query.getV5QueryName(), (Object)queryRefs[0], (Object)queryRefs[1]);
            }
        }
    }

    private void setJoinType(IXQEQueryNode[] joinOperands) {
        String leftCard = (String)joinOperands[0].getPropertyValue("cardinality");
        String rightCard = (String)joinOperands[1].getPropertyValue("cardinality");
        SQLJoin.SubType joinType = DecomposeQRD.determineJoinTypeBasedOnCardinality(leftCard, rightCard);
        V5JoinOperation joinOperation = (V5JoinOperation)joinOperands[0].getParent();
        if (leftCard != null && DecomposeQRD.cardinalityStartsWithZero(leftCard)) {
            joinOperation.detachChild(joinOperands[1]);
            joinOperation.addChild(joinOperands[1], 0);
        }
        joinOperation.setJoinType(joinType);
    }

    public static SQLJoin.SubType determineJoinTypeBasedOnCardinality(String leftCard, String rightCard) {
        if (leftCard != null && DecomposeQRD.cardinalityStartsWithZero(leftCard) && rightCard != null && DecomposeQRD.cardinalityStartsWithZero(rightCard)) {
            return SQLJoin.SubType.FULL_OUTER;
        }
        if (leftCard != null && !DecomposeQRD.cardinalityStartsWithZero(leftCard) && rightCard != null && !DecomposeQRD.cardinalityStartsWithZero(rightCard)) {
            return SQLJoin.SubType.INNER;
        }
        if (!(leftCard != null || rightCard != null && DecomposeQRD.cardinalityStartsWithZero(rightCard))) {
            return SQLJoin.SubType.INNER;
        }
        if (rightCard == null && !DecomposeQRD.cardinalityStartsWithZero(leftCard)) {
            return SQLJoin.SubType.INNER;
        }
        return SQLJoin.SubType.LEFT_OUTER;
    }

    public static boolean cardinalityStartsWithZero(String cardinality) {
        return cardinality.startsWith(ZERO_NUMBER) || cardinality.toLowerCase().startsWith(ZERO_STRING);
    }

    private void resolveQueryOperationNode(V5Query v5Query, IXQEQueryNode queryOperation, PlanningEnvironment environment) {
        IXQEQueryNode[] queryRefs = queryOperation.getChildrenOfType(101023);
        String[] queryRefNames = new String[queryRefs.length];
        for (int i = 0; i < queryRefs.length; ++i) {
            String queryName;
            queryRefNames[i] = queryName = (String)queryRefs[i].getPropertyValue("refQuery");
        }
        V5QuerySet rootQuerySet = V5QuerySet.getRootQuerySet(environment, v5Query);
        this.throwExceptionForInvalidSetOperation(queryRefNames, rootQuerySet);
    }

    private void throwExceptionForInvalidSetOperation(String[] queryRefs, V5QuerySet rootQuerySet) {
        int numProjections = -1;
        for (String queryRefName : queryRefs) {
            V5Query refQuery = rootQuerySet.getV5Query(queryRefName);
            if (refQuery == null) {
                throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "SetOperation references unknown query: " + queryRefName);
            }
            IXQEQueryNode nodeSelection = refQuery.getFirstChildByType(101009);
            IXQEQueryNode[] v5DataItemsList = nodeSelection.getChildrenOfType(101003);
            int numProjectionsInLeg = 0;
            for (IXQEQueryNode di : v5DataItemsList) {
                V5DataItem v5DataItem = (V5DataItem)di;
                if (!v5DataItem.isOriginal()) continue;
                ++numProjectionsInLeg;
            }
            if (numProjections == -1) {
                numProjections = numProjectionsInLeg;
            }
            if (numProjectionsInLeg == numProjections) continue;
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "The number of columns of set operation children are not equal.");
        }
    }

    public static V5QueryResultDefinition generateQRDForSubQuery(V5Query v5Query, PlanningEnvironment environment) {
        IXQEQueryNode[] v5DetailFilters;
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        V5QueryResultDefinition qrdForSubQuery = (V5QueryResultDefinition)nodeFactory.createNode(101055);
        IXQEQueryNode nodeEdge = nodeFactory.createNode(101049);
        qrdForSubQuery.addChild(nodeEdge);
        IXQEQueryNode nodeEdgeGroup = nodeFactory.createNode(101050);
        nodeEdge.addChild(nodeEdgeGroup);
        V5ValueSet nodeValueSet = (V5ValueSet)nodeFactory.createNode(101057);
        nodeEdgeGroup.addChild(nodeValueSet);
        IXQEQueryNode nodeGroupBody = nodeFactory.createNode(101051);
        nodeValueSet.addChild(nodeGroupBody);
        nodeEdge.setPropertyValue("name", "_edge");
        nodeValueSet.setNameProperty("_vs");
        nodeGroupBody.setPropertyValue("name", "_gb");
        qrdForSubQuery.setPropertyValue("name", SUBQUERY_QRD_NAME);
        for (IXQEQueryNode filter : v5DetailFilters = v5Query.getV5DetailFilters()) {
            if (filter.getPropertyValue("qrdName") == null) continue;
            filter.setPropertyValue("qrdName", SUBQUERY_QRD_NAME);
        }
        String queryName = v5Query.getV5QueryName();
        qrdForSubQuery.setRefQueryProperty(queryName);
        DecomposeQRD.buildDataItemRefsInGroupBodyForSubQuery(nodeFactory, nodeGroupBody, v5Query.getV5Selection());
        return qrdForSubQuery;
    }

    public static void buildDataItemRefsInGroupBodyForSubQuery(IXQENodeFactory nodeFactory, IXQEQueryNode nodeGroupBody, V5Selection selection) {
        IXQEQueryNode[] v5DataItems = selection.getChildrenOfTypeOrdered(101003);
        for (int i = 0; i < v5DataItems.length; ++i) {
            boolean addChild = true;
            ArrayList<Integer> idRefs = new ArrayList<Integer>();
            if (!((V5DataItem)v5DataItems[i]).isOriginal() || V5SubQueryBuilder.containsAggregateWithinDetail(v5DataItems[i])) continue;
            IXQEQueryNode[] setFunctions = v5DataItems[i].getDescendantsOfTypes(setTypes, false);
            if (setFunctions.length > 0) {
                IXQEQueryNode[] multiPartIdentifiers = v5DataItems[i].getDescendantsOfType(201060, false);
                for (int j = 0; j < multiPartIdentifiers.length; ++j) {
                    V5DataItem setItemRef = ((V5BoundDataItemReference)multiPartIdentifiers[j]).getRefDataItem();
                    if (setItemRef == null) continue;
                    idRefs.add(j, setItemRef.getId());
                }
            } else {
                for (int j = 0; j < idRefs.size(); ++j) {
                    if (!v5DataItems[i].getId().equals(idRefs.get(j))) continue;
                    addChild = false;
                    break;
                }
            }
            if (!addChild) continue;
            IXQEQueryNode nodeDataItemRef = nodeFactory.createNode(101015);
            nodeGroupBody.addChild(nodeDataItemRef);
            String dataItemName = (String)v5DataItems[i].getPropertyValue("name");
            nodeDataItemRef.setPropertyValue("refDataItem", dataItemName);
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        boolean bRelational;
        XQETrace trace = environment.getTrace();
        V5Query v5Query = (V5Query)node;
        if (v5Query.getPropertyValue("isResolved") != null) {
            this.traceQueryCondition(true, "V5 Query is already resolved.", trace);
            return false;
        }
        if (v5Query.getPropertyValue("queryReferencedFromFilter") != null) {
            if (v5Query.isTabular()) {
                this.traceQueryCondition(true, "relational V5 Query referenced by a filter of another query.", trace);
                return true;
            }
            this.traceQueryCondition(true, "DMR V5 Query referenced by a filter of another query.", trace);
            return false;
        }
        V5Source source = (V5Source)v5Query.getFirstChildByType(101007);
        Set<String> queryRefs = source.getReferencedQueries();
        if (queryRefs != null) {
            V5QuerySet rootQS = (V5QuerySet)environment.getRoot();
            Iterator<String> it = queryRefs.iterator();
            for (int i = 0; i < queryRefs.size(); ++i) {
                String queryName = it.next();
                V5Query v5Query2 = rootQS.getV5Query(queryName);
                if (v5Query2 == null) {
                    this.traceQueryCondition(true, "V5 Query has join expression that needs to be verified.", trace);
                    return true;
                }
                if (v5Query2.getPropertyValue("isResolved") != null || !v5Query2.isTabular() && !v5Query2.isRelStyle() && !v5Query2.getForcedDMRToRelational()) continue;
                this.traceQueryCondition(false, "V5 Query has query ref not resolved.", trace);
                return false;
            }
        }
        if (v5Query.getPropertyValue("referencedByRootQRD") != null && !this.hasJoinOrQueryOperationUnderSource(v5Query)) {
            this.traceQueryCondition(false, "V5 Query is referenced by root QRD and does not have join/queryOperation.", trace);
            return false;
        }
        boolean bl = bRelational = v5Query.isTabular() || v5Query.isRelStyle() || v5Query.getForcedDMRToRelational();
        if (!bRelational) {
            V5QuerySet rootQS = (V5QuerySet)environment.getRoot();
            List<V5Query> queries = rootQS.getReferencingQueries(v5Query.getV5QueryName(), environment);
            for (IXQEQueryNode iXQEQueryNode : queries) {
                V5Query query = (V5Query)iXQEQueryNode;
                if (!query.isTabular() && !query.isRelStyle() && !query.getForcedDMRToRelational()) continue;
                this.traceQueryCondition(true, "V5 Query is referenced by relational query.", trace);
                return true;
            }
            this.traceQueryCondition(false, "V5 Query is not referenced by relational query.", trace);
            return false;
        }
        this.traceQueryCondition(true, "The V5 Query Result Definition will be expanded.", trace);
        return true;
    }

    private boolean hasJoinOrQueryOperationUnderSource(V5Query v5Query) {
        V5Source source = (V5Source)v5Query.getFirstChildByType(101007);
        for (int i = 0; i < source.getNumberChildren(); ++i) {
            int childType = source.getChild(i).getType();
            if (childType != 101019 && childType != 101018) continue;
            return true;
        }
        return false;
    }
}

