/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.decomposition;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.V5QueryNode;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Source;
import com.cognos.xqe.ast.v5.result.V5QueryResultDefinition;
import com.cognos.xqe.ast.v5Exp.V5BoundMultiPartIdentifier;
import com.cognos.xqe.ast.v5Exp.V5BoundToMetadata;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IModelDataSource;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.query.engine.MetadataConnectionContext;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.util.LoopDetectionChain;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class LogicalDecomposition
extends Transformation {
    public static final String PROP_QRD_DECOMPOSED = "qrdDecomposed";

    public LogicalDecomposition() {
        this.mName = "Logical Decomposition.";
        this.mPassNumbers = new int[]{4, 20};
        this.mTypes = new int[]{101055};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        V5Query query = null;
        V5QuerySet querySet = (V5QuerySet)node.getAncestorOfType(101002);
        V5QueryResultDefinition qrd = (V5QueryResultDefinition)node;
        query = querySet.getV5Query(qrd.getRefQueryProperty());
        LoopDetectionChain ldc = new LoopDetectionChain();
        boolean[] twoFlags = new boolean[]{true, true};
        this.decompose(querySet, query, ldc, twoFlags);
        if (!((RequestEnvironment)environment.getRequestEnvironment()).isGetParametersRequest() && qrd.getNumberChildrenOfType(101049) > 1) {
            query.setPropertyValue("isTabular", false);
        }
        node.setPropertyValue(PROP_QRD_DECOMPOSED, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decompose(V5QuerySet querySet, V5Query query, LoopDetectionChain ldc, boolean[] twoFlags) {
        PlanningEnvironment env = (PlanningEnvironment)querySet.getPlanningEnvironment();
        try (MetadataConnectionContext mc = null;){
            IXQEQueryNode child;
            mc = env.pushMetadataConnectionContext(query);
            if (query.getPropertyValue(PROP_QRD_DECOMPOSED) != null) {
                Boolean flag1 = query.getBooleanPropertyValue("isTabular");
                Boolean flag2 = query.getBooleanPropertyValue("isRelStyle");
                if (flag1 != null) {
                    twoFlags[0] = flag1;
                }
                if (flag2 != null) {
                    twoFlags[1] = flag2;
                }
                return;
            }
            V5Query origQuery = query.getOriginalV5Query();
            if (origQuery != query) {
                this.decompose((V5QuerySet)origQuery.getAncestorOfType(101002), origQuery, ldc, twoFlags);
                query.setPropertyValue("isTabular", twoFlags[0]);
                query.setPropertyValue("isRelStyle", twoFlags[1]);
                query.setPropertyValue(PROP_QRD_DECOMPOSED, true);
                return;
            }
            String currentQueryName = query.getV5QueryName();
            if (!ldc.push(currentQueryName)) {
                throw new XQERuntimeException(XQEMessageKeys.PLN_LoopInQuery, ldc.serialize());
            }
            V5Source source = (V5Source)query.getFirstChildByType(101007);
            boolean hasQueryChild = true;
            if (source.getNumberChildren() == 0) {
                hasQueryChild = false;
            } else if (source.getNumberChildren() == 1 && (child = source.getChildren()[0]).getType() == 1007) {
                hasQueryChild = false;
            }
            if (!hasQueryChild) {
                Set<String> queryRefStrs = source.getReferencedQueries();
                if (queryRefStrs != null) {
                    for (String queryRefStr : queryRefStrs) {
                        V5Query refQuery = querySet.getV5Query(queryRefStr);
                        if (refQuery != null) {
                            boolean[] twoChildFlags = new boolean[]{true, true};
                            this.decompose(querySet, refQuery, ldc, twoChildFlags);
                            if (refQuery.getForcedDMRToRelational() && (!query.isDMR() || query.getForcedDMRToRelational())) {
                                twoChildFlags[0] = true;
                            }
                            twoFlags[0] = twoChildFlags[0];
                            twoFlags[1] = twoChildFlags[1];
                            continue;
                        }
                        throw new XQERuntimeException(XQEMessageKeys.PLN_InvalidQueryRef, query.getV5QueryName(), queryRefStr);
                    }
                } else {
                    MetadataConnection mdConnection = env.getMetadataConnection();
                    if (mdConnection != null) {
                        List<IModelDataSource> dataSources = mdConnection.getModelDataSources();
                        if (dataSources.size() == 1 && dataSources.get(0).isMultidimensional() || query.isOLAPConstruct()) {
                            twoFlags[0] = false;
                        }
                        if (this.dataSourcesAreDimensional(dataSources) || this.useDimensionalMetatdata(query, dataSources)) {
                            twoFlags[1] = false;
                        }
                    }
                }
            } else {
                child = source.getChild(0);
                int type = child.getType();
                switch (type) {
                    case 101016: {
                        twoFlags[0] = !query.isOLAPConstruct();
                        twoFlags[1] = true;
                        break;
                    }
                    case 1007: {
                        twoFlags[0] = false;
                        twoFlags[1] = false;
                        break;
                    }
                    case 101042: {
                        twoFlags[0] = false;
                        twoFlags[1] = true;
                        break;
                    }
                    case 101019: {
                        twoFlags[0] = !query.isOLAPConstruct();
                        twoFlags[1] = true;
                        IXQEQueryNode[] v5JoinOperands = child.getChildrenOfType(101021);
                        HashSet<String> joinOperandNames = new HashSet<String>();
                        for (int i = 0; i < v5JoinOperands.length; ++i) {
                            String queryName = (String)v5JoinOperands[i].getPropertyValue("queryRef");
                            joinOperandNames.add(queryName);
                            boolean[] twoChildFlags = new boolean[]{true, true};
                            this.decompose(querySet, querySet.getV5Query(queryName), ldc, twoChildFlags);
                        }
                        Set<String> queryRefs = source.getReferencedQueries();
                        for (String queryRef : queryRefs) {
                            if (joinOperandNames.contains(queryRef)) continue;
                            boolean[] twoChildFlags = new boolean[]{true, true};
                            this.decompose(querySet, querySet.getV5Query(queryRef), ldc, twoChildFlags);
                        }
                        break;
                    }
                    case 101018: {
                        twoFlags[0] = !query.isOLAPConstruct();
                        twoFlags[1] = true;
                        IXQEQueryNode[] v5QueryRefs = child.getChildrenOfType(101023);
                        for (int i = 0; i < v5QueryRefs.length; ++i) {
                            String queryName = (String)v5QueryRefs[i].getPropertyValue("refQuery");
                            boolean[] twoChildFlags = new boolean[]{true, true};
                            this.decompose(querySet, querySet.getV5Query(queryName), ldc, twoChildFlags);
                        }
                        break;
                    }
                }
            }
            if (query.hasChildOfType(101008)) {
                IXQEQueryNode[] detailFilters;
                for (IXQEQueryNode detailFilter : detailFilters = query.getV5DetailFilters()) {
                    IXQEQueryNode[] dataItems;
                    for (IXQEQueryNode dataItem : dataItems = detailFilter.getDescendantsOfTypes(new int[]{201060, 201097}, true)) {
                        String diQueryName;
                        V5Query v5query;
                        V5BoundMultiPartIdentifier di = (V5BoundMultiPartIdentifier)dataItem;
                        String[] parts = di.getNameParts();
                        if (parts.length != 2 || (v5query = querySet.getV5Query(diQueryName = parts[0])) == null || diQueryName.equals(currentQueryName)) continue;
                        boolean[] twoChildFlags = new boolean[]{true, true};
                        this.decompose(querySet, v5query, ldc, twoChildFlags);
                    }
                }
            }
            query.setPropertyValue("isTabular", twoFlags[0]);
            query.setPropertyValue("isRelStyle", twoFlags[1]);
            query.setPropertyValue(PROP_QRD_DECOMPOSED, true);
            ldc.pop();
        }
    }

    protected boolean dataSourcesAreDimensional(List<IModelDataSource> dataSources) {
        if (dataSources.isEmpty()) {
            return false;
        }
        for (IModelDataSource src : dataSources) {
            if (src.isMultidimensional()) continue;
            return false;
        }
        return true;
    }

    protected boolean useDimensionalMetatdata(V5Query query, List<IModelDataSource> dataSources) {
        IXQEQueryNode[] metadataObjs;
        int[] types = new int[]{201116, 201117, 201127, 201024};
        for (IXQEQueryNode aMetadata : metadataObjs = query.getDescendantsOfTypes(types, false)) {
            IMetadata metadata = ((V5BoundToMetadata)aMetadata).getMetadata();
            if (metadata == null || (!MetadataType.isOLAP(metadata) || !query.isDMRInQueryContext(metadata)) && !V5QueryNode.queryItemIsOLAP(metadata)) continue;
            return true;
        }
        if (metadataObjs.length > 0) {
            return false;
        }
        if (dataSources.isEmpty()) {
            return false;
        }
        IModelDataSource aDimensionalSource = null;
        for (IModelDataSource src : dataSources) {
            if (!src.isMultidimensional()) continue;
            aDimensionalSource = src;
            break;
        }
        return aDimensionalSource != null && query.isOLAPConstruct();
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        return node.getPropertyValue(PROP_QRD_DECOMPOSED) == null;
    }
}

