/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.decomposition;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5Exp.V5LiteralValue;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;

public class NormalizeSetOperationFilter
extends Transformation {
    private int[] normalizedTypes = new int[]{201098, 201050};

    public NormalizeSetOperationFilter() {
        this.mName = "Set Operation Filter Normalization.";
        this.mPassNumbers = new int[]{8};
        this.mTypes = new int[]{101008};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode[] nodesOLAP;
        for (IXQEQueryNode current : nodesOLAP = node.getDescendantsOfTypes(this.normalizedTypes, false)) {
            if (current.getType() == 201050) {
                current.extract();
                continue;
            }
            if (current.getType() != 201098) continue;
            V5LiteralValue literalValue = (V5LiteralValue)current.getFirstChildByType(201026);
            if (!literalValue.getValue().getString().equals("_memberCaption")) {
                throw new XQERuntimeException(XQEMessageKeys.V5_InvalidPropertyIdentifier, literalValue.getValue().getString());
            }
            literalValue.extract();
            current.extract();
        }
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = false;
        V5Query query = (V5Query)node.getParent();
        IXQEQueryNode nodeSOP = query.getV5Source().getFirstChildByType(101018);
        if (nodeSOP == null) {
            this.traceQueryCondition(status, "The filter is not applied to a set operation.", trace);
        } else {
            boolean bl = status = node.getDescendantsOfTypes(this.normalizedTypes, false).length != 0;
            if (status) {
                this.traceQueryCondition(status, "The filter contains OLAP expression(s) to normalize.", trace);
            } else {
                this.traceQueryCondition(status, "The filter does not contain OLAP expression(s) to normalize.", trace);
            }
        }
        return status;
    }
}

