/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.decomposition;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5Exp.V5BoundDataItemReference;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.ast.v5Exp.V5BoundMultiPartIdentifier;
import com.cognos.xqe.ast.v5Exp.V5BoundQueryItemReference;
import com.cognos.xqe.ast.v5Exp.V5CaseExpression;
import com.cognos.xqe.ast.v5Exp.V5LiteralValue;
import com.cognos.xqe.data.DataSubType;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.metadata.IQueryItem;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.v5.tabstream.MixedDMRRelUtil;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.ArrayList;
import java.util.List;

public class RefineAutomatic
extends Transformation {
    public RefineAutomatic() {
        this.mName = "Refine dataItem rollupAggregate Automatic settings";
        this.mPassNumbers = new int[]{15};
        this.mTypes = new int[]{101003};
        this.mApplicableIterations = QTEAbstractTransformation.ApplicableIterations.UNLIMITED;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        String automaticRefined = this.resolveAutomaticRollupAggregateForOlap(node);
        V5DataItem v5DataItem = (V5DataItem)node;
        String rollupAggregate = v5DataItem.getRollupAggregateProperty();
        String aggregate = v5DataItem.getAggregateProperty();
        if (rollupAggregate != null && rollupAggregate.compareTo("automatic") == 0) {
            v5DataItem.setRollupAggregateProperty(automaticRefined);
        }
        if (aggregate != null && aggregate.compareTo("automatic") == 0) {
            if (automaticRefined.equals("none") && !v5DataItem.getRollupAggregateProperty().equals("none")) {
                v5DataItem.setAggregateProperty("calculated");
            } else {
                v5DataItem.setAggregateProperty(automaticRefined);
            }
        }
    }

    private String resolveAutomaticRollupAggregateForOlap(IXQEQueryNode node) {
        if (this.containsV5SummaryFunction(node)) {
            return "calculated";
        }
        if (this.containsIfThenElseOrCaseWithMeasure(node)) {
            return "calculated";
        }
        if (this.containsIfThenElseReturningNumericV5LiteralValueExpression(node)) {
            return "calculated";
        }
        if (this.hasCalculationOrMeasureWithDefinedRegularAggregateOrImplicitMeasure(node)) {
            return "calculated";
        }
        if (this.hasReferenceToDataItemWithRollupAggregateDiffThanNone(node)) {
            return "calculated";
        }
        if (this.hasPureV5LiteralValueExpression(node)) {
            V5DataItem v5DataItem = (V5DataItem)node;
            IDataType dt = v5DataItem.getDataType();
            if (dt != null && dt.getSubType() == DataSubType.NUMERICTYPE) {
                return "calculated";
            }
            return "none";
        }
        return "none";
    }

    private boolean containsV5SummaryFunction(IXQEQueryNode node) {
        return node.getDescendantsOfCategory(201124, false).size() > 0;
    }

    private boolean containsIfThenElseOrCaseWithMeasure(IXQEQueryNode node) {
        int[] types = new int[]{201017, 201018};
        IXQEQueryNode[] ifThenElseOrCaseExpressions = node.getDescendantsOfTypes(types, false);
        if (ifThenElseOrCaseExpressions.length == 0) {
            return false;
        }
        for (IXQEQueryNode ifThenElseOrCaseExpression : ifThenElseOrCaseExpressions) {
            if (!this.hasMeasureInConditionClauses(ifThenElseOrCaseExpression)) continue;
            return true;
        }
        return false;
    }

    private boolean containsIfThenElseReturningNumericV5LiteralValueExpression(IXQEQueryNode node) {
        int[] types = new int[]{201017};
        IXQEQueryNode[] ifThenElseOrCaseExpressions = node.getDescendantsOfTypes(types, false);
        if (ifThenElseOrCaseExpressions.length == 0) {
            return false;
        }
        for (IXQEQueryNode ifThenElseOrCaseExpression : ifThenElseOrCaseExpressions) {
            if (!this.returnsV5LiteralValueExpression(ifThenElseOrCaseExpression)) continue;
            return true;
        }
        return false;
    }

    private boolean returnsV5LiteralValueExpression(IXQEQueryNode node) {
        IXQEQueryNode[] thenElseClauses = this.getThenElseClauses(node);
        for (int i = 0; i < thenElseClauses.length; ++i) {
            if (this.hasPureNumericV5LiteralValueExpression(thenElseClauses[i])) continue;
            return false;
        }
        return true;
    }

    private IXQEQueryNode[] getThenElseClauses(IXQEQueryNode node) {
        ArrayList<IXQEQueryNode> thenElseClauses = new ArrayList<IXQEQueryNode>();
        if (node.getType() == 201017) {
            thenElseClauses.add(node.getChild(1));
            thenElseClauses.add(node.getChild(2));
        }
        IXQEQueryNode[] nodes = new IXQEQueryNode[thenElseClauses.size()];
        return thenElseClauses.toArray(nodes);
    }

    private boolean hasPureNumericV5LiteralValueExpression(IXQEQueryNode node) {
        if (this.hasNumericV5LiteralValueExpression(node)) {
            List<IXQEQueryNode> objects = node.getDescendantsOfCategory(201115, true);
            return objects.isEmpty();
        }
        return false;
    }

    private boolean hasNumericV5LiteralValueExpression(IXQEQueryNode node) {
        IXQEQueryNode[] v5ExpLiteralValues = node.getDescendantsOfType(201026, true);
        if (v5ExpLiteralValues.length == 0) {
            return false;
        }
        for (IXQEQueryNode v5ExpLiteralValue : v5ExpLiteralValues) {
            IDataType literalDT = ((V5LiteralValue)v5ExpLiteralValue).getDataType();
            if (literalDT.isNumeric()) continue;
            return false;
        }
        return true;
    }

    private boolean hasMeasureInConditionClauses(IXQEQueryNode node) {
        IXQEQueryNode[] conditionClauses = this.getConditionClauses(node);
        for (int i = 0; i < conditionClauses.length; ++i) {
            IXQEQueryNode[] modelReferences;
            for (IXQEQueryNode modelReference : modelReferences = conditionClauses[i].getDescendantsOfType(201116, false)) {
                if (!((V5BoundModelIdentifier)modelReference).isMeasure()) continue;
                return true;
            }
        }
        return false;
    }

    private IXQEQueryNode[] getConditionClauses(IXQEQueryNode node) {
        ArrayList<IXQEQueryNode> conditionClauses = new ArrayList<IXQEQueryNode>();
        if (node.getType() == 201017) {
            conditionClauses.add(node.getChild(0));
        } else if (node.getType() == 201018) {
            if (((V5CaseExpression)node).getSubType() == 0) {
                conditionClauses.add(node.getChild(0));
            } else {
                IXQEQueryNode[] caseWhenClauses;
                for (IXQEQueryNode caseWhenClause : caseWhenClauses = node.getChildrenOfType(201019)) {
                    conditionClauses.add(caseWhenClause.getChild(0));
                }
            }
        }
        IXQEQueryNode[] nodes = new IXQEQueryNode[conditionClauses.size()];
        return conditionClauses.toArray(nodes);
    }

    private boolean hasCalculationOrMeasureWithDefinedRegularAggregateOrImplicitMeasure(IXQEQueryNode node) {
        IXQEQueryNode[] modelReferences;
        int[] types = new int[]{201116};
        for (IXQEQueryNode modelReference : modelReferences = node.getDescendantsOfTypes(types, false)) {
            IQueryItem queryItem;
            V5BoundModelIdentifier identifier = (V5BoundModelIdentifier)modelReference;
            if (identifier.isCalculationWithDefinedRegularAggregate()) {
                return true;
            }
            String regularAggregateName = identifier.getRegularAggregate();
            if (regularAggregateName != null && identifier.isMeasure() && !regularAggregateName.equals("unsupported")) {
                return true;
            }
            if (MetadataType.isMeasureDimension(identifier.getMetadata())) {
                return true;
            }
            if (identifier.getMetadata().getObjectType() != MetadataType.QUERY_ITEM || !(queryItem = (IQueryItem)identifier.getMetadata()).isFact()) continue;
            return true;
        }
        return false;
    }

    private boolean hasReferenceToDataItemWithRollupAggregateDiffThanNone(IXQEQueryNode node) {
        IXQEQueryNode[] references = node.getDescendantsOfTypes(new int[]{201060, 201097}, false);
        boolean ret = false;
        for (IXQEQueryNode reference : references) {
            V5DataItem v5DataItem;
            String aggregate;
            V5BoundMultiPartIdentifier identifier;
            V5DataItem dataItemRef = null;
            if (reference.getType() == 201060) {
                identifier = (V5BoundDataItemReference)reference;
                dataItemRef = ((V5BoundDataItemReference)identifier).getRefDataItem();
            } else {
                identifier = (V5BoundQueryItemReference)reference;
                dataItemRef = ((V5BoundQueryItemReference)identifier).getRefDataItem();
            }
            if (dataItemRef == null) continue;
            String rollupAggregate = dataItemRef.getRollupAggregateProperty();
            V5Query query = (V5Query)node.getAncestorOfType(101006);
            if (query.hasOlapOperand() && (aggregate = (v5DataItem = (V5DataItem)node).getAggregateProperty()) != null && aggregate.compareTo("automatic") == 0) {
                v5DataItem.setAggregateProperty(rollupAggregate);
            }
            ret = ret || rollupAggregate != null && !rollupAggregate.equals("none");
        }
        return ret;
    }

    private boolean hasV5LiteralValueExpression(IXQEQueryNode node) {
        IXQEQueryNode[] v5ExpLiteralValue = node.getDescendantsOfType(201026, true);
        return v5ExpLiteralValue.length != 0;
    }

    private boolean hasPureV5LiteralValueExpression(IXQEQueryNode node) {
        if (this.hasV5LiteralValueExpression(node)) {
            List<IXQEQueryNode> objects = node.getDescendantsOfCategory(201115, true);
            return objects.isEmpty();
        }
        return false;
    }

    private boolean hasReferenceToDataItemWithRollupAggregateAutomatic(IXQEQueryNode node) {
        IXQEQueryNode[] references;
        for (IXQEQueryNode reference : references = node.getDescendantsOfTypes(new int[]{201060, 201097}, false)) {
            String rollupAggregate;
            V5BoundMultiPartIdentifier identifier;
            V5DataItem dataItemRef = null;
            if (reference.getType() == 201060) {
                identifier = (V5BoundDataItemReference)reference;
                dataItemRef = ((V5BoundDataItemReference)identifier).getRefDataItem();
            } else {
                identifier = (V5BoundQueryItemReference)reference;
                dataItemRef = ((V5BoundQueryItemReference)identifier).getRefDataItem();
            }
            if (dataItemRef == null || (rollupAggregate = dataItemRef.getRollupAggregateProperty()) == null || !rollupAggregate.equals("automatic")) continue;
            return true;
        }
        return false;
    }

    private boolean hasTabularItemsOnTopOfOlap(IXQEQueryNode node) {
        int[] types = new int[]{201060};
        IXQEQueryNode[] v5DataItemReferences = node.getDescendantsOfTypes(types, false);
        boolean tabItemsOnTopOfOlap = false;
        for (IXQEQueryNode v5DataItemReference : v5DataItemReferences) {
            V5BoundDataItemReference v5DIRef = (V5BoundDataItemReference)v5DataItemReference;
            if (!v5DIRef.isQueryRefItem()) continue;
            tabItemsOnTopOfOlap = true;
        }
        return tabItemsOnTopOfOlap;
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        boolean flagScalarFunctionXTab;
        XQETrace trace = environment.getTrace();
        V5DataItem v5DataItem = (V5DataItem)node;
        V5Query query = (V5Query)v5DataItem.getAncestorOfType(101006);
        if (query == null || query.isDMRtoRQP() || query.getForcedDMRToRelational()) {
            this.traceQueryCondition(false, "Relational query in the context of DMR.", trace);
            return false;
        }
        Boolean property = query.getV5Source().needQueryOverTabularStream();
        boolean bl = flagScalarFunctionXTab = property != null && property != false;
        if (!query.isTabular() && !query.isRelStyle() && !flagScalarFunctionXTab || query.hasOlapOperand() || query.isDMR()) {
            String rollupAggregate = v5DataItem.getRollupAggregateProperty();
            String aggregate = v5DataItem.getAggregateProperty();
            if (rollupAggregate != null && rollupAggregate.compareTo("automatic") == 0 || aggregate != null && aggregate.compareTo("automatic") == 0) {
                if (query.isDMR() && MixedDMRRelUtil.containRelationals(v5DataItem, null)) {
                    this.traceQueryCondition(false, "This is a pure relational data item.", trace);
                    return false;
                }
                if (this.hasReferenceToDataItemWithRollupAggregateAutomatic(node)) {
                    this.traceQueryCondition(false, "This is a reference to a data item not yet evaluated.", trace);
                    return false;
                }
                if (this.hasTabularItemsOnTopOfOlap(node)) {
                    this.traceQueryCondition(true, "This is a tabular item on top of olap.", trace);
                    return false;
                }
                this.traceQueryCondition(true, "The tranformation is applicable.", trace);
                return true;
            }
            return false;
        }
        return false;
    }
}

