/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.decomposition;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Source;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;

public class RemoveSubqueryReference
extends Transformation {
    public RemoveSubqueryReference() {
        this.mName = "Remove Subquery reference for OLAP queries.";
        this.mPassNumbers = new int[]{10};
        this.mTypes = new int[]{101006};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        V5Query query = (V5Query)node;
        V5Source src = query.getV5Source();
        src.resetReferencedQueries();
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        V5Query query = (V5Query)node;
        if (query.isTabular() || query.isRelStyle()) {
            this.traceQueryCondition(false, "OLAP queries only.", trace);
            return false;
        }
        V5Source src = query.getV5Source();
        if (src != null && src.getReferencedQueries() != null) {
            this.traceQueryCondition(true, "OLAP does not have subquery.", trace);
            return true;
        }
        return false;
    }
}

