/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.dmr;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.AbstractMDXNumericValueFunction;
import com.cognos.xqe.ast.olap.BaseHierarchy;
import com.cognos.xqe.ast.olap.BaseLevel;
import com.cognos.xqe.ast.olap.BaseMember;
import com.cognos.xqe.ast.olap.BaseProperty;
import com.cognos.xqe.ast.olap.CogMDXScalarFunction;
import com.cognos.xqe.ast.olap.MDXAnd;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberDefinition;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberReference;
import com.cognos.xqe.ast.olap.MDXChildren;
import com.cognos.xqe.ast.olap.MDXComparisonOperator;
import com.cognos.xqe.ast.olap.MDXCount;
import com.cognos.xqe.ast.olap.MDXCrossjoin;
import com.cognos.xqe.ast.olap.MDXExcept;
import com.cognos.xqe.ast.olap.MDXFilter;
import com.cognos.xqe.ast.olap.MDXHeadTailFunction;
import com.cognos.xqe.ast.olap.MDXIsEmpty;
import com.cognos.xqe.ast.olap.MDXNamedSetDefinition;
import com.cognos.xqe.ast.olap.MDXNamedSetReference;
import com.cognos.xqe.ast.olap.MDXNot;
import com.cognos.xqe.ast.olap.MDXNumericConstant;
import com.cognos.xqe.ast.olap.MDXNumericIIF;
import com.cognos.xqe.ast.olap.MDXNumericOperator;
import com.cognos.xqe.ast.olap.MDXOr;
import com.cognos.xqe.ast.olap.MDXParameterBooleanValue;
import com.cognos.xqe.ast.olap.MDXParameterDateTimeValue;
import com.cognos.xqe.ast.olap.MDXParameterNumericValue;
import com.cognos.xqe.ast.olap.MDXParameterStringValue;
import com.cognos.xqe.ast.olap.MDXSet;
import com.cognos.xqe.ast.olap.MDXSetAliasDefinition;
import com.cognos.xqe.ast.olap.MDXSetAliasReference;
import com.cognos.xqe.ast.olap.MDXStringConstant;
import com.cognos.xqe.ast.olap.MDXSummaryFunction;
import com.cognos.xqe.ast.olap.MDXTopBottomFunction;
import com.cognos.xqe.ast.olap.TNodePushdownAsCustomValue;
import com.cognos.xqe.ast.olap.util.MDXLevelInfo;
import com.cognos.xqe.ast.v5.V5QueryNode;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5DetailFilter;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Selection;
import com.cognos.xqe.ast.v5.result.V5DataItemRef;
import com.cognos.xqe.ast.v5.result.V5QueryResultDefinition;
import com.cognos.xqe.ast.v5.result.V5SortItem;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.ast.v5Exp.V5AggregateBreakClause;
import com.cognos.xqe.ast.v5Exp.V5ComparisonExpression;
import com.cognos.xqe.ast.v5Exp.V5MultiPartIdentifier;
import com.cognos.xqe.ast.v5Exp.V5OrderedValueExpression;
import com.cognos.xqe.ast.v5Exp.V5ValueAnalyticFunction;
import com.cognos.xqe.ast.v5Exp.V5ValueSummaryFunction;
import com.cognos.xqe.bibushandler.datasource.ProviderCapabilites;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IQueryItem;
import com.cognos.xqe.metadata.ISortItem;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.metadata.MetadataUtil;
import com.cognos.xqe.metadata.RoleTypeEnum;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.metadata.wrapper.LevelWrapper;
import com.cognos.xqe.metadata.wrapper.MeasureWrapper;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.DMRMemberLoadQuery;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.V5QueryOverTabularStream;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.util.AggregationUtils;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.AggregateExpressionBuilder;
import com.cognos.xqe.transformation.v5tocogsql.util.metadataContext.MetadataContext;
import com.cognos.xqe.util.LocaleConverter;
import com.cognos.xqe.util.Pair;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqe.util.UniqueNameParser;
import com.cognos.xqe.util.UniqueNameParserException;
import com.cognos.xqe.util.V5SpecificationGeneration;
import com.cognos.xqe.util.pool.XQESAXReaderPool;
import com.cognos.xqe.util.pushdownQuery.DMRCustomValueRefiner;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class DMRPushdownQueryGenerator {
    private static final String PROVIDER_KEY = "DMR";
    private static final String STR_REQUIRED = "required";
    private static final String STR_EXPRESSION = "expression";
    private static final String COLUMN = "column";
    private static final String REF_MEASURE = "RefMeasure";
    private static final String STR_COALESCE_REF = "coalesced1RefMeasure";
    private static final String STR_COALESCE = "coalesce";
    private static final String SINGLE_QUOTE = "'";
    private static final String ONE = "1";
    public static final String PUSHDOWNQUERYNAME_PREFIX = "XQE_PUSHDOWNQUERY";
    public static final String PUSHDOWNQUERY_V5QUERY_NAME = "PushdownQuery";
    public static final String PUSHDOWNQUERY_2PARTS_DI_NAME = "[PushdownQuery";
    private static final String UTF8 = "UTF-8";
    private static final String HIERARCHY_UNAME = "hierarchyUniqueName";
    protected boolean factDriven = false;
    protected XQENodeFactory nodeFactory;
    protected PlanningEnvironment environment;
    protected boolean hUseMeasure = false;

    public DMRPushdownQueryGenerator(PlanningEnvironment env, boolean b) {
        this.environment = env;
        this.nodeFactory = this.environment.getNodeFactory();
        this.factDriven = b;
    }

    protected void addChildToParent(IXQEQueryNode parent, IXQEQueryNode child) {
        if (!this.factDriven) {
            parent.addChildNonIndexed(child);
        } else {
            parent.addChild(child);
        }
    }

    public void visit(AbstractMDXNode node, V5QuerySet querySet, List<ContextDataItem> contextDataItemNames, List<ContextDataItem> ancestortDataItemNames, StringBuilder buffer) {
        switch (node.getNodeType()) {
            case 1053: {
                this.visitMDXFilter((MDXFilter)node, querySet, contextDataItemNames, ancestortDataItemNames, buffer);
                break;
            }
            case 1041: {
                this.visitMDXTopBottomFunction((MDXTopBottomFunction)node, querySet, contextDataItemNames, ancestortDataItemNames, buffer);
                break;
            }
            case 1066: {
                BaseHierarchy hier = (BaseHierarchy)node.getChild(0);
                MDXNumericConstant c = (MDXNumericConstant)node.getChild(1);
                int levelIndex = (Integer)c.getConstantValue();
                ILevel level = hier.getHierarchy().getLevel(levelIndex);
                this.visitILevel(level, querySet, contextDataItemNames, ancestortDataItemNames, buffer, (PlanningEnvironment)node.getPlanningEnvironment());
                break;
            }
            case 1065: {
                this.visitBaseLevel((BaseLevel)node, querySet, contextDataItemNames, ancestortDataItemNames, buffer);
                break;
            }
            case 1067: {
                this.visitBaseMember((BaseMember)node, querySet, contextDataItemNames, ancestortDataItemNames, buffer);
                break;
            }
            case 1025: {
                this.visitBaseProperty((BaseProperty)node, querySet, contextDataItemNames, ancestortDataItemNames, buffer);
                break;
            }
            case 1013: {
                this.visitMDXCalculatedMemberReference((MDXCalculatedMemberReference)node, querySet, contextDataItemNames, ancestortDataItemNames, buffer);
                break;
            }
            case 1014: {
                this.visitMDXNamedSetReference((MDXNamedSetReference)node, querySet, contextDataItemNames, ancestortDataItemNames, buffer);
                break;
            }
            case 1015: {
                this.visitMDXSetAliasReference((MDXSetAliasReference)node, querySet, contextDataItemNames, ancestortDataItemNames, buffer);
                break;
            }
            case 1070: {
                this.visitMDXComparisonOperator((MDXComparisonOperator)node, querySet, contextDataItemNames, ancestortDataItemNames, buffer);
                break;
            }
            case 1084: {
                this.visitMDXNumericOperator((MDXNumericOperator)node, querySet, contextDataItemNames, ancestortDataItemNames, buffer);
                break;
            }
            case 1064: {
                this.visitMDXNumericConstant((MDXNumericConstant)node, querySet, contextDataItemNames, ancestortDataItemNames, buffer);
                break;
            }
            case 1127: {
                this.visitMDXStringConstant((MDXStringConstant)node, querySet, contextDataItemNames, ancestortDataItemNames, buffer);
                break;
            }
            case 1163: {
                this.visitMDXParameterBooleanValue((MDXParameterBooleanValue)node, querySet, contextDataItemNames, ancestortDataItemNames, buffer);
                break;
            }
            case 1162: {
                this.visitMDXParameterDateTimeValue((MDXParameterDateTimeValue)node, querySet, contextDataItemNames, ancestortDataItemNames, buffer);
                break;
            }
            case 1161: {
                this.visitMDXParameterNumericValue((MDXParameterNumericValue)node, querySet, contextDataItemNames, ancestortDataItemNames, buffer);
                break;
            }
            case 1159: {
                this.visitMDXParameterStringValue((MDXParameterStringValue)node, querySet, contextDataItemNames, ancestortDataItemNames, buffer);
                break;
            }
            case 1060: 
            case 1087: {
                this.visitAbstractMDXNumericValueFunction((AbstractMDXNumericValueFunction)node, querySet, contextDataItemNames, ancestortDataItemNames, buffer);
                break;
            }
            case 1109: {
                this.visitMDXNot((MDXNot)node, querySet, contextDataItemNames, ancestortDataItemNames, buffer);
                break;
            }
            case 1110: {
                this.visitMDXAnd((MDXAnd)node, querySet, contextDataItemNames, ancestortDataItemNames, buffer);
                break;
            }
            case 1111: {
                this.visitMDXOr((MDXOr)node, querySet, contextDataItemNames, ancestortDataItemNames, buffer);
                break;
            }
            case 1104: {
                this.visitMDXIsEmpty((MDXIsEmpty)node, querySet, contextDataItemNames, ancestortDataItemNames, buffer);
                break;
            }
            case 1085: {
                this.visitMDXNumericIIF((MDXNumericIIF)node, querySet, contextDataItemNames, ancestortDataItemNames, buffer);
                break;
            }
            case 1042: {
                this.visitMDXHeadTailFunction((MDXHeadTailFunction)node, querySet, contextDataItemNames, ancestortDataItemNames, buffer);
                break;
            }
            case 1030: {
                this.visitMDXCrossjoin((MDXCrossjoin)node, querySet, contextDataItemNames, ancestortDataItemNames, buffer);
                break;
            }
            case 1048: {
                this.visitMDXChildren((MDXChildren)node, querySet, contextDataItemNames, ancestortDataItemNames, buffer);
                break;
            }
            case 1039: {
                this.visitMDXSet((MDXSet)node, querySet, contextDataItemNames, ancestortDataItemNames, buffer);
                break;
            }
            case 1032: {
                this.visitMDXExcept((MDXExcept)node, querySet, contextDataItemNames, ancestortDataItemNames, buffer);
                break;
            }
            case 1003: 
            case 1004: 
            case 1005: 
            case 1016: 
            case 1040: 
            case 1052: 
            case 1059: 
            case 1069: 
            case 1073: 
            case 1076: 
            case 1077: {
                for (int i = 0; i < node.getNumberChildren(); ++i) {
                    IXQEQueryNode child = node.getChild(i);
                    if (!(child instanceof AbstractMDXNode)) continue;
                    this.visit((AbstractMDXNode)child, querySet, contextDataItemNames, ancestortDataItemNames, buffer);
                }
                if (node.getType() != 1069) break;
                DMRPushdownQueryGenerator.removeMeasureInfoFromStack(querySet);
                break;
            }
            case 1195: {
                this.visitTNodePushdownAsCustomValue((TNodePushdownAsCustomValue)node, querySet, contextDataItemNames, ancestortDataItemNames, buffer);
                break;
            }
            case 1144: {
                this.visitCogMDXScalarFunction((CogMDXScalarFunction)node, querySet, contextDataItemNames, ancestortDataItemNames, buffer);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    private static boolean isConstant(AbstractMDXNode valueExpr) {
        int type = valueExpr.getType();
        return type == 1064 || type == 1127 || type == 1162 || type == 1161 || type == 1159;
    }

    private void visitCogMDXScalarFunction(CogMDXScalarFunction node, V5QuerySet querySet, List<ContextDataItem> contextDataItemNames, List<ContextDataItem> ancestortDataItemNames, StringBuilder buffer) {
        buffer.append(node.getOperatorTypeString());
        buffer.append("(");
        for (int i = 0; i < node.getNumberChildren(); ++i) {
            this.visit((AbstractMDXNode)node.getChild(i), querySet, contextDataItemNames, ancestortDataItemNames, buffer);
            if (i == node.getNumberChildren() - 1) continue;
            buffer.append(", ");
        }
        buffer.append(")");
    }

    private static void removeMeasureInfoFromStack(V5QuerySet querySet) {
        DMRCustomValueRefiner cvRefiner = DMRPushdownQueryGenerator.getCustomValueRefiner(querySet);
        if (cvRefiner != null) {
            cvRefiner.removeMeasureInfoFromStack();
        }
    }

    private void addCustomValueColumnInPushdownQuery(V5QuerySet querySet, String dataItemName) {
        IXQEQueryNode[] pushdownQueries = querySet.getChildrenOfTypeOrdered(101006);
        V5Query pushdownQuery = (V5Query)pushdownQueries[0];
        V5QueryResultDefinition qrd = (V5QueryResultDefinition)querySet.getFirstDescendantOfTypeOrdered(101055, false);
        IXQEQueryNode groupBody = qrd.getFirstDescendantOfTypeOrdered(101051, false);
        V5DataItemRef dataItemRef = (V5DataItemRef)this.nodeFactory.createNode(101015);
        dataItemRef.setPropertyValue("refDataItem", DMRPushdownQueryGenerator.getLocalDataItemName(dataItemName, pushdownQuery, querySet));
        this.addChildToParent(groupBody, dataItemRef);
    }

    private void visitMDXTopBottomFunction(MDXTopBottomFunction node, V5QuerySet querySet, List<ContextDataItem> contextDataItemNames, List<ContextDataItem> ancestortDataItemNames, StringBuilder buffer) {
        StringBuilder aggregateSetDataItemName = new StringBuilder();
        this.visit((AbstractMDXNode)node.getChild(0), querySet, contextDataItemNames, ancestortDataItemNames, aggregateSetDataItemName);
        StringBuilder constantExpression = new StringBuilder();
        this.visit((AbstractMDXNode)node.getChild(1), querySet, contextDataItemNames, ancestortDataItemNames, constantExpression);
        StringBuilder valueExpr = new StringBuilder();
        this.visit((AbstractMDXNode)node.getChild(2), querySet, contextDataItemNames, ancestortDataItemNames, valueExpr);
        V5Query query = this.addPushdownQuery(querySet, PUSHDOWNQUERY_V5QUERY_NAME);
        List<V5Query> allQueries = DMRPushdownQueryGenerator.getOrderedQueryList(querySet);
        ArrayList<V5Query> queryList = new ArrayList<V5Query>();
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("aggregate", "none");
        properties.put("rollupAggregate", "none");
        String valueExprStr = valueExpr.toString();
        if (valueExprStr.startsWith(PUSHDOWNQUERY_2PARTS_DI_NAME)) {
            try {
                int i;
                String[] parts = UniqueNameParser.parse(valueExprStr);
                for (i = 0; i < allQueries.size() && !allQueries.get(i).getRootQueryName().equals(parts[0]); ++i) {
                }
                ++i;
                while (i < allQueries.size()) {
                    queryList.add(allQueries.get(i));
                    ++i;
                }
            }
            catch (UniqueNameParserException e) {
                queryList.addAll(allQueries);
            }
        }
        String valueExprDataItemName = this.addDataItemToPushdownQueries(valueExprStr, null, properties, queryList, null);
        valueExprDataItemName = UniqueNameGenerator.createSingleNamePart(DMRPushdownQueryGenerator.getLocalDataItemName(valueExprDataItemName, query, querySet));
        int order = 2;
        switch (node.getOperatorType()) {
            case 1: 
            case 2: 
            case 3: {
                order = 2;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                order = 1;
                break;
            }
        }
        V5OrderedValueExpression orderedValueExpr = (V5OrderedValueExpression)this.nodeFactory.createNode(201114);
        orderedValueExpr.setSubType(order);
        IXQEQueryNode dataItemIdentifier = this.nodeFactory.createNode(201030);
        ((V5MultiPartIdentifier)dataItemIdentifier).setIdentifier(valueExprDataItemName);
        this.addChildToParent(orderedValueExpr, dataItemIdentifier);
        String dataItemName = this.addTopBottomDetailFilter(orderedValueExpr, constantExpression.toString(), contextDataItemNames, ancestortDataItemNames, query, querySet);
        IXQEQueryNode dataItemRef = this.nodeFactory.createNode(101056);
        dataItemRef.setPropertyValue("refDataItem", dataItemName);
        dataItemRef.setPropertyValue("sortOrder", "ascending");
        ArrayList<IXQEQueryNode> sortList = new ArrayList<IXQEQueryNode>();
        if (contextDataItemNames.isEmpty()) {
            sortList.add(dataItemRef);
        }
        V5QueryResultDefinition qrd = (V5QueryResultDefinition)querySet.getFirstDescendantOfTypeOrdered(101055, false);
        IXQEQueryNode groupBody = qrd.getFirstDescendantOfTypeOrdered(101051, false);
        IXQEQueryNode valueSet = groupBody.getParent();
        for (int i = 0; i < valueSet.getNumberChildren(); ++i) {
            IXQEQueryNode child = valueSet.getChild(i);
            if (child.getType() != 101056) continue;
            sortList.add(child);
            String sortItemName = (String)child.getPropertyValue("refDataItem");
            if (contextDataItemNames.isEmpty() || !sortItemName.equals(DMRPushdownQueryGenerator.getLocalDataItemName(contextDataItemNames.get(contextDataItemNames.size() - 1).getContextItem(), query, querySet))) continue;
            sortList.add(dataItemRef);
        }
        Iterator<IXQEQueryNode> itChildren = valueSet.getChildrenIterator();
        while (itChildren.hasNext()) {
            IXQEQueryNode child = itChildren.next();
            if (child.getType() != 101056) continue;
            itChildren.remove();
        }
        for (IXQEQueryNode sortItem : sortList) {
            this.addChildToParent(valueSet, sortItem);
        }
    }

    private String buildFilterExpressionString(int operatorType, String lhs, String rhs) {
        StringBuilder buffer = new StringBuilder();
        IXQEQueryNode comparisonExpr = this.nodeFactory.createNode(201013);
        ((V5ComparisonExpression)comparisonExpr).setSubType(operatorType);
        IXQEQueryNode dataItemIdentifier = null;
        dataItemIdentifier = this.nodeFactory.createNode(201030);
        ((V5MultiPartIdentifier)dataItemIdentifier).setIdentifier(lhs);
        this.addChildToParent(comparisonExpr, dataItemIdentifier);
        dataItemIdentifier = this.nodeFactory.createNode(201030);
        ((V5MultiPartIdentifier)dataItemIdentifier).setIdentifier(rhs);
        this.addChildToParent(comparisonExpr, dataItemIdentifier);
        comparisonExpr.writeFormattedText(buffer);
        return buffer.toString();
    }

    private void visitMDXIsEmpty(MDXIsEmpty node, V5QuerySet querySet, List<ContextDataItem> contextDataItemNames, List<ContextDataItem> ancestortDataItemNames, StringBuilder buffer) {
        this.visit((AbstractMDXNode)node.getChild(0), querySet, contextDataItemNames, ancestortDataItemNames, buffer);
        buffer.append("=");
        buffer.append("NULL");
    }

    private void visitMDXNumericIIF(MDXNumericIIF node, V5QuerySet querySet, List<ContextDataItem> contextDataItemNames, List<ContextDataItem> ancestortDataItemNames, StringBuilder buffer) {
        buffer.append("if (");
        this.visit((AbstractMDXNode)node.getChild(0), querySet, contextDataItemNames, ancestortDataItemNames, buffer);
        buffer.append(") then (");
        this.visit((AbstractMDXNode)node.getChild(1), querySet, contextDataItemNames, ancestortDataItemNames, buffer);
        buffer.append(") else (");
        this.visit((AbstractMDXNode)node.getChild(2), querySet, contextDataItemNames, ancestortDataItemNames, buffer);
        buffer.append(")");
    }

    private void visitMDXNot(MDXNot node, V5QuerySet querySet, List<ContextDataItem> contextDataItemNames, List<ContextDataItem> ancestortDataItemNames, StringBuilder buffer) {
        buffer.append("NOT");
        buffer.append("(");
        this.visit((AbstractMDXNode)node.getChild(0), querySet, contextDataItemNames, ancestortDataItemNames, buffer);
        buffer.append(")");
    }

    private void visitMDXAnd(MDXAnd node, V5QuerySet querySet, List<ContextDataItem> contextDataItemNames, List<ContextDataItem> ancestortDataItemNames, StringBuilder buffer) {
        for (int i = 0; i < node.getNumberChildren(); ++i) {
            IXQEQueryNode child = node.getChild(i);
            if (!(child instanceof AbstractMDXNode)) continue;
            this.visit((AbstractMDXNode)child, querySet, contextDataItemNames, ancestortDataItemNames, buffer);
            if (i == node.getNumberChildren() - 1) continue;
            buffer.append(" AND ");
        }
    }

    private void visitMDXOr(MDXOr node, V5QuerySet querySet, List<ContextDataItem> contextDataItemNames, List<ContextDataItem> ancestortDataItemNames, StringBuilder buffer) {
        buffer.append("(");
        for (int i = 0; i < node.getNumberChildren(); ++i) {
            IXQEQueryNode child = node.getChild(i);
            if (!(child instanceof AbstractMDXNode)) continue;
            this.visit((AbstractMDXNode)child, querySet, contextDataItemNames, ancestortDataItemNames, buffer);
            if (i == node.getNumberChildren() - 1) continue;
            buffer.append(" OR ");
        }
        buffer.append(")");
    }

    private void visitMDXFilter(MDXFilter node, V5QuerySet querySet, List<ContextDataItem> contextDataItemNames, List<ContextDataItem> ancestortDataItemNames, StringBuilder buffer) {
        IXQEQueryNode booleanExpr = node.getChild(1);
        if (!booleanExpr.isOfCategory(1071)) {
            throw new UnsupportedOperationException();
        }
        this.visit((AbstractMDXNode)node.getChild(0), querySet, contextDataItemNames, ancestortDataItemNames, buffer);
        List<ContextDataItem> contextDataItemForValue = DMRPushdownQueryGenerator.rebuildContextDataItemNameList(contextDataItemNames, ancestortDataItemNames, buffer);
        StringBuilder filterExpression = new StringBuilder();
        this.visit((AbstractMDXNode)booleanExpr, querySet, contextDataItemForValue, ancestortDataItemNames, filterExpression);
        V5DetailFilter detailFilter = (V5DetailFilter)this.nodeFactory.createNode(101008);
        detailFilter.setPostAutoAggregation(true);
        detailFilter.setStringPropertyValue("use", STR_REQUIRED);
        IXQEQueryNode filterExpressionNode = this.nodeFactory.createNode(101013);
        filterExpressionNode.setPropertyValue(STR_EXPRESSION, filterExpression.toString());
        detailFilter.addChild(filterExpressionNode);
        V5QueryResultDefinition qrd = (V5QueryResultDefinition)querySet.getFirstDescendantOfTypeOrdered(101055, false);
        V5Query query = querySet.getV5Query(qrd.getRefQueryProperty());
        if (query.getDescendantsOfType(101008, false).length != 0) {
            query = this.addPushdownQuery(querySet, PUSHDOWNQUERY_V5QUERY_NAME);
        }
        this.addChildToParent(query, detailFilter);
    }

    private void visitBaseLevel(BaseLevel node, V5QuerySet querySet, List<ContextDataItem> contextDataItemNames, List<ContextDataItem> ancestortDataItemNames, StringBuilder buffer) {
        ILevel level = node.getLevel();
        this.visitILevel(level, querySet, contextDataItemNames, ancestortDataItemNames, buffer, (PlanningEnvironment)node.getPlanningEnvironment());
    }

    private void visitILevel(ILevel level, V5QuerySet querySet, List<ContextDataItem> contextDataItemNames, List<ContextDataItem> ancestorDataItemNames, StringBuilder buffer, PlanningEnvironment env) {
        if (level instanceof MDXLevelInfo.LevelInfo) {
            level = ((MDXLevelInfo.LevelInfo)level).getLevel();
        }
        while (!level.isRootLevel()) {
            ContextDataItem di = this.addLevelToV5QuerySet((LevelWrapper)level, false, querySet);
            boolean isNewContext = true;
            ArrayList<ContextDataItem> totalContext = new ArrayList<ContextDataItem>();
            totalContext.addAll(contextDataItemNames);
            DMRPushdownQueryGenerator.addIfNotExist(ancestorDataItemNames, totalContext);
            for (ContextDataItem existingContext : totalContext) {
                if (!existingContext.getContextItem().equals(di.getContextItem())) continue;
                isNewContext = false;
                break;
            }
            if (isNewContext) {
                if (buffer.length() != 0) {
                    buffer.insert(0, "; ");
                }
                buffer.insert(0, di.getContextItem());
            }
            level = level.getPreviousLevel();
        }
    }

    private void visitBaseMember(BaseMember node, V5QuerySet querySet, List<ContextDataItem> contextDataItemNames, List<ContextDataItem> ancestorDataItemNames, StringBuilder buffer) {
        ArrayList<ContextDataItem> totalContext = new ArrayList<ContextDataItem>();
        totalContext.addAll(contextDataItemNames);
        DMRPushdownQueryGenerator.addIfNotExist(ancestorDataItemNames, totalContext);
        if (node.isMeasure()) {
            String aggrgatedMeasureDataItemRef = this.addAggregatedMeasureToV5QuerySet(node, totalContext, querySet, null);
            buffer.append(aggrgatedMeasureDataItemRef);
            this.hUseMeasure = true;
        } else {
            this.addMemberDetailFilter(node, querySet);
        }
    }

    private void visitBaseProperty(BaseProperty node, V5QuerySet querySet, List<ContextDataItem> contextDataItemNames, List<ContextDataItem> ancestortDataItemNames, StringBuilder buffer) {
        List<V5Query> queryList = DMRPushdownQueryGenerator.getOrderedQueryList(querySet);
        IQueryItem metadata = node.getPropertyMetadata();
        if (metadata == null) {
            metadata = node.getSupplementaryMetadata();
        }
        String expr = null;
        if (metadata == null) {
            RoleTypeEnum roleType;
            IHierarchy hierarchy;
            MDXLevelInfo levelInfo = ((AbstractMDXNode)node.getParent()).getLevelInfo();
            if (levelInfo.getHierarchyInfo().getNumProjectedHierarchies() == 1 && levelInfo.getNumProjectedLevels(hierarchy = levelInfo.getHierarchyInfo().getProjectedHierarchy(0)) == 1 && (roleType = (RoleTypeEnum)((Object)node.getPropertyValue("propertyRoleType"))) != null && roleType == RoleTypeEnum.MEMBER_CAPTION) {
                ILevel level = levelInfo.getProjectedLevels(hierarchy).get(0);
                level = ((MDXLevelInfo.LevelInfo)level).getLevel();
                expr = ((LevelWrapper)level).getQueryItemExpressionForCaption();
            }
        } else {
            expr = metadata.getExpression();
            if (expr == null) {
                expr = (String)metadata.getProperty("ID");
            }
            expr = MetadataUtil.extractExpressionFromModelString(expr, (PlanningEnvironment)node.getPlanningEnvironment());
        }
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("aggregate", "none");
        properties.put("rollupAggregate", "none");
        String valueExprDataItemName = this.addDataItemToPushdownQueries(expr, null, properties, queryList, null);
        buffer.append(valueExprDataItemName);
    }

    private void visitMDXCalculatedMemberReference(MDXCalculatedMemberReference node, V5QuerySet querySet, List<ContextDataItem> contextDataItemNames, List<ContextDataItem> ancestortDataItemNames, StringBuilder buffer) {
        MDXCalculatedMemberDefinition definition = node.getDefinition();
        this.visit(definition, querySet, contextDataItemNames, ancestortDataItemNames, buffer);
    }

    private void visitMDXNamedSetReference(MDXNamedSetReference node, V5QuerySet querySet, List<ContextDataItem> contextDataItemNames, List<ContextDataItem> ancestortDataItemNames, StringBuilder buffer) {
        MDXNamedSetDefinition definition = node.getDefinition();
        this.visit(definition, querySet, contextDataItemNames, ancestortDataItemNames, buffer);
    }

    private void visitMDXSetAliasReference(MDXSetAliasReference node, V5QuerySet querySet, List<ContextDataItem> contextDataItemNames, List<ContextDataItem> ancestortDataItemNames, StringBuilder buffer) {
        MDXSetAliasDefinition definition = node.getDefinition();
        this.visit(definition, querySet, contextDataItemNames, ancestortDataItemNames, buffer);
    }

    private void visitMDXComparisonOperator(MDXComparisonOperator node, V5QuerySet querySet, List<ContextDataItem> contextDataItemNames, List<ContextDataItem> ancestortDataItemNames, StringBuilder buffer) {
        this.visit((AbstractMDXNode)node.getChild(0), querySet, contextDataItemNames, ancestortDataItemNames, buffer);
        buffer.append(' ');
        if (node.getOperatorType() == 7) {
            buffer.append("starts with");
        } else if (node.getOperatorType() == 8) {
            buffer.append("ends with");
        } else {
            buffer.append(node.getMDXString());
        }
        buffer.append(' ');
        this.visit((AbstractMDXNode)node.getChild(1), querySet, contextDataItemNames, ancestortDataItemNames, buffer);
    }

    private void visitMDXNumericConstant(MDXNumericConstant node, V5QuerySet querySet, List<ContextDataItem> contextDataItemNames, List<ContextDataItem> ancestortDataItemNames, StringBuilder buffer) {
        node.writeFormattedText(buffer);
    }

    private void visitMDXStringConstant(MDXStringConstant node, V5QuerySet querySet, List<ContextDataItem> contextDataItemNames, List<ContextDataItem> ancestortDataItemNames, StringBuilder buffer) {
        buffer.append(SINGLE_QUOTE);
        buffer.append(DMRPushdownQueryGenerator.escapeSingleQuotes(node.getConstantValue()));
        buffer.append(SINGLE_QUOTE);
    }

    private void visitMDXParameterStringValue(MDXParameterStringValue node, V5QuerySet querySet, List<ContextDataItem> contextDataItemNames, List<ContextDataItem> ancestortDataItemNames, StringBuilder buffer) {
        List<String> extNames = node.getExternalValues();
        Iterator<String> it = extNames.iterator();
        buffer.append(SINGLE_QUOTE);
        buffer.append(it.next());
        buffer.append(SINGLE_QUOTE);
        while (it.hasNext()) {
            buffer.append("; ");
            buffer.append(SINGLE_QUOTE);
            buffer.append(it.next());
            buffer.append(SINGLE_QUOTE);
        }
    }

    private void visitMDXParameterNumericValue(MDXParameterNumericValue node, V5QuerySet querySet, List<ContextDataItem> contextDataItemNames, List<ContextDataItem> ancestortDataItemNames, StringBuilder buffer) {
        List<String> extNames = node.getExternalValues();
        Iterator<String> it = extNames.iterator();
        buffer.append(it.next());
        while (it.hasNext()) {
            buffer.append("; ");
            buffer.append(it.next());
        }
    }

    private void visitMDXParameterDateTimeValue(MDXParameterDateTimeValue node, V5QuerySet querySet, List<ContextDataItem> contextDataItemNames, List<ContextDataItem> ancestortDataItemNames, StringBuilder buffer) {
        List<String> extNames = node.getExternalValues();
        Iterator<String> it = extNames.iterator();
        buffer.append(it.next());
        while (it.hasNext()) {
            buffer.append("; ");
            buffer.append(it.next());
        }
    }

    private void visitMDXParameterBooleanValue(MDXParameterBooleanValue node, V5QuerySet querySet, List<ContextDataItem> contextDataItemNames, List<ContextDataItem> ancestortDataItemNames, StringBuilder buffer) {
        List<String> extNames = node.getExternalValues();
        Iterator<String> it = extNames.iterator();
        buffer.append(it.next());
        while (it.hasNext()) {
            buffer.append("; ");
            buffer.append(it.next());
        }
    }

    private void visitMDXNumericOperator(MDXNumericOperator node, V5QuerySet querySet, List<ContextDataItem> contextDataItemNames, List<ContextDataItem> ancestortDataItemNames, StringBuilder buffer) {
        this.visit((AbstractMDXNode)node.getChild(0), querySet, contextDataItemNames, ancestortDataItemNames, buffer);
        buffer.append(' ');
        buffer.append(node.getMDXOperatorName());
        buffer.append(' ');
        this.visit((AbstractMDXNode)node.getChild(1), querySet, contextDataItemNames, ancestortDataItemNames, buffer);
    }

    private void visitMDXCrossjoin(MDXCrossjoin node, V5QuerySet querySet, List<ContextDataItem> contextDataItemNames, List<ContextDataItem> ancestorDataItemNames, StringBuilder buffer) {
        for (int i = 0; i < node.getNumberChildren(); ++i) {
            IXQEQueryNode child = node.getChild(i);
            while (child.getType() == 1039 && child.getNumberChildren() == 1) {
                child = child.getChild(0);
            }
            if (child.getType() == 1076 || child.getType() == 1077) continue;
            if (child.getType() == 1067) {
                if (((BaseMember)child).getMember() != null && ((BaseMember)child).getMember().isMeasure()) continue;
                throw new UnsupportedOperationException();
            }
            if (child.getType() == 1040) continue;
            throw new UnsupportedOperationException();
        }
        AbstractMDXNode measure = null;
        for (int i = 0; i < node.getNumberChildren(); ++i) {
            IXQEQueryNode child = node.getChild(i);
            while (child.getType() == 1039 && child.getNumberChildren() == 1) {
                child = child.getChild(0);
            }
            if (child.getType() == 1067 && ((BaseMember)child).getMember() != null && ((BaseMember)child).getMember().isMeasure()) {
                measure = (AbstractMDXNode)child;
                continue;
            }
            this.visit((AbstractMDXNode)child, querySet, contextDataItemNames, ancestorDataItemNames, buffer);
        }
        if (measure == null) {
            return;
        }
        ArrayList<ContextDataItem> totalContext = new ArrayList<ContextDataItem>();
        totalContext.addAll(contextDataItemNames);
        DMRPushdownQueryGenerator.addIfNotExist(ancestorDataItemNames, totalContext);
        String[] dataItemNames = buffer.toString().split("; ");
        ArrayList<ContextDataItem> contextDataItemForValue = new ArrayList<ContextDataItem>();
        contextDataItemForValue.addAll(totalContext);
        for (String di : dataItemNames) {
            boolean isExisting = false;
            for (ContextDataItem f : contextDataItemForValue) {
                if (!f.getContextItem().equals(di)) continue;
                isExisting = true;
                break;
            }
            if (isExisting) continue;
            contextDataItemForValue.add(new ContextDataItem(di));
        }
        contextDataItemForValue.removeAll(ancestorDataItemNames);
        if (buffer.length() > 0) {
            buffer.append("; ");
        }
        this.visit(measure, querySet, contextDataItemForValue, ancestorDataItemNames, buffer);
    }

    private void visitMDXChildren(MDXChildren node, V5QuerySet querySet, List<ContextDataItem> contextDataItemNames, List<ContextDataItem> ancestortDataItemNames, StringBuilder buffer) {
        this.visitBaseMember((BaseMember)node.getChild(0), querySet, contextDataItemNames, ancestortDataItemNames, buffer);
    }

    private void visitMDXSet(MDXSet node, V5QuerySet querySet, List<ContextDataItem> contextDataItemNames, List<ContextDataItem> ancestortDataItemNames, StringBuilder buffer) {
        IXQEQueryNode[] muns = node.getChildren();
        IXQEQueryNode filterExpr = null;
        for (IXQEQueryNode m : muns) {
            String logical;
            String mun;
            if (m.getType() != 1067) {
                throw new UnsupportedOperationException();
            }
            BaseMember member = (BaseMember)m;
            ILevel level = member.getLevel();
            IXQEQueryNode in = DMRMemberLoadQuery.createInExpression(this.nodeFactory, level, mun = member.getExternalName(), logical = (String)member.getPropertyValue("logical"));
            if (in == null) continue;
            filterExpr = DMRMemberLoadQuery.createLogicalExpression(this.nodeFactory, in, filterExpr, 1);
        }
        if (filterExpr == null) {
            return;
        }
        List<V5Query> allQueries = DMRPushdownQueryGenerator.getOrderedQueryList(querySet);
        V5Query query = allQueries.get(allQueries.size() - 1);
        V5DetailFilter detailFilter = (V5DetailFilter)this.nodeFactory.createNode(101008);
        detailFilter.setPostAutoAggregation(false);
        detailFilter.addChild(filterExpr);
        query.addChild(detailFilter);
    }

    private void visitMDXHeadTailFunction(MDXHeadTailFunction node, V5QuerySet querySet, List<ContextDataItem> contextDataItemNames, List<ContextDataItem> ancestortDataItemNames, StringBuilder buffer) {
        StringBuilder aggregateSetDataItemName = new StringBuilder();
        this.visit((AbstractMDXNode)node.getChild(0), querySet, contextDataItemNames, ancestortDataItemNames, aggregateSetDataItemName);
        StringBuilder constantExpression = new StringBuilder();
        if (node.getNumberChildren() > 1) {
            this.visit((AbstractMDXNode)node.getChild(1), querySet, contextDataItemNames, ancestortDataItemNames, constantExpression);
        } else {
            constantExpression.append(ONE);
        }
        int order = 2;
        order = node.getOperatorType() == 1 ? 2 : 1;
        V5OrderedValueExpression orderedValueExpr = (V5OrderedValueExpression)this.nodeFactory.createNode(201114);
        orderedValueExpr.setSubType(order);
        V5Query query = this.addPushdownQuery(querySet, PUSHDOWNQUERY_V5QUERY_NAME);
        this.addTopBottomDetailFilter(orderedValueExpr, constantExpression.toString(), contextDataItemNames, ancestortDataItemNames, query, querySet);
    }

    private Boolean isSameAggr(Integer v5Aggr, String aggr) {
        if (aggr == null) {
            return null;
        }
        Pair v5AggregateFunctionSubtype = AggregationUtils.convertAggregateNameToV5AggregateFunctionSubtype(aggr.toLowerCase(), null);
        return v5Aggr.equals(v5AggregateFunctionSubtype.getFirst());
    }

    private Boolean measureAggregateSameAggrName(AbstractMDXNode valueExpr, String aggregateName, AbstractMDXNode setNode, V5QuerySet querySet, V5Query query, List<ContextDataItem> contextToCheck, ILevel[] lvl) {
        Boolean rt;
        block9: {
            int tp;
            IXQEQueryNode node;
            Integer v5Aggr;
            block8: {
                rt = null;
                Pair v5AggregateFunctionSubtype = AggregationUtils.convertAggregateNameToV5AggregateFunctionSubtype(aggregateName.toLowerCase(), null);
                v5Aggr = (Integer)v5AggregateFunctionSubtype.getFirst();
                node = valueExpr;
                tp = node.getType();
                if (tp == 1059) {
                    node = node.getChild(0);
                    tp = node.getType();
                }
                if (tp != 1067) break block8;
                IXQEQueryNode[] mb = (IXQEQueryNode[])node;
                if (!mb.isMeasure()) break block9;
                rt = this.isSameAggr(v5Aggr, this.getMeasureAggrName(mb.getMember()));
                break block9;
            }
            if (tp == 1069) {
                for (IXQEQueryNode n : node.getChildren()) {
                    BaseMember mb;
                    tp = n.getType();
                    if (tp != 1067 || !(mb = (BaseMember)n).isMeasure()) continue;
                    rt = this.isSameAggr(v5Aggr, this.getMeasureAggrName(mb.getMember()));
                    break;
                }
            }
        }
        if (rt == null) {
            return rt;
        }
        MDXLevelInfo levelInfo = setNode.getLevelInfo();
        if (levelInfo.getHierarchyInfo().getNumProjectedHierarchies() != 1) {
            return null;
        }
        IHierarchy hierarchy = levelInfo.getHierarchyInfo().getProjectedHierarchy(0);
        if (levelInfo.getNumProjectedLevels(hierarchy) != 1) {
            return null;
        }
        lvl[0] = levelInfo.getProjectedLevels(hierarchy).get(0);
        V5Selection select = query.getV5Selection();
        for (ContextDataItem c : contextToCheck) {
            String nm = DMRPushdownQueryGenerator.getLocalDataItemName(c.getContextItem(), query, querySet);
            V5DataItem di = select.getDataItemByRefName(nm);
            if (di == null) {
                return null;
            }
            String hierUName = (String)di.getPropertyValue(HIERARCHY_UNAME);
            if (!hierarchy.getUniqueName().equals(hierUName)) continue;
            return null;
        }
        return rt;
    }

    private void visitAbstractMDXNumericValueFunction(AbstractMDXNumericValueFunction node, V5QuerySet querySet, List<ContextDataItem> contextDataItemNames, List<ContextDataItem> ancestorDataItemNames, StringBuilder buffer) {
        int i;
        ArrayList<ContextDataItem> scope2;
        AbstractMDXNode valueExpr = null;
        String aggregateName = null;
        String valueExprStr = null;
        Object[] dataItemNames = null;
        if (node.getChild(0).getType() == 1041 || node.getChild(0).getType() == 1042) {
            throw new UnsupportedOperationException();
        }
        ArrayList<ContextDataItem> totalContext = new ArrayList<ContextDataItem>();
        totalContext.addAll(contextDataItemNames);
        DMRPushdownQueryGenerator.addIfNotExist(ancestorDataItemNames, totalContext);
        StringBuilder aggregateSetDataItemName = new StringBuilder();
        this.visit((AbstractMDXNode)node.getChild(0), querySet, contextDataItemNames, ancestorDataItemNames, aggregateSetDataItemName);
        if (aggregateSetDataItemName.length() > 0) {
            dataItemNames = aggregateSetDataItemName.toString().split("; ");
        }
        List<ContextDataItem> contextDataItemForValue = DMRPushdownQueryGenerator.rebuildContextDataItemNameList(contextDataItemNames, ancestorDataItemNames, aggregateSetDataItemName);
        List<V5Query> allQueries = DMRPushdownQueryGenerator.getOrderedQueryList(querySet);
        V5Query query = allQueries.get(allQueries.size() - 1);
        Boolean bAggregateSameAsMeasureAggr = null;
        if (node.getType() == 1060) {
            aggregateName = ((MDXSummaryFunction)node).getMDXSummaryString();
            valueExpr = (AbstractMDXNode)node.getChild(1);
            StringBuilder valueExprDataItemName = new StringBuilder();
            if (DMRPushdownQueryGenerator.isConstant(valueExpr)) {
                valueExprStr = this.addConstantMeasureToV5QuerySet(valueExpr, querySet);
            } else {
                List<ContextDataItem> contextDIs = contextDataItemForValue;
                ILevel[] lvl = new ILevel[]{null};
                if (DMRPushdownQueryGenerator.getCustomValueRefiner(querySet) == null) {
                    ArrayList<ContextDataItem> contextToCheck = new ArrayList<ContextDataItem>(contextDataItemForValue);
                    contextToCheck.addAll(ancestorDataItemNames);
                    bAggregateSameAsMeasureAggr = this.measureAggregateSameAggrName(valueExpr, aggregateName, (AbstractMDXNode)node.getChild(0), querySet, query, contextToCheck, lvl);
                }
                if (Boolean.FALSE.equals(bAggregateSameAsMeasureAggr)) {
                    String[] newDataItemNames;
                    StringBuilder feedBack = new StringBuilder();
                    this.visitILevel(lvl[0], querySet, contextDataItemNames, ancestorDataItemNames, feedBack, (PlanningEnvironment)node.getPlanningEnvironment());
                    contextDIs = new ArrayList<ContextDataItem>(contextDataItemForValue);
                    for (String newDI : newDataItemNames = feedBack.toString().split("; ")) {
                        contextDIs.add(new ContextDataItem(newDI));
                    }
                }
                this.visit(valueExpr, querySet, contextDIs, ancestorDataItemNames, valueExprDataItemName);
                valueExprStr = valueExprDataItemName.toString();
            }
        } else if (node.getType() == 1087) {
            if (((MDXCount)node).includeEmpty()) {
                aggregateName = "total";
                scope2 = new ArrayList<ContextDataItem>();
                scope2.addAll(contextDataItemForValue);
                scope2.addAll(ancestorDataItemNames);
                V5ValueSummaryFunction rowCount = this.createValueSummaryExpression(aggregateName, ONE, scope2, query, querySet);
                StringBuilder rowCountString = new StringBuilder();
                rowCount.writeFormattedText(rowCountString);
                valueExprStr = rowCountString.toString();
            } else {
                aggregateName = "COUNT";
                valueExprStr = dataItemNames[dataItemNames.length - 1];
            }
        } else {
            throw new UnsupportedOperationException();
        }
        if (valueExprStr.startsWith(PUSHDOWNQUERY_2PARTS_DI_NAME)) {
            try {
                UniqueNameParser.parse(valueExprStr);
                valueExprStr = UniqueNameGenerator.createSingleNamePart(DMRPushdownQueryGenerator.getLocalDataItemName(valueExprStr, query, querySet));
            }
            catch (UniqueNameParserException scope2) {
                // empty catch block
            }
        }
        scope2 = new ArrayList();
        if (dataItemNames != null && dataItemNames.length > 0) {
            for (ContextDataItem aContext : totalContext) {
                if (Arrays.binarySearch(dataItemNames, aContext.getContextItem()) >= 0) continue;
                scope2.add(aContext);
            }
        } else {
            scope2.addAll(contextDataItemNames);
            if (Boolean.FALSE.equals(bAggregateSameAsMeasureAggr)) {
                scope2.addAll(ancestorDataItemNames);
            }
        }
        String exprStr = null;
        String suff = null;
        if (Boolean.TRUE.equals(bAggregateSameAsMeasureAggr)) {
            exprStr = valueExprStr;
            suff = aggregateName;
        } else {
            V5ValueSummaryFunction aggrExpression = this.createValueSummaryExpression(aggregateName, valueExprStr, scope2, query, querySet);
            StringBuilder summaryFunctionExpressionString = new StringBuilder();
            aggrExpression.writeFormattedText(summaryFunctionExpressionString);
            exprStr = summaryFunctionExpressionString.toString();
            suff = aggrExpression.getNativeName();
        }
        ArrayList<V5Query> queryList = new ArrayList<V5Query>();
        for (i = 0; i < allQueries.size() && query != allQueries.get(i); ++i) {
        }
        while (i < allQueries.size()) {
            queryList.add(allQueries.get(i));
            ++i;
        }
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("aggregate", "calculated");
        String dataItemName = this.addDataItemToPushdownQueries(exprStr, suff, properties, queryList, null);
        buffer.append(dataItemName);
    }

    private static void addIfNotExist(List<ContextDataItem> ancestorDataItemNames, List<ContextDataItem> totalContext) {
        for (ContextDataItem itemX : ancestorDataItemNames) {
            boolean found = false;
            for (ContextDataItem itemY : totalContext) {
                if (!itemX.getContextItem().equals(itemY.getContextItem())) continue;
                found = true;
                break;
            }
            if (found) continue;
            totalContext.add(itemX);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void visitMDXExcept(MDXExcept node, V5QuerySet querySet, List<ContextDataItem> contextDataItemNames, List<ContextDataItem> ancestortDataItemNames, StringBuilder buffer) {
        String diName;
        int i;
        String op2DiName;
        String op1DiName;
        String expr;
        Document customSetQueryDocument;
        V5QuerySet exceptQuerySet = (V5QuerySet)this.nodeFactory.deepCopyNode(querySet);
        this.visit((AbstractMDXNode)node.getChild(0), querySet, contextDataItemNames, ancestortDataItemNames, buffer);
        this.visit((AbstractMDXNode)node.getChild(1), exceptQuerySet, contextDataItemNames, ancestortDataItemNames, buffer);
        int index = exceptQuerySet.getChildrenOfType(101006).length + querySet.getChildrenOfType(101006).length;
        String newName = "EXCEPT" + index + PUSHDOWNQUERY_V5QUERY_NAME;
        V5SpecificationGeneration visitor = new V5SpecificationGeneration();
        visitor.visit(exceptQuerySet);
        String queryString = visitor.dumpToString();
        queryString = queryString.replaceAll(PUSHDOWNQUERY_V5QUERY_NAME, newName);
        try {
            SAXReader xmlReader = XQESAXReaderPool.getInstance().borrowReader();
            try {
                customSetQueryDocument = xmlReader.read((InputStream)new ByteArrayInputStream(queryString.getBytes(UTF8)));
            }
            finally {
                if (xmlReader != null) {
                    XQESAXReaderPool.getInstance().returnReader(xmlReader);
                }
            }
        }
        catch (Exception e) {
            throw new UnsupportedOperationException();
        }
        Element rootElement = customSetQueryDocument.getRootElement();
        Element querySetElement = rootElement.element("querySet");
        V5QuerySet v5SubSetQuerySet = (V5QuerySet)this.nodeFactory.createNode(101002);
        v5SubSetQuerySet.capture(this.environment, querySetElement);
        v5SubSetQuerySet.addToIndex();
        List<V5Query> queriesOp1 = DMRPushdownQueryGenerator.getOrderedQueryList(querySet);
        V5Query queryOp1 = queriesOp1.get(queriesOp1.size() - 1);
        List<V5Query> queriesOp2 = DMRPushdownQueryGenerator.getOrderedQueryList(v5SubSetQuerySet);
        V5Query queryOp2 = queriesOp2.get(queriesOp2.size() - 1);
        ArrayList<String> op1DIs = new ArrayList<String>();
        ArrayList<String> op2DIs = new ArrayList<String>();
        for (ContextDataItem cDI : ancestortDataItemNames) {
            for (Pair sortExpr : cDI.getSortItems()) {
                expr = (String)sortExpr.getFirst();
                op1DiName = DMRPushdownQueryGenerator.getLocalDataItemName(expr, queryOp1, querySet);
                op1DiName = UniqueNameGenerator.appendUniqueName(UniqueNameGenerator.createSingleNamePart(queryOp1.getRootQueryName()), op1DiName);
                op2DiName = DMRPushdownQueryGenerator.getLocalDataItemName(expr.replaceAll(PUSHDOWNQUERY_V5QUERY_NAME, newName), queryOp2, v5SubSetQuerySet);
                op2DiName = UniqueNameGenerator.appendUniqueName(UniqueNameGenerator.createSingleNamePart(queryOp2.getRootQueryName()), op2DiName);
                op1DIs.add(op1DiName);
                op2DIs.add(op2DiName);
            }
        }
        for (ContextDataItem cDI : contextDataItemNames) {
            for (Pair sortExpr : cDI.getSortItems()) {
                expr = (String)sortExpr.getFirst();
                op1DiName = DMRPushdownQueryGenerator.getLocalDataItemName(expr, queryOp1, querySet);
                op1DiName = UniqueNameGenerator.appendUniqueName(UniqueNameGenerator.createSingleNamePart(queryOp1.getRootQueryName()), op1DiName);
                op2DiName = DMRPushdownQueryGenerator.getLocalDataItemName(expr.replaceAll(PUSHDOWNQUERY_V5QUERY_NAME, newName), queryOp2, v5SubSetQuerySet);
                op2DiName = UniqueNameGenerator.appendUniqueName(UniqueNameGenerator.createSingleNamePart(queryOp2.getRootQueryName()), op2DiName);
                op1DIs.add(op1DiName);
                op2DIs.add(op2DiName);
            }
        }
        StringBuilder joinExpr = new StringBuilder();
        joinExpr.append("ROW(");
        for (i = 0; i < op1DIs.size(); ++i) {
            diName = (String)op1DIs.get(i);
            joinExpr.append(diName);
            if (i >= op1DIs.size() - 1) continue;
            joinExpr.append(", ");
        }
        joinExpr.append(") NOT IN (");
        for (i = 0; i < op2DIs.size(); ++i) {
            diName = (String)op2DIs.get(i);
            joinExpr.append(diName);
            if (i >= op2DIs.size() - 1) continue;
            joinExpr.append(", ");
        }
        joinExpr.append(")");
        V5DetailFilter detailFilter = (V5DetailFilter)this.nodeFactory.createNode(101008);
        IXQEQueryNode filterExpressionNode = this.nodeFactory.createNode(101013);
        filterExpressionNode.setPropertyValue(STR_EXPRESSION, joinExpr.toString());
        detailFilter.addChild(filterExpressionNode);
        detailFilter.setPostAutoAggregation(false);
        queryOp1.addChild(detailFilter);
        for (IXQEQueryNode aExceptQuery : v5SubSetQuerySet.getChildrenOfType(101006)) {
            querySet.addChild(aExceptQuery.detach(), 0);
        }
    }

    private String getMeasureAggrName(IMember measure) {
        String aggregateName = null;
        if (measure instanceof MeasureWrapper) {
            aggregateName = ((MeasureWrapper)measure).getV5AggregateAttribute();
        }
        if (AggregationUtils.isNoneCalculatedOrAutomaticAggregate(aggregateName)) {
            aggregateName = measure.getRegularAggregate().toV5Type();
        }
        return aggregateName;
    }

    public String addAggregatedMeasureToV5QuerySet(BaseMember measureMember, List<ContextDataItem> contextDataItems, V5QuerySet querySet, V5QueryOverTabularStream.ParameterContainer hdl) {
        List<V5Query> queryList = DMRPushdownQueryGenerator.getOrderedQueryList(querySet);
        V5Query query = queryList.get(0);
        IMember measure = measureMember.getMember();
        DMRPushdownQueryGenerator.addMeasureInfo(measureMember, querySet, contextDataItems);
        String expr = (String)measure.getProperty(STR_EXPRESSION);
        if (expr == null) {
            expr = measure.getUniqueID();
        }
        expr = MetadataUtil.extractExpressionFromModelString(expr, this.environment);
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("aggregate", "calculated");
        String dataItemName = this.addDataItemToPushdownQueries(expr, REF_MEASURE, properties, queryList.subList(0, 1), null);
        dataItemName = DMRPushdownQueryGenerator.getLocalDataItemName(dataItemName, query, querySet);
        DMRPushdownQueryGenerator.assignMeasureInfoToDataItem(dataItemName, query);
        IDataSourceCapabilities providerCapabilities = ProviderCapabilites.getInstance().getOrAddProviderCapabilities(PROVIDER_KEY);
        boolean useCoalesce = providerCapabilities.isSupported("enableCoalesceRankInPushDownMode") || providerCapabilities.isSupported("enableCoalesceFilterInPushDownMode");
        String nullComparison = providerCapabilities.getStringValue("null.comparison.operator", null);
        if (useCoalesce && nullComparison != null && nullComparison.equals("null")) {
            useCoalesce = false;
        }
        if (useCoalesce) {
            dataItemName = this.addCoalesceDataItem(UniqueNameGenerator.createSingleNamePart(dataItemName), queryList.subList(0, 1));
            dataItemName = DMRPushdownQueryGenerator.getLocalDataItemName(dataItemName, query, querySet);
        }
        String aggregateName = this.getMeasureAggrName(measure);
        IXQEQueryNode aggrExpression = ((MeasureWrapper)measure).getBinaryExpression();
        if (aggrExpression == null) {
            String valueExprString = UniqueNameGenerator.createSingleNamePart(dataItemName);
            aggrExpression = this.createValueSummaryExpression(aggregateName, valueExprString, contextDataItems, query, querySet);
        } else {
            AggregateExpressionBuilder builder = new AggregateExpressionBuilder(this.environment);
            aggrExpression = builder.generateAggregateExpression(aggregateName, aggrExpression);
        }
        StringBuilder buffer = new StringBuilder();
        aggrExpression.writeFormattedText(buffer);
        expr = buffer.toString();
        properties.clear();
        properties.put("aggregate", "calculated");
        properties.put("identifier", measure.getUniqueName());
        dataItemName = this.addDataItemToPushdownQueries(expr, ((V5ValueSummaryFunction)aggrExpression).getNativeName(), properties, queryList, null);
        V5QueryResultDefinition qrd = (V5QueryResultDefinition)querySet.getFirstDescendantOfTypeOrdered(101055, false);
        V5Query qrdQuery = qrd.getV5Query();
        IXQEQueryNode dataItemRef = null;
        IXQEQueryNode groupBody = qrd.getFirstDescendantOfTypeOrdered(101051, false);
        boolean isProjected = false;
        IXQEQueryNode[] projectedDataItems = groupBody.getDescendantsOfType(101015, false);
        String refDataItemName = DMRPushdownQueryGenerator.getLocalDataItemName(dataItemName, qrdQuery, querySet);
        for (IXQEQueryNode projectedDataItem : projectedDataItems) {
            if (!refDataItemName.equals(((V5DataItemRef)projectedDataItem).getDataItemRefProperty())) continue;
            isProjected = true;
            break;
        }
        if (!isProjected) {
            boolean allContextDataItemsAreProjected = true;
            for (ContextDataItem cntxt : contextDataItems) {
                isProjected = false;
                String contextDataItemName = DMRPushdownQueryGenerator.getLocalDataItemName(cntxt.contextItem, qrdQuery, querySet);
                for (IXQEQueryNode projectedDataItem : projectedDataItems) {
                    if (!contextDataItemName.equals(((V5DataItemRef)projectedDataItem).getDataItemRefProperty())) continue;
                    isProjected = true;
                    break;
                }
                if (isProjected) continue;
                allContextDataItemsAreProjected = false;
                break;
            }
            if (allContextDataItemsAreProjected) {
                dataItemRef = this.nodeFactory.createNode(101015);
                dataItemRef.setPropertyValue("refDataItem", DMRPushdownQueryGenerator.getLocalDataItemName(dataItemName, qrdQuery, querySet));
                this.addChildToParent(groupBody, dataItemRef);
            }
        }
        return dataItemName;
    }

    public String addConstantMeasureToV5QuerySet(AbstractMDXNode constantMeasure, V5QuerySet querySet) {
        List<V5Query> queryList = DMRPushdownQueryGenerator.getOrderedQueryList(querySet);
        V5Query query = queryList.get(0);
        StringBuilder buffer = new StringBuilder();
        constantMeasure.writeFormattedText(buffer);
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("aggregate", "minimum");
        String dataItemName = this.addDataItemToPushdownQueries(buffer.toString(), REF_MEASURE, properties, queryList.subList(0, 1), null);
        return dataItemName;
    }

    private static void assignMeasureInfoToDataItem(String dataItemName, V5Query query) {
        V5DataItem di;
        DMRCustomValueRefiner cvRefiner = DMRPushdownQueryGenerator.getCustomValueRefiner((V5QuerySet)query.getParent());
        if (cvRefiner != null && (di = query.getV5Selection().getDataItemByRefName(dataItemName)).getPropertyValue("measureInfo") == null) {
            di.setPropertyValue("measureInfo", cvRefiner.getMeasureInfoFromStack());
        }
    }

    private static void addMeasureInfo(BaseMember measureMember, V5QuerySet querySet, List<ContextDataItem> contextDataItems) {
        DMRCustomValueRefiner cvRefiner = DMRPushdownQueryGenerator.getCustomValueRefiner(querySet);
        if (cvRefiner != null) {
            ArrayList<String> contextDataItemNames = new ArrayList<String>();
            for (ContextDataItem ct : contextDataItems) {
                contextDataItemNames.add(ct.getContextItem());
            }
            cvRefiner.addMeasureInfo(measureMember, contextDataItemNames);
        }
    }

    public static String getLocalDataItemName(String diName, V5Query query, V5QuerySet querySet) {
        try {
            String[] parts = UniqueNameParser.parse(diName);
            if (parts.length != 2) {
                return diName;
            }
            if (parts[0].equals(query.getV5QueryName())) {
                return parts[1];
            }
            List<V5Query> queries = DMRPushdownQueryGenerator.getOrderedQueryList(querySet);
            for (int i = 0; i < queries.size(); ++i) {
                String resultName = queries.get(i).getV5Selection().getDataItemNameByExpressionStr(diName);
                if (resultName == null) continue;
                String queryName = queries.get(i).getRootQueryName();
                if (queryName.equals(query.getRootQueryName())) {
                    return resultName;
                }
                diName = UniqueNameGenerator.appendUniqueName(UniqueNameGenerator.createSingleNamePart(queryName), resultName);
                return DMRPushdownQueryGenerator.getLocalDataItemName(diName, query, querySet);
            }
        }
        catch (UniqueNameParserException uniqueNameParserException) {
            // empty catch block
        }
        return diName;
    }

    public ContextDataItem addLevelToV5QuerySetExplicit(LevelWrapper metadata, V5QuerySet querySet, String keyExpressionStr, String captionExpressionStr, List<String> levelPros) {
        V5QueryResultDefinition qrd = (V5QueryResultDefinition)querySet.getFirstDescendantOfTypeOrdered(101055, false);
        List<V5Query> queryList = DMRPushdownQueryGenerator.getOrderedQueryList(querySet);
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("aggregate", "none");
        properties.put("rollupAggregate", "none");
        String levelKeyDataItem = this.addDataItemToPushdownQueries(keyExpressionStr, null, properties, queryList, metadata);
        String localLevelKeyDataItem = DMRPushdownQueryGenerator.getLocalDataItemName(levelKeyDataItem, queryList.get(0), querySet);
        IXQEQueryNode selection = queryList.get(0).getFirstDescendantOfTypeOrdered(101009, false);
        V5DataItem dataItem = ((V5Selection)selection).getDataItemByRefName(localLevelKeyDataItem);
        dataItem.setPropertyValue("identifier", metadata.getUniqueName());
        ContextDataItem levelDataItem = new ContextDataItem(levelKeyDataItem);
        V5Query query = qrd.getV5Query();
        IXQEQueryNode dataItemRef = null;
        IXQEQueryNode groupBody = qrd.getFirstDescendantOfTypeOrdered(101051, false);
        dataItemRef = this.nodeFactory.createNode(101015);
        dataItemRef.setPropertyValue("refDataItem", DMRPushdownQueryGenerator.getLocalDataItemName(levelKeyDataItem, query, querySet));
        this.addChildToParent(groupBody, dataItemRef);
        if (captionExpressionStr != null) {
            String captionKeyDataItem = this.addDataItemToPushdownQueries(captionExpressionStr, null, properties, queryList, metadata);
            dataItemRef = this.nodeFactory.createNode(101015);
            dataItemRef.setPropertyValue("refDataItem", DMRPushdownQueryGenerator.getLocalDataItemName(captionKeyDataItem, query, querySet));
            this.addChildToParent(groupBody, dataItemRef);
        }
        for (int i = 0; i < levelPros.size(); ++i) {
            String propItemExpr = levelPros.get(i);
            String propDataItem = this.addDataItemToPushdownQueries(propItemExpr, null, properties, queryList, metadata);
            dataItemRef = this.nodeFactory.createNode(101015);
            dataItemRef.setPropertyValue("refDataItem", DMRPushdownQueryGenerator.getLocalDataItemName(propDataItem, query, querySet));
            this.addChildToParent(groupBody, dataItemRef);
        }
        return levelDataItem;
    }

    public ContextDataItem addLevelToV5QuerySet(LevelWrapper metadata, boolean bProject, V5QuerySet querySet) {
        ContextDataItem levelDataItem = null;
        String levelKeyDataItem = null;
        String captionKeyDataItem = null;
        if (metadata.getObjectType() == MetadataType.LEVEL) {
            V5QueryResultDefinition qrd = (V5QueryResultDefinition)querySet.getFirstDescendantOfTypeOrdered(101055, false);
            List<V5Query> queryList = DMRPushdownQueryGenerator.getOrderedQueryList(querySet);
            String keyExpressionStr = metadata.getQueryItemExpressionForKey();
            HashMap<String, Object> properties = new HashMap<String, Object>();
            properties.put("aggregate", "none");
            properties.put("rollupAggregate", "none");
            if (!bProject) {
                levelKeyDataItem = this.addDataItemToPushdownQueries(keyExpressionStr, null, properties, queryList.subList(0, 1), metadata);
                String localLevelKeyDataItem = DMRPushdownQueryGenerator.getLocalDataItemName(levelKeyDataItem, queryList.get(0), querySet);
                IXQEQueryNode selection = queryList.get(0).getFirstDescendantOfTypeOrdered(101009, false);
                V5DataItem dataItem = ((V5Selection)selection).getDataItemByRefName(localLevelKeyDataItem);
                dataItem.setPropertyValue("identifier", metadata.getUniqueName());
                dataItem.setPropertyValue(HIERARCHY_UNAME, metadata.getHierarchy().getUniqueName());
                return new ContextDataItem(levelKeyDataItem);
            }
            levelKeyDataItem = this.addDataItemToPushdownQueries(keyExpressionStr, null, properties, queryList, metadata);
            String localLevelKeyDataItem = DMRPushdownQueryGenerator.getLocalDataItemName(levelKeyDataItem, queryList.get(0), querySet);
            IXQEQueryNode selection = queryList.get(0).getFirstDescendantOfTypeOrdered(101009, false);
            V5DataItem dataItem = ((V5Selection)selection).getDataItemByRefName(localLevelKeyDataItem);
            dataItem.setPropertyValue("identifier", metadata.getUniqueName());
            dataItem.setPropertyValue(HIERARCHY_UNAME, metadata.getHierarchy().getUniqueName());
            levelDataItem = new ContextDataItem(levelKeyDataItem);
            V5Query query = qrd.getV5Query();
            IXQEQueryNode dataItemRef = null;
            IXQEQueryNode groupBody = qrd.getFirstDescendantOfTypeOrdered(101051, false);
            dataItemRef = this.nodeFactory.createNode(101015);
            dataItemRef.setPropertyValue("refDataItem", DMRPushdownQueryGenerator.getLocalDataItemName(levelKeyDataItem, query, querySet));
            this.addChildToParent(groupBody, dataItemRef);
            Object bFlag = querySet.getPropertyValue("customValuePushDown");
            if (bFlag == null) {
                String captionExpressionStr = metadata.getQueryItemExpressionForCaption();
                if (!captionExpressionStr.equals(keyExpressionStr)) {
                    captionKeyDataItem = this.addDataItemToPushdownQueries(captionExpressionStr, null, properties, queryList, metadata);
                    dataItemRef = this.nodeFactory.createNode(101015);
                    dataItemRef.setPropertyValue("refDataItem", DMRPushdownQueryGenerator.getLocalDataItemName(captionKeyDataItem, query, querySet));
                    this.addChildToParent(groupBody, dataItemRef);
                }
                List<Pair> sortItems = DMRPushdownQueryGenerator.getSort(this.environment, metadata, levelKeyDataItem, captionKeyDataItem);
                for (Pair sort : sortItems) {
                    String sortDataItem = null;
                    if (sort.getFirst() instanceof ISortItem) {
                        ISortItem sortItem = (ISortItem)sort.getFirst();
                        String sortItemExpr = DMRPushdownQueryGenerator.getSortItemExpression(this.environment, metadata.getConnection(), sortItem);
                        sortDataItem = this.addDataItemToPushdownQueries(sortItemExpr, null, properties, queryList, metadata);
                    } else {
                        sortDataItem = (String)sort.getFirst();
                    }
                    dataItemRef = this.nodeFactory.createNode(101056);
                    dataItemRef.setPropertyValue("refDataItem", DMRPushdownQueryGenerator.getLocalDataItemName(sortDataItem, query, querySet));
                    dataItemRef.setPropertyValue("sortOrder", sort.getSecond());
                    this.addChildToParent(groupBody.getParent(), dataItemRef);
                    Pair aSortItem = new Pair();
                    aSortItem.setFirst(sortDataItem);
                    aSortItem.setSecond(sort.getSecond());
                    levelDataItem.addSortItem(aSortItem);
                }
            }
        }
        return levelDataItem;
    }

    public static List<V5Query> getOrderedQueryList(V5QuerySet querySet) {
        ArrayList<V5Query> queryList = new ArrayList<V5Query>();
        V5QueryResultDefinition qrd = (V5QueryResultDefinition)querySet.getFirstChildByType(101055);
        if (qrd == null) {
            IXQEQueryNode[] queries;
            for (IXQEQueryNode query : queries = querySet.getDescendantsOfType(101006, false)) {
                int i;
                Set<String> queryRefs = ((V5Query)query).getV5Source().getReferencedQueries();
                if (queryRefs == null) {
                    queryList.add(0, (V5Query)query);
                    continue;
                }
                for (i = 0; i < queryList.size(); ++i) {
                    String queryName = ((V5Query)queryList.get(i)).getRootQueryName();
                    if ((queryName = UniqueNameGenerator.createSingleNamePart(queryName)).equals(queryRefs.iterator().next())) break;
                }
                queryList.add(i, (V5Query)query);
            }
            return queryList;
        }
        String queryName = qrd.getRefQueryProperty();
        V5Query query = querySet.getV5Query(queryName);
        queryList.add(query);
        Set<String> queryRefs = query.getV5Source().getReferencedQueries();
        while (queryRefs != null) {
            queryName = queryRefs.iterator().next();
            query = querySet.getV5Query(queryName);
            queryList.add(0, query);
            queryRefs = query.getV5Source().getReferencedQueries();
        }
        return queryList;
    }

    public String addDataItemToPushdownQueries(String strExpression, String suffix, HashMap<String, Object> properties, List<V5Query> queryList, LevelWrapper metadata) {
        String dataItemName = null;
        V5QuerySet querySet = (V5QuerySet)queryList.get(0).getParent();
        for (int i = 0; i < queryList.size(); ++i) {
            MetadataContext c;
            DMRCustomValueRefiner.MeasureInfo miFromStack;
            DMRCustomValueRefiner.MeasureInfo mi;
            DMRCustomValueRefiner cvRefiner;
            V5Query query = queryList.get(i);
            IXQEQueryNode selection = query.getFirstDescendantOfTypeOrdered(101009, false);
            V5DataItem di = ((V5Selection)selection).getDataItemByExpressionStr(strExpression);
            if (di != null && (cvRefiner = (DMRCustomValueRefiner)querySet.getPropertyValue("customValueRefiner")) != null && (mi = (DMRCustomValueRefiner.MeasureInfo)di.getPropertyValue("measureInfo")) != null && (miFromStack = cvRefiner.getMeasureInfoFromStack()) != null && !miFromStack.equals(mi)) {
                di = null;
            }
            if (di != null) {
                dataItemName = di.getNameProperty();
                strExpression = dataItemName = UniqueNameGenerator.appendUniqueName(UniqueNameGenerator.createSingleNamePart(query.getRootQueryName()), dataItemName);
                continue;
            }
            int columnIdx = selection.getNumberChildren();
            dataItemName = COLUMN + columnIdx;
            if (suffix != null) {
                dataItemName = dataItemName + suffix;
            }
            IXQEQueryNode dataItem = this.nodeFactory.createNode(101003);
            dataItem.setPropertyValue("name", dataItemName);
            if (properties != null) {
                ((V5QueryNode)dataItem).setProperties(properties);
            }
            IXQEQueryNode expression = this.nodeFactory.createNode(101004);
            expression.setPropertyValue(STR_EXPRESSION, strExpression);
            this.addChildToParent(dataItem, expression);
            this.addChildToParent(selection, dataItem);
            strExpression = dataItemName = UniqueNameGenerator.appendUniqueName(UniqueNameGenerator.createSingleNamePart(query.getRootQueryName()), dataItemName);
            if (metadata == null || (c = MetadataContext.getMetadataContextForDynamicMetadata(metadata)) == null) continue;
            expression.setPropertyValue("metadataContextName", c.getName());
        }
        return dataItemName;
    }

    private void addMemberDetailFilter(BaseMember node, V5QuerySet querySet) {
        if (!node.isRootMember()) {
            IXQEQueryNode[] detailFilters;
            List<V5Query> allQueries = DMRPushdownQueryGenerator.getOrderedQueryList(querySet);
            V5Query query = allQueries.get(allQueries.size() - 1);
            ILevel level = node.getLevel();
            String mun = node.getExternalName();
            String logical = (String)node.getPropertyValue("logical");
            IXQEQueryNode in = DMRMemberLoadQuery.createInExpression(this.nodeFactory, level, mun, logical);
            V5DetailFilter detailFilter = null;
            for (IXQEQueryNode df : detailFilters = query.getChildrenOfType(101008)) {
                if (!df.getChild(0).isSameExpression(in, false)) continue;
                detailFilter = (V5DetailFilter)df;
                break;
            }
            if (detailFilter == null) {
                detailFilter = (V5DetailFilter)this.nodeFactory.createNode(101008);
                detailFilter.setPostAutoAggregation(false);
                detailFilter.addChild(in);
                query.addChild(detailFilter);
            }
            DMRPushdownQueryGenerator.addMemberFilterInCustomValueRefiner(querySet, detailFilter);
        }
    }

    private static void addMemberFilterInCustomValueRefiner(V5QuerySet querySet, V5DetailFilter detailFilter) {
        DMRCustomValueRefiner cvRefiner = DMRPushdownQueryGenerator.getCustomValueRefiner(querySet);
        if (cvRefiner != null) {
            cvRefiner.addMemberFilterInCustomValueRefiner(detailFilter);
        }
    }

    public static DMRCustomValueRefiner getCustomValueRefiner(V5QuerySet querySet) {
        return (DMRCustomValueRefiner)querySet.getPropertyValue("customValueRefiner");
    }

    private String addTopBottomDetailFilter(V5OrderedValueExpression valueExpr, String count, List<ContextDataItem> contextDataItemNames, List<ContextDataItem> ancestortDataItemNames, V5Query query, V5QuerySet querySet) {
        boolean reverseOrder = valueExpr.isASCsort();
        V5ValueAnalyticFunction rankExpression = this.createRankExpression(valueExpr, reverseOrder, contextDataItemNames, ancestortDataItemNames, query, querySet);
        StringBuilder rankFunctionExpressionString = new StringBuilder();
        rankExpression.writeFormattedText(rankFunctionExpressionString);
        ArrayList<V5Query> outerQuery = new ArrayList<V5Query>();
        outerQuery.add(query);
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("aggregate", "calculated");
        String dataItemName = this.addDataItemToPushdownQueries(rankFunctionExpressionString.toString(), rankExpression.getNativeName(), properties, outerQuery, null);
        dataItemName = DMRPushdownQueryGenerator.getLocalDataItemName(dataItemName, query, querySet);
        String filterExpression = this.buildFilterExpressionString(1, UniqueNameGenerator.createSingleNamePart(dataItemName), count);
        V5DetailFilter detailFilter = (V5DetailFilter)this.nodeFactory.createNode(101008);
        detailFilter.setPostAutoAggregation(true);
        detailFilter.setStringPropertyValue("use", STR_REQUIRED);
        this.addChildToParent(query, detailFilter);
        IXQEQueryNode filterExpressionNode = this.nodeFactory.createNode(101013);
        filterExpressionNode.setPropertyValue(STR_EXPRESSION, filterExpression);
        detailFilter.addChild(filterExpressionNode);
        return dataItemName;
    }

    private V5ValueSummaryFunction createValueSummaryExpression(String aggregateName, String valueExprStr, List<ContextDataItem> scope, V5Query query, V5QuerySet querySet) {
        IXQEQueryNode dataItemIdentifier = this.nodeFactory.createNode(201030);
        ((V5MultiPartIdentifier)dataItemIdentifier).setIdentifier(valueExprStr);
        V5ValueSummaryFunction aggrExpression = null;
        Pair v5AggregateFunctionSubtype = AggregationUtils.convertAggregateNameToV5AggregateFunctionSubtype(aggregateName.toLowerCase(), null);
        aggrExpression = (V5ValueSummaryFunction)this.nodeFactory.createNode(201031);
        aggrExpression.setSubType((Integer)v5AggregateFunctionSubtype.getFirst());
        aggrExpression.setDistinct((Boolean)v5AggregateFunctionSubtype.getSecond());
        this.addChildToParent(aggrExpression, dataItemIdentifier);
        V5AggregateBreakClause forClause = (V5AggregateBreakClause)this.nodeFactory.createNode(201037);
        this.addChildToParent(aggrExpression, forClause);
        if (scope.isEmpty()) {
            forClause.setSubType(0);
        } else {
            for (ContextDataItem f : scope) {
                dataItemIdentifier = this.nodeFactory.createNode(201030);
                ((V5MultiPartIdentifier)dataItemIdentifier).setIdentifier(UniqueNameGenerator.createSingleNamePart(DMRPushdownQueryGenerator.getLocalDataItemName(f.getContextItem(), query, querySet)));
                this.addChildToParent(forClause, dataItemIdentifier);
            }
        }
        return aggrExpression;
    }

    private V5ValueAnalyticFunction createRankExpression(V5OrderedValueExpression valueExpr, boolean reverseOrder, List<ContextDataItem> contextDataItemNames, List<ContextDataItem> ancestortDataItemNames, V5Query query, V5QuerySet querySet) {
        V5ValueAnalyticFunction rankExpression = (V5ValueAnalyticFunction)this.nodeFactory.createNode(201033);
        rankExpression.setSubType(14);
        if (valueExpr != null && valueExpr.getNumberChildren() > 0) {
            this.addChildToParent(rankExpression, valueExpr);
        }
        V5OrderedValueExpression orderedValueExpr = null;
        IXQEQueryNode dataItemIdentifier = null;
        for (int i = 0; i < ancestortDataItemNames.size(); ++i) {
            ContextDataItem di = ancestortDataItemNames.get(i);
            List<Pair> sortItems = di.getSortItems();
            for (int j = 0; j < sortItems.size(); ++j) {
                String sortItemName = (String)sortItems.get(j).getFirst();
                if (!(sortItemName = DMRPushdownQueryGenerator.getLocalDataItemName(sortItemName, query, querySet)).startsWith(PUSHDOWNQUERY_2PARTS_DI_NAME)) {
                    sortItemName = UniqueNameGenerator.createSingleNamePart(sortItemName);
                }
                String orderName = (String)sortItems.get(j).getSecond();
                orderedValueExpr = (V5OrderedValueExpression)this.nodeFactory.createNode(201114);
                if (reverseOrder) {
                    if (orderName.equals("ascending")) {
                        orderedValueExpr.setSubType(2);
                    } else {
                        orderedValueExpr.setSubType(1);
                    }
                } else if (orderName.equals("ascending")) {
                    orderedValueExpr.setSubType(1);
                } else {
                    orderedValueExpr.setSubType(2);
                }
                dataItemIdentifier = this.nodeFactory.createNode(201030);
                ((V5MultiPartIdentifier)dataItemIdentifier).setIdentifier(sortItemName);
                this.addChildToParent(orderedValueExpr, dataItemIdentifier);
                this.addChildToParent(rankExpression, orderedValueExpr);
            }
        }
        V5AggregateBreakClause forClause = (V5AggregateBreakClause)this.nodeFactory.createNode(201037);
        this.addChildToParent(rankExpression, forClause);
        if (contextDataItemNames.isEmpty()) {
            forClause.setSubType(0);
        } else {
            for (ContextDataItem f : contextDataItemNames) {
                dataItemIdentifier = this.nodeFactory.createNode(201030);
                ((V5MultiPartIdentifier)dataItemIdentifier).setIdentifier(UniqueNameGenerator.createSingleNamePart(DMRPushdownQueryGenerator.getLocalDataItemName(f.getContextItem(), query, querySet)));
                this.addChildToParent(forClause, dataItemIdentifier);
            }
        }
        return rankExpression;
    }

    private static List<ContextDataItem> rebuildContextDataItemNameList(List<ContextDataItem> contextDataItemNames, List<ContextDataItem> ancestorDataItemNames, StringBuilder buffer) {
        ArrayList<ContextDataItem> totalContext = new ArrayList<ContextDataItem>();
        totalContext.addAll(contextDataItemNames);
        DMRPushdownQueryGenerator.addIfNotExist(ancestorDataItemNames, totalContext);
        String[] dataItemNames = buffer.toString().split("; ");
        ArrayList<ContextDataItem> contextDataItemForValue = new ArrayList<ContextDataItem>();
        contextDataItemForValue.addAll(totalContext);
        for (String di : dataItemNames) {
            if (di.isEmpty()) continue;
            boolean isExisting = false;
            for (ContextDataItem f : contextDataItemForValue) {
                if (!f.getContextItem().equals(di)) continue;
                isExisting = true;
                break;
            }
            if (isExisting) continue;
            contextDataItemForValue.add(new ContextDataItem(di));
        }
        contextDataItemForValue.removeAll(ancestorDataItemNames);
        return contextDataItemForValue;
    }

    public String addCoalesceDataItem(String dataItemName, List<V5Query> queryList) {
        String expr = "coalesce(" + dataItemName + ", 0" + ")";
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("aggregate", "notApplicable");
        dataItemName = this.addDataItemToPushdownQueries(expr, STR_COALESCE_REF, properties, queryList, null);
        return dataItemName;
    }

    public static String escapeSingleQuotes(String name) {
        if (name.contains(SINGLE_QUOTE)) {
            StringBuilder buffer = new StringBuilder();
            String[] tokens = name.split(SINGLE_QUOTE);
            for (int idx = 0; idx < tokens.length; ++idx) {
                buffer.append(tokens[idx]);
                buffer.append(SINGLE_QUOTE);
                buffer.append(SINGLE_QUOTE);
            }
            return buffer.toString();
        }
        return name;
    }

    public static List<Pair> getSort(PlanningEnvironment planningEnv, LevelWrapper metadata, String keyItem, String capItem) {
        MetadataConnection metadataConnection = metadata.getConnection();
        ArrayList<Pair> sortItems = new ArrayList<Pair>();
        ISortItem[] levelSortItems = metadata.getSortItems();
        if (levelSortItems.length == 0) {
            if (capItem != null) {
                sortItems.add(new Pair(capItem, "ascending"));
            }
            sortItems.add(new Pair(keyItem, "ascending"));
        } else {
            boolean bSortedOnKey = false;
            boolean bSortedOnCaption = false;
            for (ISortItem sortItem : levelSortItems) {
                String exprStr = DMRPushdownQueryGenerator.getSortItemExpression(planningEnv, metadataConnection, sortItem);
                if (exprStr.equals(metadata.getQueryItemExpressionForKey())) {
                    sortItems.add(new Pair(keyItem, sortItem.getSort().toString()));
                    bSortedOnKey = true;
                    continue;
                }
                if (capItem != null && exprStr.equals(metadata.getQueryItemExpressionForCaption())) {
                    sortItems.add(new Pair(capItem, sortItem.getSort().toString()));
                    bSortedOnCaption = true;
                    continue;
                }
                sortItems.add(new Pair(sortItem, sortItem.getSort().toString()));
            }
            if (!bSortedOnCaption && capItem != null) {
                sortItems.add(new Pair(capItem, "ascending"));
            }
            if (!bSortedOnKey) {
                sortItems.add(new Pair(keyItem, "ascending"));
            }
        }
        return sortItems;
    }

    public static String getSortItemExpression(PlanningEnvironment planningEnv, MetadataConnection metadataConnection, ISortItem sortItem) {
        IQueryItem sortQueryItem = DMRPushdownQueryGenerator.getQueryItem(sortItem.getRefObject(), metadataConnection);
        String expression = null;
        expression = sortQueryItem.getQuerySubject() != null ? sortQueryItem.getV5UniqueName() : MetadataUtil.extractExpressionFromModelString(sortQueryItem.getExpression(), planningEnv);
        return expression;
    }

    public static IQueryItem getQueryItem(String refObjName, MetadataConnection metadataConnection) {
        IMetadata refObj = metadataConnection.bindMetadataReference(refObjName);
        if (refObj == null || refObj.getObjectType() != MetadataType.QUERY_ITEM) {
            return null;
        }
        IQueryItem queryItem = (IQueryItem)refObj;
        return queryItem;
    }

    public V5QuerySet buildEmptyQuerySet(String queryName, Locale expressionLc) {
        V5QuerySet querySet = (V5QuerySet)this.nodeFactory.createNode(101002);
        if (expressionLc == null) {
            expressionLc = this.environment.getMetadataConnection().getDefaultLocale(null);
        }
        querySet.setPropertyValue("expressionLocale", LocaleConverter.localeToStr(expressionLc));
        querySet.setPropertyValue("modelPath", this.environment.getMetadataConnection().getModelName());
        this.addPushdownQuery(querySet, queryName);
        this.createPushdownQRD(querySet);
        return querySet;
    }

    private V5Query addPushdownQuery(V5QuerySet querySet, String queryName) {
        List<V5Query> queries = DMRPushdownQueryGenerator.getOrderedQueryList(querySet);
        V5Query newQuery = this.createPushdownQuery(querySet, queryName + queries.size());
        querySet.addChild(newQuery, queries.size());
        if (!queries.isEmpty()) {
            IXQEQueryNode[] dataItems;
            ArrayList<V5Query> queryAsList = new ArrayList<V5Query>();
            queryAsList.add(newQuery);
            V5QueryResultDefinition qrd = (V5QueryResultDefinition)querySet.getFirstDescendantOfTypeOrdered(101055, false);
            V5Query currentOuterQuery = qrd.getV5Query();
            newQuery.getV5Source().setQueryRef(currentOuterQuery.getRootQueryName());
            qrd.setRefQueryProperty(newQuery.getRootQueryName());
            String currentOuterQueryName = UniqueNameGenerator.createSingleNamePart(currentOuterQuery.getRootQueryName());
            IXQEQueryNode[] dataItemRefs = qrd.getDescendantsOfType(101015, false);
            IXQEQueryNode[] sortItems = qrd.getDescendantsOfType(101056, false);
            for (IXQEQueryNode dataItem : dataItems = currentOuterQuery.getV5Selection().getChildrenOfType(101003)) {
                String currentDataItemName = ((V5DataItem)dataItem).getNameProperty();
                ArrayList<V5DataItemRef> projection = new ArrayList<V5DataItemRef>();
                for (IXQEQueryNode aRef : dataItemRefs) {
                    if (!currentDataItemName.equals(((V5DataItemRef)aRef).getDataItemRefProperty())) continue;
                    projection.add((V5DataItemRef)aRef);
                }
                ArrayList<V5SortItem> sorting = new ArrayList<V5SortItem>();
                for (IXQEQueryNode aRef : sortItems) {
                    if (!currentDataItemName.equals(((V5SortItem)aRef).getRefDataItem())) continue;
                    sorting.add((V5SortItem)aRef);
                }
                if (projection.isEmpty() && sorting.isEmpty()) continue;
                String newDataItemExpr = UniqueNameGenerator.appendUniqueName(currentOuterQueryName, currentDataItemName);
                HashMap<String, Object> properties = new HashMap<String, Object>();
                for (String key : dataItem.getProperties().keySet()) {
                    if (key.equals("name")) continue;
                    properties.put(key, dataItem.getPropertyValue(key));
                }
                properties.put("aggregate", "none");
                properties.put("rollupAggregate", "none");
                String newDataItemName = this.addDataItemToPushdownQueries(newDataItemExpr, null, properties, queryAsList, null);
                newDataItemName = DMRPushdownQueryGenerator.getLocalDataItemName(newDataItemName, newQuery, querySet);
                for (V5DataItemRef v5DataItemRef : projection) {
                    if (!currentDataItemName.equals(v5DataItemRef.getDataItemRefProperty())) continue;
                    v5DataItemRef.setPropertyValue("refDataItem", newDataItemName);
                }
                for (V5SortItem v5SortItem : sorting) {
                    if (!currentDataItemName.equals(v5SortItem.getRefDataItem())) continue;
                    v5SortItem.setPropertyValue("refDataItem", newDataItemName);
                }
            }
        }
        return newQuery;
    }

    public V5Query createPushdownQuery(V5QuerySet querySet, String queryName) {
        V5Query query = (V5Query)this.nodeFactory.createNode(101006);
        IXQEQueryNode source = this.nodeFactory.createNode(101007);
        IXQEQueryNode select = this.nodeFactory.createNode(101009);
        this.addChildToParent(query, source);
        this.addChildToParent(query, select);
        query.setPropertyValue("name", queryName);
        return query;
    }

    private IXQEQueryNode createPushdownQRD(V5QuerySet querySet) {
        List<V5Query> queries = DMRPushdownQueryGenerator.getOrderedQueryList(querySet);
        String queryName = queries.get(queries.size() - 1).getRootQueryName();
        IXQEQueryNode qrd = this.nodeFactory.createNode(101055);
        this.addChildToParent(querySet, qrd);
        qrd.setPropertyValue("name", queryName + qrd.getNodeTypeName());
        qrd.setPropertyValue("refQuery", queryName);
        IXQEQueryNode edge = this.nodeFactory.createNode(101049);
        edge.setPropertyValue("name", queryName + edge.getNodeTypeName());
        this.addChildToParent(qrd, edge);
        IXQEQueryNode edgeGroup = this.nodeFactory.createNode(101050);
        this.addChildToParent(edge, edgeGroup);
        V5ValueSet valueSet = (V5ValueSet)this.nodeFactory.createNode(101057);
        valueSet.setNameProperty(queryName);
        this.addChildToParent(edgeGroup, valueSet);
        IXQEQueryNode groupBody = this.nodeFactory.createNode(101051);
        groupBody.setPropertyValue("name", queryName + groupBody.getNodeTypeName());
        this.addChildToParent(valueSet, groupBody);
        return qrd;
    }

    private void visitTNodePushdownAsCustomValue(TNodePushdownAsCustomValue node, V5QuerySet querySet, List<ContextDataItem> contextDataItemNames, List<ContextDataItem> ancestortDataItemNames, StringBuilder buffer) {
        this.visit((AbstractMDXNode)node.getChild(0), querySet, contextDataItemNames, ancestortDataItemNames, buffer);
        List<V5Query> queryList = DMRPushdownQueryGenerator.getOrderedQueryList(querySet);
        DMRCustomValueRefiner cvRefiner = (DMRCustomValueRefiner)querySet.getPropertyValue("customValueRefiner");
        if (cvRefiner != null) {
            cvRefiner.removeMeasureInfoFromStack();
        }
        if (node.getChild(0).getType() != 1060) {
            String expr = buffer.toString();
            HashMap<String, Object> properties = new HashMap<String, Object>();
            properties.put("aggregate", "calculated");
            properties.put("rollupAggregate", "calculated");
            String string = this.addDataItemToPushdownQueries(expr, null, properties, queryList, null);
        }
        V5Selection selection = queryList.get(0).getV5Selection();
        V5DataItem customValueColumn = (V5DataItem)selection.getChild(selection.getNumberChildren() - 1);
        this.addCustomValueColumnInPushdownQuery(querySet, customValueColumn.getNameProperty());
        this.addPushdownQuery(querySet, PUSHDOWNQUERY_V5QUERY_NAME);
    }

    public boolean useMeasure() {
        return this.hUseMeasure;
    }

    public static class ContextDataItem {
        private String contextItem = null;
        private List<Pair> sortItems = new ArrayList<Pair>();

        public ContextDataItem(String dataItemName) {
            this.contextItem = dataItemName;
        }

        public String getContextItem() {
            return this.contextItem;
        }

        public void setContextItem(String name) {
            this.contextItem = name;
        }

        public List<Pair> getSortItems() {
            return this.sortItems;
        }

        public void addSortItem(Pair sortItem) {
            this.sortItems.add(sortItem);
        }

        public boolean equals(Object obj) {
            if (obj instanceof ContextDataItem) {
                ContextDataItem other = (ContextDataItem)obj;
                return this.getContextItem().equals(other.getContextItem()) && this.getSortItems().equals(other.getSortItems());
            }
            return false;
        }

        public int hashCode() {
            return this.getContextItem().hashCode() + this.getSortItems().hashCode();
        }
    }
}

