/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.dmr;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.MDXFromCube;
import com.cognos.xqe.ast.rqp.RMQueryItem;
import com.cognos.xqe.ast.rqp.RQPDataItem;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5DetailFilter;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Source;
import com.cognos.xqe.ast.v5Exp.AbstractV5BooleanExpression;
import com.cognos.xqe.ast.v5Exp.V5AggregateFunction;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.ast.v5Exp.V5BoundMultiPartIdentifier;
import com.cognos.xqe.ast.v5Exp.V5BoundToMetadata;
import com.cognos.xqe.ast.v5Exp.V5InExpression;
import com.cognos.xqe.ast.v5Exp.V5IsNullExpression;
import com.cognos.xqe.ast.v5Exp.V5LiteralValue;
import com.cognos.xqe.ast.v5Exp.V5MultiPartIdentifier;
import com.cognos.xqe.ast.v5Exp.V5Parameter;
import com.cognos.xqe.ast.v5Exp.V5TupleFunction;
import com.cognos.xqe.ast.v5Exp.util.V5Builder;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.IMessageKey;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQEMessages;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.format.FormatId;
import com.cognos.xqe.format.FormatService;
import com.cognos.xqe.metadata.IAccessedViaShortcut;
import com.cognos.xqe.metadata.IAggregateRule;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IDbDimension;
import com.cognos.xqe.metadata.IDbMeasureDimension;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMeasure;
import com.cognos.xqe.metadata.IMeasureDimension;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IModelDataSource;
import com.cognos.xqe.metadata.IQueryItem;
import com.cognos.xqe.metadata.IQueryItemOfDimension;
import com.cognos.xqe.metadata.IQuerySubject;
import com.cognos.xqe.metadata.IRelationship;
import com.cognos.xqe.metadata.IScopeRelationship;
import com.cognos.xqe.metadata.IShortcut;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.metadata.MetadataUtil;
import com.cognos.xqe.metadata.RoleTypeEnum;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.metadata.provider.MetadataService;
import com.cognos.xqe.metadata.wrapper.AbstractDimensionWrapper;
import com.cognos.xqe.metadata.wrapper.CalculationWrapper;
import com.cognos.xqe.metadata.wrapper.CubeWrapper;
import com.cognos.xqe.metadata.wrapper.DimensionWrapper;
import com.cognos.xqe.metadata.wrapper.FilterWrapper;
import com.cognos.xqe.metadata.wrapper.HierarchyWrapper;
import com.cognos.xqe.metadata.wrapper.LevelWrapper;
import com.cognos.xqe.metadata.wrapper.MeasureWrapper;
import com.cognos.xqe.metadata.wrapper.QueryItemWrapper;
import com.cognos.xqe.metadata.wrapper.ScopeRelationshipWrapper;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.query.engine.NagDMRSubquery;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.ResponseMessage;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.runtree.olap.XMdx;
import com.cognos.xqe.runtree.olap.XMdxLocal;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRCube;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRDatasource;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRDimension;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRLevel;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRMeasure;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.V5QueryOverTabularStream;
import com.cognos.xqe.runtree.olap.mdx.v5provider.pushdown.PushdownManager;
import com.cognos.xqe.runtree.olap.querytemplates.CustomQuery;
import com.cognos.xqe.runtree.relational.XSql;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import com.cognos.xqe.transformation.v5tocogsql.util.metadataContext.MetadataContext;
import com.cognos.xqe.util.CollectionCast;
import com.cognos.xqe.util.Governors;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqe.util.UniqueNameParser;
import com.cognos.xqe.util.UniqueNameParserException;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public final class DMRUtilities {
    public static final String DMRQUERY_LOAD_LEVELS = "LoadLevels";
    public static final String DMRQUERY_LOAD_MEMBERS_PROPERTY = "LoadLevelMembersProperty";
    public static final String DMRQUERY_LOAD_MEMBER_CHILDREN = "LoadChildrenMember";
    public static final String DMRQUERY_FETCH_CELL_VALUES = "FetchCellValues";
    public static final String DMRQUERY_FETCH_CELL_VALUES_FL_AGGR = "FetchCellValuesFLAggregates";
    public static final String DMR_QUERY = "DMRQuery";
    public static final String DMR_NON_REUSABLE_CUBE_LOADING_QUERY = "DMR non reusable cube loading query.";
    public static final String QUOTESIGN = "\"";
    public static final int MEMBER_INDEX = 3;
    public static final int QUERYITEM_INDEX = 4;
    private static final int IN_EXPR_SET_SIZE = 250;
    protected static final String FORMAT = "format";

    private DMRUtilities() {
    }

    public static void addSQLNags(ExecutionEnvironment execution, RSAPIDataset dataset, SubqueryType aType) {
        NagDMRSubquery nag = new NagDMRSubquery();
        nag.setDMRSubQueryType(aType);
        nag.setActualQueryName(dataset.getName());
        nag.setCognosSQL(dataset.getCognosSQL());
        for (IXQEQueryNode xSql : DMRUtilities.findNativeSqlNodes(dataset)) {
            nag.addNativeSQL(((XSql)xSql).getSqlText());
        }
        execution.addNag(nag);
    }

    public static List<IXQEQueryNode> findNativeSqlNodes(IXQEQueryNode root) {
        ArrayList<IXQEQueryNode> nodeList = new ArrayList<IXQEQueryNode>();
        DMRUtilities.findNativeSqlNodes(root, nodeList);
        return nodeList;
    }

    private static void findNativeSqlNodes(IXQEQueryNode aNode, List<IXQEQueryNode> nodeList) {
        if (aNode instanceof XSql) {
            nodeList.add(aNode);
        }
        for (int i = 0; i < aNode.getNumberChildren(); ++i) {
            DMRUtilities.findNativeSqlNodes(aNode.getChild(i), nodeList);
        }
    }

    public static CubeWrapper findCubeWrapper(IXQEQueryNode xqeQueryNode, PlanningEnvironment environment, boolean create) {
        V5Query query = DMRUtilities.findQuery(xqeQueryNode);
        CubeWrapper cubeWrapper = null;
        V5Source source = (V5Source)query.getChildrenOfType(101007)[0];
        List<IXQEQueryNode> nodes = source.getDescendantsOfTypeOrdered(1007, false);
        if (nodes == null || nodes.size() == 0) {
            if (create) {
                cubeWrapper = DMRUtilities.createCubeWrapper(query, environment);
            }
        } else {
            MDXFromCube mdxFromCube = (MDXFromCube)nodes.get(0);
            if (!(mdxFromCube.getCube() instanceof CubeWrapper)) {
                throw new XQERuntimeException(XQEMessageKeys.PLN_InvalidCubeWrapper);
            }
            cubeWrapper = (CubeWrapper)mdxFromCube.getCube();
        }
        return cubeWrapper;
    }

    public static V5Query findQuery(IXQEQueryNode xqeQueryNode) {
        if (xqeQueryNode.getType() == 101006) {
            return (V5Query)xqeQueryNode;
        }
        IXQEQueryNode ancestor = xqeQueryNode.getAncestorOfTypes(new int[]{401005, 101006});
        if (ancestor == null) {
            return null;
        }
        if (ancestor.getType() == 101006) {
            return (V5Query)ancestor;
        }
        RSAPIDataset rsapiDataset = (RSAPIDataset)ancestor;
        String queryName = rsapiDataset.getRefQueryName();
        V5QuerySet queryset = (V5QuerySet)rsapiDataset.getAncestorOfType(101002);
        return queryset.getV5Query(queryName);
    }

    public static CubeWrapper createCubeWrapper(ExecutionEnvironment execEnv, String modelPath) {
        MetadataConnection metadataConnection = null;
        metadataConnection = MetadataService.getInstance().getConnection("MFW4J", modelPath, execEnv, true);
        List<IModelDataSource> dataSources = metadataConnection.getModelDataSources();
        if (dataSources == null || dataSources.size() != 1) {
            return null;
        }
        IModelDataSource modelDS = dataSources.get(0);
        String cmDataSourceName = modelDS.getCMDataSourceName();
        execEnv.getOrAddDataSource(modelDS.getName(), cmDataSourceName, null, modelDS.getMetadataProperties());
        ArrayList<IMeasure> measuresWithAggregateRules = new ArrayList<IMeasure>();
        CubeWrapper cubeWrapper = new CubeWrapper(metadataConnection, new Governors());
        cubeWrapper.getGovernors().setSuppress(Governors.Suppress.NONE.name());
        IModelDataSource ds = dataSources.get(0);
        cubeWrapper.setDataSource(ds);
        List<IMetadata> allMetadata = metadataConnection.getEntities();
        for (IMetadata mfwMetadata : allMetadata) {
            metadataConnection.updateIDToMetadataReferenceMap(mfwMetadata.getID(), mfwMetadata);
            DMRUtilities.createCubeWrapperDimensions(cubeWrapper, metadataConnection, measuresWithAggregateRules, mfwMetadata);
        }
        for (IMeasure measure : measuresWithAggregateRules) {
            DMRUtilities.processMeasuresWithAggregateRules(measure, cubeWrapper, metadataConnection);
        }
        cubeWrapper.setDefaultMeasure();
        return cubeWrapper;
    }

    public static CubeWrapper createCubeWrapper(Set<IDimension> dimensions, IModelDataSource ds, MetadataConnection metadataConnection, Governors governors) {
        CubeWrapper cubeWrapper = new CubeWrapper(metadataConnection, governors);
        cubeWrapper.setDataSource(ds);
        for (IDimension dim : dimensions) {
            DMRUtilities.createDimension(dim, cubeWrapper);
        }
        return cubeWrapper;
    }

    private static CubeWrapper createCubeWrapper(V5Query query, PlanningEnvironment environment) {
        IModelDataSource ds;
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        MDXFromCube fromCube = (MDXFromCube)nodeFactory.createNode(1007);
        V5Source source = (V5Source)query.getChildrenOfType(101007)[0];
        MetadataConnection connection = environment.getMetadataConnection();
        CubeWrapper cubeWrapper = new CubeWrapper(connection, query.getGovernors());
        String topN = (String)query.getPropertyValue("topNRows");
        if (topN != null) {
            cubeWrapper.setTopN(topN);
        }
        if ((ds = DMRUtilities.getDatasourcefromBoundToMetadta(query)) == null) {
            ds = new DMRDatasource();
        }
        cubeWrapper.setDataSource(ds);
        DMRUtilities.createCubeWrapperDimensions(query, cubeWrapper, connection);
        fromCube.bind(cubeWrapper);
        source.addChild(fromCube);
        return cubeWrapper;
    }

    private static IModelDataSource getDatasourcefromBoundToMetadta(V5Query query) {
        int[] types = new int[]{201117, 201116, 201127, 201024};
        IXQEQueryNode[] modelIdentifiers = query.getDescendantsOfTypes(types, false);
        if (modelIdentifiers != null) {
            for (IXQEQueryNode md : modelIdentifiers) {
                ICube cube;
                if (!(md instanceof V5BoundToMetadata) || (cube = MetadataUtil.getCube(((V5BoundToMetadata)md).getMetadata())) == null) continue;
                return cube.getModelDataSource();
            }
            IMetadata aQuerySubject = null;
            for (IXQEQueryNode md : modelIdentifiers) {
                IMetadata metadata;
                if (!(md instanceof V5BoundToMetadata) || !((metadata = ((V5BoundToMetadata)md).getMetadata()) instanceof IQueryItem)) continue;
                IQuerySubject querySubject = ((IQueryItem)metadata).getQuerySubject();
                aQuerySubject = querySubject;
                List<IModelDataSource> datasources = querySubject.getDataSources();
                if (datasources == null || datasources.size() <= 0) continue;
                return datasources.get(0);
            }
            if (aQuerySubject != null) {
                return aQuerySubject.getConnection().getModelDataSources().get(0);
            }
        }
        return null;
    }

    private static IDataSourceCapabilities getCapabilitiesFromTypedInSQL(V5Query query) {
        IXQEQueryNode[] modelIdentifiers;
        int[] types = new int[]{301004};
        for (IXQEQueryNode md : modelIdentifiers = query.getDescendantsOfTypes(types, false)) {
            if (!(md instanceof SQLQueryBlock)) continue;
            SQLQueryBlock queryBlock = (SQLQueryBlock)md;
            return queryBlock.getDataSource().getCapabilities();
        }
        return null;
    }

    public static IDataSourceCapabilities getDatasourceCapabilities(V5Query v5Query, PlanningEnvironment environment) {
        IModelDataSource dataSource = DMRUtilities.getDatasourcefromBoundToMetadta(v5Query);
        if (dataSource == null) {
            IDataSourceCapabilities capabilities = DMRUtilities.getCapabilitiesFromTypedInSQL(v5Query);
            return capabilities;
        }
        return DMRUtilities.getDatasourceCapabilities(dataSource, environment);
    }

    public static IDataSourceCapabilities getDatasourceCapabilities(IModelDataSource modelDatasource, PlanningEnvironment environment) {
        RequestEnvironment requestEnv = (RequestEnvironment)environment.getRequestEnvironment();
        ExecutionEnvironment execEnv = (ExecutionEnvironment)requestEnv.getExecutionEnvironment();
        IDataSource ds = execEnv.getOrAddDataSource(modelDatasource);
        return ds.getCapabilities();
    }

    private static void createCubeWrapperDimensions(V5Query query, CubeWrapper cubeWrapper, MetadataConnection connection) {
        List<IXQEQueryNode> nodes = query.getDescendantsOfCategory(201115, false);
        DMRUtilities.createCubeWrapperDimensionsNodes(nodes, cubeWrapper, connection);
    }

    public static void createCubeWrapperDimensionsNodes(List<IXQEQueryNode> nodes, CubeWrapper cubeWrapper, MetadataConnection connection) {
        ArrayList<IMeasure> measuresWithAggregateRules = new ArrayList<IMeasure>();
        for (IXQEQueryNode node : nodes) {
            String expression;
            V5BoundToMetadata v5BoundToMetadata;
            IMetadata mfwMetadata;
            V5BoundMultiPartIdentifier v5BoundMultipartId = (V5BoundMultiPartIdentifier)node;
            if (!node.isOfCategory(201029) || (mfwMetadata = (v5BoundToMetadata = (V5BoundToMetadata)v5BoundMultipartId).getMetadata()) == null) continue;
            if (v5BoundToMetadata.getType() == 201117) {
                expression = v5BoundMultipartId.getNativeName();
                int indexOf = expression.indexOf("->");
                expression = expression.substring(0, indexOf);
            } else if (v5BoundToMetadata.getType() == 201024) {
                expression = ((V5Parameter)v5BoundToMetadata).getModelIdentifier();
                if (expression == null) {
                    continue;
                }
            } else {
                expression = v5BoundMultipartId.getIdentifier();
            }
            DMRUtilities.createCubeWrapperDimensions(cubeWrapper, connection, measuresWithAggregateRules, mfwMetadata);
        }
        for (IMeasure measure : measuresWithAggregateRules) {
            DMRUtilities.processMeasuresWithAggregateRules(measure, cubeWrapper, connection);
        }
        cubeWrapper.setDefaultMeasure();
    }

    private static void createCubeWrapperDimensions(CubeWrapper cubeWrapper, MetadataConnection connection, List<IMeasure> measuresWithAggregateRules, IMetadata mfwMetadata) {
        IDimension dim = null;
        switch (mfwMetadata.getObjectType()) {
            case DIMENSION: {
                dim = (IDimension)mfwMetadata;
                if (dim.isMeasuresDimension()) {
                    cubeWrapper.addDimension(dim);
                    break;
                }
                DMRUtilities.createDimension(dim, cubeWrapper);
                break;
            }
            case HIERARCHY: {
                IHierarchy hierarchy = (IHierarchy)mfwMetadata;
                dim = hierarchy.getDimension();
                DMRUtilities.createDimension(dim, cubeWrapper);
                break;
            }
            case LEVEL: {
                ILevel level = (ILevel)mfwMetadata;
                dim = level.getDimension();
                DMRUtilities.createDimension(dim, cubeWrapper);
                break;
            }
            case MEMBER: {
                IMember member = (IMember)mfwMetadata;
                if (!member.isMeasure()) {
                    dim = member.getLevel().getDimension();
                    DMRUtilities.createDimension(dim, cubeWrapper);
                    break;
                }
            }
            case MEASURE: {
                IMeasure measure = (IMeasure)mfwMetadata;
                dim = measure.getDimension();
                cubeWrapper.addDimension(dim);
                IDimension targetDim = MetadataUtil.getTargetDim(dim);
                if (targetDim != dim) {
                    cubeWrapper.addDimension(targetDim);
                }
                if (measure.getAggregateRules().length < 0) break;
                measuresWithAggregateRules.add(measure);
                break;
            }
            case CUBE: {
                break;
            }
            case SHORTCUT: {
                break;
            }
            case QUERY_ITEM: {
                ILevel levelofQueryItem = ((IQueryItem)mfwMetadata).getLevel();
                if (levelofQueryItem == null) {
                    if (mfwMetadata instanceof IQueryItemOfDimension && ((IQueryItemOfDimension)mfwMetadata).getDimension() instanceof IMeasureDimension) {
                        String s1 = ((IQueryItemOfDimension)mfwMetadata).getDimension().toString();
                        String s2 = mfwMetadata.getID();
                        throw new XQERuntimeException(XQEMessageKeys.PLN_UnsupportedDegenerateDimension, s1, s2);
                    }
                    return;
                }
                dim = levelofQueryItem.getDimension();
                DMRUtilities.createDimension(dim, cubeWrapper);
                break;
            }
            case QUERY_SUBJECT: {
                break;
            }
        }
        if (dim != null) {
            DMRUtilities.checkForDBDimensionAndIssueNag(dim, connection);
            DMRUtilities.checkForJoinRelationshipsAndIssueNag(dim, connection);
        }
    }

    private static void checkForDBDimensionAndIssueNag(IDimension dimension, MetadataConnection connection) {
        if (dimension instanceof IDbMeasureDimension || dimension instanceof IDbDimension) {
            IExecutionEnvironment eEnv = ExecutionEnvironmentContext.getExecutionEnvironment();
            IMessageKey.Param1 messageKey = XQEMessageKeys.PLN_UnsupportedDatabaseDimension;
            Locale locale = XQEMessages.getCurrProductLocale();
            String dimensionName = dimension.getV5UniqueName();
            String nagMsg = XQEMessages.getMessage(messageKey, locale, dimensionName);
            eEnv.addNag(nagMsg);
        }
    }

    private static void checkForJoinRelationshipsAndIssueNag(IDimension dimension, MetadataConnection connection) {
        String nagMsg;
        String dimensionName;
        String joinName;
        Locale locale;
        IMessageKey.Param2 messageKey;
        IRelationship join;
        IExecutionEnvironment eEnv = ExecutionEnvironmentContext.getExecutionEnvironment();
        if (eEnv.getRequestEnvironment().getMaxSeverityLevel() < 3) {
            return;
        }
        for (IMetadata i : connection.getRelationshipShortcuts()) {
            if (!(i instanceof IRelationship) || !(join = (IRelationship)i).getLeftRefObjectId().equals(dimension.getID()) && !join.getRightRefObjectId().equals(dimension.getID())) continue;
            messageKey = XQEMessageKeys.PLN_UnsupportedJoinByRelationalPlanning;
            locale = XQEMessages.getCurrProductLocale();
            joinName = join.getV5UniqueName();
            dimensionName = dimension.getV5UniqueName();
            nagMsg = XQEMessages.getMessage(messageKey, locale, joinName, dimensionName);
            eEnv.addNag(nagMsg);
        }
        for (IMetadata j : connection.getRelationships()) {
            if (!(j instanceof IRelationship) || !(join = (IRelationship)j).getLeftRefObjectId().equals(dimension.getID()) && !join.getRightRefObjectId().equals(dimension.getID())) continue;
            messageKey = XQEMessageKeys.PLN_UnsupportedJoinByRelationalPlanning;
            locale = XQEMessages.getCurrProductLocale();
            joinName = join.getV5UniqueName();
            dimensionName = dimension.getV5UniqueName();
            nagMsg = XQEMessages.getMessage(messageKey, locale, joinName, dimensionName);
            eEnv.addNag(nagMsg);
        }
    }

    private static void processMeasuresWithAggregateRules(IMeasure measure, CubeWrapper cubeWrapper, MetadataConnection connection) {
        for (IAggregateRule rule : measure.getAggregateRules()) {
            String dimensionRef = rule.getDimensionRef();
            IMetadata metadata = connection.bindMetadataReference(dimensionRef);
            if (metadata.getObjectType() == MetadataType.SHORTCUT) {
                metadata = ((IShortcut)metadata).getTargetWithShortcut();
            }
            if (metadata.getObjectType() != MetadataType.DIMENSION) continue;
            IDimension dimension = (IDimension)metadata;
            DMRUtilities.createDimension((IDimension)metadata, cubeWrapper);
            DimensionWrapper dimWrapper = (DimensionWrapper)cubeWrapper.getWrapper(metadata);
            List<IHierarchy> projectedHierarchies = dimWrapper.getHierarchies();
            if (projectedHierarchies == null) {
                if (((IAccessedViaShortcut)metadata).isAccessedViaShortcut()) {
                    projectedHierarchies = DMRUtilities.findShortCutHierarchies((IDimension)metadata, cubeWrapper);
                    if (projectedHierarchies == null) {
                        DMRUtilities.createLowestProjectedLevel(dimension.getHierarchies().get(0), measure, dimension, cubeWrapper);
                        continue;
                    }
                    for (IHierarchy projectedHierarchy : projectedHierarchies) {
                        DMRUtilities.createLowestProjectedLevel(projectedHierarchy, measure, dimension, cubeWrapper);
                    }
                    continue;
                }
                DMRUtilities.createLowestProjectedLevel(dimension.getHierarchies().get(0), measure, dimension, cubeWrapper);
                continue;
            }
            for (IHierarchy projectedHierarchy : projectedHierarchies) {
                DMRUtilities.createLowestProjectedLevel(projectedHierarchy, measure, dimension, cubeWrapper);
            }
        }
    }

    private static void createLowestProjectedLevel(IHierarchy hierarchy, IMeasure measure, IDimension dimension, CubeWrapper cubeWrapper) {
        if (hierarchy.getLevels().isEmpty()) {
            return;
        }
        IScopeRelationship scopeRel = measure.getScopeRelationship(dimension);
        ILevel lowestLevel = null;
        if (scopeRel != null) {
            IDimension targetDimension;
            lowestLevel = scopeRel.getLowestLevel(measure, hierarchy.getLevels().get(0));
            if (lowestLevel == null) {
                lowestLevel = hierarchy.getLevels().get(0);
            } else if (dimension.isAccessedViaShortcut() && !(targetDimension = scopeRel.getNonMeasureDimension()).equals(dimension)) {
                lowestLevel = hierarchy.getLevel(lowestLevel.getIndex());
            }
        } else {
            lowestLevel = hierarchy.getLevels().get(0);
        }
        cubeWrapper.getWrapper(lowestLevel);
    }

    private static void createDimension(IDimension dimension, CubeWrapper cubeWrapper) {
        if (cubeWrapper.getWrapper(dimension) != null) {
            return;
        }
        IDimension target = dimension.getDimUnderTargetNamespace();
        if (target != dimension) {
            String[] namespaces = target.getParentNamespaces();
            if (cubeWrapper.getWrapper(target) == null) {
                cubeWrapper.createDimension(target, namespaces).getChildMetadataObjects();
            }
            namespaces[namespaces.length - 1] = dimension.getParentNamespace().getName();
            cubeWrapper.createDimension(dimension, namespaces).getChildMetadataObjects();
        } else if (dimension.isAccessedViaShortcut()) {
            String[] namespaces = dimension.getParentNamespaces();
            cubeWrapper.createDimension(dimension, namespaces).getChildMetadataObjects();
            IDimension target1 = (IDimension)dimension.getShortcut().getTarget();
            if (target1 != dimension) {
                if (cubeWrapper.getWrapper(target1) != null) {
                    return;
                }
                namespaces = target1.getParentNamespaces();
                cubeWrapper.createDimension(target1, namespaces).getChildMetadataObjects();
            }
        } else {
            String[] namespaces = dimension.getParentNamespaces();
            cubeWrapper.createDimension(dimension, namespaces).getChildMetadataObjects();
        }
    }

    private static List<IHierarchy> findShortCutHierarchies(IDimension mfwDimension, CubeWrapper cubeWrapper) {
        IDimension target = (IDimension)mfwDimension.getShortcut().getTarget();
        if (target != mfwDimension) {
            DimensionWrapper targetWrapper = (DimensionWrapper)cubeWrapper.getWrapper(target);
            return targetWrapper.getHierarchies();
        }
        return null;
    }

    public static boolean isQueryDMR(IXQEQueryNode queryNode) {
        XMdxLocal xmdxLocal;
        switch (queryNode.getType()) {
            case 501053: {
                XMdxLocal xmdxLocal2 = (XMdxLocal)queryNode;
                return xmdxLocal2.getDataSource() == null || xmdxLocal2.getDataSource().isRelational();
            }
            case 101006: {
                V5Query v5Query = (V5Query)queryNode;
                return v5Query.isDMR();
            }
        }
        V5Query v5Query = (V5Query)queryNode.getAncestorOfType(101006);
        RSAPIDataset rsapiDataset = (RSAPIDataset)queryNode.getAncestorOfType(401005);
        IXQEQueryNode root = null;
        root = v5Query != null ? v5Query : (rsapiDataset != null ? rsapiDataset : queryNode.getAncestorOfType(1101013));
        boolean isCustomQuery = false;
        if (queryNode.isOfCategory(501017)) {
            XMdx xMDXQuery = (XMdx)queryNode;
            isCustomQuery = xMDXQuery.getMDXQuery() instanceof CustomQuery;
        }
        if (root == null && !isCustomQuery) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Neither v5Query, rsapiDataset nor MARequest node were found");
        }
        if (root != null && (xmdxLocal = (XMdxLocal)root.getAncestorOfType(501053)) == null) {
            IXQEQueryNode[] iXQEQueryNodeArray = root.getDescendantsOfType(501053, true);
            int n = iXQEQueryNodeArray.length;
            for (int i = 0; i < n; ++i) {
                IXQEQueryNode node = iXQEQueryNodeArray[i];
                xmdxLocal = (XMdxLocal)node;
                if (xmdxLocal.getDataSource() != null && !xmdxLocal.getDataSource().isRelational()) continue;
                return true;
            }
        }
        if (v5Query == null) {
            String queryName;
            for (IXQEQueryNode node : queryNode.getDescendantsOfType(101006, true)) {
                v5Query = (V5Query)node;
                if (v5Query.isDMR()) {
                    return true;
                }
                queryName = (String)v5Query.getPropertyValue("name");
                if (!queryName.equals(DMRQUERY_LOAD_LEVELS) && !queryName.equals(DMRQUERY_LOAD_MEMBERS_PROPERTY) && !queryName.equals(DMRQUERY_LOAD_MEMBER_CHILDREN) && !queryName.equals(DMRQUERY_FETCH_CELL_VALUES) && !queryName.equals(DMRQUERY_FETCH_CELL_VALUES_FL_AGGR) && !queryName.startsWith(DMR_QUERY)) continue;
                return true;
            }
            if (v5Query != null) {
                return false;
            }
            if (rsapiDataset == null) {
                for (IXQEQueryNode node : queryNode.getDescendantsOfType(401005, true)) {
                    rsapiDataset = (RSAPIDataset)node;
                    queryName = rsapiDataset.getRefQueryName();
                    if (!queryName.equals(DMRQUERY_LOAD_LEVELS) && !queryName.equals(DMRQUERY_LOAD_MEMBERS_PROPERTY) && !queryName.equals(DMRQUERY_LOAD_MEMBER_CHILDREN) && !queryName.equals(DMRQUERY_FETCH_CELL_VALUES) && !queryName.equals(DMRQUERY_FETCH_CELL_VALUES_FL_AGGR) && !queryName.startsWith(DMR_QUERY)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static IXQEQueryNode createColumnMeasureRef(XQENodeFactory factory, String dataItemRefName) {
        V5MultiPartIdentifier dataItemIdentifier = (V5MultiPartIdentifier)factory.createNode(201030);
        dataItemIdentifier.setIdentifier(DMRUtilities.createColumnRefIdentifierName(dataItemRefName));
        return dataItemIdentifier;
    }

    public static String createColumnRefIdentifierName(String dataItemRefName) {
        return UniqueNameGenerator.createSingleNamePart(dataItemRefName);
    }

    public static IXQEQueryNode createColumnMeasure(XQENodeFactory factory, String dataItemRefName) {
        IXQEQueryNode dataItemRefMeasure = factory.createNode(101003);
        dataItemRefMeasure.setPropertyValue("name", dataItemRefName);
        return dataItemRefMeasure;
    }

    public static IXQEQueryNode createExpression(XQENodeFactory factory, String expression) {
        IXQEQueryNode eNode = factory.createNode(101004);
        eNode.setPropertyValue("expression", expression);
        return eNode;
    }

    public static void createDataItemWithExpression(XQENodeFactory factory, IXQEQueryNode selection, String diName, String expression) {
        IXQEQueryNode expressionNode = DMRUtilities.createExpression(factory, expression);
        IXQEQueryNode dataItemRefMeasure = DMRUtilities.createColumnMeasure(factory, diName);
        dataItemRefMeasure.addChild(expressionNode);
        selection.addChild(dataItemRefMeasure);
    }

    public static boolean isAllLevel(IMetadata metadata) {
        String isManualProp;
        return metadata instanceof ILevel && (isManualProp = (String)((ILevel)metadata).getProperty("isManual")) != null && Boolean.parseBoolean(isManualProp);
    }

    public static void convertAllLevelToRootCaptionOrRootMUNKey(V5BoundToMetadata v5BoundId, PlanningEnvironment environment, String roleType) {
        if (!roleType.equals(RoleTypeEnum.BUSINESS_KEY.toV5Keyword()) && !roleType.equals(RoleTypeEnum.MEMBER_CAPTION.toV5Keyword())) {
            throw new XQERuntimeException(XQEMessageKeys.PLN_RoleNotFound, roleType, v5BoundId.getNativeName());
        }
        V5LiteralValue literalValue = DMRUtilities.getRootCaptionOrRootMUNKeyLiteralValue(v5BoundId, environment, roleType);
        if (literalValue != null) {
            v5BoundId.exchange(literalValue);
        }
    }

    public static V5LiteralValue getRootCaptionOrRootMUNKeyLiteralValue(V5BoundToMetadata v5BoundId, PlanningEnvironment environment, String roleType) {
        V5LiteralValue literal = null;
        IMetadata metadata = v5BoundId.getMetadata();
        IHierarchy hier = null;
        if (metadata.getObjectType() == MetadataType.HIERARCHY) {
            hier = (IHierarchy)metadata;
        } else if (metadata.getObjectType() == MetadataType.LEVEL) {
            hier = ((ILevel)metadata).getHierarchy();
        }
        if (hier != null) {
            IMember rootMember = hier.getRootMember();
            if (rootMember != null) {
                literal = (V5LiteralValue)environment.getNodeFactory().createNode(201026);
                String literalValue = null;
                if (roleType.equals(RoleTypeEnum.BUSINESS_KEY.toV5Keyword())) {
                    try {
                        literalValue = UniqueNameParser.parseLastIdentifier(rootMember.getUniqueName());
                    }
                    catch (UniqueNameParserException e) {
                        throw new XQERuntimeException(e);
                    }
                } else if (roleType.equals(RoleTypeEnum.MEMBER_CAPTION.toV5Keyword())) {
                    literalValue = rootMember.getCaption();
                }
                literal.setDataType(DataTypeFactory.getVarcharType(literalValue.length()));
                literal.setValue(literalValue);
            } else {
                throw new XQERuntimeException(XQEMessageKeys.PLN_RootMemberNotDefined, hier.getName());
            }
        }
        return literal;
    }

    public static String getMetadataNameForLog(IMetadata m) {
        return m.getUniqueName();
    }

    public static String findDataItem(IXQEQueryNode selectionList, String queryItemExpression) {
        int index = DMRUtilities.getDataItemIndex(selectionList, queryItemExpression);
        if (index != -1) {
            return ((V5DataItem)selectionList.getChild(index)).getNameProperty();
        }
        return null;
    }

    public static int getDataItemIndex(IXQEQueryNode selectionList, String queryItemExpression) {
        IXQEQueryNode[] expressions;
        for (IXQEQueryNode expression : expressions = selectionList.getDescendantsOfType(101004, false)) {
            String s = (String)expression.getPropertyValue("expression");
            if (s == null || !s.equals(queryItemExpression)) continue;
            V5DataItem dataItem = (V5DataItem)expression.getParent();
            return selectionList.getPositionOfChild(dataItem);
        }
        return -1;
    }

    public static boolean allOLAPFunctionsCanBeConvertedToRelationalExpr(IXQEQueryNode filter) {
        List<IXQEQueryNode> v5Nodes = filter.getDescendantsOfCategory(201121, false);
        v5Nodes.addAll(filter.getDescendantsOfCategory(201122, false));
        v5Nodes.addAll(filter.getDescendantsOfCategory(201110, false));
        for (IXQEQueryNode v5AbsNode : v5Nodes) {
            if (v5AbsNode.getType() == 201110) {
                V5TupleFunction tf = (V5TupleFunction)v5AbsNode;
                if (tf.isCoercion()) continue;
                IXQEQueryNode[] children = tf.getChildren();
                if (children.length > 1) {
                    return false;
                }
                List<IXQEQueryNode> v5ModelId = children[0].getDescendantsOfCategory(201116, true);
                if (v5ModelId.size() != 1) {
                    return false;
                }
                V5BoundModelIdentifier v5BoundID = (V5BoundModelIdentifier)v5ModelId.get(0);
                if (v5BoundID.isMeasure()) continue;
                return false;
            }
            if (v5AbsNode.getType() == 201053 || v5AbsNode.getType() == 201086) continue;
            if (v5AbsNode.getType() == 201101) {
                IXQEQueryNode exprNode = v5AbsNode.getParent();
                while (exprNode.getType() == 101003 || exprNode.getType() == 101004) {
                    exprNode = exprNode.getParent();
                }
                return !exprNode.isOfCategory(201126) || !v5AbsNode.isAncestor(exprNode.getChild(0));
            }
            return false;
        }
        return true;
    }

    public static void isDMRExpressionHasSummaryFunction(PlanningEnvironment environment, V5BoundModelIdentifier v5BoundID, IXQEQueryNode tree) {
        if (tree == null) {
            return;
        }
        V5AggregateFunction aggrFunc = (V5AggregateFunction)tree.getFirstDescendantOfCategory(201124, true);
        IXQEQueryNode prePlanQuery = v5BoundID.getAncestorOfType(101072);
        if (prePlanQuery != null && aggrFunc != null) {
            RSAPIDataset rsapiDataset = (RSAPIDataset)v5BoundID.getAncestorOfType(401005);
            String queryName = rsapiDataset.getRefQueryName();
            String item = DMRUtilities.getContextObjectName(v5BoundID);
            ResponseMessage responseMsg = new ResponseMessage(1, ResponseMessage.ResponseMessageType.TYPE_PLAN_STAT_INT, XQEMessageKeys.PLN_DMRExpressionWithSummaryFunction, v5BoundID.getIdentifier(), v5BoundID.getExpression(), queryName, item);
            environment.getResponseMessageFolder().appendPlanningResponseMessage(responseMsg);
        }
    }

    private static String getContextObjectName(V5BoundModelIdentifier v5BoundID) {
        IXQEQueryNode ancestor = v5BoundID.getAncestorOfTypes(new int[]{801008, 801033, 101008});
        if (ancestor == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        String item = null;
        if (ancestor instanceof RQPDataItem) {
            item = (String)ancestor.getPropertyValue("originalV5Name");
            sb.append("DataItem: \"");
        } else if (ancestor instanceof RMQueryItem) {
            item = ((RMQueryItem)ancestor).getQueryItem().getID();
            sb.append("ModelItem: \"");
        } else if (ancestor instanceof V5DetailFilter) {
            item = ((V5DetailFilter)ancestor).getOriginalExpression();
            sb.append("DetailFilter: \"");
        }
        sb.append(item);
        sb.append(QUOTESIGN);
        return sb.toString();
    }

    public static IDimension getMFWDimension(DMRDimension dmrDim) {
        if (dmrDim.isMeasureDimension()) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Use getMFWDimension(DMRMeasure dmrMeasure) instead.");
        }
        DMRCube dmrCube = (DMRCube)dmrDim.getCube();
        IDimension dim = (IDimension)dmrCube.getWrapped(dmrDim);
        if (dim instanceof DimensionWrapper) {
            DimensionWrapper dimWrapper = (DimensionWrapper)dim;
            CubeWrapper cubeWrapper = dimWrapper.getCube();
            return (IDimension)cubeWrapper.getWrapped(dimWrapper);
        }
        return null;
    }

    public static IDimension getMFWDimension(DMRMeasure dmrMeasure) {
        DMRCube dmrCube = (DMRCube)dmrMeasure.getDimension().getCube();
        IMeasure measure = (IMeasure)dmrCube.getWrapped(dmrMeasure);
        if (measure instanceof MeasureWrapper) {
            MeasureWrapper measureWrapper = (MeasureWrapper)measure;
            IMeasure mfwMeasure = measureWrapper.getWrapped();
            return mfwMeasure.getDimension();
        }
        return null;
    }

    public static IMeasure getMFWMeasure(DMRMeasure dmrMeasure) {
        DMRCube dmrCube = (DMRCube)dmrMeasure.getDimension().getCube();
        IMeasure measure = (IMeasure)dmrCube.getWrapped(dmrMeasure);
        if (measure instanceof MeasureWrapper) {
            MeasureWrapper measureWrapper = (MeasureWrapper)measure;
            return measureWrapper.getWrapped();
        }
        return null;
    }

    public static DMRDimension getDMRDimension(IDimension mfwDimension, CubeWrapper cubeWrapper) {
        IDimension dim = (IDimension)cubeWrapper.getWrapper(mfwDimension);
        if (dim instanceof DimensionWrapper) {
            DimensionWrapper dimWrapper = (DimensionWrapper)dim;
            return (DMRDimension)cubeWrapper.getWrapper(dimWrapper);
        }
        return null;
    }

    public static DMRLevel getDMRLevel(ILevel mfwLevel, DMRCube dmrCube) {
        CubeWrapper cubeWrapper = (CubeWrapper)dmrCube.getWrapped(dmrCube);
        ILevel level = (ILevel)cubeWrapper.getWrapper(mfwLevel);
        if (level instanceof LevelWrapper) {
            LevelWrapper levelWrapper = (LevelWrapper)level;
            IDimension dimWrapper = level.getDimension();
            IHierarchy hierWrapper = level.getHierarchy();
            IDimension dmrDim = dmrCube.getDimension(dimWrapper.getName());
            IHierarchy dmrHier = dmrDim.getHierarchy(hierWrapper.getName());
            return (DMRLevel)dmrHier.getLevel(levelWrapper.getName());
        }
        return null;
    }

    public static IDimension getMFWDimensionTarget(DMRDimension dmrDim) {
        if (dmrDim.isMeasureDimension() && dmrDim.getDefaultMember() != null && dmrDim.getDefaultMember() instanceof DMRMeasure) {
            return DMRUtilities.getMFWDimension((DMRMeasure)dmrDim.getDefaultMember());
        }
        return DMRUtilities.getMFWDimensionTarget(DMRUtilities.getMFWDimension(dmrDim));
    }

    public static IDimension getMFWDimensionTarget(IDimension mfwDimension) {
        if (mfwDimension == null) {
            return null;
        }
        if (mfwDimension.isAccessedViaShortcut()) {
            IDimension dimTarget = (IDimension)mfwDimension.getShortcut().getTarget();
            return dimTarget;
        }
        return mfwDimension;
    }

    public static IDimension getDimension(IHierarchy hierarchy) {
        IDimension dimension = hierarchy.getDimension();
        if (dimension instanceof DMRDimension) {
            DMRDimension dmrDimension = (DMRDimension)hierarchy.getDimension();
            DMRCube dmrCube = (DMRCube)dmrDimension.getCube();
            dimension = (IDimension)dmrCube.getWrapped(dmrDimension);
        }
        if (dimension instanceof DimensionWrapper) {
            DimensionWrapper dimWrapper = (DimensionWrapper)dimension;
            CubeWrapper cubeWrapper = dimWrapper.getCube();
            IDimension mfwDimension = (IDimension)cubeWrapper.getWrapped(dimWrapper);
            dimension = DMRUtilities.getMFWDimensionTarget(mfwDimension);
        }
        return dimension;
    }

    public static DMRDimension[] getDMRDimensionsFromMFWDimensionUniqueName(String uniqueName, DMRCube cube) {
        List<DMRDimension> dims = CollectionCast.downcast(cube.getDimensions(), IDimension.class, DMRDimension.class);
        return DMRUtilities.getDMRDimensionsFromMFWDimensionUniqueName(uniqueName, dims);
    }

    public static DMRDimension[] getDMRDimensionsFromMFWDimensionUniqueName(String uniqueName, List<DMRDimension> dims) {
        ArrayList<DMRDimension> dimensions = new ArrayList<DMRDimension>();
        IDimension directMapping = null;
        for (DMRDimension dmrDim : dims) {
            IDimension aDim = dmrDim.getWrappedDimension();
            if (!(aDim instanceof AbstractDimensionWrapper)) continue;
            AbstractDimensionWrapper dimWrapper = (AbstractDimensionWrapper)aDim;
            if (dimWrapper.isDirectWrapping(uniqueName)) {
                directMapping = dimWrapper.getWrappedDimension();
            }
            if (!dimWrapper.isDefiningMFWDimension(uniqueName)) continue;
            dimensions.add(dmrDim);
        }
        if (!directMapping.isAccessedViaShortcut()) {
            return dimensions.toArray(new DMRDimension[dimensions.size()]);
        }
        IShortcut shortcut = ((IAccessedViaShortcut)((Object)directMapping)).getShortcut();
        IMetadata target = shortcut.getTarget();
        if (!(target instanceof IDimension)) {
            return dimensions.toArray(new DMRDimension[dimensions.size()]);
        }
        IDimension mfwDimTarget = (IDimension)target;
        for (DMRDimension dmrDim : dims) {
            if (!dmrDim.isDefiningMFWDimension(mfwDimTarget.getID())) continue;
            dimensions.add(dmrDim);
        }
        return dimensions.toArray(new DMRDimension[dimensions.size()]);
    }

    public static AbstractV5BooleanExpression createFilterForMember(PlanningEnvironment planningEnv, IMember member) {
        XQENodeFactory nodeFactory = planningEnv.getNodeFactory();
        AbstractV5BooleanExpression filterCondition = null;
        IXQEQueryNode columnExpr = DMRUtilities.generateColumnExpression(planningEnv, member);
        Value businessKeyValue = member.getBusinessKeyValue();
        if (businessKeyValue == null || businessKeyValue.isNull()) {
            filterCondition = (AbstractV5BooleanExpression)nodeFactory.createNode(201010);
            filterCondition.addChild(columnExpr);
        } else {
            filterCondition = (AbstractV5BooleanExpression)nodeFactory.createNode(201013);
            filterCondition.setSubType(2);
            filterCondition.addChild(columnExpr);
            V5LiteralValue literalValue = V5Builder.createV5LiteralValue(nodeFactory, businessKeyValue);
            filterCondition.addChild(literalValue);
        }
        return filterCondition;
    }

    public static AbstractV5BooleanExpression createINExpressionForMembers(PlanningEnvironment planningEnv, Collection<IMember> members) {
        IMember firstMember = members.iterator().next();
        if (members.size() == 1) {
            return DMRUtilities.createFilterForMember(planningEnv, firstMember);
        }
        XQENodeFactory nodeFactory = planningEnv.getNodeFactory();
        IXQEQueryNode columnExpr = DMRUtilities.generateColumnExpression(planningEnv, firstMember);
        AbstractV5BooleanExpression filterExpr = null;
        V5InExpression inExpr = null;
        boolean hasNullBusinessKey = false;
        boolean startNewClause = false;
        int i = -1;
        for (IMember member : members) {
            ++i;
            Value businessKeyVal = member.getBusinessKeyValue();
            if (businessKeyVal == null || businessKeyVal.isNull()) {
                hasNullBusinessKey = true;
                continue;
            }
            if (startNewClause || filterExpr == null) {
                inExpr = (V5InExpression)nodeFactory.createNode(201011);
                if (filterExpr == null) {
                    inExpr.addChild(columnExpr);
                    filterExpr = inExpr;
                } else {
                    inExpr.addChild(nodeFactory.deepCopyNode(columnExpr));
                    filterExpr = V5Builder.createV5OrOperator(nodeFactory, filterExpr, inExpr);
                }
                startNewClause = false;
            }
            V5LiteralValue literalValue = V5Builder.createV5LiteralValue(nodeFactory, businessKeyVal);
            inExpr.addChild(literalValue);
            if (i <= 0 || i % 250 != 0) continue;
            startNewClause = true;
        }
        if (hasNullBusinessKey) {
            V5IsNullExpression isNullExpr = (V5IsNullExpression)nodeFactory.createNode(201010);
            isNullExpr.addChild(nodeFactory.deepCopyNode(columnExpr));
            filterExpr = filterExpr == null ? isNullExpr : V5Builder.createV5OrOperator(nodeFactory, filterExpr, isNullExpr);
        }
        return filterExpr;
    }

    private static IXQEQueryNode generateColumnExpression(PlanningEnvironment planningEnv, IMember member) {
        DMRLevel aLevel = (DMRLevel)member.getLevel();
        IXQEQueryNode columnExpr = RQPUtilities.createV5ValueExpressionMetadata(aLevel.getQueryItemExpressionForKey(), planningEnv, null, V5QueryOverTabularStream.getLevelModel(aLevel));
        MetadataContext mc = aLevel.getMetadataContext();
        if (mc != null) {
            mc.setMetadataContextOnV5MultiPartIdentifier(columnExpr);
        }
        return columnExpr;
    }

    public static FormatId resolveFormatIdForMeasure(IMember measure, Value measureValue) {
        FormatId formatId = null;
        String measureFormat = (String)measure.getProperty(FORMAT);
        if (measureFormat != null) {
            formatId = FormatService.getInstance().registerV5Format(measureFormat, null);
        } else {
            formatId = measureValue.getFormatId();
            if ((formatId == null || formatId == FormatId.INVALID_FORMAT_FID) && measureValue.isNumeric()) {
                formatId = FormatId.DEFAULT_NUMBER_FORMAT_FID;
            }
        }
        return formatId;
    }

    public static void useRelationalCache(DMRCube cube, PlanningEnvironment environment, Governors governors, SubqueryType type) {
        RequestEnvironment requestEnvironment = (RequestEnvironment)environment.getRequestEnvironment();
        int maxSeverityLevel = requestEnvironment.getMaxSeverityLevel();
        if ((requestEnvironment.isValidateRequest() || requestEnvironment.isMixedRequest()) && maxSeverityLevel == 3) {
            return;
        }
        if (type.equals((Object)SubqueryType.FETCH_CELL_VALUES) || type.equals((Object)SubqueryType.FETCH_CELL_VALUES_FIRST_LAST_AGGREGATE)) {
            DMRUtilities.useRelationalCacheForCells(cube, governors);
        } else {
            DMRUtilities.useRelationalCacheForMembers(cube, governors);
        }
    }

    private static void useRelationalCacheForMembers(DMRCube cube, Governors governors) {
        Governors.DMRUseRelationalCache reuseQueryReuseCacheForMembers = governors.getDMRMembersUseRelationalCache();
        if (reuseQueryReuseCacheForMembers.equals((Object)Governors.DMRUseRelationalCache.ALWAYS)) {
            governors.setLocalCache(Boolean.TRUE.toString());
            governors.setLocalCachePolicy(Governors.LocalCachePolicy.QUERY_REFERENCED_BY_LAYOUT.toString());
        } else if (reuseQueryReuseCacheForMembers.equals((Object)Governors.DMRUseRelationalCache.NEVER)) {
            governors.setLocalCache(Boolean.FALSE.toString());
        } else if (reuseQueryReuseCacheForMembers.equals((Object)Governors.DMRUseRelationalCache.CUBE_REUSE_DISABLED) && !cube.isReusedCube()) {
            governors.setLocalCache(Boolean.TRUE.toString());
            governors.setLocalCachePolicy(Governors.LocalCachePolicy.QUERY_REFERENCED_BY_LAYOUT.toString());
        }
    }

    private static void useRelationalCacheForCells(DMRCube cube, Governors governors) {
        Governors.DMRUseRelationalCache reuseQueryReuseCacheForCells = governors.getDMRCellsUseRelationalCache();
        if (reuseQueryReuseCacheForCells.equals((Object)Governors.DMRUseRelationalCache.ALWAYS)) {
            governors.setLocalCache(Boolean.TRUE.toString());
            governors.setLocalCachePolicy(Governors.LocalCachePolicy.QUERY_REFERENCED_BY_LAYOUT.toString());
        } else if (reuseQueryReuseCacheForCells.equals((Object)Governors.DMRUseRelationalCache.NEVER)) {
            governors.setLocalCache(Boolean.FALSE.toString());
        } else if (reuseQueryReuseCacheForCells.equals((Object)Governors.DMRUseRelationalCache.CUBE_REUSE_DISABLED) && !cube.isReusedCube()) {
            governors.setLocalCache(Boolean.TRUE.toString());
            governors.setLocalCachePolicy(Governors.LocalCachePolicy.QUERY_REFERENCED_BY_LAYOUT.toString());
        }
    }

    public static IMetadata getWrapped(IMetadata md) {
        if (md instanceof AbstractDimensionWrapper) {
            return ((AbstractDimensionWrapper)md).getWrappedDimension();
        }
        if (md instanceof CalculationWrapper) {
            return ((CalculationWrapper)md).getWrappedCalculation();
        }
        if (md instanceof FilterWrapper) {
            return ((FilterWrapper)md).getWrappedFilter();
        }
        if (md instanceof HierarchyWrapper) {
            return ((HierarchyWrapper)md).getWrappedHierarchy();
        }
        if (md instanceof LevelWrapper) {
            return ((LevelWrapper)md).getWrappedLevel();
        }
        if (md instanceof MeasureWrapper) {
            return ((MeasureWrapper)md).getWrapped();
        }
        if (md instanceof QueryItemWrapper) {
            return ((QueryItemWrapper)((Object)md)).getQueryItem();
        }
        if (md instanceof ScopeRelationshipWrapper) {
            return ((ScopeRelationshipWrapper)md).getWrappedScopeRelationship();
        }
        return md;
    }

    public static enum SubqueryType {
        LOAD_LEVELS,
        LOAD_MEMBERS_PROPERTY,
        LOAD_MEMBER_CHILDREN,
        FETCH_CELL_VALUES,
        FETCH_CELL_VALUES_FIRST_LAST_AGGREGATE,
        PD_FILTER,
        PD_TOPCOUNT,
        PD_BOTTOMCOUNT,
        PD_HEAD,
        PD_TAIL,
        LOAD_NON_REUSABLE_CUBE;


        public static SubqueryType getPushdownSubqueryType(PushdownManager pdManager) {
            String functionName = pdManager.getTopPushdownFunctionName();
            if (functionName != null) {
                if (functionName.equals("Filter") || functionName.equals("Aggregate")) {
                    return PD_FILTER;
                }
                if (functionName.equals("TopCount")) {
                    return PD_TOPCOUNT;
                }
                if (functionName.equals("BottomCount")) {
                    return PD_BOTTOMCOUNT;
                }
                if (functionName.equals("Head")) {
                    return PD_HEAD;
                }
                if (functionName.equals("Tail")) {
                    return PD_TAIL;
                }
            }
            return FETCH_CELL_VALUES;
        }

        public String toString() {
            switch (this) {
                case LOAD_LEVELS: {
                    return DMRUtilities.DMRQUERY_LOAD_LEVELS;
                }
                case LOAD_MEMBERS_PROPERTY: {
                    return DMRUtilities.DMRQUERY_LOAD_MEMBERS_PROPERTY;
                }
                case LOAD_MEMBER_CHILDREN: {
                    return DMRUtilities.DMRQUERY_LOAD_MEMBER_CHILDREN;
                }
                case FETCH_CELL_VALUES: {
                    return DMRUtilities.DMRQUERY_FETCH_CELL_VALUES;
                }
                case FETCH_CELL_VALUES_FIRST_LAST_AGGREGATE: {
                    return DMRUtilities.DMRQUERY_FETCH_CELL_VALUES_FL_AGGR;
                }
                case PD_FILTER: {
                    return "Filter";
                }
                case PD_TOPCOUNT: {
                    return "TopCount";
                }
                case PD_BOTTOMCOUNT: {
                    return "BottomCount";
                }
                case PD_HEAD: {
                    return "Head";
                }
                case PD_TAIL: {
                    return "Tail";
                }
                case LOAD_NON_REUSABLE_CUBE: {
                    return DMRUtilities.DMR_NON_REUSABLE_CUBE_LOADING_QUERY;
                }
            }
            return DMRUtilities.DMR_QUERY;
        }
    }
}

