/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.dmr;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5DetailFilter;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.ast.v5Exp.V5SimpleNode;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.metadata.IMeasure;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.provider.Dimension;
import com.cognos.xqe.metadata.wrapper.CubeWrapper;
import com.cognos.xqe.metadata.wrapper.MeasureWrapper;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.ResponseMessage;
import com.cognos.xqe.query.engine.ResponseMessageFolder;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.util.AggregationUtils;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.dmr.DMRUtilities;
import com.cognos.xqe.util.Pair;
import com.cognos.xqeqte.QTEAbstractTransformation;
import java.util.List;

public class PropagateV5Aggregate
extends Transformation {
    private static final String PROPAGATE_AGGREGATE_ALREADY = "propagateAggregate";
    private static final int MAX_TRY = 500;

    public PropagateV5Aggregate() {
        this.mName = "Propagates the V5 Aggregate to the measure.";
        this.mPassNumbers = new int[]{5};
        this.mTypes = new int[]{201116};
        this.mMode = QTEAbstractTransformation.Mode.TOP_DOWN_FAST;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode[] summaryAggrs;
        IXQEQueryNode[] dataItems;
        V5DataItem ancestorDataItem;
        IXQEQueryNode expressionToCopy;
        IXQEQueryNode[] dis;
        V5DataItem di;
        String topmostAgg;
        IMetadata metadata = ((V5BoundModelIdentifier)node).getMetadata();
        MeasureWrapper wrapper = (MeasureWrapper)metadata;
        V5DataItem dataItem = (V5DataItem)node.getAncestorOfType(101003);
        String aggregate = dataItem.getAggregateProperty();
        if (aggregate == null || aggregate.equals("none")) {
            aggregate = "automatic";
        }
        if ((topmostAgg = (di = (V5DataItem)(dis = node.getAncestorsOfType(101003))[dis.length - 1]).getAggregateProperty()) == null) {
            topmostAgg = "automatic";
        }
        if (topmostAgg.equals("notApplicable")) {
            node.setPropertyValue(PROPAGATE_AGGREGATE_ALREADY, true);
            return;
        }
        IXQEQueryNode expression = dataItem.getDetailExpression();
        if (expression.getType() == 101004) {
            expression = expression.getChild(0);
        }
        if (this.replaceByMeasureWrapperWithDifferentAggregateType(environment, expressionToCopy = this.expressionToAggregateByRelational(node, aggregate, expression), node, topmostAgg)) {
            node.setPropertyValue(PROPAGATE_AGGREGATE_ALREADY, true);
            return;
        }
        if (AggregationUtils.isNoneCalculatedOrAutomaticAggregate(aggregate) && dataItem.getAncestorOfType(101003) != null && dataItem.getAncestorOfType(201031) == null) {
            for (V5DataItem ancestorDataItem2 = (V5DataItem)dataItem.getAncestorOfType(101003); ancestorDataItem2 != null; ancestorDataItem2 = (V5DataItem)ancestorDataItem2.getAncestorOfType(101003)) {
                if (AggregationUtils.isNoneCalculatedOrAutomaticAggregate(ancestorDataItem2.getAggregateProperty())) continue;
                aggregate = ancestorDataItem2.getAggregateProperty();
                dataItem = ancestorDataItem2;
                break;
            }
        }
        if (dataItem.getAncestorOfType(101003) != null && !AggregationUtils.isNoneCalculatedOrAutomaticAggregate((ancestorDataItem = (V5DataItem)(dataItems = dataItem.getAncestorsOfType(101003))[dataItems.length - 1]).getAggregateProperty())) {
            aggregate = ancestorDataItem.getAggregateProperty();
            dataItem = ancestorDataItem;
        }
        if (!AggregationUtils.isNoneCalculatedOrAutomaticAggregate(aggregate) && (summaryAggrs = expressionToCopy.getDescendantsOfType(201031, true)).length > 0) {
            ResponseMessageFolder messageFolder = environment.getResponseMessageFolder();
            messageFolder.appendPlanningResponseMessage(new ResponseMessage(1, ResponseMessage.ResponseMessageType.TYPE_PLAN_STAT_INT, XQEMessageKeys.PLN_NonCompatibleAggregateAttributeWithMeasureExpression, aggregate, dataItem.getNameProperty()));
        }
        if (expressionToCopy != node || !AggregationUtils.isNoneCalculatedOrAutomaticAggregate(aggregate) && !aggregate.equals(wrapper.getRegularAggregate().toV5Type())) {
            CubeWrapper cube = DMRUtilities.findCubeWrapper(node, environment, false);
            MeasureWrapper alternativeWrapper = this.needToCreateNewMeasureWrapper(aggregate, expressionToCopy, wrapper.getWrapped(), cube, node);
            if (alternativeWrapper == null) {
                wrapper = cube.createMeasureWrapper(wrapper);
                wrapper.setV5AggregateAttribute(aggregate);
                wrapper.setReUseable(false);
                if (expressionToCopy != node) {
                    IXQEQueryNode copy = environment.getNodeFactory().deepCopyNode(expressionToCopy);
                    copy.removeFromIndex();
                    wrapper.setBinaryExpression(copy);
                    IDataType orgDT = wrapper.getDataType();
                    IDataType expDT = ((V5SimpleNode)wrapper.getBinaryExpression()).getDataType();
                    if (orgDT != null && expDT != null && orgDT.isNumeric() && expDT.isNumeric() && orgDT.isInteger() && !orgDT.hasScale() && (!expDT.isInteger() || expDT.hasScale())) {
                        wrapper.setDataType(expDT);
                    }
                }
            } else {
                wrapper = alternativeWrapper;
            }
            if (expressionToCopy != node) {
                this.removeCalculatedMembers(expression, aggregate, node);
            }
            ((V5BoundModelIdentifier)node).setMetadata(wrapper);
        }
        node.setPropertyValue(PROPAGATE_AGGREGATE_ALREADY, true);
    }

    protected boolean replaceByMeasureWrapperWithDifferentAggregateType(PlanningEnvironment environment, IXQEQueryNode expression, IXQEQueryNode node, String aggregate) {
        if (expression != node) {
            return false;
        }
        if (AggregationUtils.isNoneCalculatedOrAutomaticAggregate(aggregate)) {
            return false;
        }
        IMetadata metadata = ((V5BoundModelIdentifier)node).getMetadata();
        MeasureWrapper wrapper = (MeasureWrapper)metadata;
        String measureAggr = wrapper.getRegularAggregate().toV5Type();
        if (measureAggr.equals(aggregate)) {
            return false;
        }
        IMeasure fmMeasure = wrapper.getWrapped();
        if (!wrapper.isReUseable() || fmMeasure == null || !fmMeasure.isMFWMeasure() || wrapper.getBinaryExpression() != null) {
            return false;
        }
        CubeWrapper cube = DMRUtilities.findCubeWrapper(node, environment, false);
        String newName = wrapper.getName() + "_" + aggregate;
        IMember[] allMeasures = fmMeasure.getHierarchy().getMembers();
        newName = this.ensureUniqueName(newName, allMeasures, cube);
        MeasureWrapper newWrapper = null;
        Dimension measureDim = cube.createAndReturnMeasuresDimension();
        for (IMetadata m : measureDim.getChildMetadataObjects()) {
            MeasureWrapper mw;
            if (!(m instanceof MeasureWrapper) || !newName.equals((mw = (MeasureWrapper)m).getName())) continue;
            newWrapper = mw;
            break;
        }
        if (newWrapper == null) {
            newWrapper = cube.createMeasureWrapperWithDifferentAggregate(wrapper, newName, aggregate);
        }
        V5BoundModelIdentifier identifier = (V5BoundModelIdentifier)node;
        identifier.setMetadata(newWrapper);
        return true;
    }

    protected String ensureUniqueName(String newName, IMember[] allMeasures, CubeWrapper cube) {
        for (int i = 0; i < 500; ++i) {
            String tryName = null;
            tryName = i == 0 ? newName : newName + Integer.toString(i);
            boolean found = false;
            for (IMember measure : allMeasures) {
                String measureName = cube.buildMeasureName((IMeasure)measure);
                if (!measureName.equals(tryName)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return tryName;
        }
        return newName;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        Boolean isPropagated = (Boolean)node.getPropertyValue(PROPAGATE_AGGREGATE_ALREADY);
        if (isPropagated != null && isPropagated.booleanValue()) {
            this.traceNodeCondition(false, "V5 Aggregate is propagated already.", trace);
            return false;
        }
        IMetadata metadata = ((V5BoundModelIdentifier)node).getMetadata();
        if (metadata == null) {
            this.traceNodeCondition(false, "Not bounded to metadata.", trace);
            return false;
        }
        if (!(metadata instanceof MeasureWrapper)) {
            this.traceNodeCondition(false, "Not a measure wrapper.", trace);
            return false;
        }
        V5DataItem dataItem = (V5DataItem)node.getAncestorOfType(101003);
        if (dataItem == null) {
            this.traceNodeCondition(false, "The expression does not belong to a V5 data item.", trace);
            return false;
        }
        IXQEQueryNode filter = node.getAncestorOfType(101008);
        if (filter != null && ((V5DetailFilter)filter).getPostAutoAggregation()) {
            this.traceNodeCondition(false, "The expression should not be pushed in PAA filter.", trace);
            return false;
        }
        if (node.getAncestorOfType(201106) != null && node.getAncestorOfType(201031) == null) {
            return false;
        }
        this.traceNodeCondition(true, "Propagate the V5 Aggregate.", trace);
        return true;
    }

    private void removeCalculatedMembers(IXQEQueryNode expression, String aggregate, IXQEQueryNode measureItem) {
        if (!AggregationUtils.isNoneCalculatedOrAutomaticAggregate(aggregate)) {
            IXQEQueryNode expressionParent = expression.getParent();
            List<IXQEQueryNode> v5ValueExpressions = expression.getDescendantsOfCategory(201014, true);
            if (v5ValueExpressions.size() > 0) {
                IXQEQueryNode temp = measureItem.extract();
                expressionParent.detachChildren();
                expressionParent.addChild(temp);
            }
        } else {
            IXQEQueryNode summaryFunction = measureItem.getAncestorOfType(201031);
            if (summaryFunction != null) {
                IXQEQueryNode summaryExpression = summaryFunction.getChild(0);
                IXQEQueryNode temp = measureItem.extract();
                summaryExpression.detach();
                summaryFunction.addChild(temp, 0);
            }
        }
    }

    private IXQEQueryNode expressionToAggregateByRelational(IXQEQueryNode node, String aggregate, IXQEQueryNode diExpression) {
        IXQEQueryNode summaryFunction;
        IXQEQueryNode newExpression = null;
        newExpression = AggregationUtils.isNoneCalculatedOrAutomaticAggregate(aggregate) || node.getAncestorOfCategory(201085) != null ? ((summaryFunction = node.getAncestorOfTypeWithAnchor(201031, 201085)) != null ? summaryFunction : node) : diExpression;
        return newExpression;
    }

    private MeasureWrapper needToCreateNewMeasureWrapper(String aggregateAttribute, IXQEQueryNode expression, IMeasure measure, CubeWrapper cube, IXQEQueryNode node) {
        Pair v5AggregateSubtype = AggregationUtils.convertAggregateNameToV5AggregateFunctionSubtype(aggregateAttribute, measure.getDataType());
        List<MeasureWrapper> wrappers = cube.getMeasures(measure);
        for (MeasureWrapper mw : wrappers) {
            String mwAggregate = mw.getV5AggregateAttribute();
            IXQEQueryNode mwExpression = mw.getBinaryExpression();
            if (mwAggregate == null && (expression != node || (mwAggregate = mw.getRegularAggregate().toV5Type()) == null)) continue;
            Pair mwV5AggregateSubtype = AggregationUtils.convertAggregateNameToV5AggregateFunctionSubtype(mwAggregate, mw.getDataType());
            if (mwV5AggregateSubtype.getFirst().equals(v5AggregateSubtype.getFirst()) && mwV5AggregateSubtype.getSecond().equals(v5AggregateSubtype.getSecond()) && mwExpression == null && expression == node) {
                return mw;
            }
            if (mwExpression == null || !mwV5AggregateSubtype.getFirst().equals(v5AggregateSubtype.getFirst()) || !mwV5AggregateSubtype.getSecond().equals(v5AggregateSubtype.getSecond()) || !mwExpression.isSameExpression(expression, false)) continue;
            return mw;
        }
        return null;
    }
}

