/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.dmr;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.MDXEdge;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.wrapper.CubeWrapper;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.trace.XQETrace;

public class RemoveEdgeSuppressionWhenNoMeasureForDMR
extends Transformation {
    private static final String APPLY_MESSAGE = "Suppress nulls is false on the edge because the query contains no measures.";

    public RemoveEdgeSuppressionWhenNoMeasureForDMR() {
        this.mName = "Remove Edge Null Suppression (NON_EMPTY) for DMR when there is not measure in the query.";
        this.mPassNumbers = new int[]{50};
        this.mTypes = new int[]{1006};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        MDXEdge mdxEdge = (MDXEdge)node;
        mdxEdge.setMDXNonEmptyProperty(false);
        mdxEdge.setPowerCubeZeroSuppress(false);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        MDXEdge mdxEdge = (MDXEdge)node;
        if (mdxEdge != null && !mdxEdge.getMDXNonEmptyProperty()) {
            this.traceQueryCondition(false, "The edge has null suppression property is already set to false.", trace);
            return false;
        }
        this.traceNodeCondition(true, APPLY_MESSAGE, trace);
        return true;
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        ICube cube = mdxQuery.getMDXFrom().getCube();
        if (!(cube instanceof CubeWrapper)) {
            this.traceNodeCondition(false, "Query is not DMR", trace);
            return false;
        }
        String suppressQueryHint = mdxQuery.getSuppressNullsQueryHint();
        if (suppressQueryHint != null && suppressQueryHint.equalsIgnoreCase("nulls")) {
            this.traceQueryCondition(false, "V5 queryhint specifies null suppression.", trace);
            return false;
        }
        RSAPIDataset dataset = (RSAPIDataset)mdxQuery.getAncestorOfType(401005);
        if (dataset.projectsMeasures()) {
            this.traceNodeCondition(false, "DMR Cube contains non default measures.", trace);
            return false;
        }
        this.traceNodeCondition(true, APPLY_MESSAGE, trace);
        return true;
    }
}

