/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.dmr;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.ast.v5Exp.V5LiteralValue;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.metadata.RoleTypeEnum;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;

public class RemoveRedundantNodes
extends Transformation {
    public RemoveRedundantNodes() {
        this.mName = "Remove redundant nodes from the expression.";
        this.mPassNumbers = new int[]{5};
        this.mTypes = new int[]{201050, 201086, 201098};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        if (node.getType() == 201098) {
            node.detachChild(0);
        }
        node.extract();
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        V5Query query = (V5Query)node.getAncestorOfType(101006);
        if (query == null) {
            this.traceNodeCondition(false, "Expression does not belong to a Query ", trace);
            return false;
        }
        if (!query.isDMRtoRQP()) {
            this.traceNodeCondition(false, "Expression belongs to a  DMR query not manageable by RQP.", trace);
            return false;
        }
        if (node.getType() == 201050) {
            if (node.getAncestorOfType(101008) != null) {
                IXQEQueryNode captionArg = node.getChild(0);
                if (captionArg.getType() == 201116 && ((V5BoundModelIdentifier)captionArg).getMetadata().getObjectType() == MetadataType.QUERY_ITEM) {
                    this.traceNodeCondition(false, "Caption function can be removed.", trace);
                    return true;
                }
                this.traceQueryCondition(true, "Caption can not be removed.", trace);
                return false;
            }
            this.traceQueryCondition(true, "Caption can be removed.", trace);
            return true;
        }
        String roleType = RoleTypeEnum.MEMBER_CAPTION.toV5Keyword();
        if (node.getAncestorOfType(101008) != null) {
            roleType = RoleTypeEnum.BUSINESS_KEY.toV5Keyword();
        }
        if (node.getType() == 201098 && ((V5LiteralValue)node.getChild(0)).getValue().getString().compareTo(roleType) != 0) {
            this.traceNodeCondition(false, "RoleValue function cannot be removed.", trace);
            return false;
        }
        this.traceQueryCondition(true, "Expression should be removed.", trace);
        return true;
    }
}

