/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.dmr;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5Exp.V5BoundDataItemReference;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.dmr.DMRUtilities;

public class ReplaceDIRefWithMUNinSlicerDetailFilter
extends Transformation {
    public ReplaceDIRefWithMUNinSlicerDetailFilter() {
        this.mName = "Solves MUN based data item references in slicer/detail filter.";
        this.mPassNumbers = new int[]{5};
        this.mTypes = new int[]{201060};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        V5DataItem dataItem = ((V5BoundDataItemReference)node).getRefDataItem();
        V5Query query = DMRUtilities.findQuery(node);
        IXQEQueryNode[] dataRefs = query.getDescendantsOfType(201060, true);
        int foundRefs = 0;
        for (int i = 0; i < dataRefs.length; ++i) {
            if (((V5BoundDataItemReference)dataRefs[i]).getRefDataItem() != dataItem) continue;
            ++foundRefs;
        }
        IXQEQueryNode[] member = dataItem.getDescendantsOfType(201117, false);
        if (foundRefs == 1 && member.length == 1) {
            node.exchange(dataItem.getChild(0).getChild(0).detach());
            dataItem.extract();
        } else {
            node.exchange(nodeFactory.deepCopyNode(dataItem.getChild(0).getChild(0)));
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        IXQEQueryNode filter = node.getAncestorOfTypes(new int[]{101008, 101010});
        if (filter == null) {
            this.traceNodeCondition(false, "The MUN is not within a detail filter or slicer.", trace);
            return false;
        }
        V5Query query = DMRUtilities.findQuery(node);
        if (!query.isDMRtoRQP()) {
            this.traceNodeCondition(false, "Query is not a DMR query manageable by RQP.", environment.getTrace());
            return false;
        }
        IXQEQueryNode[] memberF = filter.getDescendantsOfType(201117, false);
        IXQEQueryNode[] memberR = ((V5BoundDataItemReference)node).getRefDataItem().getDescendantsOfType(201117, false);
        if (memberF.length == 0 && memberR.length == 0) {
            this.traceNodeCondition(false, "The filter has no MUN based encodings.", environment.getTrace());
            return false;
        }
        V5DataItem reference = ((V5BoundDataItemReference)node).getRefDataItem();
        if (reference.getChild(0).getType() == 101004 && reference.getChild(0).getNumberChildren() == 1) {
            return true;
        }
        this.traceNodeCondition(false, "The data item reference is not replaced.", trace);
        return false;
    }
}

