/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.dmr;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5.V5InvalidElementException;
import com.cognos.xqe.ast.v5.query.V5DetailFilter;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5Exp.V5BoundMemberUniqueName;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.ast.v5Exp.V5InExpression;
import com.cognos.xqe.ast.v5Exp.V5SetFunction;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.wrapper.HierarchyWrapper;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.dmr.DMRUtilities;
import java.util.List;

public class ReplaceDMRSlicerWithDetailFilter
extends Transformation {
    public ReplaceDMRSlicerWithDetailFilter() {
        this.mName = "ReplaceDMRSlicerWithDetailFilter.";
        this.mPassNumbers = new int[]{7};
        this.mTypes = new int[]{101010};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        V5Query query = (V5Query)node.getAncestorOfType(101006);
        for (IXQEQueryNode child : node.getChildren()) {
            IHierarchy hierarchy = null;
            V5SetFunction setExpr = (V5SetFunction)nodeFactory.createNode(201101);
            V5InExpression inExpr = (V5InExpression)nodeFactory.createNode(201011);
            List<IXQEQueryNode> memberRefs = child.getDescendantsOfCategory(201117, false);
            for (IXQEQueryNode memberRef : memberRefs) {
                if (hierarchy == null) {
                    hierarchy = ((V5BoundMemberUniqueName)memberRef).getHierarchy();
                }
                setExpr.addChild(memberRef.detach());
            }
            if (hierarchy == null) continue;
            V5BoundModelIdentifier hierExpr = (V5BoundModelIdentifier)nodeFactory.createNode(201116);
            hierExpr.setMetadata(hierarchy);
            hierExpr.setIdentifier(hierarchy.getV5UniqueName());
            if (hierarchy instanceof HierarchyWrapper) {
                hierExpr.setPropertyValue("isMetadataWrapped", Boolean.TRUE);
            }
            inExpr.addChild(hierExpr);
            inExpr.addChild(setExpr);
            V5DetailFilter detailFilter = (V5DetailFilter)nodeFactory.createNode(101008);
            detailFilter.setPostAutoAggregation(false);
            detailFilter.setPropertyValue("dmrSlicer", Boolean.TRUE);
            detailFilter.addChild(inExpr);
            query.addChild(detailFilter);
        }
        node.detach();
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        V5Query query = DMRUtilities.findQuery(node);
        if (!query.isDMRtoRQP()) {
            this.traceNodeCondition(false, "Query is not a DMR query manageable by RQP.", environment.getTrace());
            return false;
        }
        for (IXQEQueryNode child : node.getChildren()) {
            IXQEQueryNode[] itemRefs;
            if (child.getType() != 101014) {
                throw new V5InvalidElementException(XQEMessageKeys.V5_InvalidElement, child.getNodeTypeName(), node.getNodeTypeName());
            }
            List<IXQEQueryNode> memberRefs = child.getDescendantsOfCategory(201117, false);
            if (memberRefs.size() == 0) {
                this.traceNodeCondition(false, "The slicer memberset has no data item or MUN.", environment.getTrace());
                return false;
            }
            for (IXQEQueryNode memberRef : memberRefs) {
                if (memberRef.getParent() != child && memberRef.getParent().getType() != 201101 && memberRef.getParent().getType() != 101003) {
                    this.traceNodeCondition(false, "This is not a simple set of members.", environment.getTrace());
                    return false;
                }
                IHierarchy hier = ((V5BoundMemberUniqueName)memberRef).getHierarchy();
                if (!hier.getDimension().isMeasuresDimension()) continue;
                this.traceNodeCondition(false, "There is measure in the slicer.", environment.getTrace());
                return false;
            }
            int[] types = new int[]{101003, 201101};
            for (IXQEQueryNode memberRef : itemRefs = child.getDescendantsOfTypes(types, false)) {
                if (memberRef.getParent() == child || memberRef.getParent().getType() == 201101 || memberRef.getParent().getType() == 101003) continue;
                this.traceNodeCondition(false, "This is a complex slicer memberset.", environment.getTrace());
                return false;
            }
        }
        this.traceNodeCondition(true, "V5Slicer in DMR query will be converted to a V5DetailFilter.", trace);
        return true;
    }
}

