/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.dmr;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.metadata.wrapper.CubeWrapper;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.runtree.ma.member.response.XMAGenerateMemberResponse;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.dmr.DMRUtilities;

public class UpdateMetadataMemberResponseCube
extends Transformation {
    public UpdateMetadataMemberResponseCube() {
        this.mName = "Update the cube of an XMAGenerateMemberResponse node for a DMR query.";
        this.mPassNumbers = new int[]{3};
        this.mTypes = new int[]{501113, 501146, 501145};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        CubeWrapper cubeWrapper = DMRUtilities.findCubeWrapper(node, environment, false);
        ((XMAGenerateMemberResponse)node).setCube(cubeWrapper);
        environment.setTreeHasBeenModified();
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        V5Query query = DMRUtilities.findQuery(node);
        if (query == null) {
            this.traceNodeCondition(false, "XMAGenerateMemberResponse has no query node.", trace);
            return false;
        }
        if (!query.isDMR()) {
            this.traceNodeCondition(false, "Query is not DMR.", trace);
            return false;
        }
        CubeWrapper cubeWrapper = DMRUtilities.findCubeWrapper(node, environment, false);
        if (cubeWrapper == null) {
            this.traceNodeCondition(false, "The query does not have a cube wrapper", trace);
            return false;
        }
        if (cubeWrapper == ((XMAGenerateMemberResponse)node).getCube()) {
            this.traceNodeCondition(false, "Cube wrapper has already been set.", trace);
            return false;
        }
        this.traceNodeCondition(true, "Need to set cube wrapper on XMAGenerateMemberResponse node.", trace);
        return true;
    }
}

