/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.ma;

import com.cognos.mfw4j.framework.MFWGateway;
import com.cognos.mfw4j.framework.MFWModelRes;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.ma.MAMetadataQuery;
import com.cognos.xqe.ma4j.framework.MAGlobalsProcessor;
import com.cognos.xqe.ma4j.framework.MAResolverFullPath;
import com.cognos.xqe.ma4j.framework.MAWorkingLocales;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqeqte.QTEAbstractTransformation;
import org.dom4j.Element;

public final class ReplaceStartatPathWithStartatRef
extends Transformation {
    public ReplaceStartatPathWithStartatRef() {
        this.mName = "Replace the Start_atPath property in MAMetadataQuery with Start_atRef.";
        this.mPassNumbers = new int[]{0};
        this.mTypes = new int[]{1101015};
        this.mApplicableIterations = QTEAbstractTransformation.ApplicableIterations.INITIAL;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        MAMetadataQuery maMetadataQuery = (MAMetadataQuery)node;
        String startAtPath = maMetadataQuery.getStartAtPathValue();
        String startAtRef = null;
        if (maMetadataQuery.isExplicitMemberQuery()) {
            startAtRef = startAtPath;
        } else {
            MetadataConnection metadataConnection = maMetadataQuery.getMetadataConnection();
            MFWGateway mPGW = metadataConnection.getGateway().getGatewayImpl();
            Element connectionElement = ((ExecutionEnvironment)environment.getExecutionEnvironment()).getConnectionElement();
            String runLocale = connectionElement.element("runLocale").attributeValue("value");
            String authoringLocale = (String)maMetadataQuery.getPropertyValue("authoringLocale");
            MAWorkingLocales mWorkingLocales = new MAWorkingLocales();
            mWorkingLocales.setEffectiveLocale(runLocale);
            mWorkingLocales.setAuthoringLocale(authoringLocale);
            MAGlobalsProcessor gp = new MAGlobalsProcessor(mPGW, mWorkingLocales);
            mWorkingLocales.setSupportedLocals(gp.getSupportedLocales());
            MAResolverFullPath resolver = new MAResolverFullPath(mPGW, mWorkingLocales);
            resolver.resolvePath(startAtPath, null);
            if (resolver.getLastRefType() != MFWModelRes.getInstance().RID_queryItemFolder && resolver.getLastRefType() != MFWModelRes.getInstance().RID_folder) {
                startAtRef = resolver.getRefID();
            }
        }
        if (startAtRef != null) {
            maMetadataQuery.setPropertyValue("start_atRef", startAtRef);
            maMetadataQuery.removeProperty("start_atPath");
        }
        maMetadataQuery.removeProperty("start_at");
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        MAMetadataQuery maMetadataQuery = (MAMetadataQuery)node;
        if (maMetadataQuery.getMetadataConnection() == null) {
            this.traceNodeCondition(false, "The maMetadataQuery needs to bind metadataConnection first.", trace);
            return false;
        }
        String startAtPath = maMetadataQuery.getStartAtPathValue();
        String startAtRef = maMetadataQuery.getStartAtRefValue();
        boolean bl = status = maMetadataQuery.isMemberQuery() && startAtRef == null && startAtPath != null;
        if (status) {
            this.traceNodeCondition(status, "The MAMetadataQuery does not have a Start_atRef value. Need to set Start_atRef property using Start_atPath.", trace);
        } else {
            this.traceNodeCondition(status, "The maMetadataQuery is not a member query OR there is a Start_atRef value.", trace);
        }
        return status;
    }
}

