/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.ma.convertMAQuery;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.ma.MAMetadataQuery;
import com.cognos.xqe.ast.maExp.MASimpleNode;
import com.cognos.xqe.metadata.IQueryItem;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.ma.MAMetadataItem;

public abstract class MAMunQueryToV5Query
extends Transformation {
    public MAMunQueryToV5Query() {
        this.mName = "Convert MUN query to V5QuerySet.";
        this.mPassNumbers = new int[]{2};
        this.mTypes = new int[]{1101019};
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!((MASimpleNode)node).isMemberQuery()) {
            this.traceNodeCondition(false, "The metadata query is not a member query.", trace);
            return false;
        }
        MAMetadataQuery maMetadataQuery = this.getMAMetadataQuery(node);
        if (maMetadataQuery == null) {
            this.traceNodeCondition(false, "This is not an MA Query .", trace);
            return false;
        }
        if (null == maMetadataQuery.getMunQuery()) {
            this.traceNodeCondition(false, "The MA Query is not a MUN query.", trace);
            return false;
        }
        MAMetadataItem mdi = maMetadataQuery.getReferencedMetaItem();
        if (mdi != null) {
            if (mdi.getMetadata() instanceof IQueryItem) {
                this.traceNodeCondition(false, "The start_at ref is a query item", trace);
                return false;
            }
        } else {
            this.traceNodeCondition(false, "Not a member query.", trace);
            return false;
        }
        if (maMetadataQuery.getDescendantsOfType(501017, false).length != 0) {
            this.traceNodeCondition(false, "The MDX node has already been generated.", trace);
            return false;
        }
        if (!maMetadataQuery.getDescendantsOfCategory(501113, false).isEmpty()) {
            this.traceNodeCondition(false, "The Query has already been generated.", trace);
            return false;
        }
        this.traceNodeCondition(true, "The MAMetadataQuery is a MUN query.", trace);
        return true;
    }

    protected MAMetadataQuery getMAMetadataQuery(IXQEQueryNode node) {
        return ((MASimpleNode)node).getMAMetadataQuery();
    }

    @Override
    public abstract void apply(IXQEQueryNode var1, PlanningEnvironment var2);
}

