/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.ma.convertMAQuery;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.ma.MAMetadataQuery;
import com.cognos.xqe.ast.maExp.MACollection;
import com.cognos.xqe.ast.maExp.MASimpleNode;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5Expression;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Selection;
import com.cognos.xqe.ast.v5.query.V5Source;
import com.cognos.xqe.ast.v5.result.V5EdgeGroup;
import com.cognos.xqe.ast.v5.result.V5PropertyExpression;
import com.cognos.xqe.ast.v5.result.V5QueryResultDefinition;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.ast.v5Exp.AbstractV5Set;
import com.cognos.xqe.ast.v5Exp.V5HeadFunction;
import com.cognos.xqe.ast.v5Exp.V5LevelsFunction;
import com.cognos.xqe.ast.v5Exp.V5LiteralValue;
import com.cognos.xqe.ast.v5Exp.V5MembersFunction;
import com.cognos.xqe.ast.v5Exp.V5MultiPartIdentifier;
import com.cognos.xqe.ast.v5Exp.V5RoleValueFunction;
import com.cognos.xqe.ast.v5Exp.V5SetFunction;
import com.cognos.xqe.ast.v5Exp.V5UnionFunction;
import com.cognos.xqe.data.types.StringType;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IntegerValue;
import com.cognos.xqe.metadata.ICalculation;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IQueryItem;
import com.cognos.xqe.metadata.RoleTypeEnum;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.runtree.ma.member.response.XMADMRMemberMetadata;
import com.cognos.xqe.runtree.ma.member.response.XMAGenerateMemberResponse;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.ma.MAMetadataItem;
import com.cognos.xqe.transformation.ma.util.MetadataHelper;
import java.util.List;
import java.util.Set;

public abstract class MAQuerytoV5Query
extends Transformation {
    protected static final String QUERY_NAME = "query1";
    protected static final String V5DATAITEM_AGGR_ROLLUP_AGGR = "none";
    protected static final String QRD_NAME = "rs1";
    protected static final String QRD_EDGE_NAME = "edge1";
    public static final int LEVEL_INDEX = 0;
    private static final String VALID_MA_QUERY = "validMAQuery";

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        List<IMember> requestedMembers;
        if (this.applyDMR(node, environment)) {
            return;
        }
        XQENodeFactory factory = environment.getNodeFactory();
        MAMetadataQuery maMetadataQuery = ((MASimpleNode)node).getMAMetadataQuery();
        MACollection memberCollection = this.getMemberCollection(node);
        XMAGenerateMemberResponse xMemberResponse = MetadataHelper.generateMemberResponse(factory, maMetadataQuery);
        String startAtRef = maMetadataQuery.getStartAtRefValue();
        if (startAtRef != null && !startAtRef.startsWith("[")) {
            return;
        }
        if (xMemberResponse.getType() == 501145 && maMetadataQuery.isDMRMultipleExplicitMembersMAQuery() && (requestedMembers = MetadataHelper.getExplicitMembersFromDMRCube(environment, maMetadataQuery, memberCollection)) != null) {
            XMADMRMemberMetadata dmrMemberMetadata = (XMADMRMemberMetadata)factory.createNode(501155);
            dmrMemberMetadata.setRequestedMembers(requestedMembers);
            xMemberResponse.addChild(dmrMemberMetadata);
            return;
        }
        V5QuerySet querySet = (V5QuerySet)factory.createNode(101002);
        xMemberResponse.addChild(querySet);
        V5Query v5Query = (V5Query)factory.createNode(101006);
        querySet.addChild(v5Query);
        this.buildV5Query(node, v5Query, environment, maMetadataQuery, memberCollection);
        Boolean isValidMemberQuery = (Boolean)memberCollection.getPropertyValue(VALID_MA_QUERY);
        if (null != isValidMemberQuery && !isValidMemberQuery.booleanValue()) {
            return;
        }
        V5QueryResultDefinition qrd = this.buildQRD(factory, memberCollection);
        querySet.addChild(qrd);
    }

    protected boolean applyDMR(IXQEQueryNode node, PlanningEnvironment environment) {
        return false;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!((MASimpleNode)node).isMemberQuery()) {
            this.traceNodeCondition(false, "The metadata query is not a member query.", trace);
            return false;
        }
        Boolean valid = (Boolean)this.getMemberCollection(node).getPropertyValue(VALID_MA_QUERY);
        if (null != valid && !valid.booleanValue()) {
            this.traceNodeCondition(false, "The MA query is not a member Query.", trace);
            return false;
        }
        MAMetadataQuery maMetadataQuery = this.getMAMetadataQuery(node);
        if (maMetadataQuery == null) {
            this.traceNodeCondition(false, "This is not an MA Query .", trace);
            return false;
        }
        if (maMetadataQuery.getMunQuery() != null) {
            this.traceNodeCondition(false, "The MA Query is a MUN query.", trace);
            return false;
        }
        if (!maMetadataQuery.getGenerateV5()) {
            this.traceNodeCondition(false, "GenerateV5 is false", trace);
            return false;
        }
        MAMetadataItem mdi = maMetadataQuery.getReferencedMetaItem();
        if (mdi != null) {
            if (mdi.getDatasource() == null) {
                this.traceNodeCondition(false, "The metadata item didn't bind to a valid metadata.", trace);
                return false;
            }
            IMetadata metadata = mdi.getMetadata();
            if (metadata instanceof ICalculation || metadata instanceof IQueryItem) {
                this.traceNodeCondition(false, "The start_at ref is not valid for a member query", trace);
                return false;
            }
            if (metadata instanceof IDimension && !((IDimension)metadata).isMeasuresDimension()) {
                this.traceNodeCondition(false, "Non measure dimension can only have members under hierarchies and levels.", trace);
                return false;
            }
        }
        if (maMetadataQuery.getDescendantsOfType(101002, false).length != 0) {
            this.traceNodeCondition(false, "The V5QuerySet is already generated.", trace);
            return false;
        }
        if (!maMetadataQuery.getDescendantsOfCategory(501113, false).isEmpty()) {
            this.traceNodeCondition(false, "The Query has already been generated.", trace);
            return false;
        }
        this.traceNodeCondition(true, "The MAMetadataQuery is a member query, need to convert to a V5QuerySet.", trace);
        return true;
    }

    protected MAMetadataQuery getMAMetadataQuery(IXQEQueryNode node) {
        return ((MASimpleNode)node).getMAMetadataQuery();
    }

    protected MACollection getMemberCollection(IXQEQueryNode node) {
        if (node.getType() == 1101019) {
            return (MACollection)node;
        }
        return this.getMAMetadataQuery(node).getMemberCollection();
    }

    protected void buildV5Query(IXQEQueryNode node, V5Query v5Query, PlanningEnvironment environment, MAMetadataQuery maMetadataQuery, MACollection memberCollection) {
        XQENodeFactory factory = environment.getNodeFactory();
        v5Query.setPropertyValue("name", QUERY_NAME);
        V5Source source = (V5Source)factory.createNode(101007);
        String modelPath = environment.getMetadataConnection().getModelName();
        source.setModel(modelPath);
        V5Selection selection = (V5Selection)factory.createNode(101009);
        v5Query.addChild(source);
        v5Query.addChild(selection);
        v5Query.setStringPropertyValue(V5Query.QueryHint.QUERY_INTENT.getPropertyName(), "metadata");
        this.addDataItems(node, selection, factory, maMetadataQuery, memberCollection);
    }

    protected void addRootMemberToV5Query(V5Query v5Query, IXQENodeFactory factory, MAMetadataQuery maMetadataQuery) {
        V5Expression expression = (V5Expression)v5Query.getFirstDescendantOfTypeOrdered(101004, false);
        V5Expression rootMember = (V5Expression)factory.createNode(101004);
        rootMember.setExpression(maMetadataQuery.getStartAtRefValue());
        V5SetFunction v5ParentSet = (V5SetFunction)factory.createNode(201101);
        v5ParentSet.addChild(rootMember);
        AbstractV5Set child = (AbstractV5Set)expression.getChild(0);
        V5UnionFunction v5UnionNode = (V5UnionFunction)factory.createNode(201111);
        expression.exchangeChildNode(child, v5UnionNode);
        v5UnionNode.addChild(v5ParentSet);
        v5UnionNode.addChild(child);
    }

    protected boolean buildV5Expression(IXQEQueryNode node, V5Expression v5Expression, IXQENodeFactory factory, MAMetadataQuery maMetadataQuery, MACollection memberCollection) {
        String sizeValue;
        String refItem = maMetadataQuery.getStartAtRefValue();
        if (refItem == null) {
            return false;
        }
        AbstractV5Set setExpr = this.buildFilterOrOtherSetExpr(node, refItem, factory, maMetadataQuery);
        if (setExpr == null) {
            IXQEQueryNode xMemberResponse = memberCollection.getChild(0);
            xMemberResponse.detachChild(0);
            memberCollection.setPropertyValue(VALID_MA_QUERY, Boolean.FALSE);
            return false;
        }
        int from = 0;
        int size = Integer.MAX_VALUE;
        String fromValue = (String)maMetadataQuery.getPropertyValue("ResultStart");
        if (fromValue != null) {
            from = Integer.valueOf(fromValue);
        }
        if ((sizeValue = (String)maMetadataQuery.getPropertyValue("ResultCount")) != null && Integer.valueOf(sizeValue) != 0) {
            size = Integer.valueOf(sizeValue);
        }
        V5LiteralValue intVal = (V5LiteralValue)factory.createNode(201026);
        IntegerValue val = DataValueFactory.createIntegerValue(size - from);
        intVal.setDataType(val.getDataType());
        intVal.setValue(val.toString());
        V5HeadFunction headFunc = (V5HeadFunction)factory.createNode(201071);
        headFunc.addChild(setExpr);
        headFunc.addChild(intVal);
        v5Expression.addChild(headFunc);
        return true;
    }

    protected V5QueryResultDefinition buildQRD(IXQENodeFactory factory, MACollection memberCollection) {
        V5QueryResultDefinition qrd = (V5QueryResultDefinition)factory.createNode(101055);
        IXQEQueryNode edge = factory.createNode(101049);
        qrd.addChild(edge);
        V5EdgeGroup edgeGroup = (V5EdgeGroup)factory.createNode(101050);
        this.buildEdgeGroup(edgeGroup, factory, memberCollection);
        edge.addChild(edgeGroup);
        edge.setPropertyValue("name", QRD_EDGE_NAME);
        qrd.setPropertyValue("name", QRD_NAME);
        qrd.setRefQueryProperty(QUERY_NAME);
        return qrd;
    }

    public static void setV5QRDValueSetProperties(IXQEQueryNode valueSet, MACollection memberCollection, IXQENodeFactory factory) {
        V5PropertyExpression propExpr = null;
        V5RoleValueFunction roleValueFn = null;
        V5LiteralValue strVal = null;
        Set<String> collectionProperties = memberCollection.getRequiredProperties();
        for (String key : collectionProperties) {
            RoleTypeEnum rollType = RoleTypeEnum.fromV5("_" + key);
            switch (rollType) {
                case MEMBER_UNIQUE_NAME: 
                case LEVEL_UNIQUE_NAME: 
                case PARENT_UNIQUE_NAME: 
                case HIERARCHY_UNIQUE_NAME: 
                case DIMENSION_UNIQUE_NAME: 
                case MEMBER_CAPTION: 
                case LEVEL_NUMBER: 
                case BUSINESS_KEY: {
                    propExpr = (V5PropertyExpression)factory.createNode(101054);
                    roleValueFn = (V5RoleValueFunction)factory.createNode(201098);
                    strVal = (V5LiteralValue)factory.createNode(201026);
                    strVal.setDataType(StringType.DEFAULTSTRINGTYPE);
                    strVal.setValue(rollType.toV5Keyword());
                    roleValueFn.addChild(strVal);
                    propExpr.addChild(roleValueFn);
                    valueSet.addChild(propExpr);
                    break;
                }
            }
        }
    }

    protected abstract AbstractV5Set buildFilterOrOtherSetExpr(IXQEQueryNode var1, String var2, IXQENodeFactory var3, MAMetadataQuery var4);

    protected V5MembersFunction buildV5MemberFunction(String refItem, boolean withLevelFunction, IXQENodeFactory factory) {
        V5MembersFunction v5Members = (V5MembersFunction)factory.createNode(201086);
        V5MultiPartIdentifier identifier = (V5MultiPartIdentifier)factory.createNode(201030);
        identifier.setIdentifier(refItem);
        if (withLevelFunction) {
            V5LevelsFunction v5Levels = (V5LevelsFunction)factory.createNode(201083);
            v5Levels.addChild(identifier);
            V5LiteralValue index = (V5LiteralValue)factory.createNode(201026);
            IntegerValue intIndex = DataValueFactory.createIntegerValue(0);
            index.setDataType(intIndex.getDataType());
            index.setValue(intIndex.toString());
            v5Levels.addChild(index);
            v5Members.addChild(v5Levels);
        } else {
            v5Members.addChild(identifier);
        }
        return v5Members;
    }

    protected void addDataItems(IXQEQueryNode node, V5Selection selection, IXQENodeFactory factory, MAMetadataQuery maMetadataQuery, MACollection memberCollection) {
        V5DataItem dataItem = (V5DataItem)factory.createNode(101003);
        dataItem.setAggregateProperty(V5DATAITEM_AGGR_ROLLUP_AGGR);
        dataItem.setNameProperty("member");
        dataItem.setRollupAggregateProperty(V5DATAITEM_AGGR_ROLLUP_AGGR);
        V5Expression v5Expression = (V5Expression)factory.createNode(101004);
        dataItem.addChild(v5Expression);
        selection.addChild(dataItem);
        this.buildV5Expression(node, v5Expression, factory, maMetadataQuery, memberCollection);
    }

    protected void buildEdgeGroup(V5EdgeGroup edgeGroup, IXQENodeFactory factory, MACollection memberCollection) {
        V5ValueSet valueSet = (V5ValueSet)factory.createNode(101057);
        edgeGroup.addChild(valueSet);
        valueSet.setNameProperty("member");
        valueSet.setRefDataItemProperty("member");
        MAQuerytoV5Query.setV5QRDValueSetProperties(valueSet, memberCollection, factory);
    }
}

