/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.ma.provider;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.ma.MAMetadataQuery;
import com.cognos.xqe.ast.maExp.MACollection;
import com.cognos.xqe.ast.maExp.MASimpleNode;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.ma.MAMetadataItem;
import com.cognos.xqe.transformation.ma.provider.MemberTransformation;

public abstract class BindMAIdentifier
extends MemberTransformation {
    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        XQETrace trace = environment.getTrace();
        if (!((MASimpleNode)node).isMemberQuery()) {
            this.traceNodeCondition(false, "The MACollection is not a member MACollection.", trace);
            return false;
        }
        MAMetadataQuery maMetadataQuery = ((MASimpleNode)node).getMAMetadataQuery();
        MACollection memberCollection = this.getMAMemberCollection(node, maMetadataQuery);
        if (null != memberCollection.getPropertyValue("dimensionUniqueName")) {
            this.traceNodeCondition(false, "Binding is already done.", trace);
            return false;
        }
        if (maMetadataQuery.isSAPVariableMAQuery()) {
            this.traceNodeCondition(false, "The MAMetadataQuery is SAP variable query.", trace);
            return false;
        }
        return true;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        MAMetadataQuery maMetadataQuery = ((MASimpleNode)node).getMAMetadataQuery();
        MAMetadataItem metaDataItem = maMetadataQuery.getReferencedMetaItem();
        MACollection memberCollection = this.getMAMemberCollection(node, maMetadataQuery);
        String queryDataSourceType = this.getMADatasourceType(environment);
        IHierarchy hierarchy = metaDataItem.getHierarchy();
        if (hierarchy != null) {
            String hun = hierarchy.getUniqueName();
            String dun = hierarchy.getDimension().getUniqueName();
            memberCollection.setPropertyValue("hierarchyUniqueName", hun);
            memberCollection.setPropertyValue("dimensionUniqueName", dun);
        }
        this.setLevelAndMember(maMetadataQuery, environment);
        if (queryDataSourceType.equals("BW")) {
            metaDataItem.setKeyDate(environment);
        }
    }

    abstract void setLevelAndMember(MAMetadataQuery var1, PlanningEnvironment var2);
}

