/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.ma.provider;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.ma.MAMetadataQuery;
import com.cognos.xqe.ast.maExp.MACollection;
import com.cognos.xqe.ast.maExp.MASimpleNode;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.providers.olap.MetadataRestriction;
import com.cognos.xqe.data.providers.olap.RestrictionType;
import com.cognos.xqe.data.values.DateValue;
import com.cognos.xqe.metadata.IAlias;
import com.cognos.xqe.metadata.IAliasEntry;
import com.cognos.xqe.metadata.ICalculation;
import com.cognos.xqe.metadata.IModelDataSource;
import com.cognos.xqe.metadata.IQueryItem;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.ma.MAMetadataItem;
import com.cognos.xqe.transformation.ma.provider.MemberTransformation;
import com.cognos.xqe.transformation.ma.util.MetadataHelper;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class SetRestrictionsForMAQuery
extends MemberTransformation {
    public static final String METADATQUERY_NULL = "Metadata query cannot be null";

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        MAMetadataQuery maMetadataQuery = ((MASimpleNode)node).getMAMetadataQuery();
        MACollection memberCollection = this.getMAMemberCollection(node, maMetadataQuery);
        if (memberCollection == null) {
            memberCollection = node.getType() == 1101019 ? (MACollection)node : maMetadataQuery.getMemberCollection();
        }
        if (null == memberCollection || !memberCollection.isMemberQuery()) {
            this.traceNodeCondition(false, "The MACollection is not a member MACollection.", trace);
            return false;
        }
        if (!maMetadataQuery.isSAPVariableMAQuery() && null == memberCollection.getPropertyValue("dimensionUniqueName")) {
            this.traceQueryCondition(false, "Binding is not done yet.", trace);
            return false;
        }
        if (maMetadataQuery.getMunQuery() != null && maMetadataQuery.getMunQuery().equals("logical")) {
            this.traceNodeCondition(false, "The MAMetadataQuery requires MDX.", trace);
            return false;
        }
        MAMetadataItem metaItem = maMetadataQuery.getReferencedMetaItem();
        if (metaItem.isMeasuresDimension()) {
            this.traceNodeCondition(false, "Not a member query.", trace);
            return false;
        }
        if (metaItem.getMetadata() instanceof ICalculation || metaItem.getMetadata() instanceof IQueryItem) {
            this.traceNodeCondition(false, "The start_at ref is not valid for a member query", trace);
            return false;
        }
        if (!memberCollection.getDescendantsOfCategory(501113, false).isEmpty()) {
            this.traceNodeCondition(false, "The run tree is already generated.", trace);
            return false;
        }
        this.traceNodeCondition(true, "The MAMetadataQuery is a member query. Need to generate XMAMemberMetadata.", trace);
        return true;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        MetadataRestriction maRestriction = new MetadataRestriction();
        this.buildRestriction(node, environment, maRestriction);
        MetadataHelper.addMemberResponse(node, environment, maRestriction);
    }

    public void buildRestriction(IXQEQueryNode node, PlanningEnvironment environment, MetadataRestriction restriction) {
        String sizeValue;
        MAMetadataItem maItem;
        String keyDate;
        List<IAliasEntry> aliasentries;
        IAlias alias;
        ExecutionEnvironment execEnv;
        IDataSource dataSource;
        Map<String, Object> metadataProperties;
        Set projectLocales;
        MAMetadataQuery maMetadataQuery = ((MASimpleNode)node).getMAMetadataQuery();
        if (maMetadataQuery == null) {
            node.throwInternalError(METADATQUERY_NULL);
        }
        IModelDataSource modelDataSource = environment.getMADataSource();
        restriction.add(RestrictionType.CUBE, modelDataSource.getCube().getUniqueName());
        if (modelDataSource.getCatalog() != null) {
            restriction.add(RestrictionType.CATALOG, modelDataSource.getCatalog().getUniqueName());
        }
        if ((projectLocales = (Set)(metadataProperties = (dataSource = (execEnv = (ExecutionEnvironment)environment.getExecutionEnvironment()).getDataSourceByModelName(modelDataSource.getName())).getMetadataProperties()).get("project_locales")) != null && !projectLocales.isEmpty()) {
            ArrayList locales = new ArrayList(projectLocales);
            restriction.add(RestrictionType.PROJECT_LOCALES, locales);
        }
        if ((alias = modelDataSource.getAlias()) != null && !(aliasentries = alias.getAliasEntries()).isEmpty()) {
            LinkedHashMap<String, String> aliasTable = new LinkedHashMap<String, String>();
            for (IAliasEntry aliasEntry : aliasentries) {
                String key = aliasEntry.getKey();
                String value = aliasEntry.getValue();
                if (aliasTable.containsKey(key)) {
                    value = (String)aliasTable.get(key) + ";" + value;
                }
                aliasTable.put(key, value);
            }
            restriction.add(RestrictionType.ALIASES, aliasTable);
        }
        if ((keyDate = (maItem = maMetadataQuery.getReferencedMetaItem()).getKeyDate()) != null) {
            DateValue validTo;
            restriction.add(RestrictionType.KEY_DATE, keyDate);
            DateValue validFrom = maItem.getValidFromDate();
            if (validFrom != null) {
                restriction.add(RestrictionType.VALID_FROM, validFrom);
            }
            if ((validTo = maItem.getValidTo()) != null) {
                restriction.add(RestrictionType.VALID_TO, validTo);
            }
        }
        int from = 0;
        int size = Integer.MAX_VALUE;
        String fromValue = (String)maMetadataQuery.getPropertyValue("ResultStart");
        if (fromValue != null) {
            from = Integer.valueOf(fromValue);
        }
        if ((sizeValue = (String)maMetadataQuery.getPropertyValue("ResultCount")) != null && Integer.valueOf(sizeValue) != 0) {
            size = Integer.valueOf(sizeValue);
        }
        restriction.add(RestrictionType.FROM, from);
        restriction.add(RestrictionType.SIZE, size);
        int depth = 0;
        String depthValue = (String)maMetadataQuery.getPropertyValue("Depth");
        if (depthValue != null && !depthValue.isEmpty() && Integer.valueOf(depthValue) != 0) {
            depth = Integer.valueOf(depthValue);
            restriction.add(RestrictionType.SCOPE, depth);
        }
    }
}

