/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.ma.provider;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.ma.MAMetadataQuery;
import com.cognos.xqe.ast.ma.MARequestedPropertiesEnum;
import com.cognos.xqe.ast.maExp.MABlockConstraint;
import com.cognos.xqe.ast.maExp.MACollection;
import com.cognos.xqe.ast.maExp.MAConstraint;
import com.cognos.xqe.ast.maExp.MASimpleNode;
import com.cognos.xqe.data.providers.DataSourceTypeEnum;
import com.cognos.xqe.data.providers.olap.MetadataRestriction;
import com.cognos.xqe.data.providers.olap.RestrictionType;
import com.cognos.xqe.metadata.TreeOperatorEnum;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.ma.MAMetadataItem;
import com.cognos.xqe.transformation.ma.provider.MASearchCriteria;
import com.cognos.xqe.transformation.ma.provider.SetRestrictionsForMAQuery;
import com.cognos.xqe.transformation.ma.util.MetadataHelper;
import java.util.ArrayList;
import java.util.EnumSet;

public class SetRestrictionsForMemberSearch
extends SetRestrictionsForMAQuery {
    public static final String SINGLE_QUOTE = "'";

    public SetRestrictionsForMemberSearch() {
        this.mName = "Set constrains for sap or essbase search.";
        this.mPassNumbers = new int[]{2};
        this.mTypes = new int[]{1101017, 1101021};
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        if (!super.passesNodeCondition(node, environment)) {
            return false;
        }
        XQETrace trace = environment.getTrace();
        if (node.getParent().getType() == 1101017) {
            this.traceNodeCondition(false, "The MAConstraint is a child of a MABlockConstraint. In such case, this tranformation should apply to root MABlockConstraint.", trace);
            return false;
        }
        MAMetadataQuery maMetadataQuery = ((MASimpleNode)node).getMAMetadataQuery();
        if (maMetadataQuery.isMemberSearchMAQuery()) {
            this.traceNodeCondition(true, "The MAConstraint is SAP variable constraint. Other transfromation should apply.", trace);
            return true;
        }
        this.traceNodeCondition(false, "The Constraint is NOT SAP variable query.", trace);
        return false;
    }

    @Override
    public void buildRestriction(IXQEQueryNode node, PlanningEnvironment environment, MetadataRestriction restriction) {
        super.buildRestriction(node, environment, restriction);
        String queryDataSourceType = this.getMADatasourceType(environment);
        if (!DataSourceTypeEnum.isTM(queryDataSourceType)) {
            restriction.replace(RestrictionType.SIZE, Integer.MAX_VALUE);
        }
        MAMetadataQuery maMetadataQuery = ((MASimpleNode)node).getMAMetadataQuery();
        MACollection memberCollection = this.getMAMemberCollection(node, maMetadataQuery);
        MetadataHelper.setRestrictionValues(memberCollection, restriction);
        String memberUniqueName = (String)memberCollection.getPropertyValue("memberUniqueName");
        if (null != memberUniqueName) {
            MAMetadataItem metatItem = maMetadataQuery.getReferencedMetaItem();
            if (metatItem.searchWithDescendants(maMetadataQuery)) {
                restriction.add(RestrictionType.TREEOP, EnumSet.of(TreeOperatorEnum.SELF, TreeOperatorEnum.DESCENDANTS));
            } else {
                restriction.add(RestrictionType.TREEOP, EnumSet.of(TreeOperatorEnum.SELF, TreeOperatorEnum.CHILDREN));
            }
        }
        this.buildSearchCriteria((MASimpleNode)node, restriction);
    }

    private boolean buildSearchCriteria(MASimpleNode constraint, MetadataRestriction restriction) {
        MARequestedPropertiesEnum property = MARequestedPropertiesEnum.CAPTION;
        MABlockConstraint.Operation operation = null;
        MAConstraint.Function condition = null;
        ArrayList<String> values = null;
        IXQEQueryNode[] maConstraints = null;
        boolean isCaseInsensitive = false;
        if (constraint.getType() == 1101017) {
            operation = ((MABlockConstraint)constraint).getOperation();
            maConstraints = constraint.getChildrenOfType(1101021);
            condition = ((MAConstraint)maConstraints[0]).getFunction();
            isCaseInsensitive = ((MAConstraint)maConstraints[0]).getCaseSensitive() == false;
            values = new ArrayList(maConstraints.length);
            for (IXQEQueryNode child : maConstraints) {
                MAConstraint childConstraint = (MAConstraint)child;
                values.add(childConstraint.getOperand(MAConstraint.Operand.RIGHT_OPERAND));
            }
        } else {
            condition = ((MAConstraint)constraint).getFunction();
            isCaseInsensitive = ((MAConstraint)constraint).getCaseSensitive() == false;
            values = new ArrayList<String>(1);
            values.add(((MAConstraint)constraint).getOperand(MAConstraint.Operand.RIGHT_OPERAND));
        }
        MASearchCriteria searchCriteria = new MASearchCriteria(property, condition, values, operation, isCaseInsensitive);
        restriction.add(RestrictionType.MEMBERSEARCH, searchCriteria);
        return true;
    }
}

