/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.mdx;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.mdx.parser.MDXQueryNode;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.runtree.olap.mdx.XMdxNode;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.util.pool.XQEIntegerPoolForNodeType;
import java.util.HashMap;
import java.util.Iterator;

public class GenerateXMdxLocalRuntree
extends Transformation {
    private static final HashMap<Integer, Integer> AST_TO_RUNTREE_MAP = new HashMap();

    public GenerateXMdxLocalRuntree() {
        this.mName = "Generates a runtree for the MDX AST.";
        this.mPassNumbers = new int[]{1};
        this.generateNodeTypes();
    }

    private void generateNodeTypes() {
        this.mTypes = new int[AST_TO_RUNTREE_MAP.size()];
        Iterator<Integer> it = AST_TO_RUNTREE_MAP.keySet().iterator();
        int i = 0;
        while (it.hasNext()) {
            this.mTypes[i] = it.next();
            ++i;
        }
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        int nodeType = AST_TO_RUNTREE_MAP.get(XQEIntegerPoolForNodeType.getInteger(node.getType()));
        XMdxNode xNode = (XMdxNode)nodeFactory.createNode(nodeType);
        xNode.setParserNode((MDXQueryNode)node);
        node.getParent().exchangeChildNode(node, xNode, true);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        this.traceQueryCondition(true, "GenerateXMdxLocalRuntreeNode applied", trace);
        return true;
    }

    static {
        AST_TO_RUNTREE_MAP.put(701010, 501054);
        AST_TO_RUNTREE_MAP.put(701011, 501055);
        AST_TO_RUNTREE_MAP.put(701012, 501056);
        AST_TO_RUNTREE_MAP.put(701013, 501057);
        AST_TO_RUNTREE_MAP.put(701020, 501058);
        AST_TO_RUNTREE_MAP.put(701029, 501059);
        AST_TO_RUNTREE_MAP.put(701030, 501060);
        AST_TO_RUNTREE_MAP.put(701031, 501061);
        AST_TO_RUNTREE_MAP.put(701032, 501062);
        AST_TO_RUNTREE_MAP.put(701034, 501063);
        AST_TO_RUNTREE_MAP.put(701035, 501064);
        AST_TO_RUNTREE_MAP.put(701043, 501067);
        AST_TO_RUNTREE_MAP.put(701046, 501068);
        AST_TO_RUNTREE_MAP.put(701049, 501070);
        AST_TO_RUNTREE_MAP.put(701050, 501071);
        AST_TO_RUNTREE_MAP.put(701053, 501072);
        AST_TO_RUNTREE_MAP.put(701054, 501073);
        AST_TO_RUNTREE_MAP.put(701055, 501074);
        AST_TO_RUNTREE_MAP.put(701056, 501075);
        AST_TO_RUNTREE_MAP.put(701057, 501076);
        AST_TO_RUNTREE_MAP.put(701060, 501077);
        AST_TO_RUNTREE_MAP.put(701033, 501087);
        AST_TO_RUNTREE_MAP.put(701021, 501089);
        AST_TO_RUNTREE_MAP.put(701052, 501090);
        AST_TO_RUNTREE_MAP.put(701044, 501091);
        AST_TO_RUNTREE_MAP.put(701022, 501122);
        AST_TO_RUNTREE_MAP.put(701026, 501123);
        AST_TO_RUNTREE_MAP.put(701027, 501124);
        AST_TO_RUNTREE_MAP.put(701028, 501125);
        AST_TO_RUNTREE_MAP.put(701040, 501126);
        AST_TO_RUNTREE_MAP.put(701041, 501127);
        AST_TO_RUNTREE_MAP.put(701061, 501166);
    }
}

