/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.mdx.dmr;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.MDXFromCube;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.bibushandler.datasource.ProviderCapabilites;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.wrapper.CubeWrapper;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.v5.tabstream.DMRSetFunctionToExplicitSetUtil;
import com.cognos.xqe.trace.XQETrace;

public final class ReplaceSetFunctionWithExplicitMemberSet
extends Transformation {
    public ReplaceSetFunctionWithExplicitMemberSet() {
        this.mName = "Replace Relative Set / member Function with Explicit Member Set / Explicit Member.";
        this.mPassNumbers = new int[]{0};
        this.mTypes = new int[]{1002};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        DMRSetFunctionToExplicitSetUtil.replaceSetFunctionWithMemberSet(node, environment);
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        MDXFromCube fromCube;
        ICube cube;
        MDXQuery mdxQuery;
        String reqType = ((RequestEnvironment)environment.getRequestEnvironment()).getOperationName();
        if ("execute".equals(reqType) && (mdxQuery = (MDXQuery)node) != null && mdxQuery.isDMR() && !mdxQuery.isDMRCubeReuseEnabled() && !"ExtractMembersFromV5SetFunction".equals(mdxQuery.getV5NameProperty()) && (cube = (fromCube = mdxQuery.getMDXFrom()).getCube()) instanceof CubeWrapper) {
            CubeWrapper modelCube = (CubeWrapper)cube;
            IDataSourceCapabilities providerCapabilities = ProviderCapabilites.getInstance().getOrAddProviderCapabilities("DMR");
            if (providerCapabilities.getBooleanValue("expandRelativeFunctionCubeNotReuse", false) && !modelCube.isDesignMode() && modelCube.getTabStreamWrapper() == null && modelCube.getTabularResultSetName() == null) {
                this.traceQueryCondition(true, "The V5 Set function is a descendant of a MDXQuery for DMR", environment.getTrace());
                return true;
            }
        }
        this.traceQueryCondition(false, "The V5 Set function is not a descendant of a MDXQuery for DMR", environment.getTrace());
        return false;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        MDXQuery mdxQuery = (MDXQuery)node;
        if (DMRSetFunctionToExplicitSetUtil.canApply(mdxQuery)) {
            this.traceNodeCondition(true, "The V5 Set function can be replaced by member set.", trace);
            return true;
        }
        this.traceNodeCondition(false, "The V5 Set function can not be replaced by member set.", trace);
        return false;
    }
}

