/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.moser;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.ast.olap.util.MDXLevelInfo;
import com.cognos.xqe.ast.rqp.RQPDataItem;
import com.cognos.xqe.ast.rqp.RQPFactManager;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5Selection;
import com.cognos.xqe.ast.v5.query.V5Source;
import com.cognos.xqe.ast.v5.result.V5DataItemRef;
import com.cognos.xqe.ast.v5.result.V5EdgeGroup;
import com.cognos.xqe.ast.v5.result.V5QueryResultDefinition;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.ast.v5Exp.V5SimpleNode;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.data.json.JSONUtil;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IAccessedViaShortcut;
import com.cognos.xqe.metadata.ICalculation;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMeasure;
import com.cognos.xqe.metadata.IMeasureDimension;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.INamedSet;
import com.cognos.xqe.metadata.IProperty;
import com.cognos.xqe.metadata.IQuerySubject;
import com.cognos.xqe.metadata.IRelationship;
import com.cognos.xqe.metadata.IScopeRelationship;
import com.cognos.xqe.metadata.IShortcut;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.metadata.MetadataUtil;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.metadata.provider.MetadataService;
import com.cognos.xqe.metrics.MetricsService;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.planner.QueryPlanner;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.OperationEnum;
import com.cognos.xqe.transformation.moser.GenerateModuleMetadataForPackage;
import com.cognos.xqe.transformation.moser.MoserCommandUtil;
import com.cognos.xqe.transformation.moser.util.JoinGraphCache;
import com.cognos.xqe.transformation.olap.XQEOlapUnsupportedQueryException;
import com.cognos.xqe.transformation.v5.RefineAutomaticXtab;
import com.cognos.xqe.transformation.v5.binding.BindV5MemberUniqueName;
import com.cognos.xqe.transformation.v5.binding.ExpandRolapNamedSetMultiPartIdentifier;
import com.cognos.xqe.transformation.v5tocogsql.RQPQueryFormulation.UnwindV5BoundMultipartIdentifier;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.InitializeFactManager;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.ProcessDataItemRefInValueSet;
import com.cognos.xqe.transformation.v5tocogsql.V5QueryToRQPQuery.ReplaceQRDWithRQPQuery;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import com.cognos.xqe.transformation.v5tocogsql.util.undirectedgraph.GraphEdge;
import com.cognos.xqe.transformation.v5tocogsql.util.undirectedgraph.UndirectedGraph;
import com.cognos.xqe.util.ArrayWrapper;
import com.cognos.xqe.util.Governors;
import com.cognos.xqe.util.LoopDetectionChain;
import com.cognos.xqe.util.Pair;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqe.util.UniqueNameParser;
import com.cognos.xqemoser.ModuleIdPair;
import com.cognos.xqemoser.MoserCalculation;
import com.cognos.xqemoser.MoserEmbeddedModuleWrapper;
import com.cognos.xqemoser.MoserItemNormalization;
import com.cognos.xqemoser.MoserItemNormalizationGroup;
import com.cognos.xqemoser.MoserMetadataConnection;
import com.cognos.xqemoser.MoserModule;
import com.cognos.xqemoser.MoserQueryItem;
import com.cognos.xqemoser.MoserQuerySubject;
import com.cognos.xqemoser.MoserRelationship;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.json.java.OrderedJSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public final class GenerateJoinGraph {
    public static final String QUERY_NAME = "joingraphQuery";
    public static final String MOSER_CMD_NAME = "joingraph";
    public static final String REF_DI = "refDI";
    private static final String STR_N = "N";
    private static final String STR_ONE = "1";
    private static final String STR_COL = ":";
    private static final String STR_DOT = ".";
    private static final String STR_MAIN = "DATAMODULE";
    private static final String STR_DASH = "-";
    private static final String MEASURE_PREFIX = "[MEASURES]";
    private static final String DMR_MEASURE_PREFIX = "[MEASURES_";
    private static final String CLOSE_BK = "]";
    private static final String STR_CARD = "cardinality";
    private static final String STR_QUERYITEM = "queryitem";
    private static final String STR_GROUP = "group";
    private static final String STR_CONNECTOR = "connector";
    private static final int LIMIT = 10;
    private static final int LARGE_FM_ENTITY = 100;

    private GenerateJoinGraph() {
    }

    public static void generateV5QuerySet(PlanningEnvironment environment, Element functionSpec) {
        String module = null;
        String moduleType = null;
        boolean prettyPrint = false;
        boolean forceExplicit = false;
        List children = functionSpec.elements();
        int size = children.size();
        for (int i = 0; i < size; ++i) {
            String booleanValue;
            Element child = (Element)children.get(i);
            Pair keyValue = MoserCommandUtil.getNameAndValueMap(child);
            if (keyValue == null) continue;
            if ("module".equals(keyValue.getFirst())) {
                module = (String)keyValue.getSecond();
                continue;
            }
            if ("type".equals(keyValue.getFirst())) {
                moduleType = (String)keyValue.getSecond();
                continue;
            }
            if ("jsonPrettyPrint".equals(keyValue.getFirst())) {
                booleanValue = (String)keyValue.getSecond();
                prettyPrint = Boolean.valueOf(booleanValue);
                continue;
            }
            if (!"explicit".equals(keyValue.getFirst())) continue;
            booleanValue = (String)keyValue.getSecond();
            forceExplicit = Boolean.valueOf(booleanValue);
        }
        if (module == null || moduleType == null) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Missing parameter module or module type in API joingraph ");
        }
        List<String> exprs = null;
        GenerateJoinGraph.logStartMetadataConnection(module);
        boolean isModule = true;
        if ("package".equals(moduleType)) {
            isModule = false;
        }
        RequestEnvironment requestEnv = (RequestEnvironment)environment.getRequestEnvironment();
        ExecutionEnvironment execEnv = (ExecutionEnvironment)requestEnv.getExecutionEnvironment();
        MetadataConnection metadataConnection = environment.getMetadataConnection();
        if (metadataConnection == null) {
            MetricsService.startCollectingMetric(requestEnv, "mfwRequest");
            if (isModule) {
                metadataConnection = MetadataService.getInstance().getConnection("MOSER", module, execEnv, true);
            } else {
                boolean metadataRequest = true;
                boolean forceMetadataRefresh = true;
                boolean forceCMTrusted = false;
                boolean[] connectionOptions = MetadataService.getConnectionOptions(forceCMTrusted, forceMetadataRefresh, metadataRequest);
                metadataConnection = MetadataService.getInstance().getConnection("MFW4J", module, execEnv, true, connectionOptions);
            }
            MetricsService.endCollectingMetric(requestEnv, "mfwRequest");
        }
        GenerateJoinGraph.logEndMetadataConnection(module);
        GenerateJoinGraph.getJoinGraphMetdataConnection(environment, metadataConnection, module, exprs, prettyPrint, true, forceExplicit);
    }

    public static String getJoinGraphMetdataConnection(PlanningEnvironment environment, MetadataConnection metadataConnection, String module, List<String> exprs, boolean prettyPrint, boolean bThrow) {
        return GenerateJoinGraph.getJoinGraphMetdataConnection(environment, metadataConnection, module, exprs, prettyPrint, bThrow, false);
    }

    protected static V5QuerySet createV5QuerySet(XQENodeFactory factory, PlanningEnvironment environment, String module) {
        V5QuerySet querySet = (V5QuerySet)factory.createNode(101002);
        Governors gc = new Governors();
        gc.setCrossProdAllowed(Governors.GovernorPermission.ALLOW.toString());
        gc.setAutoSort(Governors.AutoSort.NONE.toString());
        querySet.setPropertyValue("governors", gc);
        querySet.setPropertyValue("modelPath", module);
        environment.getNodeIndex().addNode(querySet);
        environment.setRoot(querySet);
        return querySet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String getJoinGraphMetdataConnection(PlanningEnvironment environment, MetadataConnection metadataConnection, String module, List<String> exprs, boolean prettyPrint, boolean bThrow, boolean bForceExplicit) {
        MetadataConnection metadataConnection2 = metadataConnection;
        synchronized (metadataConnection2) {
            Pair p;
            GenerateJoinGraph.logStartJoinGraph(module);
            String cachedJoinGraph = metadataConnection.getJoinGraph();
            if (cachedJoinGraph != null) {
                GenerateJoinGraph.logEndJoinGraph(module);
                return GenerateJoinGraph.returnCachedJoinGraph(cachedJoinGraph, bThrow);
            }
            environment.setMetdataConnection(metadataConnection);
            Locale moduleExpressionLocale = null;
            boolean isModule = metadataConnection instanceof MoserMetadataConnection;
            moduleExpressionLocale = isModule ? ((MoserMetadataConnection)metadataConnection).getModuleExpressionLocale() : metadataConnection.getExpressionLocale();
            RequestEnvironment requestEnv = (RequestEnvironment)environment.getRequestEnvironment();
            if (moduleExpressionLocale != null) {
                requestEnv.setExpressionLocale(moduleExpressionLocale);
            }
            XQENodeFactory factory = environment.getNodeFactory();
            V5QuerySet querySet = GenerateJoinGraph.createV5QuerySet(factory, environment, module);
            if (!isModule) {
                String preloadJoinGraph;
                InfoClass info = new InfoClass();
                info.mc = metadataConnection;
                info.aliasForLog = "FM";
                info.bPrettyPrint = prettyPrint;
                Map<MetadataConnection, Pair> explictMetadataByMC = GenerateJoinGraph.collectExplicitMetadataObject(metadataConnection, exprs, module, bForceExplicit);
                if (explictMetadataByMC != null) {
                    info.bNeedExplicit = true;
                    Pair p2 = explictMetadataByMC.get(metadataConnection);
                    if (p2 != null) {
                        info.explicitRelObj = (Map)p2.getFirst();
                        info.explicitOLAPObj = (Map)p2.getSecond();
                    }
                }
                if (bThrow) {
                    info.bOlap = true;
                }
                if ((preloadJoinGraph = JoinGraphCache.getInstance().getCacheJoinGraphIfExists(requestEnv, info.mc)) != null) {
                    GenerateJoinGraph.logUsePreloadJoinGraph(info.mc.getModelName());
                    GenerateJoinGraph.logEndJoinGraph(module);
                    if (bThrow) {
                        throw new XQERuntimeException(XQEMessageKeys.PLN_StopJoinGraph, preloadJoinGraph);
                    }
                    return preloadJoinGraph;
                }
                if (!GenerateJoinGraph.addQueryItemsFromPackage(metadataConnection, querySet, factory, info)) {
                    GenerateJoinGraph.logEndJoinGraph(module);
                    return GenerateJoinGraph.returnEmptyResponse(bThrow);
                }
                JSONObject jJoinGraph = GenerateJoinGraph.generateJoinGraph(environment, info);
                GenerateJoinGraph.logEndJoinGraph(module);
                return GenerateJoinGraph.stopJoinGraph(prettyPrint, jJoinGraph, metadataConnection, bThrow, explictMetadataByMC == null);
            }
            MoserMetadataConnection mc = (MoserMetadataConnection)metadataConnection;
            Map<String, Pair> packages = mc.getPackages();
            if (packages.size() == 1 && mc.usedInEmbeddedModule((HashMap)(p = packages.values().iterator().next()).getSecond())) {
                Map standAloneCalc;
                MetadataConnection fmMc;
                InfoClass info = new InfoClass();
                if (bThrow) {
                    info.bOlap = true;
                }
                info.bPrettyPrint = prettyPrint;
                info.mc = fmMc = (MetadataConnection)p.getFirst();
                info.aliasForLog = "embed on FM";
                Map explicitStandaloneCalc = null;
                Map<MetadataConnection, Pair> explictMetadataByMC = GenerateJoinGraph.collectExplicitMetadataObject(metadataConnection, exprs, module, bForceExplicit);
                if (explictMetadataByMC != null) {
                    info.bNeedExplicit = true;
                    Pair ppp = explictMetadataByMC.get(metadataConnection);
                    if (ppp != null) {
                        explicitStandaloneCalc = (Map)ppp.getFirst();
                    }
                    if ((ppp = explictMetadataByMC.get(fmMc)) != null) {
                        info.explicitRelObj = (Map)ppp.getFirst();
                        info.explicitOLAPObj = (Map)ppp.getSecond();
                    }
                }
                if ((standAloneCalc = explicitStandaloneCalc) == null) {
                    standAloneCalc = GenerateJoinGraph.getStandAloneCalc(mc);
                }
                if (standAloneCalc == null || standAloneCalc.isEmpty()) {
                    String preloadJoinGraph = JoinGraphCache.getInstance().getCacheJoinGraphIfExists(requestEnv, info.mc);
                    if (preloadJoinGraph != null) {
                        GenerateJoinGraph.logUsePreloadJoinGraph(info.mc.getModelName());
                        GenerateJoinGraph.logEndJoinGraph(module);
                        if (bThrow) {
                            throw new XQERuntimeException(XQEMessageKeys.PLN_StopJoinGraph, preloadJoinGraph);
                        }
                        return preloadJoinGraph;
                    }
                    String mcCacheJoinGraph = info.mc.getJoinGraph();
                    if (mcCacheJoinGraph != null) {
                        GenerateJoinGraph.logEndJoinGraph(module);
                        if (bThrow) {
                            throw new XQERuntimeException(XQEMessageKeys.PLN_StopJoinGraph, mcCacheJoinGraph);
                        }
                        return mcCacheJoinGraph;
                    }
                } else {
                    info.bHasStandAloneCalcs = true;
                }
                boolean bUsePreload = GenerateJoinGraph.usePreloadJoinGraph(info, false, requestEnv);
                boolean bUseCache = false;
                if (!bUsePreload) {
                    bUseCache = GenerateJoinGraph.useCachedJoinGraph(info, false);
                }
                if (!(bUsePreload || bUseCache || GenerateJoinGraph.addQueryItemsFromPackage(fmMc, querySet, factory, info) || explicitStandaloneCalc != null)) {
                    GenerateJoinGraph.logEndJoinGraph(module);
                    return GenerateJoinGraph.returnEmptyResponse(bThrow);
                }
                if (standAloneCalc != null && !standAloneCalc.isEmpty()) {
                    GenerateJoinGraph.appendStandAloneCalculation(mc, querySet, factory, info, standAloneCalc);
                }
                JSONObject jJoinGraph = GenerateJoinGraph.generateJoinGraph(environment, info);
                if (!bUsePreload && !bUseCache) {
                    GenerateJoinGraph.cacheJoinGraph(jJoinGraph, info, false);
                }
                GenerateJoinGraph.logEndJoinGraph(module);
                return GenerateJoinGraph.stopJoinGraph(prettyPrint, jJoinGraph, metadataConnection, bThrow, false);
            }
            if (packages.isEmpty()) {
                InfoClass info = new InfoClass();
                info.mc = mc;
                info.aliasForLog = "module";
                info.bPrettyPrint = prettyPrint;
                if (mc.getModule() instanceof MoserEmbeddedModuleWrapper) {
                    MoserEmbeddedModuleWrapper wrapper = (MoserEmbeddedModuleWrapper)mc.getModule();
                    MoserMetadataConnection srcMC = wrapper.getSourceMetadataConnection();
                    info.bEmbeddedModuleOnly = true;
                    String strJoinGraphSrc = GenerateJoinGraph.getJoinGraphMetdataConnection(environment, srcMC, srcMC.getModelPath(), null, prettyPrint, false, false);
                    GenerateJoinGraph.useJoinGraph(info, false, strJoinGraphSrc);
                }
                if (!GenerateJoinGraph.addQueryItemsFromDataModule(mc, querySet, factory, info)) {
                    GenerateJoinGraph.logEndJoinGraph(module);
                    if (!info.bEmbeddedModuleOnly) {
                        return GenerateJoinGraph.returnEmptyResponse(bThrow);
                    }
                    GenerateJoinGraph.stopJoinGraph(prettyPrint, info.jJoinGraph, metadataConnection, bThrow, true);
                }
                JSONObject jJoinGraph = GenerateJoinGraph.generateJoinGraph(environment, info);
                GenerateJoinGraph.logEndJoinGraph(module);
                return GenerateJoinGraph.stopJoinGraph(prettyPrint, jJoinGraph, metadataConnection, bThrow, true);
            }
            return GenerateJoinGraph.getJoinGraphDataModulePackageComplete(environment, mc, querySet, factory, packages, bThrow, module, prettyPrint);
        }
    }

    protected static String getJoinGraphDataModulePackageComplete(PlanningEnvironment environment, MoserMetadataConnection mc, V5QuerySet querySet, XQENodeFactory factory, Map<String, Pair> packages, boolean bThrow, String module, boolean prettyPrint) {
        TreeMap<String, InfoClass> mp = new TreeMap<String, InfoClass>();
        InfoClass infoMain = new InfoClass();
        infoMain.mc = mc;
        infoMain.prefix = STR_MAIN;
        infoMain.aliasForLog = "module on FM";
        infoMain.bPrettyPrint = prettyPrint;
        boolean b = GenerateJoinGraph.addQueryItemsFromDataModule(mc, querySet, factory, infoMain);
        if (b) {
            infoMain.mcToAlias = new HashMap<MetadataConnection, String>();
            for (Map.Entry<String, Pair> entry : packages.entrySet()) {
                infoMain.mcToAlias.put((MetadataConnection)entry.getValue().getFirst(), entry.getKey());
            }
            JSONObject jJoinGraph = GenerateJoinGraph.generateJoinGraph(environment, infoMain);
            mp.put(STR_MAIN, infoMain);
        }
        RequestEnvironment requestEnv = (RequestEnvironment)environment.getRequestEnvironment();
        for (Map.Entry<String, Pair> entry : packages.entrySet()) {
            MetadataConnection fmMc = (MetadataConnection)entry.getValue().getFirst();
            InfoClass info = new InfoClass();
            info.mc = fmMc;
            info.prefix = entry.getKey();
            info.aliasForLog = "FM:" + info.prefix;
            info.bPrettyPrint = prettyPrint;
            if (bThrow) {
                info.bOlap = true;
            }
            boolean bPreLoad = GenerateJoinGraph.usePreloadJoinGraph(info, true, requestEnv);
            boolean bUseCache = false;
            if (!bPreLoad) {
                bUseCache = GenerateJoinGraph.useCachedJoinGraph(info, true);
            }
            if (bPreLoad || bUseCache || GenerateJoinGraph.addQueryItemsFromPackage(fmMc, querySet, factory, info)) {
                b = true;
            }
            JSONObject jJoinGraph = GenerateJoinGraph.generateJoinGraph(environment, info);
            if (!bPreLoad && !bUseCache) {
                GenerateJoinGraph.cacheJoinGraph(jJoinGraph, info, true);
            }
            mp.put(entry.getKey(), info);
        }
        if (!b) {
            GenerateJoinGraph.logEndJoinGraph(module);
            return GenerateJoinGraph.returnEmptyResponse(bThrow);
        }
        JSONObject jSONObject = GenerateJoinGraph.combineJoinGraph(environment, mp);
        GenerateJoinGraph.logEndJoinGraph(module);
        return GenerateJoinGraph.stopJoinGraph(prettyPrint, jSONObject, mc, bThrow, false);
    }

    protected static boolean addExplictMetadata(String id, IMetadata md, Map<MetadataConnection, Pair> rt, boolean bRel) {
        IMetadata r;
        Map<String, IMetadata> mp;
        MetadataConnection mc = md.getConnection();
        Pair p = rt.get(mc);
        if (p == null) {
            p = new Pair();
            rt.put(mc, p);
        }
        if (bRel) {
            mp = (TreeMap<String, IMetadata>)p.getFirst();
            if (mp == null) {
                mp = new TreeMap<String, IMetadata>();
                p.setFirst(mp);
            }
        } else {
            mp = (Map)p.getSecond();
            if (mp == null) {
                mp = new TreeMap();
                p.setSecond(mp);
            }
        }
        return (r = mp.put(id, md)) == null;
    }

    protected static Map<MetadataConnection, Pair> collectExplicitMetadataObject(MetadataConnection mc, List<String> explicit, String nm, boolean bforceExplicit) {
        if (explicit == null || explicit.isEmpty()) {
            return null;
        }
        if (!bforceExplicit) {
            int nEntities = mc.getEntities().size();
            if (nEntities <= 100) {
                return null;
            }
            if ((double)explicit.size() >= (double)(nEntities * 2 * 10) * 0.7) {
                return null;
            }
        }
        GenerateJoinGraph.logStartCollectExplicitMetadata(nm);
        HashMap<MetadataConnection, Pair> rt = new HashMap<MetadataConnection, Pair>();
        int n = 0;
        block5: for (String id : explicit) {
            IMetadata md = mc.bindMetadataReference(id);
            if (md instanceof IProperty) {
                if (!GenerateJoinGraph.addExplictMetadata(id, md, rt, false)) continue;
                ++n;
                continue;
            }
            MetadataType objType = md.getObjectType();
            switch (objType) {
                case CALCULATION: {
                    if (!"namedSet".equals(((ICalculation)md).getCalcType())) {
                        if (!GenerateJoinGraph.addExplictMetadata(id, md, rt, true)) continue block5;
                        ++n;
                        continue block5;
                    }
                    if (!GenerateJoinGraph.addExplictMetadata(id, md, rt, false)) continue block5;
                    ++n;
                    continue block5;
                }
                case NAMED_SET: 
                case HIERARCHY: 
                case LEVEL: 
                case MEASURE: 
                case MEMBER: {
                    if (!GenerateJoinGraph.addExplictMetadata(id, md, rt, false)) continue block5;
                    ++n;
                    continue block5;
                }
                case QUERY_ITEM: {
                    if (!GenerateJoinGraph.addExplictMetadata(id, md, rt, true)) continue block5;
                    ++n;
                    continue block5;
                }
            }
            throw new XQEOlapUnsupportedQueryException(XQEMessageKeys.PLN_TemporarilyUnsupportedFeature, id);
        }
        GenerateJoinGraph.logEndCollectExplicitMetadata(n);
        return rt;
    }

    protected static void cacheJoinGraph(JSONObject jJoinGraph, InfoClass info, boolean bTrimPrefix) {
        if (jJoinGraph == null || info.mc.getJoinGraph() != null || info.bNeedExplicit) {
            return;
        }
        if (!bTrimPrefix) {
            GenerateJoinGraph.trimStandAloneCalucationAndCache(jJoinGraph, info);
        } else {
            GenerateJoinGraph.trimPrefixAndCache(jJoinGraph, info);
        }
    }

    protected static void trimStandAloneCalucationAndCache(JSONObject jJoinGraph, InfoClass info) {
        JSONArray jQueryItems;
        JSONArray jGroups;
        if (info.standaloneCalcs == null || info.standaloneCalcs.isEmpty()) {
            info.mc.setJoinGraph(jJoinGraph.toString());
            return;
        }
        JSONObject r = new JSONObject();
        JSONArray jConnectors = (JSONArray)jJoinGraph.get((Object)STR_CONNECTOR);
        if (jConnectors != null) {
            r.put((Object)STR_CONNECTOR, (Object)jConnectors);
        }
        if ((jGroups = (JSONArray)jJoinGraph.get((Object)STR_GROUP)) != null) {
            r.put((Object)STR_GROUP, (Object)jGroups);
        }
        if ((jQueryItems = (JSONArray)jJoinGraph.get((Object)STR_QUERYITEM)) != null) {
            JSONArray jNewQueryItems = new JSONArray();
            for (Object o : jQueryItems) {
                JSONObject jObj = (JSONObject)o;
                HashSet keys = new HashSet(jObj.keySet());
                keys.retainAll(info.standaloneCalcs);
                if (!keys.isEmpty()) continue;
                jNewQueryItems.add((Object)jObj);
            }
            if (!jNewQueryItems.isEmpty()) {
                r.put((Object)STR_QUERYITEM, (Object)jNewQueryItems);
            }
        }
        info.mc.setJoinGraph(r.toString());
    }

    protected static JSONArray trimArrayValue(JSONArray a, int n) {
        JSONArray r = new JSONArray();
        for (Object o : a) {
            String v = (String)o;
            v = v.substring(n);
            r.add((Object)v);
        }
        return r;
    }

    protected static void trimPrefixAndCache(JSONObject jJoinGraph, InfoClass info) {
        JSONArray jQueryItems;
        JSONArray jGroups;
        JSONObject newJG = new JSONObject();
        int nPrefix = info.prefix.length() + 1;
        JSONArray jConnectors = (JSONArray)jJoinGraph.get((Object)STR_CONNECTOR);
        if (jConnectors != null) {
            JSONArray newConnectors = new JSONArray();
            newJG.put((Object)STR_CONNECTOR, (Object)newConnectors);
            for (Object o : jConnectors) {
                JSONObject jO = (JSONObject)o;
                JSONObject newObj = new JSONObject();
                newConnectors.add((Object)newObj);
                for (Object keyO : jO.keySet()) {
                    String key = (String)keyO;
                    String v = (String)jO.get((Object)key);
                    if (!key.equals(STR_CARD)) {
                        v = v.substring(nPrefix);
                    }
                    newObj.put((Object)key, (Object)v);
                }
            }
        }
        if ((jGroups = (JSONArray)jJoinGraph.get((Object)STR_GROUP)) != null) {
            JSONArray newGroups = GenerateJoinGraph.trimArrayValue(jGroups, nPrefix);
            newJG.put((Object)STR_GROUP, (Object)newGroups);
        }
        if ((jQueryItems = (JSONArray)jJoinGraph.get((Object)STR_QUERYITEM)) != null) {
            JSONArray jNewQueryItems = new JSONArray();
            for (Object o : jQueryItems) {
                JSONObject jO = (JSONObject)o;
                JSONObject newObj = new JSONObject();
                jNewQueryItems.add((Object)newObj);
                for (Object keyO : jO.keySet()) {
                    String key = (String)keyO;
                    JSONArray v = (JSONArray)jO.get((Object)key);
                    key = key.substring(nPrefix);
                    JSONArray newV = GenerateJoinGraph.trimArrayValue(v, nPrefix);
                    newObj.put((Object)key, (Object)newV);
                }
            }
            if (!jNewQueryItems.isEmpty()) {
                newJG.put((Object)STR_QUERYITEM, (Object)jNewQueryItems);
            }
        }
        info.mc.setJoinGraph(newJG.toString());
    }

    protected static JSONArray appendArrayValue(JSONArray a, String prefix) {
        JSONArray r = new JSONArray();
        for (Object o : a) {
            String v = (String)o;
            v = prefix + v;
            r.add((Object)v);
        }
        return r;
    }

    protected static JSONObject apendPrefix(JSONObject jJoinGraph, String prefix) {
        JSONArray jQueryItems;
        JSONArray jGroups;
        JSONObject newJG = new JSONObject();
        JSONArray jConnectors = (JSONArray)jJoinGraph.get((Object)STR_CONNECTOR);
        if (jConnectors != null) {
            JSONArray newConnectors = new JSONArray();
            newJG.put((Object)STR_CONNECTOR, (Object)newConnectors);
            for (Object o : jConnectors) {
                JSONObject jO = (JSONObject)o;
                JSONObject newObj = new JSONObject();
                newConnectors.add((Object)newObj);
                for (Object keyO : jO.keySet()) {
                    String key = (String)keyO;
                    String v = (String)jO.get((Object)key);
                    if (!key.equals(STR_CARD)) {
                        v = prefix + v;
                    }
                    newObj.put((Object)key, (Object)v);
                }
            }
        }
        if ((jGroups = (JSONArray)jJoinGraph.get((Object)STR_GROUP)) != null) {
            JSONArray newGroups = GenerateJoinGraph.appendArrayValue(jGroups, prefix);
            newJG.put((Object)STR_GROUP, (Object)newGroups);
        }
        if ((jQueryItems = (JSONArray)jJoinGraph.get((Object)STR_QUERYITEM)) != null) {
            JSONArray jNewQueryItems = new JSONArray();
            for (Object o : jQueryItems) {
                JSONObject jO = (JSONObject)o;
                JSONObject newObj = new JSONObject();
                jNewQueryItems.add((Object)newObj);
                for (Object keyO : jO.keySet()) {
                    String key = (String)keyO;
                    JSONArray v = (JSONArray)jO.get((Object)key);
                    key = prefix + key;
                    JSONArray newV = GenerateJoinGraph.appendArrayValue(v, prefix);
                    newObj.put((Object)key, (Object)newV);
                }
            }
            if (!jNewQueryItems.isEmpty()) {
                newJG.put((Object)STR_QUERYITEM, (Object)jNewQueryItems);
            }
        }
        return newJG;
    }

    protected static boolean useCachedJoinGraph(InfoClass info, boolean bAppendPrefix) {
        String sJoinGraph = info.mc.getJoinGraph();
        return GenerateJoinGraph.useJoinGraph(info, bAppendPrefix, sJoinGraph);
    }

    protected static boolean useJoinGraph(InfoClass info, boolean bAppendPrefix, String sJoinGraph) {
        if (sJoinGraph == null) {
            return false;
        }
        if (info.bNeedExplicit && info.getSizeOfExplicit() == 0) {
            return false;
        }
        try {
            info.jJoinGraph = OrderedJSONObject.parse((String)sJoinGraph);
            if (bAppendPrefix) {
                info.jJoinGraph = GenerateJoinGraph.apendPrefix(info.jJoinGraph, info.prefix + STR_DOT);
            }
        }
        catch (Exception e) {
            info.mc.setJoinGraph(null);
            return false;
        }
        return true;
    }

    protected static boolean usePreloadJoinGraph(InfoClass info, boolean bAppendPrefix, RequestEnvironment requestEnv) {
        String cacheJoinGraph = JoinGraphCache.getInstance().getCacheJoinGraphIfExists(requestEnv, info.mc);
        if (cacheJoinGraph == null) {
            return false;
        }
        try {
            info.jJoinGraph = OrderedJSONObject.parse((String)cacheJoinGraph);
            if (bAppendPrefix) {
                info.jJoinGraph = GenerateJoinGraph.apendPrefix(info.jJoinGraph, info.prefix + STR_DOT);
            }
        }
        catch (Exception e) {
            return false;
        }
        GenerateJoinGraph.logUsePreloadJoinGraph(info.mc.getModelName());
        return true;
    }

    private static String returnCachedJoinGraph(String cachedJoinGraph, boolean bThrow) {
        if (bThrow) {
            throw new XQERuntimeException(XQEMessageKeys.PLN_StopJoinGraph, cachedJoinGraph);
        }
        return cachedJoinGraph;
    }

    protected static String stopJoinGraph(boolean prettyPrint, JSONObject jJoinGraph, MetadataConnection metadataConnection, boolean bThrow, boolean cache) {
        String r = jJoinGraph.toString();
        if (prettyPrint) {
            r = JSONUtil.prettyPrint(r);
        }
        if (cache) {
            metadataConnection.setJoinGraph(r);
        }
        if (bThrow) {
            throw new XQERuntimeException(XQEMessageKeys.PLN_StopJoinGraph, r);
        }
        return r;
    }

    protected static void logStartMetadataConnection(String moduleName) {
        if (MoserCommandUtil.INFO_LOGGER.isOn()) {
            MoserCommandUtil.INFO_LOGGER.log(LogLevel.INFO, OperationEnum.START, "start MetadataConnection for join graph: " + moduleName);
        }
    }

    protected static void logEndMetadataConnection(String moduleName) {
        if (MoserCommandUtil.INFO_LOGGER.isOn()) {
            MoserCommandUtil.INFO_LOGGER.log(LogLevel.INFO, OperationEnum.END, "end MetadataConnection for join graph: " + moduleName);
        }
    }

    protected static void logStartJoinGraph(String moduleName) {
        if (MoserCommandUtil.INFO_LOGGER.isOn()) {
            MoserCommandUtil.INFO_LOGGER.log(LogLevel.INFO, OperationEnum.START, "start join graph: " + moduleName);
        }
    }

    protected static void logEndJoinGraph(String moduleName) {
        if (MoserCommandUtil.INFO_LOGGER.isOn()) {
            MoserCommandUtil.INFO_LOGGER.log(LogLevel.INFO, OperationEnum.END, "end join graph: " + moduleName);
        }
    }

    protected static void logStartV5Query(String nm) {
        if (MoserCommandUtil.INFO_LOGGER.isOn()) {
            MoserCommandUtil.INFO_LOGGER.log(LogLevel.INFO, OperationEnum.START, "start V5Query for join graph: " + nm);
        }
    }

    protected static void logEndV5Query(int sz) {
        if (MoserCommandUtil.INFO_LOGGER.isOn()) {
            MoserCommandUtil.INFO_LOGGER.log(LogLevel.INFO, OperationEnum.END, "end V5Query for join graph with " + sz + " queryitems");
        }
    }

    protected static void logStartCollectObjects(String nm) {
        if (MoserCommandUtil.INFO_LOGGER.isOn()) {
            MoserCommandUtil.INFO_LOGGER.log(LogLevel.INFO, OperationEnum.START, "start collect first level metadata for join graph: " + nm);
        }
    }

    protected static void logEndCollectObjects(int sz) {
        if (MoserCommandUtil.INFO_LOGGER.isOn()) {
            MoserCommandUtil.INFO_LOGGER.log(LogLevel.INFO, OperationEnum.END, "end collect first level metadata for join graph with " + sz + " objects");
        }
    }

    protected static void logStartDimensions(String nm) {
        if (MoserCommandUtil.INFO_LOGGER.isOn()) {
            MoserCommandUtil.INFO_LOGGER.log(LogLevel.INFO, OperationEnum.START, "start Dimensions for join graph: " + nm);
        }
    }

    protected static void logEndDimensions(int sz) {
        if (MoserCommandUtil.INFO_LOGGER.isOn()) {
            MoserCommandUtil.INFO_LOGGER.log(LogLevel.INFO, OperationEnum.END, "end Dimensions for join graph with " + sz + " dimensions");
        }
    }

    protected static void logStartRelational(String nm) {
        if (MoserCommandUtil.INFO_LOGGER.isOn()) {
            MoserCommandUtil.INFO_LOGGER.log(LogLevel.INFO, OperationEnum.START, "start relationship for join graph: " + nm);
        }
    }

    protected static void logEndRelational(int sz) {
        if (MoserCommandUtil.INFO_LOGGER.isOn()) {
            MoserCommandUtil.INFO_LOGGER.log(LogLevel.INFO, OperationEnum.END, "end relationship for join graph with " + sz + " relationships");
        }
    }

    protected static void logStartMeasures(String nm) {
        if (MoserCommandUtil.INFO_LOGGER.isOn()) {
            MoserCommandUtil.INFO_LOGGER.log(LogLevel.INFO, OperationEnum.START, "start Measures for join graph: " + nm);
        }
    }

    protected static void logEndMeasures(int sz) {
        if (MoserCommandUtil.INFO_LOGGER.isOn()) {
            MoserCommandUtil.INFO_LOGGER.log(LogLevel.INFO, OperationEnum.END, "end Measures for join graph with " + sz + " measures");
        }
    }

    protected static void logStartCollectExplicitMetadata(String nm) {
        if (MoserCommandUtil.INFO_LOGGER.isOn()) {
            MoserCommandUtil.INFO_LOGGER.log(LogLevel.INFO, OperationEnum.START, "start collect explicit metadata for join graph: " + nm);
        }
    }

    protected static void logEndCollectExplicitMetadata(int sz) {
        if (MoserCommandUtil.INFO_LOGGER.isOn()) {
            MoserCommandUtil.INFO_LOGGER.log(LogLevel.INFO, OperationEnum.END, "end collect explicit metadata for join graph with " + sz + " objects");
        }
    }

    protected static void logUsePreloadJoinGraph(String nm) {
        if (MoserCommandUtil.INFO_LOGGER.isOn()) {
            MoserCommandUtil.INFO_LOGGER.log(LogLevel.INFO, "use preload join graph: " + nm);
        }
    }

    protected static void logStartPreloading(String nm) {
        if (MoserCommandUtil.INFO_LOGGER.isOn()) {
            MoserCommandUtil.INFO_LOGGER.log(LogLevel.INFO, OperationEnum.START, "start preload join graph: " + nm);
        }
    }

    protected static void logEndPreloading(String nm, boolean b) {
        if (MoserCommandUtil.INFO_LOGGER.isOn()) {
            MoserCommandUtil.INFO_LOGGER.log(LogLevel.INFO, OperationEnum.END, "end preload join graph: " + nm + " status: " + b);
        }
    }

    protected static String generateQueryName(String suffix) {
        String qName = QUERY_NAME;
        if (suffix != null) {
            qName = qName + STR_DASH + suffix;
        }
        return qName;
    }

    protected static String generateQRDName(String suffix) {
        String qrdName = "QRD";
        if (suffix != null) {
            qrdName = qrdName + STR_DASH + suffix;
        }
        return qrdName;
    }

    protected static void removeQueryAndQRD(InfoClass info) {
        if (info.v5Query != null) {
            info.v5Query.detach();
            info.v5Query = null;
        }
        if (info.v5QRD != null) {
            info.v5QRD.detach();
            info.v5QRD = null;
        }
    }

    protected static void createV5QueryAndQRD(MetadataConnection metadataConnection, V5QuerySet querySet, XQENodeFactory factory, InfoClass info) {
        V5Query v5Query;
        info.v5Query = v5Query = (V5Query)factory.createNode(101006);
        querySet.addChild(v5Query);
        String qName = GenerateJoinGraph.generateQueryName(info.prefix);
        v5Query.setPropertyValue("name", qName);
        v5Query.setPropertyValue(V5Query.QueryHint.DASHBOARD.getPropertyName(), "true");
        v5Query.setPropertyValue("queryForTestJoin", true);
        v5Query.setPropertyValue("isTabular", Boolean.TRUE);
        v5Query.setPropertyValue("isRelStyle", Boolean.TRUE);
        V5Source source = (V5Source)factory.createNode(101007);
        source.setModel(metadataConnection.getModelPath());
        String moduleType = metadataConnection.getModelType();
        if (moduleType != null) {
            source.setModelType(moduleType);
        }
        v5Query.addChild(source);
        source.setIsBound();
        info.v5Select = (V5Selection)factory.createNode(101009);
        info.v5Select.setPropertyValue("autoSummary", false);
        v5Query.addChild(info.v5Select);
        info.v5QRD = (V5QueryResultDefinition)factory.createNode(101055);
        querySet.addChild(info.v5QRD);
        String qrdName = GenerateJoinGraph.generateQRDName(info.prefix);
        info.v5QRD.setPropertyValue("name", qrdName);
        info.v5QRD.setRefQueryProperty(qName);
        IXQEQueryNode edge = factory.createNode(101049);
        info.v5QRD.addChild(edge);
        edge.setPropertyValue("name", "Edge1");
        V5EdgeGroup edgeGroup = (V5EdgeGroup)factory.createNode(101050);
        edge.addChild(edgeGroup);
        V5ValueSet valueSet = (V5ValueSet)factory.createNode(101057);
        edgeGroup.addChild(valueSet);
        valueSet.setNameProperty("valueSet1");
        info.v5GroupBody = factory.createNode(101051);
        valueSet.addChild(info.v5GroupBody);
        info.v5GroupBody.setPropertyValue("name", "groupBody1");
    }

    protected static Map<String, IMetadata> getStandAloneCalc(MoserMetadataConnection mc) {
        MoserModule topModule = mc.getModule();
        List<MoserCalculation> calcs = topModule.getCalculations();
        if (calcs.isEmpty()) {
            return null;
        }
        TreeMap<String, IMetadata> rt = new TreeMap<String, IMetadata>();
        HashSet seenCalcs = new HashSet();
        for (MoserCalculation c : calcs) {
            if (c.isHidden() || seenCalcs.contains(c)) continue;
            String id = c.getName();
            rt.put(id, c);
        }
        return rt;
    }

    protected static void appendStandAloneCalculation(MoserMetadataConnection mc, V5QuerySet querySet, XQENodeFactory factory, InfoClass info, Map<String, IMetadata> calcs) {
        JSONArray jGroups;
        info.standaloneCalcs = new HashSet<String>();
        if (info.v5Select == null) {
            GenerateJoinGraph.createV5QueryAndQRD(mc, querySet, factory, info);
        }
        int nQI = info.v5Select.getChildrenOfType(101003).length + 1;
        for (Map.Entry<String, IMetadata> entry : calcs.entrySet()) {
            String id = entry.getKey();
            if (!GenerateJoinGraph.addADataItem(id, entry.getValue(), info.v5Select, info.v5GroupBody, factory)) continue;
            ++nQI;
            info.standaloneCalcs.add(id);
        }
        if (!info.standaloneCalcs.isEmpty() && info.jJoinGraph != null && (jGroups = (JSONArray)info.jJoinGraph.get((Object)STR_GROUP)) != null && !jGroups.isEmpty()) {
            info.seenGroups = new HashSet<String>();
            for (Object o : jGroups) {
                String g = (String)o;
                info.seenGroups.add(g);
            }
        }
    }

    protected static boolean addQueryItemsFromDataModule(MoserMetadataConnection mc, V5QuerySet querySet, XQENodeFactory factory, InfoClass info) {
        GenerateJoinGraph.logStartV5Query(STR_MAIN);
        GenerateJoinGraph.createV5QueryAndQRD(mc, querySet, factory, info);
        HashSet<MoserCalculation> seenCalcs = new HashSet<MoserCalculation>();
        int nQI = 0;
        MoserModule topModule = mc.getModule();
        int sz = topModule.getUniqueName().length() + 1;
        List<MoserQuerySubject> qss = topModule.getQuerySubjects();
        for (MoserQuerySubject qs : qss) {
            String id;
            if (qs.isHidden()) continue;
            List<IMetadata> qis = null;
            qis = info.bEmbeddedModuleOnly ? qs.getQueryItemsAndMeasures() : qs.getQueryItemsAndMeasuresThis();
            for (IMetadata qi : qis) {
                MoserQueryItem moserQI = (MoserQueryItem)qi;
                if (moserQI.isHidden() || info.bEmbeddedModuleOnly && !moserQI.inEmbeddedModule()) continue;
                id = null;
                if (!info.bEmbeddedModuleOnly) {
                    id = moserQI.getUniqueID();
                    id = id.substring(sz);
                } else {
                    id = qs.getName() + STR_DOT + qi.getName();
                }
                if (!GenerateJoinGraph.addADataItem(id, moserQI, info.v5Select, info.v5GroupBody, factory)) continue;
                ++nQI;
            }
            if (info.bEmbeddedModuleOnly) continue;
            List<MoserCalculation> calcs = qs.getCalculations();
            for (MoserCalculation c : calcs) {
                if (c.isHidden() || seenCalcs.contains(c)) continue;
                id = c.getUniqueID();
                if (!GenerateJoinGraph.addADataItem(id = id.substring(sz), c, info.v5Select, info.v5GroupBody, factory)) continue;
                ++nQI;
                seenCalcs.add(c);
            }
        }
        List<MoserCalculation> calcs = topModule.getCalculations();
        for (MoserCalculation c : calcs) {
            if (c.isHidden() || seenCalcs.contains(c)) continue;
            String id = c.getName();
            if (info.bEmbeddedModuleOnly && c.getParentObject() instanceof MoserQuerySubject) {
                id = c.getParentObject().getName() + STR_DOT + c.getName();
            }
            if (!GenerateJoinGraph.addADataItem(id, c, info.v5Select, info.v5GroupBody, factory)) continue;
            ++nQI;
            seenCalcs.add(c);
        }
        if (nQI == 0) {
            GenerateJoinGraph.removeQueryAndQRD(info);
        }
        GenerateJoinGraph.logEndV5Query(nQI);
        return nQI != 0;
    }

    protected static boolean addQueryItemsFromPackage(MetadataConnection metadataConnection, V5QuerySet querySet, XQENodeFactory factory, InfoClass info) {
        GenerateJoinGraph.logStartV5Query(info.aliasForLog);
        GenerateJoinGraph.createV5QueryAndQRD(metadataConnection, querySet, factory, info);
        if (!info.bNeedExplicit) {
            return GenerateJoinGraph.addAllObjectsToV5(metadataConnection, factory, info);
        }
        return GenerateJoinGraph.addExplicitObjectsToV5(factory, info);
    }

    protected static boolean addExplicitObjectsToV5(XQENodeFactory factory, InfoClass info) {
        int nQI = 0;
        if (info.explicitRelObj != null) {
            for (Map.Entry<String, IMetadata> entry : info.explicitRelObj.entrySet()) {
                if (!GenerateJoinGraph.addADataItem(entry.getKey(), entry.getValue(), info.v5Select, info.v5GroupBody, factory)) continue;
                ++nQI;
            }
        }
        if (nQI == 0) {
            GenerateJoinGraph.removeQueryAndQRD(info);
        }
        GenerateJoinGraph.logEndV5Query(nQI);
        return nQI != 0 || info.explicitOLAPObj != null;
    }

    protected static boolean addAllObjectsToV5(MetadataConnection metadataConnection, XQENodeFactory factory, InfoClass info) {
        GenerateModuleMetadataForPackage generator;
        info.generator = generator = new GenerateModuleMetadataForPackage();
        generator.connection = metadataConnection;
        generator.mdResponse = new JSONObject();
        generator.version30 = false;
        if (info.prefix != null) {
            generator.idPrefix = info.prefix + STR_DOT;
        }
        GenerateJoinGraph.logStartCollectObjects(info.aliasForLog);
        generator.collectMetadataObjects();
        GenerateJoinGraph.logEndCollectObjects(generator.allObjects.size());
        int nQI = 0;
        for (ArrayList<IMetadata> objChain : generator.allObjects) {
            boolean bInShortcut = false;
            for (IMetadata obj : objChain) {
                if (obj.getObjectType() != MetadataType.SHORTCUT) continue;
                bInShortcut = true;
                break;
            }
            IMetadata origObj = objChain.get(objChain.size() - 1);
            String parentId = generator.getIdentifier(origObj);
            IMetadata obj = origObj.getObjectType() == MetadataType.SHORTCUT ? ((IShortcut)origObj).getTarget() : origObj;
            MetadataType tp = obj.getObjectType();
            if (tp == MetadataType.QUERY_SUBJECT) {
                List<IMetadata> children = obj.getChildMetadataObjects();
                for (IMetadata child : children) {
                    nQI += GenerateJoinGraph.collectItems(parentId, child, bInShortcut, generator, info);
                }
                continue;
            }
            if (tp == MetadataType.CALCULATION) {
                ICalculation cal = (ICalculation)obj;
                if (!"namedSet".equals(cal.getCalcType())) {
                    info.addRelationObject(parentId, cal);
                    ++nQI;
                    continue;
                }
                info.addOLAPObject(obj, origObj, bInShortcut);
                continue;
            }
            if (tp != MetadataType.DIMENSION && tp != MetadataType.NAMED_SET) continue;
            info.addOLAPObject(obj, origObj, bInShortcut);
        }
        boolean bAddRelDataItems = false;
        if (nQI > 0) {
            boolean bl = bAddRelDataItems = GenerateJoinGraph.addRelationalDataItems(info, factory) > 0;
        }
        if (!info.bHasStandAloneCalcs && !bAddRelDataItems) {
            GenerateJoinGraph.removeQueryAndQRD(info);
        }
        GenerateJoinGraph.logEndV5Query(nQI);
        return bAddRelDataItems || info.hasOLAPObject();
    }

    protected static int addRelationalDataItems(InfoClass info, XQENodeFactory factory) {
        int nQI = 0;
        for (Pair p : info.relObjects) {
            String id = (String)p.getFirst();
            if (info.prefixTrim != null) {
                id = id.substring(info.prefixTrim);
            }
            if (!GenerateJoinGraph.addADataItem(id, (IMetadata)p.getSecond(), info.v5Select, info.v5GroupBody, factory)) continue;
            ++nQI;
        }
        return nQI;
    }

    protected static int collectItems(String parentId, IMetadata obj, boolean inShortcut, GenerateModuleMetadataForPackage generator, InfoClass info) {
        List<IMetadata> children;
        if (!generator.isVisible(obj, inShortcut)) {
            return 0;
        }
        int nQI = 0;
        MetadataType tp = obj.getObjectType();
        if (tp == MetadataType.QUERY_ITEM && !(obj instanceof IProperty)) {
            String idforexpr = generator.getIdForExpression(parentId, obj);
            info.addRelationObject(idforexpr, obj);
            ++nQI;
            parentId = idforexpr;
        }
        if ((children = obj.getChildMetadataObjects()) != null && !children.isEmpty()) {
            for (IMetadata child : children) {
                if (!generator.isPropertyWithVisibleRoles(child)) continue;
                nQI += GenerateJoinGraph.collectItems(parentId, child, inShortcut, generator, info);
            }
        }
        return nQI;
    }

    protected static boolean addADataItem(String idforexpr, IMetadata md, IXQEQueryNode selection, IXQEQueryNode groupBody, XQENodeFactory factory) {
        if (md.isHidden()) {
            return false;
        }
        V5DataItem dataItem = (V5DataItem)factory.createNode(101003);
        selection.addChild(dataItem);
        dataItem.setPropertyValue("name", idforexpr);
        dataItem.setAggregateProperty(RefineAutomaticXtab.AggrTypeEnum.NONE.getV5Name());
        dataItem.setRollupAggregateProperty(RefineAutomaticXtab.AggrTypeEnum.NONE.getV5Name());
        dataItem.setPropertyValue("sort", "none");
        V5BoundModelIdentifier boundNode = (V5BoundModelIdentifier)factory.createNode(201116);
        boundNode.setMetadata(md);
        dataItem.addChild(boundNode);
        dataItem.setDetailContext(boundNode);
        V5DataItemRef dataItemRef = (V5DataItemRef)factory.createNode(101015);
        dataItemRef.setPropertyValue("refDataItem", idforexpr);
        dataItemRef.setPropertyValue(REF_DI, dataItem);
        groupBody.addChild(dataItemRef);
        return true;
    }

    public static JSONObject generateJoinGraph(PlanningEnvironment environment, InfoClass info) {
        if (info.hasOLAPObject() || info.explicitOLAPObj != null) {
            JSONArray jQueryItems;
            GenerateJoinGraph.addOLAPJoinGraph(environment, info);
            if (info.jJoinGraph != null && (jQueryItems = (JSONArray)info.jJoinGraph.get((Object)STR_QUERYITEM)) != null) {
                info.mapOLAPItemToGroups = new HashMap<String, Set<String>>();
                for (Object o : jQueryItems) {
                    JSONObject jObj = (JSONObject)o;
                    Set k = jObj.keySet();
                    if (k.size() != 1) continue;
                    String sKey = (String)k.iterator().next();
                    JSONArray vs = (JSONArray)jObj.get((Object)sKey);
                    info.mapOLAPItemToGroups.put(sKey, new HashSet(vs));
                }
            }
        }
        if (info.v5QRD != null) {
            GenerateJoinGraph.generateJoinGraphFromRelational(environment, info);
        }
        return info.jJoinGraph;
    }

    protected static void generateJoinGraphFromRelational(PlanningEnvironment environment, InfoClass info) {
        GenerateJoinGraph.logStartRelational(info.aliasForLog);
        ReplaceQRDWithRQPQuery t1 = new ReplaceQRDWithRQPQuery();
        ProcessDataItemRefInValueSet t2 = new ProcessDataItemRefInValueSet();
        t2.setUsedByJoinGraph();
        IXQEQueryNode valueSet = info.v5QRD.getFirstDescendantOfTypeOrdered(101057, false);
        try {
            if (MoserCommandUtil.INFO_LOGGER.isOn()) {
                MoserCommandUtil.INFO_LOGGER.log(LogLevel.INFO, OperationEnum.START, "start RQPQuery");
            }
            t1.apply((IXQEQueryNode)info.v5QRD, environment);
            if (MoserCommandUtil.INFO_LOGGER.isOn()) {
                MoserCommandUtil.INFO_LOGGER.log(LogLevel.INFO, OperationEnum.END, "end RQPQuery");
                MoserCommandUtil.INFO_LOGGER.log(LogLevel.INFO, OperationEnum.START, "start RQPDataItem");
            }
            t2.apply(valueSet, environment);
            if (MoserCommandUtil.INFO_LOGGER.isOn()) {
                MoserCommandUtil.INFO_LOGGER.log(LogLevel.INFO, OperationEnum.END, "end RQPDataItem");
            }
        }
        catch (Exception e) {
            GenerateJoinGraph.logEndRelational(0);
            return;
        }
        if (MoserCommandUtil.INFO_LOGGER.isOn()) {
            MoserCommandUtil.INFO_LOGGER.log(LogLevel.INFO, OperationEnum.START, "start unwind");
        }
        RQPQuery rqpQuery = (RQPQuery)valueSet.getAncestorOfType(801017);
        UnwindV5BoundMultipartIdentifier t3 = new UnwindV5BoundMultipartIdentifier(new int[0]);
        t3.setUsedByJoinGraph();
        List<IXQEQueryNode> lst = rqpQuery.getDescendantsOfTypeOrdered(801008, false);
        for (IXQEQueryNode n : lst) {
            LoopDetectionChain ldc = new LoopDetectionChain();
            try {
                t3.applyImplementation(n.getChild(0), environment, ldc);
            }
            catch (Exception e) {
                n.setChild(environment.getNodeFactory().createNode(201023));
            }
        }
        if (MoserCommandUtil.INFO_LOGGER.isOn()) {
            MoserCommandUtil.INFO_LOGGER.log(LogLevel.INFO, OperationEnum.END, "end unwind");
        }
        List allJoinPaths = null;
        if (!info.bEmbeddedModuleOnly) {
            if (MoserCommandUtil.INFO_LOGGER.isOn()) {
                MoserCommandUtil.INFO_LOGGER.log(LogLevel.INFO, OperationEnum.START, "start all joins");
            }
            InitializeFactManager t4 = new InitializeFactManager();
            Pair allJoins = new Pair();
            t4.setUsedByJoinGraph(allJoins);
            RQPFactManager rqpFactManager = rqpQuery.getFactManager();
            List<IMetadata> qsSetToJoin = GenerateJoinGraph.collectQuerySubjects(rqpQuery);
            if (qsSetToJoin.size() > 1) {
                t4.createFactFinder(rqpFactManager, environment, null, null, qsSetToJoin, false, null);
                allJoinPaths = (List)allJoins.getFirst();
            } else {
                allJoinPaths = new ArrayList();
            }
            if (MoserCommandUtil.INFO_LOGGER.isOn()) {
                MoserCommandUtil.INFO_LOGGER.log(LogLevel.INFO, OperationEnum.END, "end all joins");
            }
        }
        int n = GenerateJoinGraph.generateJsonJoinGraph(environment, rqpQuery, allJoinPaths, info);
        GenerateJoinGraph.logEndRelational(n);
    }

    /*
     * WARNING - void declaration
     */
    protected static int generateJsonJoinGraph(PlanningEnvironment environment, RQPQuery rqpQuery, List<List<IMetadata>> allJoinPaths, InfoClass info) {
        TreeSet<String> groups = new TreeSet<String>();
        TreeMap<ModuleIdPair, String> connectors = new TreeMap<ModuleIdPair, String>();
        HashSet<MoserQuerySubject> itemNormQS = new HashSet<MoserQuerySubject>();
        JSONArray jQueryItems = (JSONArray)info.jJoinGraph.get((Object)STR_QUERYITEM);
        if (jQueryItems == null) {
            jQueryItems = new JSONArray();
            info.jJoinGraph.put((Object)STR_QUERYITEM, (Object)jQueryItems);
        }
        String prefix = null;
        IXQEQueryNode proj = rqpQuery.getFirstChildByType(801016);
        if (proj != null) {
            IXQEQueryNode[] dataItems = proj.getChildrenOfType(801008);
            for (IXQEQueryNode n : dataItems) {
                RQPDataItem di = (RQPDataItem)n;
                String nm = di.getName();
                if (prefix == null && MetadataUtil.isIdForPackage(nm)) {
                    prefix = nm.substring(0, nm.indexOf(STR_DOT) + 1);
                }
                TreeSet<String> grps = GenerateJoinGraph.getGroups(di, prefix, itemNormQS, info);
                JSONObject jQI = new JSONObject();
                JSONArray jGrps = new JSONArray();
                for (String g : grps) {
                    jGrps.add((Object)g);
                }
                jQI.put((Object)nm, (Object)jGrps);
                jQueryItems.add((Object)jQI);
                if (info.bEmbeddedModuleOnly) continue;
                if (info.seenGroups != null) {
                    grps.removeAll(info.seenGroups);
                }
                groups.addAll(grps);
            }
        }
        if (allJoinPaths != null) {
            for (List list : allJoinPaths) {
                for (IMetadata r : list) {
                    IRelationship j = (IRelationship)r;
                    Pair leftRight = GenerateJoinGraph.getJoinIds(j, prefix, itemNormQS);
                    String leftId = (String)leftRight.getFirst();
                    String rightId = (String)leftRight.getSecond();
                    boolean bLR = true;
                    ModuleIdPair k = null;
                    if (leftId.compareTo(rightId) <= 0) {
                        k = new ModuleIdPair(leftId, rightId, null);
                    } else {
                        k = new ModuleIdPair(rightId, leftId, null);
                        bLR = false;
                    }
                    if (connectors.containsKey(k)) continue;
                    groups.add(leftId);
                    groups.add(rightId);
                    String card = GenerateJoinGraph.getCardinality(j, bLR);
                    connectors.put(k, card);
                }
            }
        }
        for (MoserQuerySubject moserQuerySubject : itemNormQS) {
            MoserItemNormalization itemNorm = moserQuerySubject.getItemNormalization();
            if (itemNorm.isGeneratedFromPrimaryKey()) continue;
            List<MoserItemNormalizationGroup> grps = itemNorm.getMoserItemNormalizationGroups();
            for (MoserItemNormalizationGroup gp : grps) {
                List<MoserItemNormalizationGroup> pgrps = gp.getParentGroups();
                for (MoserItemNormalizationGroup parentG : pgrps) {
                    String leftId = moserQuerySubject.getName() + STR_DASH + parentG.getName();
                    String rightId = moserQuerySubject.getName() + STR_DASH + gp.getName();
                    boolean bLR = true;
                    ModuleIdPair k = null;
                    if (leftId.compareTo(rightId) <= 0) {
                        k = new ModuleIdPair(leftId, rightId, null);
                    } else {
                        k = new ModuleIdPair(rightId, leftId, null);
                        bLR = false;
                    }
                    if (connectors.containsKey(k)) continue;
                    groups.add(leftId);
                    groups.add(rightId);
                    String card = null;
                    card = bLR ? "1:N" : "N:1";
                    connectors.put(k, card);
                }
            }
        }
        JSONArray jGroups = (JSONArray)info.jJoinGraph.get((Object)STR_GROUP);
        if (jGroups == null) {
            jGroups = new JSONArray();
            info.jJoinGraph.put((Object)STR_GROUP, (Object)jGroups);
        }
        for (String g : groups) {
            jGroups.add((Object)g);
        }
        JSONArray jSONArray = (JSONArray)info.jJoinGraph.get((Object)STR_CONNECTOR);
        if (jSONArray == null) {
            JSONArray jSONArray2 = new JSONArray();
            info.jJoinGraph.put((Object)STR_CONNECTOR, (Object)jSONArray2);
        }
        int numConnectors = 0;
        for (Map.Entry entry : connectors.entrySet()) {
            void var11_19;
            GenerateJoinGraph.addConnector((JSONArray)var11_19, (ModuleIdPair)entry.getKey(), (String)entry.getValue());
            ++numConnectors;
        }
        return numConnectors;
    }

    protected static List<IMetadata> collectQuerySubjects(RQPQuery rqpQuery) {
        HashSet<IQuerySubject> r = new HashSet<IQuerySubject>();
        IXQEQueryNode proj = rqpQuery.getFirstChildByType(801016);
        if (proj != null) {
            IXQEQueryNode[] objs;
            for (IXQEQueryNode o : objs = proj.getDescendantsOfType(201116, false)) {
                IQuerySubject qs = ((V5BoundModelIdentifier)o).getQuerySubject();
                if (qs == null) continue;
                r.add(qs);
            }
        }
        return new ArrayList<IMetadata>(r);
    }

    public static Set<IMetadata> getJoinPaths(MetadataConnection mdConn, UndirectedGraph g, List<IMetadata> mEntitiesToJoin, HashMap<String, IMetadata> mIdToJoin) {
        ArrayList<Pair> entitiesToJoin = new ArrayList<Pair>();
        for (IMetadata mdObj : mEntitiesToJoin) {
            entitiesToJoin.add(new Pair(mdConn.getID(mdObj), mdObj));
        }
        HashSet<IMetadata> joinPath = new HashSet<IMetadata>();
        if (g.isConnected()) {
            GenerateJoinGraph.addAllEdges(g, joinPath, entitiesToJoin, mdConn, mEntitiesToJoin, mIdToJoin);
        } else {
            GenerateJoinGraph.addEdgesByForest(g, joinPath, entitiesToJoin, mdConn, mIdToJoin);
        }
        return joinPath;
    }

    protected static void addAllEdges(UndirectedGraph g, Set<IMetadata> joinPath, ArrayList<Pair> entitiesToJoin, MetadataConnection mdConn, List<IMetadata> mEntitiesToJoin, HashMap<String, IMetadata> mIdToJoin) {
        for (GraphEdge edge : g.getEdges()) {
            String joinId = edge.getEdgeId();
            GenerateJoinGraph.addOneRelationship(mIdToJoin, joinId, joinPath);
        }
    }

    protected static void addOneRelationship(HashMap<String, IMetadata> mIdToJoin, String joinId, Set<IMetadata> joinPath) {
        IMetadata joinObj = mIdToJoin.get(joinId);
        if (!(joinObj instanceof IRelationship)) {
            return;
        }
        IRelationship relationship = (IRelationship)joinObj;
        IMetadata left = relationship.getLeftRefObject();
        IMetadata right = relationship.getRightRefObject();
        if (left == null || !left.isAccessible()) {
            return;
        }
        if (right == null || !right.isAccessible()) {
            return;
        }
        joinPath.add(joinObj);
    }

    protected static void addEdgesByForest(UndirectedGraph g, Set<IMetadata> joinPath, ArrayList<Pair> entitiesToJoin, MetadataConnection mdConn, HashMap<String, IMetadata> mIdToJoin) {
        ArrayList<ArrayList<String>> nodeVectors = new ArrayList<ArrayList<String>>();
        ArrayList<ArrayList<String>> edgeVectors = new ArrayList<ArrayList<String>>();
        g.getConnectedComponents(nodeVectors, edgeVectors);
        HashMap<String, Integer> nodeToForest = new HashMap<String, Integer>();
        for (int i = 0; i < nodeVectors.size(); ++i) {
            for (String string : nodeVectors.get(i)) {
                nodeToForest.put(string, i);
            }
        }
        HashMap<Integer, HashSet<Pair>> requiredForest = new HashMap<Integer, HashSet<Pair>>();
        for (Pair pair : entitiesToJoin) {
            String eId = (String)pair.getFirst();
            Integer fId = (Integer)nodeToForest.get(eId);
            if (fId == null) continue;
            HashSet<Pair> entitySet = (HashSet<Pair>)requiredForest.get(fId);
            if (entitySet == null) {
                entitySet = new HashSet<Pair>();
                requiredForest.put(fId, entitySet);
            }
            entitySet.add(pair);
        }
        for (Map.Entry entry : requiredForest.entrySet()) {
            Set sEntity = (Set)entry.getValue();
            if (sEntity.size() < 2) continue;
            ArrayList<String> edgesForest = edgeVectors.get((Integer)entry.getKey());
            for (String joinId : edgesForest) {
                GenerateJoinGraph.addOneRelationship(mIdToJoin, joinId, joinPath);
            }
        }
    }

    protected static Pair getJoinIds(IRelationship j, String prefix, Set<MoserQuerySubject> itemNormQS) {
        IMetadata left = j.getLeftRefObject();
        IMetadata right = j.getRightRefObject();
        List<MoserRelationship.MoserLink> lnk = null;
        if (j instanceof MoserRelationship) {
            lnk = ((MoserRelationship)j).getLinks();
        }
        if (lnk == null || lnk.isEmpty()) {
            return new Pair(GenerateJoinGraph.getQuerySubjectId(left, null, prefix, null), GenerateJoinGraph.getQuerySubjectId(right, null, prefix, null));
        }
        String leftId = null;
        if (itemNormQS.contains(left)) {
            leftId = GenerateJoinGraph.getGroupNameFromLink((MoserQuerySubject)left, lnk, true);
        }
        if (leftId == null) {
            leftId = GenerateJoinGraph.getQuerySubjectId(left, null, prefix, null);
        }
        String rightId = null;
        if (itemNormQS.contains(right)) {
            rightId = GenerateJoinGraph.getGroupNameFromLink((MoserQuerySubject)right, lnk, false);
        }
        if (rightId == null) {
            rightId = GenerateJoinGraph.getQuerySubjectId(right, null, prefix, null);
        }
        return new Pair(leftId, rightId);
    }

    protected static String getGroupNameFromLink(MoserQuerySubject qs, List<MoserRelationship.MoserLink> lnk, boolean bL) {
        String nm = null;
        for (MoserRelationship.MoserLink p : lnk) {
            String qiId = null;
            qiId = bL ? p.getLeftRefId() : p.getRightRefId();
            String gName = GenerateJoinGraph.getGroupNameForMoserQueryItem(qs, qiId, null);
            if (nm == null) {
                nm = gName;
                continue;
            }
            if (nm.equals(gName)) continue;
            return null;
        }
        return nm;
    }

    protected static void addConnector(JSONArray jConnectors, ModuleIdPair p, String card) {
        JSONObject jJoin = new JSONObject();
        jJoin.put((Object)"leftId", p.getFirst());
        jJoin.put((Object)"rightId", p.getSecond());
        jJoin.put((Object)STR_CARD, (Object)card);
        jConnectors.add((Object)jJoin);
    }

    protected static String returnEmptyResponse(boolean bThrow) {
        JSONObject jJoinGraph = new JSONObject();
        if (bThrow) {
            throw new XQERuntimeException(XQEMessageKeys.PLN_StopJoinGraph, jJoinGraph.toString());
        }
        return jJoinGraph.toString();
    }

    protected static TreeSet<String> getGroups(RQPDataItem di, String prefix, HashSet<MoserQuerySubject> itemNormQS, InfoClass info) {
        TreeSet<String> rt = new TreeSet<String>();
        List<IXQEQueryNode> v5Identifiers = di.getDescendantsOfTypeOrdered(201116, false);
        for (IXQEQueryNode v5Identifier : v5Identifiers) {
            V5BoundModelIdentifier boundModelId = (V5BoundModelIdentifier)v5Identifier;
            IQuerySubject qs = boundModelId.getQuerySubject();
            IMetadata qi = boundModelId.getMetadata();
            String pre = prefix;
            if (pre == null && info.mcToAlias != null && (pre = info.mcToAlias.get(qi.getConnection())) != null) {
                pre = pre + STR_DOT;
            }
            if (qs == null) {
                if (info.mapOLAPItemToGroups == null) continue;
                String fullId = null;
                fullId = pre != null ? pre + qi.getID() : qi.getID();
                Set<String> olapGroups = info.mapOLAPItemToGroups.get(fullId);
                if (olapGroups == null) continue;
                rt.addAll(olapGroups);
                continue;
            }
            String groupId = GenerateJoinGraph.getQuerySubjectId(qs, qi, pre, itemNormQS);
            rt.add(groupId);
        }
        return rt;
    }

    protected static String getGroupNameForMoserQueryItem(MoserQuerySubject qs, String qiName, Set<MoserQuerySubject> itemNormQS) {
        MoserItemNormalization itemNorm = qs.getItemNormalization();
        if (itemNorm == null || qiName == null || itemNorm.isGeneratedFromPrimaryKey()) {
            return qs.getName();
        }
        String grpName = itemNorm.getGroupName(qiName);
        if (grpName == null) {
            return qs.getName();
        }
        if (itemNormQS != null) {
            itemNormQS.add(qs);
        }
        return qs.getName() + STR_DASH + grpName;
    }

    protected static String getQuerySubjectId(IMetadata qs, IMetadata qi, String prefix, Set<MoserQuerySubject> itemNormQS) {
        IMetadata obj;
        if (qs instanceof MoserQuerySubject) {
            String qiName = null;
            if (qi != null) {
                qiName = qi.getName();
            }
            return GenerateJoinGraph.getGroupNameForMoserQueryItem((MoserQuerySubject)qs, qiName, itemNormQS);
        }
        IMetadata sc = null;
        if (qs instanceof IAccessedViaShortcut && ((IAccessedViaShortcut)qs).isAccessedViaShortcut()) {
            sc = ((IAccessedViaShortcut)qs).getShortcut();
        }
        IMetadata iMetadata = obj = sc != null ? sc : qs;
        if (prefix != null) {
            return prefix + obj.getID();
        }
        return obj.getID();
    }

    protected static String getCardinality(IRelationship j, boolean bLR) {
        String m;
        if (j.isDummy()) {
            return "1:1";
        }
        String left = STR_ONE;
        if (bLR) {
            m = IRelationship.Cardinality.getMaxCard(j.getLeftCardinality());
            if ("many".equals(m)) {
                left = STR_N;
            }
        } else {
            m = IRelationship.Cardinality.getMaxCard(j.getRightCardinality());
            if ("many".equals(m)) {
                left = STR_N;
            }
        }
        String right = STR_ONE;
        if (bLR) {
            String m2 = IRelationship.Cardinality.getMaxCard(j.getRightCardinality());
            if ("many".equals(m2)) {
                right = STR_N;
            }
        } else {
            String m3 = IRelationship.Cardinality.getMaxCard(j.getLeftCardinality());
            if ("many".equals(m3)) {
                right = STR_N;
            }
        }
        return left + STR_COL + right;
    }

    public static Element generateResponse(String jsonJoinGraph) {
        Element elemResponse = DocumentHelper.createElement((String)"moserCommandResponse");
        Element elemResult = DocumentHelper.createElement((String)"moserCommandResult");
        elemResponse.add(elemResult);
        Element elemItemEle = DocumentHelper.createElement((String)"item");
        elemResult.add(elemItemEle);
        elemItemEle.setText(jsonJoinGraph);
        return elemResponse;
    }

    protected static Map<String, Set<String>> getQueryItemToGroupMap(JSONArray jQI) {
        if (jQI == null || jQI.isEmpty()) {
            return null;
        }
        HashMap<String, Set<String>> r = new HashMap<String, Set<String>>();
        for (int i = 0; i < jQI.size(); ++i) {
            JSONObject o = (JSONObject)jQI.get(i);
            for (Object k : o.keySet()) {
                String kName = (String)k;
                JSONArray v = (JSONArray)o.get(k);
                if (v == null) continue;
                HashSet g = new HashSet(v);
                r.put(kName, g);
            }
        }
        if (r.isEmpty()) {
            return null;
        }
        return r;
    }

    protected static void addJoinsBetweenDataModuleAndPackage(PlanningEnvironment environment, Map<String, InfoClass> map, JSONArray jCONNECTOR) {
        if (map.size() <= 1) {
            return;
        }
        InfoClass infoMain = map.get(STR_MAIN);
        if (infoMain == null) {
            return;
        }
        JSONObject joinModule = infoMain.jJoinGraph;
        MetadataConnection metadataConnection = environment.getMetadataConnection();
        if (!(metadataConnection instanceof MoserMetadataConnection)) {
            return;
        }
        MoserMetadataConnection mc = (MoserMetadataConnection)metadataConnection;
        Map<String, Set<String>> mainMp = GenerateJoinGraph.getQueryItemToGroupMap((JSONArray)joinModule.get((Object)STR_QUERYITEM));
        if (mainMp == null) {
            return;
        }
        HashMap<String, Map<String, Set<String>>> alias = new HashMap<String, Map<String, Set<String>>>();
        for (Map.Entry<String, InfoClass> entry : map.entrySet()) {
            JSONObject joinFM;
            Map<String, Set<String>> aMp;
            String a = entry.getKey();
            if (STR_MAIN.equals(a) || (aMp = GenerateJoinGraph.getQueryItemToGroupMap((JSONArray)(joinFM = entry.getValue().jJoinGraph).get((Object)STR_QUERYITEM))) == null) continue;
            alias.put(a, aMp);
        }
        if (alias.isEmpty()) {
            return;
        }
        HashSet<ModuleIdPair> seen = new HashSet<ModuleIdPair>();
        MoserModule topModule = mc.getModule();
        List<MoserRelationship> relationships = topModule.getRelationships();
        for (MoserRelationship j : relationships) {
            GenerateJoinGraph.addConnectorBetweenModuleAndPackage(mainMp, alias, j, jCONNECTOR, seen);
        }
    }

    protected static void addConnectorBetweenModuleAndPackage(Map<String, Set<String>> mainMp, Map<String, Map<String, Set<String>>> alias, MoserRelationship relationship, JSONArray jCONNECTOR, Set<ModuleIdPair> seen) {
        String leftOrgId = relationship.getOriginalLeftId();
        String rightOrgId = relationship.getOriginalRightId();
        if (leftOrgId == null || rightOrgId == null) {
            return;
        }
        boolean bLeft = MetadataUtil.isIdForPackage(leftOrgId);
        boolean bRight = MetadataUtil.isIdForPackage(rightOrgId);
        if (!bLeft && !bRight) {
            return;
        }
        List<MoserRelationship.MoserLink> links = relationship.getLinks();
        if (links == null || links.isEmpty()) {
            return;
        }
        for (MoserRelationship.MoserLink p : links) {
            String leftQI = p.getLeftRefId();
            String rightQI = p.getRightRefId();
            String leftGrp = GenerateJoinGraph.getQueryItemGroups(leftQI, leftOrgId, bLeft, mainMp, alias);
            String rightGrp = GenerateJoinGraph.getQueryItemGroups(rightQI, rightOrgId, bRight, mainMp, alias);
            if (leftGrp == null || rightGrp == null) continue;
            boolean bLR = true;
            ModuleIdPair k = null;
            if (leftGrp.compareTo(rightGrp) <= 0) {
                k = new ModuleIdPair(leftGrp, rightGrp, null);
            } else {
                k = new ModuleIdPair(rightGrp, leftGrp, null);
                bLR = false;
            }
            if (seen.contains(k)) continue;
            String card = GenerateJoinGraph.getCardinality(relationship, bLR);
            seen.add(k);
            GenerateJoinGraph.addConnector(jCONNECTOR, k, card);
        }
    }

    protected static String getQueryItemGroups(String qi, String qs, boolean b, Map<String, Set<String>> mainMp, Map<String, Map<String, Set<String>>> alias) {
        String qiId = qs + STR_DOT + qi;
        Map<String, Set<String>> mp = null;
        if (b) {
            String prefix = qs.substring(0, qs.indexOf(STR_DOT));
            mp = alias.get(prefix);
        } else {
            mp = mainMp;
        }
        if (mp == null) {
            return null;
        }
        Set<String> g = mp.get(qiId);
        if (g == null || g.size() != 1) {
            return null;
        }
        return g.iterator().next();
    }

    public static JSONObject combineJoinGraph(PlanningEnvironment environment, Map<String, InfoClass> map) {
        JSONObject jJoinGraph = new JSONObject();
        JSONArray jQI = new JSONArray();
        JSONArray jGRP = new JSONArray();
        JSONArray jCONNECTOR = new JSONArray();
        GenerateJoinGraph.addJoinsBetweenDataModuleAndPackage(environment, map, jCONNECTOR);
        for (Map.Entry<String, InfoClass> entry : map.entrySet()) {
            JSONArray jCon;
            JSONArray jGp;
            JSONObject jObj = entry.getValue().jJoinGraph;
            JSONArray jItm = (JSONArray)jObj.get((Object)STR_QUERYITEM);
            if (jItm != null) {
                jQI.addAll((Collection)jItm);
            }
            if ((jGp = (JSONArray)jObj.get((Object)STR_GROUP)) != null) {
                jGRP.addAll((Collection)jGp);
            }
            if ((jCon = (JSONArray)jObj.get((Object)STR_CONNECTOR)) == null) continue;
            jCONNECTOR.addAll((Collection)jCon);
        }
        jJoinGraph.put((Object)STR_QUERYITEM, (Object)jQI);
        jJoinGraph.put((Object)STR_GROUP, (Object)jGRP);
        jJoinGraph.put((Object)STR_CONNECTOR, (Object)jCONNECTOR);
        return jJoinGraph;
    }

    protected static void addOLAPJoinGraph(PlanningEnvironment environment, InfoClass info) {
        if (!info.bNeedExplicit) {
            GenerateJoinGraph.addOLAPJoinGraphComplete(environment, info);
        } else {
            GenerateJoinGraph.addOLAPJoinGraphPartial(environment, info);
        }
    }

    protected static HierInfo getOrCreateHierInfo(Map<IHierarchy, HierInfo> hiers, IHierarchy h) {
        HierInfo info = hiers.get(h);
        if (info == null) {
            info = new HierInfo();
            hiers.put(h, info);
            if (h.isParentChild()) {
                info.props = new ArrayList();
            } else {
                info.levelToProps = new HashMap();
            }
        }
        return info;
    }

    protected static void addHierarchyLevelInfo(Map<IHierarchy, HierInfo> hiers, List<IMetadata> mds) {
        for (IMetadata md : mds) {
            if (md instanceof IHierarchy) {
                GenerateJoinGraph.getOrCreateHierInfo(hiers, (IHierarchy)md);
                continue;
            }
            if (!(md instanceof ILevel)) continue;
            IHierarchy h = ((ILevel)md).getHierarchy();
            HierInfo info = GenerateJoinGraph.getOrCreateHierInfo(hiers, h);
            List<Pair> p = info.levelToProps.get((ILevel)md);
            if (p != null) continue;
            info.levelToProps.put((ILevel)md, new ArrayList());
        }
    }

    protected static void addHierarchyInfo(Map<IHierarchy, HierInfo> hiers, IMetadata md, Pair p) {
        if (md == null) {
            return;
        }
        if (md instanceof ILevel) {
            ILevel lvl = (ILevel)md;
            HierInfo info = GenerateJoinGraph.getOrCreateHierInfo(hiers, lvl.getHierarchy());
            List<Pair> lst = info.levelToProps.get(lvl);
            if (lst == null) {
                lst = new ArrayList<Pair>();
                info.levelToProps.put(lvl, lst);
            }
            lst.add(p);
            return;
        }
        if (md instanceof IHierarchy) {
            IHierarchy h = (IHierarchy)md;
            HierInfo info = GenerateJoinGraph.getOrCreateHierInfo(hiers, h);
            info.props.add(p);
        }
    }

    protected static boolean groupExplicitMetadataObjects(PlanningEnvironment env, InfoClass info, Map<IHierarchy, HierInfo> hiers, ArrayList<Pair> measures, ArrayList<Pair> namedSet) {
        Boolean bDMR = null;
        for (Map.Entry<String, IMetadata> entry : info.explicitOLAPObj.entrySet()) {
            ILevel lvl;
            String id = entry.getKey();
            IMetadata md = entry.getValue();
            Pair p = new Pair(id, md);
            if (bDMR == null) {
                bDMR = md.isDMR();
            }
            if (md instanceof INamedSet) {
                boolean[] isMeasure = new boolean[]{false};
                ArrayList<IMetadata> mds = GenerateJoinGraph.getNamedSetLevels(env, (INamedSet)md, isMeasure);
                GenerateJoinGraph.addHierarchyLevelInfo(hiers, mds);
                namedSet.add(p);
                continue;
            }
            if (md instanceof IMember) {
                if (((IMember)md).isMeasure()) {
                    measures.add(p);
                    continue;
                }
                lvl = ((IMember)md).getLevel();
                if (lvl != null) {
                    GenerateJoinGraph.addHierarchyInfo(hiers, lvl, p);
                    continue;
                }
                GenerateJoinGraph.addHierarchyInfo(hiers, ((IMember)md).getHierarchy(), p);
                continue;
            }
            if (md instanceof IHierarchy) {
                IHierarchy h = (IHierarchy)md;
                if (h.isParentChild()) {
                    GenerateJoinGraph.addHierarchyInfo(hiers, h, p);
                    continue;
                }
                ArrayList<IMetadata> lvls = new ArrayList<IMetadata>(h.getLevels());
                GenerateJoinGraph.addHierarchyLevelInfo(hiers, lvls);
                HierInfo hInfo = GenerateJoinGraph.getOrCreateHierInfo(hiers, h);
                hInfo.hierId = id;
                continue;
            }
            if (md instanceof ILevel) {
                GenerateJoinGraph.addHierarchyInfo(hiers, md, p);
                continue;
            }
            if (!(md instanceof IProperty)) continue;
            lvl = ((IProperty)md).getLevel();
            if (lvl != null) {
                GenerateJoinGraph.addHierarchyInfo(hiers, lvl, p);
                continue;
            }
            GenerateJoinGraph.addHierarchyInfo(hiers, ((IProperty)md).getHierarchy(), p);
        }
        for (Map.Entry<Object, Object> entry : hiers.entrySet()) {
            HierInfo hInfo = (HierInfo)entry.getValue();
            if (hInfo.levelToProps == null) continue;
            TreeMap<Integer, ILevel> sortMp = new TreeMap<Integer, ILevel>();
            for (ILevel lvl : hInfo.levelToProps.keySet()) {
                sortMp.put(lvl.getIndex(), lvl);
            }
            hInfo.sortedLevels = new ArrayList(sortMp.values());
        }
        return Boolean.TRUE.equals(bDMR);
    }

    protected static void addPropertyIds(InfoClass info, List<Pair> properties, String groupName) {
        ArrayList<String> groupNameList = new ArrayList<String>();
        groupNameList.add(groupName);
        for (Pair aP : properties) {
            GenerateJoinGraph.addQueryItem(info, (String)aP.getFirst(), groupNameList);
        }
        GenerateJoinGraph.addGroup(info, groupName);
    }

    protected static void addExplicitMeasuresJoinGraph(List<Pair> measures, InfoClass info, Map<IHierarchy, HierInfo> hiers) {
        String measureGroup = MEASURE_PREFIX;
        if (info.prefix != null) {
            measureGroup = info.prefix + STR_DOT + measureGroup;
        }
        ArrayList<String> grps = new ArrayList<String>();
        grps.add(measureGroup);
        for (Pair pair : measures) {
            GenerateJoinGraph.addQueryItem(info, (String)pair.getFirst(), grps);
        }
        GenerateJoinGraph.addGroup(info, measureGroup);
        for (Map.Entry entry : hiers.entrySet()) {
            HierInfo hInfo = (HierInfo)entry.getValue();
            String lvlGrp = hInfo.hierGrpName;
            if (lvlGrp == null) {
                lvlGrp = hInfo.levelGrpNames.get(hInfo.levelGrpNames.size() - 1);
            }
            GenerateJoinGraph.addOneToManyConnector(info.jJoinGraph, lvlGrp, measureGroup);
        }
    }

    protected static void addDMRExplicitMeasuresJoinGraph(List<Pair> measures, InfoClass info, Map<IHierarchy, HierInfo> hiers) {
        TreeMap<ArrayWrapper<String>, ArrayList<Pair>> measureGroups = new TreeMap<ArrayWrapper<String>, ArrayList<Pair>>();
        for (Pair pair : measures) {
            ArrayWrapper<String> arrayWrapper = GenerateJoinGraph.getScopePartial(hiers, (IMeasure)pair.getSecond());
            ArrayList<Pair> lst = (ArrayList<Pair>)measureGroups.get(arrayWrapper);
            if (lst == null) {
                lst = new ArrayList<Pair>();
                measureGroups.put(arrayWrapper, lst);
            }
            lst.add(pair);
        }
        int i = 0;
        for (Map.Entry entry : measureGroups.entrySet()) {
            ArrayWrapper scopeGrps = (ArrayWrapper)entry.getKey();
            List measureItems = (List)entry.getValue();
            String grpName = DMR_MEASURE_PREFIX + ++i + CLOSE_BK;
            ArrayList<String> mgrps = new ArrayList<String>();
            mgrps.add(grpName);
            for (Pair p : measureItems) {
                GenerateJoinGraph.addQueryItem(info, (String)p.getFirst(), mgrps);
            }
            GenerateJoinGraph.addGroup(info, grpName);
            for (String lvlGrp : (String[])scopeGrps.get()) {
                GenerateJoinGraph.addOneToManyConnector(info.jJoinGraph, lvlGrp, grpName);
            }
        }
        if (hiers.size() > 1) {
            TreeSet<String> treeSet = new TreeSet<String>();
            for (HierInfo hInfo : hiers.values()) {
                treeSet.add(hInfo.levelGrpNames.get(hInfo.levelGrpNames.size() - 1));
            }
            ArrayWrapper<String> arrayWrapper = new ArrayWrapper<String>(treeSet.toArray(new String[0]));
            if (!measureGroups.containsKey(arrayWrapper)) {
                String grpName = DMR_MEASURE_PREFIX + ++i + CLOSE_BK;
                GenerateJoinGraph.addGroup(info, grpName);
                for (String lvlGrp : arrayWrapper.get()) {
                    GenerateJoinGraph.addOneToManyConnector(info.jJoinGraph, lvlGrp, grpName);
                }
            }
        }
    }

    protected static ArrayWrapper<String> getScopePartial(Map<IHierarchy, HierInfo> hiers, IMeasure m) {
        TreeSet<String> scope = new TreeSet<String>();
        HashMap<IDimension, ArrayList<IHierarchy>> dimToHier = new HashMap<IDimension, ArrayList<IHierarchy>>();
        for (IHierarchy iHierarchy : hiers.keySet()) {
            IDimension dim = iHierarchy.getDimension();
            ArrayList<IHierarchy> lst = (ArrayList<IHierarchy>)dimToHier.get(dim);
            if (lst == null) {
                lst = new ArrayList<IHierarchy>();
                dimToHier.put(dim, lst);
            }
            lst.add(iHierarchy);
        }
        for (Map.Entry entry : dimToHier.entrySet()) {
            HierInfo hInfo;
            IScopeRelationship scopeRel = m.getScopeRelationship((IMetadata)entry.getKey());
            if (scopeRel == null) {
                for (IHierarchy h : (List)entry.getValue()) {
                    hInfo = hiers.get(h);
                    if (hInfo.sortedLevels.get(0).getIndex() != 0) continue;
                    scope.add(hInfo.levelGrpNames.get(0));
                }
                continue;
            }
            for (IHierarchy h : (List)entry.getValue()) {
                hInfo = hiers.get(h);
                ILevel lowestLevel = scopeRel.getLowestLevel(m, hInfo.sortedLevels.get(0));
                if (lowestLevel == null) {
                    if (hInfo.sortedLevels.get(0).getIndex() != 0) continue;
                    scope.add(hInfo.levelGrpNames.get(0));
                    continue;
                }
                int idx = lowestLevel.getIndex();
                int scopeLvlIdx = -1;
                for (int i = hInfo.sortedLevels.size() - 1; i >= 0; --i) {
                    if (hInfo.sortedLevels.get(i).getIndex() > idx) continue;
                    scopeLvlIdx = i;
                    break;
                }
                if (scopeLvlIdx == -1) {
                    if (hInfo.sortedLevels.get(0).getIndex() != 0) continue;
                    scope.add(hInfo.levelGrpNames.get(0));
                    continue;
                }
                scope.add(hInfo.levelGrpNames.get(scopeLvlIdx));
            }
        }
        return new ArrayWrapper<String>(scope.toArray(new String[0]));
    }

    protected static void addHierarchyToJoinGraphPartial(InfoClass info, IHierarchy h, HierInfo hInfo, Map<IMetadata, String> lvlToGrp) {
        if (h.isParentChild()) {
            hInfo.hierGrpName = GenerateJoinGraph.appendPrefix(info.prefix, h.getID());
            GenerateJoinGraph.addPropertyIds(info, hInfo.props, hInfo.hierGrpName);
            if (lvlToGrp != null) {
                lvlToGrp.put(h, hInfo.hierGrpName);
            }
        } else {
            String preGrp = null;
            ArrayList<String> grpNames = new ArrayList<String>();
            hInfo.levelGrpNames = new ArrayList<String>();
            for (ILevel lvl : hInfo.sortedLevels) {
                String groupName = GenerateJoinGraph.appendPrefix(info.prefix, lvl.getID());
                hInfo.levelGrpNames.add(groupName);
                if (lvlToGrp != null) {
                    lvlToGrp.put(lvl, groupName);
                }
                GenerateJoinGraph.addPropertyIds(info, hInfo.levelToProps.get(lvl), groupName);
                if (preGrp != null) {
                    GenerateJoinGraph.addOneToManyConnector(info.jJoinGraph, preGrp, groupName);
                }
                preGrp = groupName;
                grpNames.add(groupName);
            }
            if (hInfo.hierId != null) {
                GenerateJoinGraph.addQueryItem(info, hInfo.hierId, grpNames);
            }
        }
    }

    protected static void addOLAPJoinGraphPartial(PlanningEnvironment environment, InfoClass info) {
        HierInfo hInfo;
        ArrayList<Pair> measures = new ArrayList<Pair>();
        ArrayList<Pair> namedSet = new ArrayList<Pair>();
        HashMap<IHierarchy, HierInfo> hiers = new HashMap<IHierarchy, HierInfo>();
        GenerateJoinGraph.logStartDimensions(info.aliasForLog);
        boolean isDMR = GenerateJoinGraph.groupExplicitMetadataObjects(environment, info, hiers, measures, namedSet);
        HashMap<IMetadata, String> lvlToGrp = null;
        if (!namedSet.isEmpty()) {
            lvlToGrp = new HashMap<IMetadata, String>();
        }
        if (info.bPrettyPrint) {
            TreeMap<String, IHierarchy> sortHier = new TreeMap<String, IHierarchy>();
            for (IHierarchy h : hiers.keySet()) {
                sortHier.put(h.getID(), h);
            }
            for (IHierarchy h : sortHier.values()) {
                hInfo = hiers.get(h);
                GenerateJoinGraph.addHierarchyToJoinGraphPartial(info, h, hInfo, lvlToGrp);
            }
        } else {
            for (Map.Entry<IHierarchy, HierInfo> hierEntry : hiers.entrySet()) {
                IHierarchy h;
                h = hierEntry.getKey();
                hInfo = hierEntry.getValue();
                GenerateJoinGraph.addHierarchyToJoinGraphPartial(info, h, hInfo, lvlToGrp);
            }
        }
        GenerateJoinGraph.logEndDimensions(hiers.size());
        GenerateJoinGraph.logStartMeasures(info.aliasForLog);
        if (!isDMR) {
            GenerateJoinGraph.addExplicitMeasuresJoinGraph(measures, info, hiers);
        } else {
            GenerateJoinGraph.addDMRExplicitMeasuresJoinGraph(measures, info, hiers);
        }
        GenerateJoinGraph.logEndMeasures(measures.size());
        if (!namedSet.isEmpty()) {
            for (Pair o : namedSet) {
                INamedSet nmSet = (INamedSet)o.getSecond();
                boolean[] isMeasure = new boolean[]{false};
                ArrayList<IMetadata> mds = GenerateJoinGraph.getNamedSetLevels(environment, nmSet, isMeasure);
                List<String> nmSetGrps = GenerateJoinGraph.getGroupsFromLevel(mds, lvlToGrp, isMeasure[0]);
                GenerateJoinGraph.addQueryItem(info, (String)o.getFirst(), nmSetGrps);
            }
        }
    }

    protected static void addOLAPJoinGraphComplete(PlanningEnvironment environment, InfoClass info) {
        ArrayList<TopObject> measures = new ArrayList<TopObject>();
        ArrayList<TopObject> namedset = new ArrayList<TopObject>();
        GenerateJoinGraph.logStartDimensions(info.aliasForLog);
        int nDims = 0;
        for (TopObject p : info.olapObjects) {
            IMetadata mdObj = p.obj;
            if (MetadataType.DIMENSION.equals((Object)mdObj.getObjectType())) {
                IDimension dim = (IDimension)mdObj;
                if (dim.isMeasuresDimension()) {
                    measures.add(p);
                    continue;
                }
                GenerateJoinGraph.addDimensionJoinGraph(environment, p, info);
                ++nDims;
                continue;
            }
            namedset.add(p);
        }
        GenerateJoinGraph.logEndDimensions(nDims);
        GenerateJoinGraph.logStartMeasures(info.aliasForLog);
        int nMeasures = 0;
        if (!measures.isEmpty()) {
            nMeasures = ((TopObject)measures.get((int)0)).obj.isDMR() ? GenerateJoinGraph.addDMRMeasuesJoinGraph(measures, info) : GenerateJoinGraph.addAllMeasuresJoinGraph(measures, info);
        }
        GenerateJoinGraph.logEndMeasures(nMeasures);
        if (!namedset.isEmpty()) {
            HashMap<IMetadata, String> lvlToGrp = new HashMap<IMetadata, String>();
            for (DimInfo dimInfo : info.dims.values()) {
                GenerateJoinGraph.getLevelToGroupMap(lvlToGrp, dimInfo);
            }
            for (TopObject o : namedset) {
                if (!info.generator.isVisible(o.obj, o.inShortcut)) continue;
                INamedSet nmSet = (INamedSet)o.obj;
                boolean[] isMeasure = new boolean[]{false};
                ArrayList<IMetadata> mds = GenerateJoinGraph.getNamedSetLevels(environment, nmSet, isMeasure);
                List<String> nmSetGrps = GenerateJoinGraph.getGroupsFromLevel(mds, lvlToGrp, isMeasure[0]);
                String id = nmSet.getID();
                if (!o.obj.equals(o.orgObj)) {
                    id = o.orgObj.getID();
                }
                GenerateJoinGraph.addQueryItem(info, id, nmSetGrps);
            }
        }
    }

    protected static void addDimensionJoinGraph(PlanningEnvironment env, TopObject dimObj, InfoClass info) {
        List<IHierarchy> hiers;
        if (!info.generator.isVisible(dimObj.obj, dimObj.inShortcut)) {
            return;
        }
        DimInfo dimInfo = new DimInfo();
        dimInfo.dim = (IDimension)dimObj.obj;
        dimInfo.orgObj = dimObj.orgObj;
        if (!dimObj.obj.equals(dimObj.orgObj) && !(hiers = dimInfo.dim.getHierarchies()).isEmpty()) {
            String hId = hiers.get(0).getID();
            hId = GenerateJoinGraph.replaceFirstTwo(dimObj.orgObj.getID(), hId);
            IMetadata md = info.mc.bindMetadataReference(hId);
            if (md instanceof IHierarchy) {
                dimInfo.dim = ((IHierarchy)md).getDimension();
            }
        }
        hiers = dimInfo.dim.getHierarchies();
        boolean b = false;
        for (IHierarchy hier : hiers) {
            if (!info.generator.isPropertyWithVisibleRoles(hier)) continue;
            if (hier.isParentChild()) {
                b = GenerateJoinGraph.addParentChildHierarchy(info, hier, dimInfo) || b;
                continue;
            }
            b = GenerateJoinGraph.addLevelHierarchy(info, hier, dimInfo) || b;
        }
        if (b) {
            if (!dimInfo.namedSet.isEmpty()) {
                HashMap<IMetadata, String> lvlToGrp = new HashMap<IMetadata, String>();
                GenerateJoinGraph.getLevelToGroupMap(lvlToGrp, dimInfo);
                for (IMetadata md : dimInfo.namedSet) {
                    INamedSet nmSet = (INamedSet)md;
                    boolean[] isMeasure = new boolean[]{false};
                    ArrayList<IMetadata> mds = GenerateJoinGraph.getNamedSetLevels(env, nmSet, isMeasure);
                    List<String> nmSetGrps = GenerateJoinGraph.getGroupsFromLevel(mds, lvlToGrp, isMeasure[0]);
                    GenerateJoinGraph.addQueryItem(info, nmSet.getID(), nmSetGrps);
                }
            }
            info.dims.put(dimInfo.dim.getID(), dimInfo);
        }
    }

    protected static ArrayList<IMetadata> getNamedSetLevels(PlanningEnvironment env, INamedSet nmSet, boolean[] isMeasure) {
        ArrayList<IMetadata> mds = new ArrayList<IMetadata>();
        isMeasure[0] = false;
        ICube cube = null;
        cube = nmSet.getDimension() == null ? nmSet.getConnection().getCubes()[0] : nmSet.getDimension().getCube();
        if (cube.getModelDataSource().isROLAP()) {
            if (!GenerateJoinGraph.getLevelsFromROLAPNamedSetExpr(env, nmSet, mds, new LoopDetectionChain(), isMeasure)) {
                return new ArrayList<IMetadata>();
            }
        } else {
            IHierarchy nmHier = nmSet.getHierarchy();
            if (nmHier.getDimension().isMeasuresDimension()) {
                isMeasure[0] = true;
            } else if (nmHier != null && nmHier.isParentChild()) {
                mds.add(nmHier);
            } else {
                List<ILevel> lvls = nmSet.getLevels();
                for (ILevel l : lvls) {
                    mds.add(l);
                }
            }
        }
        return mds;
    }

    protected static boolean getLevelsFromROLAPNamedSetExpr(PlanningEnvironment env, INamedSet nmSet, ArrayList<IMetadata> mds, LoopDetectionChain chain, boolean[] isMeasure) {
        boolean bR = false;
        isMeasure[0] = false;
        try {
            V5SimpleNode node;
            MDXHierInfo h;
            IXQEQueryNode c;
            IXQEQueryNode root = env.getNodeFactory().createNode(201071);
            V5BoundModelIdentifier nmSetNode = (V5BoundModelIdentifier)env.getNodeFactory().createNode(201116);
            nmSetNode.setMetadata(nmSet);
            root.addChild(nmSetNode);
            ExpandRolapNamedSetMultiPartIdentifier t1 = new ExpandRolapNamedSetMultiPartIdentifier();
            int[] passNumbers = new int[]{0};
            BindV5MemberUniqueName t2 = new BindV5MemberUniqueName(passNumbers);
            bR = GenerateJoinGraph.unwindAndBindNamedSet(env, nmSetNode, chain, t1, t2);
            if (bR && (c = root.getChild(0)).isOfCategory(201120) && (h = (node = (V5SimpleNode)c).getHierarchyInfo()).getNumProjectedHierarchies() == 1) {
                MDXLevelInfo contextLevel = new MDXLevelInfo();
                IHierarchy hierarchy = h.getProjectedHierarchy(0);
                if (hierarchy.getDimension().isMeasuresDimension()) {
                    isMeasure[0] = true;
                } else {
                    contextLevel.addProjectedHierarchy(hierarchy.getDefaultMember().getLevel());
                    ArrayList<V5SimpleNode> fncs = new ArrayList<V5SimpleNode>();
                    MDXLevelInfo levelInfo = node.getHierarchyLevelInfo(contextLevel, fncs);
                    List<ILevel> levels = levelInfo.getProjectedLevels(hierarchy);
                    for (ILevel lInfo : levels) {
                        if (!(lInfo instanceof MDXLevelInfo.LevelInfo)) continue;
                        mds.add(((MDXLevelInfo.LevelInfo)lInfo).getLevel());
                    }
                }
            }
        }
        catch (Exception e) {
            return false;
        }
        return bR;
    }

    protected static boolean unwindAndBindNamedSet(PlanningEnvironment env, V5BoundModelIdentifier nmSetNode, LoopDetectionChain ldc, ExpandRolapNamedSetMultiPartIdentifier t1, BindV5MemberUniqueName t2) {
        IXQEQueryNode[] muns;
        IXQEQueryNode[] allV5NodesToBind;
        String idToPush = nmSetNode.getIdentifier();
        if (!ldc.push(idToPush)) {
            return false;
        }
        IXQEQueryNode p = nmSetNode.getParent();
        t1.apply((IXQEQueryNode)nmSetNode, env);
        RQPUtilities.bindV5MultiPartIdentifierToModel(p, env);
        for (IXQEQueryNode v5Node : allV5NodesToBind = p.getDescendantsOfType(201116, true)) {
            String calcType;
            V5BoundModelIdentifier c = (V5BoundModelIdentifier)v5Node;
            IMetadata metaData = c.getMetadata();
            if (metaData.getObjectType() != MetadataType.CALCULATION || !(calcType = ((ICalculation)metaData).getCalcType()).equals("namedSet") || GenerateJoinGraph.unwindAndBindNamedSet(env, c, ldc, t1, t2)) continue;
            return false;
        }
        for (IXQEQueryNode mn : muns = p.getDescendantsOfType(201028, true)) {
            t2.apply(mn, env);
        }
        ldc.pop();
        return true;
    }

    protected static List<String> getGroupsFromLevel(List<IMetadata> lvls, HashMap<IMetadata, String> lvlToGrp, boolean isMeasure) {
        ArrayList<String> rt = new ArrayList<String>();
        if (isMeasure) {
            rt.add(MEASURE_PREFIX);
        } else {
            for (IMetadata l : lvls) {
                String g = lvlToGrp.get(l);
                if (g == null) continue;
                rt.add(g);
            }
        }
        return rt;
    }

    protected static void getLevelToGroupMap(HashMap<IMetadata, String> lvlToGrp, DimInfo dimInfo) {
        for (List<Pair> lst : dimInfo.hierToLevels.values()) {
            for (Pair p : lst) {
                lvlToGrp.put((IMetadata)p.getSecond(), (String)p.getFirst());
            }
        }
    }

    protected static boolean addParentChildHierarchy(InfoClass info, IHierarchy hier, DimInfo dimInfo) {
        ArrayList<IMetadata> properties = new ArrayList<IMetadata>();
        GenerateJoinGraph.collectProperties(info, hier, properties, dimInfo.namedSet);
        properties.add(hier);
        String groupName = GenerateJoinGraph.appendPrefix(info.prefix, hier.getID());
        ArrayList<Pair> groups = new ArrayList<Pair>();
        groups.add(new Pair(groupName, hier));
        dimInfo.hierToLevels.put(hier, groups);
        GenerateJoinGraph.addProperties(info, properties, groupName);
        return true;
    }

    protected static String appendPrefix(String prefix, String id) {
        if (prefix == null) {
            return id;
        }
        return prefix + STR_DOT + id;
    }

    protected static void addQueryItem(InfoClass info, String objID, List<String> groupName) {
        JSONArray jQI = (JSONArray)info.jJoinGraph.get((Object)STR_QUERYITEM);
        if (jQI == null) {
            jQI = new JSONArray();
            info.jJoinGraph.put((Object)STR_QUERYITEM, (Object)jQI);
        }
        JSONObject aQI = new JSONObject();
        JSONArray grps = new JSONArray();
        for (String g : groupName) {
            grps.add((Object)g);
        }
        String propName = GenerateJoinGraph.appendPrefix(info.prefix, objID);
        aQI.put((Object)propName, (Object)grps);
        jQI.add((Object)aQI);
    }

    protected static void addGroup(InfoClass info, String groupName) {
        JSONArray jGPS = (JSONArray)info.jJoinGraph.get((Object)STR_GROUP);
        if (jGPS == null) {
            jGPS = new JSONArray();
            info.jJoinGraph.put((Object)STR_GROUP, (Object)jGPS);
        }
        jGPS.add((Object)groupName);
    }

    protected static void addProperties(InfoClass info, ArrayList<IMetadata> properties, String groupName) {
        ArrayList<String> groupNameList = new ArrayList<String>();
        groupNameList.add(groupName);
        for (IMetadata aP : properties) {
            GenerateJoinGraph.addQueryItem(info, aP.getID(), groupNameList);
        }
        GenerateJoinGraph.addGroup(info, groupName);
    }

    protected static boolean addLevelHierarchy(InfoClass info, IHierarchy hier, DimInfo dimInfo) {
        String preGrp = null;
        ArrayList<Pair> groups = new ArrayList<Pair>();
        ArrayList<String> grpNames = new ArrayList<String>();
        List<ILevel> levels = hier.getLevels();
        for (ILevel lvl : levels) {
            if (!info.generator.isPropertyWithVisibleRoles(lvl)) continue;
            ArrayList<IMetadata> properties = new ArrayList<IMetadata>();
            GenerateJoinGraph.collectProperties(info, lvl, properties, dimInfo.namedSet);
            properties.add(lvl);
            String groupName = GenerateJoinGraph.appendPrefix(info.prefix, lvl.getID());
            grpNames.add(groupName);
            groups.add(new Pair(groupName, lvl));
            GenerateJoinGraph.addProperties(info, properties, groupName);
            if (preGrp != null) {
                GenerateJoinGraph.addOneToManyConnector(info.jJoinGraph, preGrp, groupName);
            }
            preGrp = groupName;
        }
        if (groups.isEmpty()) {
            return false;
        }
        GenerateJoinGraph.addQueryItem(info, hier.getID(), grpNames);
        dimInfo.hierToLevels.put(hier, groups);
        return true;
    }

    protected static void addOneToManyConnector(JSONObject rt, String left, String right) {
        JSONArray jconn = (JSONArray)rt.get((Object)STR_CONNECTOR);
        if (jconn == null) {
            jconn = new JSONArray();
            rt.put((Object)STR_CONNECTOR, (Object)jconn);
        }
        GenerateJoinGraph.addConnector(jconn, new ModuleIdPair(left, right, null), "1:N");
    }

    protected static String replaceFirstTwo(String dimID, String id) {
        String[] nameParts;
        String rt = id;
        if (dimID != null && (nameParts = UniqueNameParser.parseNoThrow(id)) != null && nameParts.length > 2) {
            StringBuilder sb = new StringBuilder();
            for (int i = 2; i < nameParts.length; ++i) {
                sb.append(STR_DOT);
                sb.append(UniqueNameGenerator.createSingleNamePart(nameParts[i]));
            }
            rt = dimID + sb.toString();
        }
        return rt;
    }

    protected static void collectProperties(InfoClass info, IMetadata obj, ArrayList<IMetadata> properties, ArrayList<IMetadata> namedset) {
        if (!info.generator.isPropertyWithVisibleRoles(obj)) {
            return;
        }
        MetadataType tp = obj.getObjectType();
        if (tp == MetadataType.QUERY_ITEM && obj instanceof IProperty) {
            properties.add(obj);
        } else if (tp == MetadataType.NAMED_SET) {
            namedset.add(obj);
        }
        List<IMetadata> children = obj.getChildMetadataObjects();
        if (children == null || children.isEmpty()) {
            return;
        }
        for (IMetadata c : children) {
            GenerateJoinGraph.collectProperties(info, c, properties, namedset);
        }
    }

    protected static List<IMember> getMeasures(InfoClass info, IMetadata dim, IMetadata sc) {
        ArrayList<IMember> rt = new ArrayList<IMember>();
        if (!(dim instanceof IMeasureDimension)) {
            return rt;
        }
        IDimension mDim = (IDimension)dim;
        List<IHierarchy> hiers = mDim.getHierarchies();
        if (hiers.isEmpty()) {
            return rt;
        }
        String scID = null;
        if (!dim.equals(sc)) {
            scID = sc.getID();
        }
        for (IHierarchy h : hiers) {
            IMember[] members = h.getMembers();
            if (members == null) continue;
            for (IMember m : members) {
                if (scID != null) {
                    String mId = GenerateJoinGraph.replaceFirstTwo(scID, m.getID());
                    IMetadata md = info.mc.bindMetadataReference(mId);
                    m = md instanceof IMember ? (IMember)md : null;
                }
                if (m == null || !info.generator.isPropertyWithVisibleRoles(m)) continue;
                rt.add(m);
            }
        }
        return rt;
    }

    protected static int addAllMeasuresJoinGraph(List<TopObject> measures, InfoClass info) {
        int rt = 0;
        String measureGroup = MEASURE_PREFIX;
        if (info.prefix != null) {
            measureGroup = info.prefix + STR_DOT + measureGroup;
        }
        ArrayList<String> grps = new ArrayList<String>();
        grps.add(measureGroup);
        boolean b = false;
        for (TopObject o : measures) {
            if (!info.generator.isVisible(o.obj, o.inShortcut)) continue;
            List<IMember> measureMembers = GenerateJoinGraph.getMeasures(info, o.obj, o.orgObj);
            b = !measureMembers.isEmpty() || b;
            for (IMetadata iMetadata : measureMembers) {
                GenerateJoinGraph.addQueryItem(info, iMetadata.getID(), grps);
                ++rt;
            }
        }
        if (b) {
            GenerateJoinGraph.addGroup(info, measureGroup);
            for (DimInfo d : info.dims.values()) {
                for (List<Pair> lvls : d.hierToLevels.values()) {
                    String string = (String)lvls.get(lvls.size() - 1).getFirst();
                    GenerateJoinGraph.addOneToManyConnector(info.jJoinGraph, string, measureGroup);
                }
            }
        }
        return rt;
    }

    protected static int addDMRMeasuesJoinGraph(List<TopObject> measures, InfoClass info) {
        int rt = 0;
        TreeMap<ArrayWrapper<String>, ArrayList<IMember>> measureGroups = new TreeMap<ArrayWrapper<String>, ArrayList<IMember>>();
        for (TopObject o : measures) {
            if (!info.generator.isVisible(o.obj, o.inShortcut)) continue;
            List<IMember> measureMembers = GenerateJoinGraph.getMeasures(info, o.obj, o.orgObj);
            for (IMember m : measureMembers) {
                ArrayWrapper<String> scope = GenerateJoinGraph.getScope(info, (IMeasure)m);
                ArrayList<IMember> lst = (ArrayList<IMember>)measureGroups.get(scope);
                if (lst == null) {
                    lst = new ArrayList<IMember>();
                    measureGroups.put(scope, lst);
                }
                lst.add(m);
            }
        }
        int i = 0;
        for (Map.Entry entry : measureGroups.entrySet()) {
            ArrayWrapper scopeGrps = (ArrayWrapper)entry.getKey();
            List measureItems = (List)entry.getValue();
            String grpName = DMR_MEASURE_PREFIX + ++i + CLOSE_BK;
            ArrayList<String> mgrps = new ArrayList<String>();
            mgrps.add(grpName);
            for (IMember p : measureItems) {
                GenerateJoinGraph.addQueryItem(info, p.getID(), mgrps);
                ++rt;
            }
            GenerateJoinGraph.addGroup(info, grpName);
            for (String lvlGrp : (String[])scopeGrps.get()) {
                GenerateJoinGraph.addOneToManyConnector(info.jJoinGraph, lvlGrp, grpName);
            }
        }
        return rt;
    }

    protected static ArrayWrapper<String> getScope(InfoClass info, IMeasure m) {
        TreeSet<String> scope = new TreeSet<String>();
        for (Map.Entry<String, DimInfo> entry : info.dims.entrySet()) {
            DimInfo dimInfo = entry.getValue();
            IScopeRelationship scopeRel = m.getScopeRelationship(dimInfo.dim);
            if (scopeRel == null) {
                for (List<Pair> lvls : dimInfo.hierToLevels.values()) {
                    scope.add((String)lvls.get(0).getFirst());
                }
                continue;
            }
            for (List<Pair> lvls : dimInfo.hierToLevels.values()) {
                ILevel lowestLevel = scopeRel.getLowestLevel(m, (ILevel)lvls.get(0).getSecond());
                String lvlGrp = (String)lvls.get(0).getFirst();
                for (Pair p : lvls) {
                    if (!p.getSecond().equals(lowestLevel)) continue;
                    lvlGrp = (String)p.getFirst();
                    break;
                }
                scope.add(lvlGrp);
            }
        }
        return new ArrayWrapper<String>(scope.toArray(new String[0]));
    }

    public static String preloadJoinGraph(ExecutionEnvironment execEnv, InfoClass info) {
        RequestEnvironment reqEnv = (RequestEnvironment)execEnv.getRequestEnvironment();
        String module = info.getMetadataConnection().getModelName();
        GenerateJoinGraph.logStartPreloading(module);
        try {
            PlanningEnvironment planEnv = QueryPlanner.setupEnvironment(reqEnv);
            MetadataConnection mc = info.getMetadataConnection();
            planEnv.setMetdataConnection(mc);
            Locale moduleExpressionLocale = mc.getExpressionLocale();
            if (moduleExpressionLocale != null) {
                reqEnv.setExpressionLocale(moduleExpressionLocale);
            }
            XQENodeFactory factory = planEnv.getNodeFactory();
            V5QuerySet querySet = GenerateJoinGraph.createV5QuerySet(factory, planEnv, mc.getModelName());
            GenerateJoinGraph.createV5QueryAndQRD(mc, querySet, factory, info);
            int nQI = GenerateJoinGraph.addRelationalDataItems(info, factory);
            if (nQI == 0) {
                GenerateJoinGraph.removeQueryAndQRD(info);
            }
            if (nQI == 0 && !info.hasOLAPObject()) {
                GenerateJoinGraph.logEndPreloading(module, false);
                return null;
            }
            JSONObject jJoinGraph = GenerateJoinGraph.generateJoinGraph(planEnv, info);
            GenerateJoinGraph.logEndPreloading(module, true);
            return jJoinGraph.toString();
        }
        catch (Exception e) {
            GenerateJoinGraph.logEndPreloading(module, false);
            return null;
        }
    }

    public static final class InfoClass {
        protected MetadataConnection mc;
        protected boolean bOlap;
        protected String prefix;
        protected boolean bNeedExplicit = false;
        protected Map<String, IMetadata> explicitRelObj;
        protected Map<String, IMetadata> explicitOLAPObj;
        protected V5Query v5Query;
        protected V5Selection v5Select;
        protected V5QueryResultDefinition v5QRD;
        protected IXQEQueryNode v5GroupBody;
        protected ArrayList<TopObject> olapObjects;
        protected HashMap<String, DimInfo> dims = new HashMap();
        protected GenerateModuleMetadataForPackage generator;
        protected JSONObject jJoinGraph = new JSONObject();
        protected Set<String> standaloneCalcs;
        protected Set<String> seenGroups;
        protected String aliasForLog;
        protected boolean bPrettyPrint = false;
        protected List<Pair> relObjects = new ArrayList<Pair>();
        protected Integer prefixTrim;
        protected boolean bHasStandAloneCalcs;
        protected Map<String, Set<String>> mapOLAPItemToGroups;
        protected Map<MetadataConnection, String> mcToAlias;
        protected boolean bEmbeddedModuleOnly = false;

        protected void addOLAPObject(IMetadata obj, IMetadata origObj, boolean inShortcut) {
            if (!this.bOlap) {
                return;
            }
            if (this.olapObjects == null) {
                this.olapObjects = new ArrayList();
            }
            TopObject o = new TopObject();
            o.obj = obj;
            o.orgObj = origObj;
            o.inShortcut = inShortcut;
            this.olapObjects.add(o);
        }

        protected boolean hasOLAPObject() {
            if (!this.bOlap) {
                return false;
            }
            return this.olapObjects != null && !this.olapObjects.isEmpty();
        }

        protected int getSizeOfExplicit() {
            int n = 0;
            if (this.explicitOLAPObj != null) {
                n += this.explicitOLAPObj.size();
            }
            if (this.explicitRelObj != null) {
                n += this.explicitRelObj.size();
            }
            return n;
        }

        protected void addRelationObject(String internalId, IMetadata obj) {
            this.relObjects.add(new Pair(internalId, obj));
        }

        public int computeNumberOfObjects() {
            int n = this.relObjects.size();
            if (this.olapObjects != null) {
                n += this.olapObjects.size() * 20;
            }
            return n;
        }

        public MetadataConnection getMetadataConnection() {
            return this.mc;
        }
    }

    protected static final class HierInfo {
        protected HashMap<ILevel, List<Pair>> levelToProps = null;
        protected List<ILevel> sortedLevels = null;
        protected List<String> levelGrpNames = null;
        protected String hierId = null;
        protected ArrayList<Pair> props = null;
        protected String hierGrpName = null;

        protected HierInfo() {
        }
    }

    protected static final class DimInfo {
        protected IDimension dim;
        protected IMetadata orgObj;
        protected ArrayList<IMetadata> namedSet = new ArrayList();
        protected HashMap<IHierarchy, List<Pair>> hierToLevels = new HashMap();

        protected DimInfo() {
        }
    }

    protected static final class TopObject {
        protected IMetadata obj;
        protected IMetadata orgObj;
        protected boolean inShortcut;

        protected TopObject() {
        }
    }
}

