/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.moser.crosstab;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5.modquery.ModQuery;
import com.cognos.xqe.ast.v5.result.V5QueryResultDefinition;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.moser.util.ContextDependentModQueryToV5QueryUtil;
import com.cognos.xqe.transformation.moser.util.ConvertModQueryToV5QueryUtil;

public final class ConvertCrossTabModQueryToV5Query
extends Transformation {
    public ConvertCrossTabModQueryToV5Query(int passNumber) {
        this.mName = "Convert simple XTab ModQuery To V5Query";
        this.mPassNumbers = new int[]{passNumber};
        this.mTypes = new int[]{101055};
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        V5QueryResultDefinition qrd = (V5QueryResultDefinition)node;
        XQETrace trace = environment.getTrace();
        if (qrd.isList()) {
            this.traceQueryCondition(false, "not a CrossTab QRD.", trace);
            return false;
        }
        ConvertModQueryToV5QueryUtil.ModQueryStatus status = (ConvertModQueryToV5QueryUtil.ModQueryStatus)((Object)qrd.getPropertyValue("modQueryToV5QueryApplied"));
        if (status != null) {
            this.traceQueryCondition(false, "Mod Query is converted to V5Query.", trace);
            return false;
        }
        ModQuery modQuery = ConvertModQueryToV5QueryUtil.getReferencedModQuery(qrd);
        if (modQuery != null) {
            this.traceQueryCondition(true, "need to convert CrossTab mod query to V5 query.", trace);
            return true;
        }
        this.traceQueryCondition(false, "no Mod Query.", trace);
        return false;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        V5QueryResultDefinition qrd = (V5QueryResultDefinition)node;
        qrd.setPropertyValue("modQueryToV5QueryApplied", (Object)ConvertModQueryToV5QueryUtil.ModQueryStatus.MODQUERY_COMPLETE);
        ModQuery modquery = ConvertModQueryToV5QueryUtil.getReferencedModQuery(qrd);
        if (ContextDependentModQueryToV5QueryUtil.hasContextDependentSet(qrd, modquery)) {
            ContextDependentModQueryToV5QueryUtil.convertContextDependentModQueryToV5Query(environment, modquery, qrd);
        } else {
            ConvertModQueryToV5QueryUtil.convertSimpleModQueryToV5Query(environment, modquery, qrd);
        }
    }
}

