/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.aggregation_distribution;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.CogMDXAggregate;
import com.cognos.xqe.ast.olap.CogMDXGroup;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberDefinition;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.MDXSummaryFunction;
import com.cognos.xqe.ast.olap.MDXSummaryFunctionTypeEnum;
import com.cognos.xqe.ast.v5Exp.V5RollupAggregateEnum;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.aggregation_distribution.DistributeMDXSummaryFunction;
import com.cognos.xqe.transformation.olap.aggregation_distribution.InsertErrorCellUpdateDecorationForNoneRollup;
import com.cognos.xqe.transformation.olap.aggregation_distribution.IntersectCogMDXAggreagateWithMeasures;

public final class ConvertCogMDXAggregateWithoutVEToMDXSummaryFunction
extends Transformation {
    public static final String PROP_DISTRIBUTION_PENDING = "PROP_DISTRIBUTION_PENDING";

    public ConvertCogMDXAggregateWithoutVEToMDXSummaryFunction() {
        this.mName = "Convert CogMDXAggregate to MDXSummaryFunction when aggregate distribution is not required. Otherwise, builds the distribution IIF construct.";
        this.mPassNumbers = new int[]{28};
        this.mTypes = new int[]{1012};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        CogMDXAggregate cogMDXAggregate = (CogMDXAggregate)node;
        IXQEQueryNode[] cogMDXGroupNodes = node.getDescendantsOfType(1027, false);
        for (int i = 0; i < cogMDXGroupNodes.length; ++i) {
            ((CogMDXGroup)cogMDXGroupNodes[i]).setProjectDetailsOnly();
        }
        MDXSummaryFunction mdxSummary = (MDXSummaryFunction)nodeFactory.createNode(1060);
        mdxSummary.setIsWithinDetailCalc(cogMDXAggregate.isWithinDetailCalc());
        mdxSummary.setIntersectingMeasures(cogMDXAggregate.getIntersectingMeasures());
        V5RollupAggregateEnum rollupAggregate = cogMDXAggregate.getIntersectingMeasureRollupAggregate();
        if (rollupAggregate != null) {
            mdxSummary.setSummaryType(MDXSummaryFunctionTypeEnum.convertRollupAggregateToMDXSummaryFunctionType(rollupAggregate));
        }
        node.getParent().exchangeChildNode(node, mdxSummary, true);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (!node.validateChildCategories()) {
            this.traceNodeCondition(false, "The child nodes of the target CogMDXAggregate node are invalid.", trace);
            return false;
        }
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        if (mdxQuery == null) {
            this.traceNodeCondition(false, "The node is not within a MDXQuery node.", trace);
            return false;
        }
        boolean status = node.getNumberChildren() == 1;
        String msgStr = null;
        if (status) {
            MDXCalculatedMemberDefinition ancestorCalcDef = (MDXCalculatedMemberDefinition)node.getAncestorOfType(1005);
            CogMDXAggregate cogMDXAggregate = (CogMDXAggregate)node;
            if (ancestorCalcDef != null && mdxQuery.getHierarchyInfo().projectsMeasures() && mdxQuery.getProjectedReferences(ancestorCalcDef).size() > 0 && cogMDXAggregate.getIntersectingMeasures().isEmpty()) {
                this.traceNodeCondition(false, "The MDXQuery ptojectes measures and the 'intersectingMeasures' property have not been se yet.", trace);
                return false;
            }
            if (InsertErrorCellUpdateDecorationForNoneRollup.nodeCondition(node, null)) {
                msgStr = "Insert error cell update decoration is required first.";
                status = false;
            } else if (IntersectCogMDXAggreagateWithMeasures.nodeCondition(mdxQuery, node, null)) {
                msgStr = "Intersection with measures is required first.";
                status = false;
            } else if (DistributeMDXSummaryFunction.nodeCondition(mdxQuery, node, null)) {
                msgStr = "Aggregate distribution is required first.";
                status = false;
            } else {
                msgStr = "The CogMDXAggregate can be converted to a MDXSummaryFunction.";
            }
        } else {
            msgStr = "The CogMDXAggregate can not be converted to a MDXSummaryFunction.";
        }
        this.traceNodeCondition(status, msgStr, trace);
        return status;
    }
}

