/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.aggregation_distribution;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.localprocessing.v5.V5ResultCellUpdate;
import com.cognos.xqe.ast.olap.AbstractMDXMember;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.CogMDXAggregate;
import com.cognos.xqe.ast.olap.CogMDXGroup;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberDefinition;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberReference;
import com.cognos.xqe.ast.olap.MDXEdge;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.MDXSetAliasDefinition;
import com.cognos.xqe.ast.olap.MDXSetAliasReference;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.ast.util.ASTUtil;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.ast.v5Exp.V5RollupAggregateEnum;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.data.values.ValueState;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.ResponseMessage;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.resultset.interfaces.ICell;
import com.cognos.xqe.resultsets.ContextValue;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.rsapi.RSAPIEdgeRowset;
import com.cognos.xqe.runtree.v5.cellupdate.AbstractXV5CellUpdateRule;
import com.cognos.xqe.runtree.v5.cellupdate.XV5CellSpec;
import com.cognos.xqe.trace.XQETrace;
import java.util.Iterator;
import java.util.Set;

public class InsertErrorCellUpdateDecorationForNoneRollup
extends Transformation {
    private static final String ERROR_FINDING_COG_MDX_GROUP = "Error finding CogMDXGroup.";
    private static final String PROP_ERROR_CELL_UPDATE_DECO_ADDED = "errorCellUpdateDecoAdded";

    public InsertErrorCellUpdateDecorationForNoneRollup() {
        this.mName = "Insert cell update decoration to set error in intersections of aggregation and measure with none rollupAggregate";
        this.mPassNumbers = new int[]{28};
        this.mTypes = new int[]{1012};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        CogMDXAggregate mdxAggregate = (CogMDXAggregate)node;
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        RSAPIDataset rsapiDataset = (RSAPIDataset)mdxQuery.getAncestorOfType(401005);
        int aSeverity = 1;
        V5ResultCellUpdate cellUpdateNode = null;
        IXQEQueryNode[] nodeCellUpdate = rsapiDataset.getDescendantsOfType(601014, false);
        if (nodeCellUpdate.length == 0) {
            cellUpdateNode = (V5ResultCellUpdate)nodeFactory.createNode(601014);
            rsapiDataset.getChild(0).insertParent(cellUpdateNode);
        } else {
            cellUpdateNode = (V5ResultCellUpdate)nodeCellUpdate[0];
        }
        MDXCalculatedMemberDefinition ancestorCalcDef = (MDXCalculatedMemberDefinition)node.getAncestorOfType(1005);
        Set<IXQEQueryNode> calcRefs = mdxQuery.getProjectedReferences(ancestorCalcDef);
        for (IXQEQueryNode it : calcRefs) {
            String warningParam;
            MDXCalculatedMemberReference calcRef = (MDXCalculatedMemberReference)it;
            CogMDXGroup currGroup = (CogMDXGroup)calcRef.getAncestorOfCategory(1027);
            RSAPIEdgeRowset currRowset = currGroup.getRSAPIEdgeRowset();
            int rowSetId = currRowset.getRowsetId();
            int currentOrdinal = currRowset.getDataItemOrdinal(currGroup.getFirstRSAPIDataItem());
            MDXEdge mdEdge = (MDXEdge)calcRef.getAncestorOfType(1006);
            int currentEdgeOrdinal = mdxQuery.getEdgeOrdinal(mdEdge);
            String v5Name = (String)ancestorCalcDef.getPropertyValue("v5Name");
            XV5CellSpec aggrCellSpec = new XV5CellSpec(currentEdgeOrdinal, rowSetId, currentOrdinal, v5Name);
            AbstractXV5CellUpdateRule cellUpdateRule = new AbstractXV5CellUpdateRule(aggrCellSpec){

                @Override
                public boolean apply(ICell cell) {
                    Value v = null;
                    IValue column = cell.getValue();
                    if (column instanceof ContextValue) {
                        ContextValue cv = (ContextValue)column;
                        v = (Value)cv.getValue().copy();
                        cv.setValue(v);
                    } else {
                        v = (Value)column.copy();
                        cell.setValue(v);
                    }
                    v.setState(ValueState.ERROR);
                    return true;
                }
            };
            if (!mdxAggregate.hasExplicitMeasureContext()) {
                Set<AbstractMDXMember> intersectingMeasures = mdxAggregate.getIntersectingMeasures();
                XV5CellSpec measCellSpec = null;
                for (AbstractMDXMember currMeasure : intersectingMeasures) {
                    if (currMeasure.getRollupAggregate() != V5RollupAggregateEnum.NONE) continue;
                    CogMDXGroup ancestorGroup = (CogMDXGroup)currMeasure.getAncestorOfCategory(1027);
                    MDXEdge measEdge = (MDXEdge)currMeasure.getAncestorOfType(1006);
                    if (ancestorGroup == null) {
                        MDXSetAliasReference aliasRef;
                        MDXSetAliasDefinition aliasDef = (MDXSetAliasDefinition)currMeasure.getAncestorOfCategory(1004);
                        if (aliasDef == null) {
                            currMeasure.throwInternalError(ERROR_FINDING_COG_MDX_GROUP);
                        }
                        Iterator<MDXSetAliasReference> iterator = aliasDef.getSetAliasRefs().iterator();
                        while (iterator.hasNext() && (ancestorGroup = (CogMDXGroup)(aliasRef = iterator.next()).getAncestorOfCategory(1027)) == null) {
                        }
                        if (ancestorGroup == null) {
                            currMeasure.throwInternalError(ERROR_FINDING_COG_MDX_GROUP);
                        }
                    }
                    RSAPIEdgeRowset currMeasureRowSet = ancestorGroup.getRSAPIEdgeRowset();
                    int measEdgeOrdinal = mdxQuery.getEdgeOrdinal(measEdge);
                    int measRowSetId = currMeasureRowSet.getRowsetId();
                    int measOrdinal = currMeasureRowSet.getDataItemOrdinal(ancestorGroup.getFirstRSAPIDataItem());
                    String measV5Name = "AnyIntersectingCalculationName";
                    measCellSpec = new XV5CellSpec(measEdgeOrdinal, measRowSetId, measOrdinal, measV5Name);
                    cellUpdateRule.addIntersectingCellSpec(measCellSpec);
                    currMeasure.setRollupAggregate(V5RollupAggregateEnum.MINIMUM);
                    warningParam = ancestorGroup.getRefDataItemProperty();
                    environment.getResponseMessageFolder().appendPlanningResponseMessage(new ResponseMessage(aSeverity, ResponseMessage.ResponseMessageType.TYPE_PLAN_STAT_INT, XQEMessageKeys.PLN_AggregationTypeNone, V5RollupAggregateEnum.NONE.getName(), warningParam));
                }
            } else {
                ((AbstractMDXNode)node.getChild(1)).setRollupAggregate(V5RollupAggregateEnum.MINIMUM);
                V5ValueSet v5Valueset = (V5ValueSet)ASTUtil.getFirstNodeOfTypeFromAncestorQueryLineage(calcRef, 101057);
                warningParam = v5Valueset == null ? "" : v5Valueset.getRefDataItemProperty();
                environment.getResponseMessageFolder().appendPlanningResponseMessage(new ResponseMessage(aSeverity, ResponseMessage.ResponseMessageType.TYPE_PLAN_STAT_INT, XQEMessageKeys.PLN_AggregationTypeNone, V5RollupAggregateEnum.NONE.getName(), warningParam));
            }
            cellUpdateNode.addCellUpdateRule(cellUpdateRule);
        }
        node.setPropertyValue(PROP_ERROR_CELL_UPDATE_DECO_ADDED, Boolean.TRUE);
    }

    static boolean nodeCondition(IXQEQueryNode node, StringBuilder traceMsg) {
        if (node.getPropertyValue(PROP_ERROR_CELL_UPDATE_DECO_ADDED) != null) {
            if (traceMsg != null) {
                traceMsg.append(" Transformation InsertErrorCellUpdateDecorationForNoneRollup has been applied.");
            }
            return false;
        }
        CogMDXAggregate mdxAggregate = (CogMDXAggregate)node;
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        if (mdxQuery.getNumberOfEdges() < 2) {
            if (traceMsg != null) {
                traceMsg.append(" The query is not a crosstab.");
            }
            return false;
        }
        MDXCalculatedMemberDefinition ancestorCalcDef = (MDXCalculatedMemberDefinition)node.getAncestorOfType(1005);
        if (ancestorCalcDef != null && mdxQuery.getProjectedReferences(ancestorCalcDef).isEmpty()) {
            if (traceMsg != null) {
                traceMsg.append(" The CogMDXAggregate node is not defined in a projected calculated member.");
            }
            return false;
        }
        MDXHierInfo firstChildHierInfo = ((AbstractMDXSet)mdxAggregate.getChild(0)).getHierarchyInfo();
        if (firstChildHierInfo.projectsMeasures()) {
            if (traceMsg != null) {
                traceMsg.append(" This node is an aggregate within a set of measures.");
            }
            return false;
        }
        if (mdxAggregate.hasExplicitMeasureContext()) {
            V5RollupAggregateEnum rollupAggregate = ((AbstractMDXNode)node.getChild(1)).getRollupAggregate();
            if (rollupAggregate == V5RollupAggregateEnum.NONE) {
                if (traceMsg != null) {
                    traceMsg.append(" This CogMDXAggregate node has measure parameter whose rollupAggregate is none.");
                }
                return true;
            }
            if (traceMsg != null) {
                traceMsg.append(" This CogMDXAggregate node has measure parameter but its rollupAggregate is not none.");
            }
            return false;
        }
        if (mdxAggregate.getIntersectingMeasures().isEmpty()) {
            if (traceMsg != null) {
                traceMsg.append(" This CogMDXAggregate node has no measure parameter and does not intersect measures.");
            }
            return false;
        }
        Set<AbstractMDXMember> intersectingMeasures = mdxAggregate.getIntersectingMeasures();
        for (AbstractMDXMember currMeasure : intersectingMeasures) {
            CogMDXGroup ancestorGroup;
            if (currMeasure.getRollupAggregate() != V5RollupAggregateEnum.NONE || (ancestorGroup = (CogMDXGroup)currMeasure.getAncestorOfCategory(1027)) == null || ancestorGroup.getRSAPIEdgeRowset() == null) continue;
            if (traceMsg != null) {
                traceMsg.append(" This CogMDXAggregate node is intersecting with none rollupAggregate measures.");
            }
            return true;
        }
        if (traceMsg != null) {
            traceMsg.append(" This CogMDXAggregate node is not intersecting with none rollupAggregate measures.");
        }
        return false;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        StringBuilder traceMsg = null;
        if (trace.getTraceLevel() != 0) {
            traceMsg = new StringBuilder();
        }
        boolean status = InsertErrorCellUpdateDecorationForNoneRollup.nodeCondition(node, traceMsg);
        String traceStr = null;
        if (traceMsg != null) {
            traceStr = traceMsg.toString();
        }
        this.traceNodeCondition(status, traceStr, trace);
        return status;
    }
}

