/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.aggregation_distribution;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.AbstractMDXMember;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberDefinition;
import com.cognos.xqe.ast.olap.MDXDimensionLine;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.MDXSummaryFunction;
import com.cognos.xqe.ast.olap.MDXSummaryFunctionTypeEnum;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.util.CollectMeasuresIntersectingWithProjCalcUtil;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class SetCogMDXAggregateIntersectingMeasuresProperty
extends Transformation {
    public SetCogMDXAggregateIntersectingMeasuresProperty() {
        this.mName = "Set CogMDXAggregate 'intersectingMeasures' property.";
        this.mPassNumbers = new int[]{28};
        this.mTypes = new int[]{1012, 1060};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        MDXSummaryFunction mdxAggregate = (MDXSummaryFunction)node;
        MDXCalculatedMemberDefinition calcDef = (MDXCalculatedMemberDefinition)node.getAncestorOfType(1005);
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        Set<AbstractMDXMember> intersectingMeasures = null;
        intersectingMeasures = CollectMeasuresIntersectingWithProjCalcUtil.collectMeasuresIntersectingWithProjCalc(calcDef, mdxQuery);
        this.excludeMeasuresNotInContext(node, intersectingMeasures);
        if (intersectingMeasures.isEmpty()) {
            intersectingMeasures.add(mdxQuery.getQueryDefaultMeasure());
        }
        mdxAggregate.setIntersectingMeasures(intersectingMeasures);
    }

    private void excludeMeasuresNotInContext(IXQEQueryNode node, Set<AbstractMDXMember> intersectingMeasures) {
        IXQEQueryNode parent = node.getParent();
        if (parent.isOfCategory(1085) && parent.getChild(2) == node) {
            IXQEQueryNode[] listIS = node.getAncestorsOfType(1085);
            block0: for (int i = 0; i < listIS.length; ++i) {
                IXQEQueryNode current = listIS[i];
                if (!current.getChild(0).isOfCategory(1091)) continue;
                Iterator<AbstractMDXMember> it = intersectingMeasures.iterator();
                while (it.hasNext()) {
                    if (!it.next().isSameExpression(current.getChild(0).getChild(1), false)) continue;
                    it.remove();
                    continue block0;
                }
            }
        }
        Iterator<AbstractMDXMember> it = intersectingMeasures.iterator();
        while (it.hasNext()) {
            AbstractMDXMember measure = it.next();
            if (!measure.isValueExpressionForSpecificAggregation()) continue;
            it.remove();
        }
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (node.getAncestorOfType(1005) == null) {
            StringBuilder msgStr = new StringBuilder("The ancestor node is");
            msgStr.append(" ");
            msgStr.append("not");
            msgStr.append(" ");
            msgStr.append("a MDXCalculatedMemberDefinition node.");
            this.traceNodeCondition(false, msgStr.toString(), trace);
            return false;
        }
        boolean status = false;
        StringBuilder msgStr = new StringBuilder("The node is");
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        if (mdxQuery == null) {
            msgStr.append(" ");
            msgStr.append("not");
            msgStr.append(" ");
            msgStr.append("within a MDXQuery node.");
            status = false;
            this.traceNodeCondition(status, msgStr.toString(), trace);
            return status;
        }
        msgStr.append(" ");
        msgStr.append("within a MDXQuery node.");
        status = true;
        String s1 = "The MDXQuery node does";
        boolean includeSelf = false;
        IXQEQueryNode[] v5Edges = mdxQuery.getDescendantsOfType(101049, includeSelf);
        if (v5Edges.length != 0) {
            msgStr.append(" ");
            msgStr.append("The MDXQuery node does");
            msgStr.append(" ");
            msgStr.append("contain V5Edge nodes. It is not ready yet.");
            this.traceNodeCondition(false, msgStr.toString(), trace);
            return false;
        }
        String s2 = "project measures.";
        if (mdxQuery.getHierarchyInfo().projectsMeasures()) {
            msgStr.append(" ");
            msgStr.append("The MDXQuery node does");
            msgStr.append(" ");
            msgStr.append("project measures.");
            status = true;
        } else {
            msgStr.append(" ");
            msgStr.append("The MDXQuery node does");
            msgStr.append(" ");
            msgStr.append("not");
            msgStr.append(" ");
            msgStr.append("project measures.");
            status = false;
        }
        this.traceNodeCondition(status, msgStr.toString(), trace);
        return status;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        MDXCalculatedMemberDefinition calcDef;
        XQETrace trace = environment.getTrace();
        MDXSummaryFunction mdxAggregate = (MDXSummaryFunction)node;
        if (!node.validateChildCategories()) {
            this.traceNodeCondition(false, "The children of the target CogMDXAggregate node are invalid.", trace);
            return false;
        }
        if (mdxAggregate.getSummaryType() != MDXSummaryFunctionTypeEnum.AGGREGATE) {
            this.traceNodeCondition(false, "Summary node is not an AGGRERGATE.", trace);
            return false;
        }
        if (mdxAggregate.hasExplicitMeasureContext()) {
            this.traceNodeCondition(false, " The CogMDXAggregate node has explicit measure context.", trace);
            return false;
        }
        if (mdxAggregate.getIntersectingMeasures().size() > 0) {
            this.traceNodeCondition(false, "The intersecting measures property has already been set.", trace);
            return false;
        }
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        if (mdxQuery.getProjectedReferences(calcDef = (MDXCalculatedMemberDefinition)node.getAncestorOfType(1005)).size() == 0) {
            MDXDimensionLine dimLine;
            boolean valid = false;
            if (!node.isOfCategory(1012) && (dimLine = mdxQuery.getDimensionLine()) != null) {
                HashSet<IXQEQueryNode> calcRefs = new HashSet<IXQEQueryNode>();
                dimLine.getProjectedReference(calcRefs, calcDef);
                boolean bl = valid = calcRefs.size() != 0;
            }
            if (!valid) {
                this.traceNodeCondition(false, " The CogMDXAggregate node is not projected.", trace);
                return false;
            }
        }
        this.traceNodeCondition(true, " The CogMDXAggregate node is projected.", trace);
        return true;
    }
}

