/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.aggregation_distribution;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.AbstractMDXMember;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.BaseMember;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberDefinition;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberReference;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.MDXSummaryFunction;
import com.cognos.xqe.ast.olap.MDXSummaryFunctionTypeEnum;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.util.SolveOrderUtil;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class SetMDXSummaryFunctionType
extends Transformation {
    public SetMDXSummaryFunctionType() {
        this.mName = "Change MDXSummaryFunction type from aggregate to type provided by measure aggregation rule.";
        this.mPassNumbers = new int[]{28};
        this.mTypes = new int[]{1060};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        MDXSummaryFunctionTypeEnum aggregateType = this.findAggregateType((MDXSummaryFunction)node, null);
        ((MDXSummaryFunction)node).setSummaryType(aggregateType);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        node.throwOnInvalidChildCategories();
        if (((MDXSummaryFunction)node).getSummaryType() != MDXSummaryFunctionTypeEnum.AGGREGATE) {
            this.traceNodeCondition(false, "This node's type is not aggregate.", trace);
            return false;
        }
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        if (!(mdxQuery.getDataSourceType().equals("BW") || mdxQuery.getDataSourceType().equals("EB") || mdxQuery.getDataSourceType().equals("DO") || mdxQuery.getDataSourceType().equals("TM") || mdxQuery.getDataSourceType().equals("TMR"))) {
            this.traceNodeCondition(false, "This transformation is only applicable for SAP, Essbase and TM1.", trace);
            return false;
        }
        StringBuilder traceMsg = new StringBuilder();
        MDXSummaryFunctionTypeEnum aggregateType = this.findAggregateType((MDXSummaryFunction)node, traceMsg);
        if (aggregateType == MDXSummaryFunctionTypeEnum.SUM || aggregateType == MDXSummaryFunctionTypeEnum.MAXIMUM || aggregateType == MDXSummaryFunctionTypeEnum.MINIMUM) {
            this.traceNodeCondition(true, "Aggregate type for measure in context is a single associative measure", trace);
            return true;
        }
        if (mdxQuery.getDataSourceType().equals("BW") && aggregateType != MDXSummaryFunctionTypeEnum.UNDEFINED_SUMMARY_TYPE && aggregateType != MDXSummaryFunctionTypeEnum.AGGREGATE) {
            this.traceNodeCondition(true, "Non associative aggregate type can be converted for SAP", trace);
            return true;
        }
        this.traceNodeCondition(false, "Aggregate type for measure in context is not a single associative measure", trace);
        return false;
    }

    private MDXSummaryFunctionTypeEnum findAggregateType(MDXSummaryFunction node, StringBuilder traceMsg) {
        MDXSummaryFunctionTypeEnum aggregateType = MDXSummaryFunctionTypeEnum.UNDEFINED_SUMMARY_TYPE;
        List<AbstractMDXNode> members = ((AbstractMDXSet)node.getChild(0)).getDescendantsOfCategory(1067, true, true, true, true, true);
        for (int i = 0; i < members.size(); ++i) {
            AbstractMDXMember member = (AbstractMDXMember)members.get(i);
            if (member.getHierarchy().getDimension().getMembersRollup()) continue;
            return aggregateType;
        }
        Set<AbstractMDXMember> measures = null;
        if (node.getNumberChildren() >= 2) {
            int[] types = new int[]{1067, 1013};
            IXQEQueryNode[] baseMembers = node.getChild(1).getDescendantsOfTypes(types, false);
            for (int i = 0; i < baseMembers.length; ++i) {
                AbstractMDXMember member = (AbstractMDXMember)baseMembers[i];
                if (!member.getHierarchy().getDimension().isMeasuresDimension()) continue;
                if (measures == null) {
                    measures = new HashSet<AbstractMDXMember>();
                }
                measures.add(member);
            }
        }
        if (measures == null && ((measures = node.getIntersectingMeasures()) == null || measures.isEmpty())) {
            if (traceMsg != null) {
                traceMsg.append("No value expression and no intersecting measures.");
            }
            return MDXSummaryFunctionTypeEnum.UNDEFINED_SUMMARY_TYPE;
        }
        MDXCalculatedMemberDefinition ancestorCalcDef = (MDXCalculatedMemberDefinition)node.getAncestorOfType(1005);
        int solveOrder = SolveOrderUtil.getMaxMDXSolveOrder();
        if (ancestorCalcDef != null) {
            solveOrder = ancestorCalcDef.getSolveOrder();
        }
        Iterator<AbstractMDXMember> it = measures.iterator();
        AbstractMDXMember firstMeasure = null;
        MDXHierInfo hierInfo = ((AbstractMDXNode)node.getChild(0)).getHierarchyInfo();
        while (it.hasNext()) {
            AbstractMDXMember measure = it.next();
            if (measure.getType() == 1013) {
                if (((MDXCalculatedMemberReference)measure).getSolveOrder() > solveOrder) continue;
                IXQEQueryNode valueExpr = ((MDXCalculatedMemberReference)measure).getDefinition().getChild(0);
                if (valueExpr.getType() != 1087) {
                    if (traceMsg != null) {
                        traceMsg.append("The calculation: '");
                        traceMsg.append(((MDXCalculatedMemberReference)measure).getUniqueName());
                        traceMsg.append("' intersects this AGGREGATE and has a lower solve order. ");
                        traceMsg.append("  Calculations do not have aggregation rules.");
                    }
                    return MDXSummaryFunctionTypeEnum.UNDEFINED_SUMMARY_TYPE;
                }
                if (firstMeasure == null) {
                    aggregateType = MDXSummaryFunctionTypeEnum.SUM;
                    firstMeasure = measure;
                } else if (aggregateType != MDXSummaryFunctionTypeEnum.SUM) {
                    if (traceMsg != null) {
                        traceMsg.append(" The aggregate rule of measure : '");
                        traceMsg.append(((MDXCalculatedMemberReference)measure).getUniqueName());
                        traceMsg.append("' is different from the aggregate rule of the fist measure.");
                    }
                    aggregateType = MDXSummaryFunctionTypeEnum.UNDEFINED_SUMMARY_TYPE;
                    break;
                }
            }
            if (measure.getType() != 1067) continue;
            MDXSummaryFunctionTypeEnum aggregateTypeOfThisMeasure = ((BaseMember)measure).getSummaryFunctionType(hierInfo);
            if (firstMeasure == null) {
                aggregateType = aggregateTypeOfThisMeasure;
                firstMeasure = measure;
                continue;
            }
            if (aggregateType == aggregateTypeOfThisMeasure) continue;
            if (traceMsg != null) {
                traceMsg.append(" The aggregate rule of measure: '");
                traceMsg.append(((BaseMember)measure).getUniqueName());
                traceMsg.append("' is : '");
                traceMsg.append(((BaseMember)measure).getMeasureAggregateRuleForGivenSet(hierInfo).getModelName());
                traceMsg.append("', that is different from the aggregate rule of the fist measure.");
            }
            aggregateType = MDXSummaryFunctionTypeEnum.UNDEFINED_SUMMARY_TYPE;
            break;
        }
        if (traceMsg != null) {
            if (aggregateType == MDXSummaryFunctionTypeEnum.UNDEFINED_SUMMARY_TYPE) {
                traceMsg.append("Impossible to find an explicit aggregation rule. ");
            } else {
                traceMsg.append("All measures for MDXSummary node of type AGGREGATE have the same aggregation rule. ");
            }
        }
        return aggregateType;
    }
}

