/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.axisgeneration;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.CogMDXGroup;
import com.cognos.xqe.ast.olap.MDXSet;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;

public final class RemoveCogMDXGroupWhenNotRequired
extends Transformation {
    public RemoveCogMDXGroupWhenNotRequired() {
        this.mName = "Remove CogMDXGroup when not required.";
        this.mPassNumbers = new int[]{39};
        this.mTypes = new int[]{1027};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        CogMDXGroup targetCogMDXGroup = (CogMDXGroup)node;
        AbstractMDXSet abstractMDXSet = (AbstractMDXSet)targetCogMDXGroup.getChild(0);
        if (abstractMDXSet.getType() == 1039) {
            ((MDXSet)abstractMDXSet).setDoNotOptimizeMDXSetWithinMDXSet(true);
        }
        targetCogMDXGroup.extract();
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        boolean status = false;
        String msgStr = null;
        IXQEQueryNode mdxQuery = node.getAncestorOfType(1002);
        if (mdxQuery == null) {
            msgStr = "The node is not within a MDXQuery node.";
            status = false;
        } else {
            msgStr = "The node is within a MDXQuery node.";
            status = true;
        }
        this.traceQueryCondition(status, msgStr, trace);
        return status;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        IXQEQueryNode[] cogMDXGroups = node.getAncestorsOfType(1027);
        for (int i = 0; i < cogMDXGroups.length; ++i) {
            boolean sameHierApplied;
            if (!((CogMDXGroup)cogMDXGroups[i]).isProjectedDescendant((CogMDXGroup)node)) continue;
            boolean diffHierApplied = cogMDXGroups[i].getPropertyValue("PrepareOuterNestedGroupDiffHierarchyApplied") != Boolean.TRUE;
            boolean bl = sameHierApplied = cogMDXGroups[i].getPropertyValue("PrepareOuterNestedGroupSameHierarchyApplied") != Boolean.TRUE;
            if (!diffHierApplied || !sameHierApplied) continue;
            this.traceNodeCondition(false, "The target CogMDXGroup node is nested under a CogMDXGroup node that has not yet been transformed by PrepareNestedGroupDifferentHierarchy or PrepareNestedGroupSameHierarchy.", trace);
            return false;
        }
        if (node.getNumberChildren() != 1) {
            this.traceNodeCondition(false, "The CogMDXGroup node does have 1 child node.", trace);
            return false;
        }
        if (!node.getChild(0).isOfCategory(1021)) {
            this.traceNodeCondition(false, "The first child node is not an AbstractMDXSet instance.", trace);
            return false;
        }
        if (node.getChild(0).isValidPlannedQuery() != -1) {
            this.traceNodeCondition(false, "The first child node contains unresolved CogMDX/Transformation nodes.", trace);
            return false;
        }
        this.traceNodeCondition(true, "The CogMDXGroup node is no longer required.", trace);
        return true;
    }
}

