/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.decoration;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQEBaseQueryNode;
import com.cognos.xqe.ast.localprocessing.OLAPEdgeDecoration;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;

public class OrderEdgeDecorationsByEdgeAndTupleOrdinal
extends Transformation {
    public OrderEdgeDecorationsByEdgeAndTupleOrdinal() {
        this.mName = "Order the hierarchy decoration as per edge dependency.";
        this.mPassNumbers = new int[]{31};
        this.mTypes = new int[]{601009};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        int idx;
        OLAPEdgeDecoration targetDeco = (OLAPEdgeDecoration)node;
        int targetEdgeOrdinal = targetDeco.getEdgeOrdinalProperty();
        IXQEQueryNode[] ancestorDecos = targetDeco.getAncestorsOfCategory(601008);
        XQEBaseQueryNode ancestorToSwapWith = null;
        int[] skipTypes = new int[]{601012, 601018};
        OLAPEdgeDecoration emptyValueSetDeco = null;
        for (IXQEQueryNode currentDeco : ancestorDecos) {
            int ancestorEdgeOrdinal;
            OLAPEdgeDecoration ancestorDeco = (OLAPEdgeDecoration)currentDeco;
            if (ancestorDeco.isOfTypes(skipTypes)) {
                if (targetDeco.getParent() != ancestorDeco || !ancestorDeco.isOfCategory(601018)) continue;
                emptyValueSetDeco = ancestorDeco;
                continue;
            }
            if (ancestorDeco.getIsGroupedDecoration() || targetEdgeOrdinal < (ancestorEdgeOrdinal = ancestorDeco.getEdgeOrdinalProperty()) || targetEdgeOrdinal <= ancestorEdgeOrdinal && this.compareTupleOrdinal(targetDeco, ancestorDeco) != 1) continue;
            ancestorToSwapWith = ancestorDeco;
        }
        IXQEQueryNode[] targetNodeChildren = targetDeco.getChildren();
        for (int idx2 = 1; idx2 < targetNodeChildren.length; ++idx2) {
            targetDeco.detachChild(1);
        }
        IXQEQueryNode[] ancestorToSwapWithChildren = ancestorToSwapWith.getChildren();
        for (idx = 1; idx < ancestorToSwapWithChildren.length; ++idx) {
            ancestorToSwapWith.detachChild(1);
        }
        targetDeco.extract();
        ancestorToSwapWith.insertParent(targetDeco);
        if (emptyValueSetDeco != null) {
            emptyValueSetDeco.extract();
            targetDeco.insertParent(emptyValueSetDeco);
        }
        for (idx = 1; idx < targetNodeChildren.length; ++idx) {
            targetDeco.addChild(targetNodeChildren[idx]);
        }
        for (idx = 1; idx < ancestorToSwapWithChildren.length; ++idx) {
            if (ancestorToSwapWithChildren[idx] == targetDeco) continue;
            ancestorToSwapWith.addChild(ancestorToSwapWithChildren[idx]);
        }
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        OLAPEdgeDecoration currentDeco = (OLAPEdgeDecoration)node;
        if (currentDeco.getIsGroupedDecoration()) {
            this.traceQueryCondition(false, "The hierarchy decoration is grouped within another decoration. Nothing to do.", trace);
            return false;
        }
        int currentEdgeOrdinal = currentDeco.getEdgeOrdinalProperty();
        int[] skipTypes = new int[]{601012, 601018};
        IXQEQueryNode[] parentDecos = node.getAncestorsOfCategory(601008);
        for (int idx = 0; idx < parentDecos.length; ++idx) {
            int parentEdgeOrdinal;
            OLAPEdgeDecoration parentDeco = (OLAPEdgeDecoration)parentDecos[idx];
            if (parentDeco.isOfTypes(skipTypes) || parentDeco.getIsGroupedDecoration() || currentEdgeOrdinal < (parentEdgeOrdinal = parentDeco.getEdgeOrdinalProperty())) continue;
            if (currentEdgeOrdinal > parentEdgeOrdinal) {
                this.traceQueryCondition(true, "There is at least one parent decoration using lower edge ordinal.", trace);
                return true;
            }
            int r = this.compareTupleOrdinal(currentDeco, parentDeco);
            if (r != 1) continue;
            this.traceQueryCondition(true, "There is at least one parent decoration using lower tuple ordinal for the edge this decrotation is for.", trace);
            return true;
        }
        this.traceQueryCondition(false, "The decoration related to the current edge already in proper order.", trace);
        return false;
    }

    protected int compareTupleOrdinal(OLAPEdgeDecoration src, OLAPEdgeDecoration target) {
        int targetTupleOrdinal;
        int r = 0;
        int srcTupleOrdinal = src.getTupleOrdinalProperty();
        if (srcTupleOrdinal == (targetTupleOrdinal = target.getTupleOrdinalProperty())) {
            return r;
        }
        r = srcTupleOrdinal > targetTupleOrdinal ? 1 : -1;
        return r;
    }
}

