/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.edgemapping;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.CogMDXGroup;
import com.cognos.xqe.ast.olap.CogMDXReportSummary;
import com.cognos.xqe.ast.olap.MDXEdge;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.runtree.olap.edgemapping.AbstractOLAPColumn;
import com.cognos.xqe.runtree.olap.edgemapping.OLAPContextColumn;
import com.cognos.xqe.runtree.olap.edgemapping.OLAPEdgeMappingException;
import com.cognos.xqe.runtree.olap.edgemapping.OLAPRow;
import com.cognos.xqe.runtree.olap.edgemapping.OLAPRowCycle;
import com.cognos.xqe.runtree.olap.edgemapping.XOLAPEdgeMapping;
import com.cognos.xqe.runtree.olap.edgemapping.edgeelementfactory.EdgeElementFactory;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.edgemapping.BuildXOLAPEdgeMappingUtilities;
import java.util.List;

public class BuildOLAPRowCycleForSameHierNested
extends Transformation {
    public BuildOLAPRowCycleForSameHierNested() {
        this.mName = "This transformation builds an OLAPRowCycle node for a CogMDXGroup nesting the same hierarchy.";
        this.mPassNumbers = new int[]{35};
        this.mTypes = new int[]{1027, 1080};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        CogMDXGroup ancestorGroup;
        CogMDXGroup cogMDXGroup = (CogMDXGroup)node;
        MDXEdge mdxEdge = (MDXEdge)cogMDXGroup.getAncestorOfType(1006);
        XOLAPEdgeMapping xOLAPEdgeMapping = mdxEdge.getXOLAPEdgeMapping();
        EdgeElementFactory edgeElementFactory = environment.getEdgeElementFactory();
        OLAPRowCycle rowCycle = BuildXOLAPEdgeMappingUtilities.createRowCycle(xOLAPEdgeMapping, edgeElementFactory);
        BuildXOLAPEdgeMappingUtilities.createAbstractOLAPColumn(3, cogMDXGroup, mdxEdge, edgeElementFactory, -1, cogMDXGroup.getFirstRSAPIDataItem(), rowCycle);
        IXQEQueryNode setAliasDef = cogMDXGroup.getAncestorOfCategory(1004);
        if (setAliasDef != null && setAliasDef.getParent().getType() == 1030 && BuildXOLAPEdgeMappingUtilities.isDefaultMemberSet((AbstractMDXSet)setAliasDef.getParent().getChild(1))) {
            AbstractOLAPColumn column = (AbstractOLAPColumn)edgeElementFactory.createEdgeElementByType(2);
            AbstractMDXSet dmSet = (AbstractMDXSet)setAliasDef.getParent().getChild(1);
            IHierarchy hierarchy = dmSet.getHierarchyInfo().getProjectedHierarchy(0);
            column.setHierarchy(hierarchy);
            column.addRule(hierarchy, 3);
            column.addRemoveAction(edgeElementFactory);
            int aTuplePosition = mdxEdge.getHierarchyInfo().getProjectedHierarchyIndex(hierarchy);
            column.setTuplePosition(aTuplePosition);
            column.setAbstractMDXSetProperties(dmSet);
            column.setHierarchyNormalization(true);
            dmSet.setAbstractOLAPColumn(column);
            OLAPRow row = (OLAPRow)edgeElementFactory.createEdgeElementByType(0);
            row.addColumn(column, true);
            BuildXOLAPEdgeMappingUtilities.createSameAsContextCurrentMemberColumn(edgeElementFactory, cogMDXGroup, (OLAPContextColumn)rowCycle.getFirstColumn(), row, mdxEdge);
            rowCycle.addRow(row, true);
        }
        if ((ancestorGroup = (CogMDXGroup)cogMDXGroup.getAncestorOfCategory(1027)) == null) {
            xOLAPEdgeMapping.addRow(rowCycle, false);
        } else {
            AbstractOLAPColumn ancestorColumn;
            IHierarchy hierarchy = cogMDXGroup.getFirstSetHierarchy();
            if (hierarchy.equals(ancestorGroup.getFirstSetHierarchy()) && (ancestorColumn = ancestorGroup.getFirstAbstractOLAPColumn()) != null && ancestorColumn.getParentRow() != null) {
                if (!ancestorColumn.getParentRow().isCycle()) {
                    throw new OLAPEdgeMappingException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "!ancestorColumn.getParentRow().isCycle()");
                }
                OLAPRowCycle ancestorRowCycle = (OLAPRowCycle)ancestorColumn.getParentRow();
                ancestorRowCycle.addRow(rowCycle, false);
            }
        }
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        CogMDXGroup detailGroup;
        AbstractOLAPColumn detailGroupColumn;
        IXQEQueryNode detailExpr;
        XQETrace trace = environment.getTrace();
        CogMDXGroup cogMDXGroup = (CogMDXGroup)node;
        MDXEdge mdxEdge = (MDXEdge)cogMDXGroup.getAncestorOfType(1006);
        if (mdxEdge == null) {
            this.traceQueryCondition(false, "The target CogMDXGroup is not under a MDXEdge node.", trace);
            return false;
        }
        if (mdxEdge.getXOLAPEdgeMapping() == null) {
            this.traceQueryCondition(false, "The target MDXEdge has not yet an associated XOLAPEdgeMapping.", trace);
            return false;
        }
        if (cogMDXGroup.isGenerateContextRequired().booleanValue()) {
            this.traceNodeCondition(false, "GenerateContext action is required for this hierarchy.", trace);
            return false;
        }
        if (cogMDXGroup.getAbstractOLAPColumnList() != null) {
            this.traceNodeCondition(false, "This trasformation was applied already.", trace);
            return false;
        }
        if (cogMDXGroup.getNumberChildren() == 1) {
            this.traceQueryCondition(false, "The target CogMDXGroup is not nesting a set.", trace);
            return false;
        }
        if (!mdxEdge.isProjectedDescendant(cogMDXGroup)) {
            this.traceQueryCondition(false, "The target CogMDXGroup is not projected by its ancestor MDXEdge node.", trace);
            return false;
        }
        if (cogMDXGroup.getType() == 1080 && (detailExpr = ((CogMDXReportSummary)cogMDXGroup).getDetailExpr()) != null && detailExpr.getType() == 1027 && (detailGroupColumn = (detailGroup = (CogMDXGroup)detailExpr).getFirstAbstractOLAPColumn()) == null && !detailGroup.isGenerateContextRequired().booleanValue()) {
            this.traceQueryCondition(false, "The target CogMDXReportSummary is not ready yet.", trace);
            return false;
        }
        this.traceNodeCondition(true, "This transformation is applicable.", trace);
        return true;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        AbstractMDXSet secondChild;
        XQETrace trace = environment.getTrace();
        CogMDXGroup cogMDXGroup = (CogMDXGroup)node;
        String reason = "The target CogMDXGroup projects an empty set.";
        if (cogMDXGroup.getChild(0).getType() == 1145) {
            this.traceNodeCondition(false, "The target CogMDXGroup projects an empty set.", trace);
            return false;
        }
        IHierarchy hierarchy = cogMDXGroup.getFirstSetHierarchy();
        if (!hierarchy.equals((secondChild = (AbstractMDXSet)cogMDXGroup.getChild(1)).getHierarchyInfo().getProjectedHierarchy(0))) {
            this.traceQueryCondition(false, "The target CogMDXGroup is not nesting a set of the same hierarchy.", trace);
            return false;
        }
        List<IXQEQueryNode> descendantGroups = secondChild.getDescendantsOfCategory(1027, true);
        int emptySameHierProjDescendantGroupCount = 0;
        int sameHierProjDescendantGroupCount = 0;
        for (IXQEQueryNode descendantGroup : descendantGroups) {
            CogMDXGroup currGroup = (CogMDXGroup)descendantGroup;
            if (!cogMDXGroup.isProjectedDescendant(currGroup) || !hierarchy.equals(currGroup.getFirstSetHierarchy())) continue;
            ++sameHierProjDescendantGroupCount;
            if (currGroup.getChild(0).getDescendantsOfType(1145, true).length > 0) {
                ++emptySameHierProjDescendantGroupCount;
                continue;
            }
            if (currGroup.getFirstAbstractOLAPColumn() != null || currGroup.isGenerateContextRequired().booleanValue()) continue;
            this.traceNodeCondition(false, "A nested CogMDXGroup is not ready yet.", trace);
            return false;
        }
        if (sameHierProjDescendantGroupCount == emptySameHierProjDescendantGroupCount) {
            this.traceNodeCondition(false, "The target CogMDXGroup projects an empty set.", trace);
            return false;
        }
        this.traceNodeCondition(true, "The target CogMDXGroup is nesting a set of the same hierarchy.", trace);
        return true;
    }
}

