/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.edgemapping;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.CogMDXGroup;
import com.cognos.xqe.ast.olap.MDXEdge;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.runtree.olap.edgemapping.AbstractOLAPRow;
import com.cognos.xqe.runtree.olap.edgemapping.OLAPColumn;
import com.cognos.xqe.runtree.olap.edgemapping.OLAPContextColumn;
import com.cognos.xqe.runtree.olap.edgemapping.OLAPRow;
import com.cognos.xqe.runtree.olap.edgemapping.OLAPRowCycle;
import com.cognos.xqe.runtree.olap.edgemapping.XOLAPEdgeMapping;
import com.cognos.xqe.runtree.olap.edgemapping.actions.ActionFactory;
import com.cognos.xqe.runtree.olap.edgemapping.actions.LockContextColumn;
import com.cognos.xqe.runtree.olap.edgemapping.actions.Remove;
import com.cognos.xqe.runtree.olap.edgemapping.edgeelementfactory.EdgeElementFactory;
import com.cognos.xqe.trace.XQETrace;
import java.util.Set;

public class BuildTagForOverlappingContextColumn
extends Transformation {
    public static final String BUILDTAGFOROVERLAPPINGCONTEXTCOLUMN_APPLIED = "BuildTagForOverlappingContextColumnApplied";

    public BuildTagForOverlappingContextColumn() {
        this.mName = "Build tags between overlapping columns of a single hierarchy edge";
        this.mPassNumbers = new int[]{36};
        this.mTypes = new int[]{1006};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode[] groups;
        MDXEdge mdxEdge = (MDXEdge)node;
        for (IXQEQueryNode group : groups = mdxEdge.getDescendantsOfType(1027, false)) {
            CogMDXGroup cogMDXGroup = (CogMDXGroup)group;
            if (!mdxEdge.isProjectedDescendant(cogMDXGroup) || !this.isTaggingRequired(cogMDXGroup)) continue;
            OLAPContextColumn cogMDXGroupColumn = (OLAPContextColumn)cogMDXGroup.getAbstractOLAPColumnList().get(0);
            int aTuplePosition = mdxEdge.getHierarchyInfo().getProjectedHierarchyIndex(cogMDXGroupColumn.getHierarchy());
            EdgeElementFactory edgeElementFactory = environment.getEdgeElementFactory();
            OLAPRow tagRow = (OLAPRow)edgeElementFactory.createEdgeElementByType(0);
            Remove remove = new Remove();
            tagRow.addAction(remove);
            OLAPColumn aColumn = (OLAPColumn)edgeElementFactory.createEdgeElementByType(2);
            aColumn.setTuplePosition(aTuplePosition);
            aColumn.setHierarchy(cogMDXGroupColumn.getHierarchy());
            aColumn.setAbstractMDXSetProperties(cogMDXGroup);
            if (aColumn.getRules().getIsReportHierarchy() == null) {
                Set<IHierarchy> reportHierarchies = mdxEdge.getReportHierarchies();
                aColumn.getRules().setReportHierarchy(reportHierarchies.contains(cogMDXGroupColumn.getHierarchy()));
            }
            tagRow.addColumn(aColumn, false);
            tagRow.setTag(true);
            ActionFactory actionFactory = edgeElementFactory.getActionFactory();
            LockContextColumn lockContextColumn = (LockContextColumn)actionFactory.createActionByType(5);
            lockContextColumn.setTargetId(cogMDXGroupColumn.getId());
            lockContextColumn.setTargetClassName(cogMDXGroupColumn.getClass().getName());
            tagRow.addAction(lockContextColumn);
            OLAPRowCycle rowCycle = (OLAPRowCycle)cogMDXGroupColumn.getParentRow().getParentRow();
            rowCycle.insertRow(tagRow, rowCycle.indexOf(cogMDXGroupColumn.getParentRow()));
            cogMDXGroup.setPropertyValue("tagTypeReq", "eachTuple");
        }
        mdxEdge.setPropertyValue(BUILDTAGFOROVERLAPPINGCONTEXTCOLUMN_APPLIED, Boolean.TRUE);
    }

    public boolean isTaggingRequired(CogMDXGroup cogMDXGroup) {
        if (cogMDXGroup.getHierarchyInfo().getNumProjectedHierarchies() > 1) {
            return false;
        }
        String value = (String)cogMDXGroup.getPropertyValue("tagTypeReq");
        if (value != null && value.equals("eachTuple")) {
            return false;
        }
        if (cogMDXGroup.getChild(0).getType() == 1145) {
            return false;
        }
        if (cogMDXGroup.getAbstractOLAPColumnList() == null || !cogMDXGroup.getAbstractOLAPColumnList().get(0).isContext()) {
            return false;
        }
        OLAPContextColumn cogMDXGroupColumn = (OLAPContextColumn)cogMDXGroup.getAbstractOLAPColumnList().get(0);
        OLAPRowCycle rowCycle = (OLAPRowCycle)cogMDXGroupColumn.getParentRow();
        int numberOfRows = rowCycle.getNumberOfRows();
        for (int i = 0; i < numberOfRows; ++i) {
            AbstractOLAPRow currentRow = rowCycle.getRow(i);
            if (!currentRow.getFirstColumn().getRules().overlaps(cogMDXGroupColumn.getRules())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        MDXEdge mdxEdge = (MDXEdge)node;
        XOLAPEdgeMapping edgeMapping = mdxEdge.getXOLAPEdgeMapping();
        if (edgeMapping == null || edgeMapping.getRootRowCycle() == null) {
            this.traceNodeCondition(false, "Associated XOLAPEdgeMapping node is not found or initialized.", trace);
            return false;
        }
        if (edgeMapping.getRootRowCycle().getNumberOfRows() == 0) {
            this.traceNodeCondition(false, "Associated XOLAPEdgeMapping is empty.", trace);
            return false;
        }
        if (node.getPropertyValue(BUILDTAGFOROVERLAPPINGCONTEXTCOLUMN_APPLIED) != null) {
            this.traceNodeCondition(false, "BuildTagBetweenOverlappingPaths was applied already.", trace);
            return false;
        }
        MDXQuery mdxQuery = (MDXQuery)mdxEdge.getAncestorOfType(1002);
        String queryDataSource = mdxQuery.getDataSourceType();
        String propValue = "RebuildMUNRulesForPowerCubeRootAliasesApplied";
        if (queryDataSource.equals("PC") && mdxEdge.getPropertyValue("RebuildMUNRulesForPowerCubeRootAliasesApplied") != Boolean.TRUE) {
            this.traceNodeCondition(false, "This transformation is not applicable yet.", trace);
            return false;
        }
        this.traceNodeCondition(true, "This transformation is applicable.", trace);
        return true;
    }
}

