/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.edgemapping;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.CogMDXGroup;
import com.cognos.xqe.ast.olap.MDXEdge;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.util.MDXLevelInfo;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.exception.XQEMessage;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMeasure;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IProperty;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.rsapi.RSAPIDataItem;
import com.cognos.xqe.rsapi.RSAPIEdgeRowset;
import com.cognos.xqe.runtree.olap.edgemapping.AbstractOLAPColumn;
import com.cognos.xqe.trace.XQETrace;
import java.util.ArrayList;
import java.util.List;

public class DetectIncompatibleNestingSameHierarchy
extends Transformation {
    protected static final String TRANSFORMATION_APPLIED = "DetectIncompatibleNestingSameHierarchyApplied";

    public DetectIncompatibleNestingSameHierarchy() {
        this.mName = "Detect incompatible cases of same hierarchy nesting.";
        this.mPassNumbers = new int[]{36};
        this.mTypes = new int[]{1006};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        node.setPropertyValue(TRANSFORMATION_APPLIED, Boolean.TRUE);
        MDXEdge mdxEdge = (MDXEdge)node;
        List<IXQEQueryNode> groups = mdxEdge.getDescendantsOfCategory(1027, false);
        ArrayList<CogMDXGroup> leafGroups = new ArrayList<CogMDXGroup>();
        for (IXQEQueryNode group : groups) {
            if (group.getNumberChildren() != 1 || !mdxEdge.isProjectedDescendant((CogMDXGroup)group)) continue;
            leafGroups.add((CogMDXGroup)group);
        }
        boolean masterDetailCase = false;
        for (CogMDXGroup leafGroup : leafGroups) {
            MDXQuery mdxQuery;
            IDataSourceCapabilities capabilities;
            IHierarchy hierarchy;
            if (!masterDetailCase && leafGroup.getFirstAbstractOLAPColumn() != null) {
                RSAPIEdgeRowset rowset = leafGroup.getFirstAbstractOLAPColumn().getRowset();
                boolean bl = masterDetailCase = rowset != null && rowset.getNestedRowset() != null && rowset.getNestedRowset().isEmpty() && rowset.getNestedRowset().getHeaderRowset() != null && rowset.getNestedRowset().getHeaderRowset().isEmpty();
            }
            if ((hierarchy = this.compatibleNesting(leafGroup, masterDetailCase)) == null || (capabilities = (mdxQuery = (MDXQuery)mdxEdge.getAncestorOfType(1002)).getCapabilities()).isSupported("v5.reportermode.incompatibleNestingSameHierarchy")) continue;
            XQEMessage message = new XQEMessage(XQEMessageKeys.PLN_UnsupportedIncompatipleNestingSameHierarchy, hierarchy.getName(), node);
            throw new XQERuntimeException(message);
        }
    }

    protected void getGroupMinMaxLevel(CogMDXGroup cogMDXGroup, int[] minMax) {
        MDXLevelInfo firstChildLevelInfo;
        int[] types;
        IXQEQueryNode[] nodes;
        boolean bUseLowestLevel = false;
        AbstractMDXSet firstChild = (AbstractMDXSet)cogMDXGroup.getChild(0);
        if (firstChild.projectsOnlyAscendantsOrDescendantsOfCurrentMember(true) && (nodes = firstChild.getDescendantsOfTypes(types = new int[]{1046, 1043, 1044, 1045}, true)).length == 0) {
            bUseLowestLevel = true;
        }
        if ((firstChildLevelInfo = firstChild.getLevelInfo()).isEmpty()) {
            return;
        }
        IHierarchy hierarchy = firstChild.getHierarchyInfo().getProjectedHierarchy(0);
        List<ILevel> levels = firstChildLevelInfo.getProjectedLevels(hierarchy);
        if (levels != null) {
            int highest = -1;
            int lowest = -1;
            for (int i = 0; i < levels.size(); ++i) {
                ILevel aLevel = levels.get(i);
                int levelIdx = aLevel.getIndex();
                if (highest == -1 || highest > levelIdx) {
                    highest = levelIdx;
                }
                if (lowest != -1 && lowest >= levelIdx) continue;
                lowest = levelIdx;
            }
            if (highest != -1 && lowest != -1) {
                if (!bUseLowestLevel) {
                    if (minMax[0] == -1 || minMax[0] > highest) {
                        minMax[0] = highest;
                    }
                    if (minMax[1] == -1 || minMax[1] < lowest) {
                        minMax[1] = lowest;
                    }
                } else {
                    if (minMax[0] == -1 || minMax[0] > lowest) {
                        minMax[0] = lowest;
                    }
                    if (minMax[1] == -1 || minMax[1] < lowest) {
                        minMax[1] = lowest;
                    }
                }
            }
        }
    }

    protected IHierarchy compatibleNesting(CogMDXGroup cogMDXGroup, boolean masterDetailCase) {
        CogMDXGroup innerGroup = cogMDXGroup;
        AbstractOLAPColumn innerColumn = null;
        while (innerGroup != null) {
            innerColumn = innerGroup.getFirstAbstractOLAPColumn();
            if (innerColumn == null) {
                innerGroup = (CogMDXGroup)innerGroup.getAncestorOfCategory(1027);
                continue;
            }
            if (innerGroup.isGenerateContextRequired().booleanValue()) {
                innerGroup = (CogMDXGroup)innerGroup.getAncestorOfCategory(1027);
                continue;
            }
            int ruleType = innerColumn.getRulesType();
            if (innerGroup.getFirstAbstractOLAPColumn().getNumOfCalculations() <= 0 || ruleType != 2) break;
            innerGroup = (CogMDXGroup)innerGroup.getAncestorOfCategory(1027);
        }
        if (innerGroup == null) {
            return null;
        }
        MDXEdge mdxEdge = (MDXEdge)innerGroup.getAncestorOfCategory(1006);
        AbstractMDXSet innerGroupFirstChild = (AbstractMDXSet)innerGroup.getChild(0);
        IHierarchy innerGroupHierarchy = innerGroupFirstChild.getHierarchyInfo().getProjectedHierarchy(0);
        int[] minMax = new int[]{-1, -1};
        int[] innerminMax = new int[]{-1, -1};
        this.getGroupMinMaxLevel(innerGroup, minMax);
        innerminMax[0] = minMax[0];
        innerminMax[1] = minMax[1];
        CogMDXGroup ancestorGroup = innerGroup;
        AbstractOLAPColumn ancestoColumn = null;
        int ancestorNumber = 0;
        while (ancestorGroup != null) {
            CogMDXGroup aboveAncestorGroup;
            AbstractMDXSet ancestorFirstChild = (AbstractMDXSet)ancestorGroup.getChild(0);
            IHierarchy ancestorHierarchy = ancestorFirstChild.getHierarchyInfo().getProjectedHierarchy(0);
            if (ancestorGroup.isGenerateContextRequired().booleanValue()) {
                ancestorGroup = (CogMDXGroup)ancestorGroup.getAncestorOfCategory(1027);
                continue;
            }
            ancestoColumn = ancestorGroup.getFirstAbstractOLAPColumn();
            int ruleType = ancestoColumn.getRulesType();
            if (ancestorGroup.getFirstAbstractOLAPColumn().getNumOfCalculations() > 0 && ruleType == 2) {
                ancestorGroup = (CogMDXGroup)ancestorGroup.getAncestorOfCategory(1027);
                continue;
            }
            if ((ancestorGroup = (CogMDXGroup)ancestorGroup.getAncestorOfCategory(1027)) == null) {
                return null;
            }
            ancestorFirstChild = (AbstractMDXSet)ancestorGroup.getChild(0);
            ancestorHierarchy = ancestorFirstChild.getHierarchyInfo().getProjectedHierarchy(0);
            ancestoColumn = ancestorGroup.getFirstAbstractOLAPColumn();
            int[] ancestorMinMax = new int[]{-1, -1};
            this.getGroupMinMaxLevel(ancestorGroup, ancestorMinMax);
            if (innerGroupHierarchy.getDimension().isMeasuresDimension()) {
                return this.compatibleNesting(ancestorGroup, masterDetailCase);
            }
            if (!ancestorHierarchy.equals(innerGroupHierarchy)) {
                return this.compatibleNesting(ancestorGroup, masterDetailCase);
            }
            ++ancestorNumber;
            if (ancestorMinMax[0] == -1) continue;
            if (minMax[0] != -1 && ancestorMinMax[0] != ancestorMinMax[1] && this.levelsOverlap(minMax, ancestorMinMax) && (minMax[0] != minMax[1] || minMax[1] != ancestorMinMax[1]) && mdxEdge.getReportHierarchies().size() > 1) {
                return innerGroupHierarchy;
            }
            if (!(minMax[0] == -1 || ancestorMinMax[0] == ancestorMinMax[1] || !this.levelsOverlap(minMax, ancestorMinMax) || minMax[0] == minMax[1] && minMax[1] == ancestorMinMax[1] || innerColumn.getRowset() == null || ancestoColumn.getRowset() == null || innerColumn.getRowset().getRowsetId() == ancestoColumn.getRowset().getRowsetId() || (aboveAncestorGroup = (CogMDXGroup)ancestorGroup.getAncestorOfCategory(1027)) == null && mdxEdge.getReportHierarchies().size() <= 1 && ancestoColumn.getRowset().getParentRowset() == null && ancestoColumn.getRowset().getNestedRowset().getSiblingRowset() == null && ancestoColumn.getRowset().getSiblingRowset() == null && ancestoColumn.getRowset().getDataItems().length <= 0 && innerColumn.getRowset().getDataItems().length <= 0)) {
                return innerGroupHierarchy;
            }
            if (minMax[1] != -1 && minMax[1] < ancestorMinMax[0] && innerColumn.getRowset() != null && ancestoColumn.getRowset() != null && innerColumn.getRowset().getRowsetId() != ancestoColumn.getRowset().getRowsetId()) {
                if (!DetectIncompatibleNestingSameHierarchy.isValidReverseOrder(ancestorHierarchy, ancestoColumn, ancestorMinMax, innerColumn, innerminMax)) {
                    if (masterDetailCase) {
                        boolean bl = masterDetailCase = ancestorMinMax[0] == ancestorMinMax[1] && innerminMax[0] == innerminMax[1] && innerColumn.getRowset().getHeaderRowset() != null && innerColumn.getRowset().getHeaderRowset().isEmpty();
                    }
                    if (!masterDetailCase) {
                        return innerGroupHierarchy;
                    }
                    masterDetailCase = true;
                }
            } else if (minMax[0] != -1 && minMax[0] < ancestorMinMax[0] && innerColumn.getRowset() != null && ancestoColumn.getRowset() != null && innerColumn.getRowset().getRowsetId() != ancestoColumn.getRowset().getRowsetId() ? !DetectIncompatibleNestingSameHierarchy.isValidReverseOrder(ancestorHierarchy, ancestoColumn, ancestorMinMax, innerColumn, innerminMax) : (ancestorNumber > 1 && minMax[1] != -1 && minMax[1] < ancestorMinMax[1] && innerColumn.getRowset() != null && ancestoColumn.getRowset() != null && innerColumn.getRowset().getRowsetId() != ancestoColumn.getRowset().getRowsetId() ? !DetectIncompatibleNestingSameHierarchy.isValidReverseOrder(ancestorHierarchy, ancestoColumn, ancestorMinMax, innerColumn, innerminMax) : minMax[1] != -1 && innerminMax[0] < ancestorMinMax[0] && innerColumn.getRowset() != null && ancestoColumn.getRowset() != null && innerColumn.getRowset().getRowsetId() == ancestoColumn.getRowset().getRowsetId() && innerColumn.getDataItemIndex() != -1 && ancestoColumn.getDataItemIndex() != -1 && innerGroupHierarchy.getLevelCount() == innerColumn.getCogMDXGroup().getLevelInfo().getNumProjectedLevels(innerGroupHierarchy) && mdxEdge.getReportHierarchies().size() > 1)) {
                return innerGroupHierarchy;
            }
            if (minMax[1] == -1 || minMax[1] < ancestorMinMax[1]) {
                minMax[1] = ancestorMinMax[1];
            }
            if (minMax[0] != -1 && minMax[0] <= ancestorMinMax[0]) continue;
            minMax[0] = ancestorMinMax[0];
        }
        return null;
    }

    private boolean levelsOverlap(int[] minMax1, int[] minMax2) {
        if (minMax1[0] == minMax2[0] || minMax1[1] == minMax2[1]) {
            return true;
        }
        if (minMax1[1] == minMax2[0] || minMax1[0] == minMax2[1]) {
            return true;
        }
        if (minMax1[0] < minMax2[0]) {
            if (minMax2[0] < minMax1[1] && minMax2[1] < minMax1[1]) {
                return true;
            }
            if (minMax2[0] < minMax1[1] && minMax2[1] > minMax1[1]) {
                return true;
            }
        }
        if (minMax1[0] > minMax2[0]) {
            if (minMax1[0] < minMax2[1] && minMax1[1] < minMax2[1]) {
                return true;
            }
            if (minMax1[0] < minMax2[1] && minMax1[1] > minMax2[1]) {
                return true;
            }
        }
        return false;
    }

    private static boolean isValidReverseOrder(IHierarchy ancestorHierarchy, AbstractOLAPColumn ancestoColumn, int[] ancestorMinMax, AbstractOLAPColumn innerColumn, int[] innerminMax) {
        int maxLevelId = ancestorHierarchy.getLevelCount() - 1;
        if (innerColumn != null && innerColumn.getRowset() != null && innerColumn.getRowset().getRefDataItem() == null && innerColumn.getDataItemIndex() != -1 && (innerminMax[0] == innerminMax[1] || innerminMax[0] == 0 && innerminMax[1] == maxLevelId)) {
            boolean validDetails = true;
            RSAPIEdgeRowset innerRowset = innerColumn.getRowset();
            RSAPIDataItem[] details = innerRowset.getDataItems();
            IMetadata metadata = null;
            for (RSAPIDataItem detail : details) {
                IMetadata aProperty;
                IMetadata currMetadata = detail.getModelReference();
                IHierarchy aHierarchy = null;
                if (currMetadata instanceof IHierarchy) {
                    aHierarchy = (IHierarchy)currMetadata;
                } else if (currMetadata instanceof ILevel) {
                    ILevel aLevel = (ILevel)currMetadata;
                    aHierarchy = aLevel.getHierarchy();
                } else if (currMetadata instanceof IProperty) {
                    aProperty = (IProperty)currMetadata;
                    aHierarchy = aProperty.getHierarchy();
                } else if (currMetadata instanceof IMeasure) {
                    aProperty = (IMeasure)currMetadata;
                    aHierarchy = aProperty.getHierarchy();
                } else {
                    validDetails = false;
                    break;
                }
                if (!aHierarchy.equals(ancestorHierarchy)) {
                    validDetails = false;
                    break;
                }
                if (metadata == null) {
                    metadata = currMetadata;
                    continue;
                }
                if (metadata == detail.getModelReference()) continue;
                if (metadata instanceof IHierarchy) {
                    if (currMetadata instanceof IProperty || currMetadata instanceof ILevel || currMetadata instanceof IHierarchy) continue;
                    validDetails = false;
                    break;
                }
                if (metadata instanceof ILevel) {
                    if (currMetadata instanceof IProperty || currMetadata instanceof IHierarchy || currMetadata instanceof ILevel) continue;
                    validDetails = false;
                    break;
                }
                if (metadata instanceof IProperty) {
                    if (currMetadata instanceof ILevel || currMetadata instanceof IProperty || currMetadata instanceof IHierarchy) continue;
                    validDetails = false;
                    break;
                }
                validDetails = false;
                break;
            }
            if (validDetails && ancestorMinMax[0] == ancestorMinMax[1] && ancestoColumn != null && ancestoColumn.getRowset() != null && ancestoColumn.getRowset().getRefDataItem() != null && ancestoColumn.getDataItemIndex() == -1) {
                return true;
            }
        }
        return innerColumn != null && innerColumn.getRowset() != null && innerColumn.getRowset().getNestedRowset() == null && innerColumn.getRowset().getRefDataItem() != null && innerColumn.getDataItemIndex() == -1 && innerColumn.getHierarchy().getLevelCount() == innerColumn.getCogMDXGroup().getLevelInfo().getNumProjectedLevels(innerColumn.getHierarchy()) && ancestorMinMax[0] == ancestorMinMax[1] && ancestoColumn != null && ancestoColumn.getRowset() != null && ancestoColumn.getRowset().getRefDataItem() != null && ancestoColumn.getDataItemIndex() == -1;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (node.getPropertyValue(TRANSFORMATION_APPLIED) != null) {
            this.traceNodeCondition(false, "The transformation was applied already.", trace);
            return false;
        }
        this.traceNodeCondition(true, "The transformation was not applied yet.", trace);
        return true;
    }
}

