/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.edgemapping;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberReference;
import com.cognos.xqe.ast.olap.MDXEdge;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.runtree.olap.edgemapping.XOLAPEdgeMapping;
import com.cognos.xqe.runtree.olap.edgemapping.actions.ActionFactory;
import com.cognos.xqe.trace.XQETrace;

public class RebuildMemberUniqueNameRulesForReplacedRootMember
extends Transformation {
    public RebuildMemberUniqueNameRulesForReplacedRootMember() {
        this.mName = "Rebuilds MUN rules for root members that have been replaced.";
        this.mPassNumbers = new int[]{44};
        this.mTypes = new int[]{1013};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        MDXCalculatedMemberReference calcRef = (MDXCalculatedMemberReference)node;
        MDXEdge mdxEdge = (MDXEdge)calcRef.getAncestorOfType(1006);
        XOLAPEdgeMapping xOLAPEdgeMapping = mdxEdge.getXOLAPEdgeMapping();
        ActionFactory actionFactory = environment.getEdgeElementFactory().getActionFactory();
        xOLAPEdgeMapping.rebuildMUNRulesForReplacedRootMember(calcRef.getReplacedRootMember(), calcRef, actionFactory);
        calcRef.setReplacedRootMember(null);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        MDXCalculatedMemberReference calcRef = (MDXCalculatedMemberReference)node;
        String transformationDoesNotApplies = "The transfromation does not applies.";
        if (calcRef.getReplacedRootMember() == null) {
            this.traceNodeCondition(false, "The transfromation does not applies.", trace);
            return false;
        }
        MDXEdge mdxEdge = (MDXEdge)calcRef.getAncestorOfType(1006);
        if (mdxEdge == null || !mdxEdge.isProjectedDescendant(calcRef)) {
            this.traceNodeCondition(false, "The transfromation does not applies.", trace);
            return false;
        }
        if (mdxEdge.getXOLAPEdgeMapping() == null) {
            this.traceNodeCondition(false, "The transfromation does not applies.", trace);
            return false;
        }
        this.traceNodeCondition(true, "The transfromation does applies.", trace);
        return true;
    }
}

