/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.edgemapping;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.rsapi.RSAPIDataset;
import com.cognos.xqe.runtree.olap.edgemapping.XOLAPEdgeMapping;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.edgemapping.RemoveDecorationRuntreeNodes;

public class RemoveEmptyXOLAPEdgeMapping
extends Transformation {
    public RemoveEmptyXOLAPEdgeMapping() {
        this.mName = "Removes empty XOLAPEdgeMapping nodes.";
        this.mPassNumbers = new int[]{39};
        this.mTypes = new int[]{501144};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        RSAPIDataset dataset = (RSAPIDataset)node.getAncestorOfType(401005);
        if (dataset != null) {
            dataset.setGenerateDerivedRowsInRSAPI(false);
        }
        RemoveDecorationRuntreeNodes.removeDecorationRuntreeNodes(node);
        ((XOLAPEdgeMapping)node).extract();
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (((XOLAPEdgeMapping)node).isEmpty()) {
            this.traceNodeCondition(true, "Target XOLAPEdgeMapping node is empty.", trace);
            return true;
        }
        this.traceNodeCondition(false, "Target XOLAPEdgeMapping node is not empty.", trace);
        return false;
    }
}

