/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.edgemapping.unbalanced;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.CogMDXGroup;
import com.cognos.xqe.ast.olap.MDXCrossjoin;
import com.cognos.xqe.ast.olap.MDXEdge;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.runtree.olap.edgemapping.AbstractOLAPColumn;
import com.cognos.xqe.runtree.olap.edgemapping.OLAPEdgeMappingException;
import com.cognos.xqe.runtree.olap.edgemapping.OLAPRowCycle;
import com.cognos.xqe.trace.XQETrace;
import java.util.ArrayList;

public class LinkAbstractOLAPRowForUnbalancedCompensationCrossjoinToParentRow
extends Transformation {
    private static final String THIS_TRANSFORMATION_IS_APPLICABLE = "This transformation is applicable.";

    public LinkAbstractOLAPRowForUnbalancedCompensationCrossjoinToParentRow() {
        this.mName = "This transformation links the AbstractOLAPRow of a given MDXCorsjoin with that of its ancestor CogMDXGroup.";
        this.mPassNumbers = new int[]{35};
        this.mTypes = new int[]{1030};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        MDXCrossjoin mdxCrossjoin = (MDXCrossjoin)node;
        CogMDXGroup ancestorGroup = (CogMDXGroup)mdxCrossjoin.getAncestorOfCategory(1027);
        ArrayList<AbstractOLAPColumn> abstractOLAPColumnList = new ArrayList<AbstractOLAPColumn>();
        abstractOLAPColumnList.addAll(mdxCrossjoin.getAbstractOLAPColumnList());
        for (AbstractOLAPColumn abstractOLAPColumn : abstractOLAPColumnList) {
            if (abstractOLAPColumn.getParentRow().getParentRow() != null) continue;
            ((OLAPRowCycle)ancestorGroup.getFirstAbstractOLAPColumn().getParentRow()).addRow(abstractOLAPColumn.getParentRow(), false);
        }
        environment.setTreeHasBeenModified();
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        MDXCrossjoin mdxCrossjoin = (MDXCrossjoin)node;
        MDXEdge mdxEdge = (MDXEdge)mdxCrossjoin.getAncestorOfType(1006);
        if (mdxEdge == null) {
            this.traceQueryCondition(false, "The target MDXCrossjoin is not under a MDXEdge node.", trace);
            return false;
        }
        if (mdxEdge.getXOLAPEdgeMapping() == null) {
            this.traceQueryCondition(false, "The target MDXEdge has not yet an associated XOLAPEdgeMapping.", trace);
            return false;
        }
        if (mdxCrossjoin.getParent().getType() != 1113) {
            this.traceQueryCondition(false, "The target MDXCrossjoin is not whithin a TNodeUnbCompensation node.", trace);
            return false;
        }
        if (mdxCrossjoin.getAbstractOLAPColumnList() == null) {
            this.traceQueryCondition(false, "The target MDXCrossjoin has not an associated AbstractOLAPColumn.", trace);
            return false;
        }
        boolean foundAnUnlinkedCrossjoinColumn = false;
        for (AbstractOLAPColumn column : mdxCrossjoin.getAbstractOLAPColumnList()) {
            if (column.getParentRow() == null) {
                this.traceQueryCondition(false, "The target MDXCrossjoin has not an associated AbstractOLAPRow.", trace);
                return false;
            }
            if (column.getParentRow().getParentRow() != null) continue;
            foundAnUnlinkedCrossjoinColumn = true;
            break;
        }
        if (foundAnUnlinkedCrossjoinColumn) {
            this.traceQueryCondition(true, THIS_TRANSFORMATION_IS_APPLICABLE, trace);
            return true;
        }
        this.traceQueryCondition(false, "The associated AbstractOLAPRow has a parent AbstractOLAPRow.", trace);
        return false;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        MDXCrossjoin mdxCrossjoin = (MDXCrossjoin)node;
        CogMDXGroup ancestorGroup = (CogMDXGroup)mdxCrossjoin.getAncestorOfCategory(1027);
        if (ancestorGroup.getFirstAbstractOLAPColumn() == null) {
            this.traceQueryCondition(false, "The ancestor CogMDXGroup has not an associated AbstractOLAPColumn.", trace);
            return false;
        }
        if (ancestorGroup.getFirstAbstractOLAPColumn().getParentRow() == null || !ancestorGroup.getFirstAbstractOLAPColumn().getParentRow().isCycle()) {
            throw new OLAPEdgeMappingException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "!ancestorColumn.getParentRow().isCycle()");
        }
        this.traceNodeCondition(true, THIS_TRANSFORMATION_IS_APPLICABLE, trace);
        return true;
    }
}

