/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.finalization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.MDXEdge;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;

public class AddMemberTypePropertyToDimensionProperties
extends Transformation {
    public AddMemberTypePropertyToDimensionProperties() {
        this.mName = "Apply MEMBER_TYPE property to DIMENSION PROPERTIES";
        this.mPassNumbers = new int[]{46};
        this.mTypes = new int[]{1002};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        MDXQuery mdxQuery = (MDXQuery)node;
        IXQEQueryNode[] edges = mdxQuery.getDescendantsOfType(1006, false);
        for (int i = 0; i < edges.length; ++i) {
            ((MDXEdge)edges[i]).addMemberProperty("MEMBER_TYPE");
        }
        mdxQuery.resetMemberTypeRequested();
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        MDXQuery mdxQuery = (MDXQuery)node;
        if (!mdxQuery.isMemberTypeRequested()) {
            this.traceQueryCondition(false, "The query does not need MEMBER_TYPE in DIMENSION PROPERTIES.", trace);
            return false;
        }
        this.traceNodeCondition(true, "The query needs MEMBER_TYPE in DIMENSION PROPERTIES.", trace);
        return true;
    }
}

