/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.finalization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.CogMDXProperties;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberDefinition;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberReference;
import com.cognos.xqe.ast.olap.MDXCurrentMember;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.util.MDXBuilder;
import java.rmi.server.UID;
import java.util.List;

public class RemoveAndPropagateMDXPropertiesScopeSet
extends Transformation {
    public static final String NESTING_DEPTH_OF_CONTEXT_FOR_PROPERTY = "nestingDepthOfContextForProperty";
    private static final int[] GROUP_NEST_NODES = new int[]{1027, 1026};

    public RemoveAndPropagateMDXPropertiesScopeSet() {
        this.mName = "Remove scope from MDX properties and propagate it if required.";
        this.mPassNumbers = new int[]{5};
        this.mTypes = new int[]{1016};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        AbstractMDXSet parentGroup;
        Integer nDepth;
        XQENodeFactory factory = environment.getNodeFactory();
        CogMDXProperties mdxProperties = (CogMDXProperties)node;
        AbstractMDXNode scopeExpr = (AbstractMDXNode)node.getChild(1);
        IHierarchy scopeHierarchy = scopeExpr.getHierarchyInfo().getProjectedHierarchy(0);
        MDXCalculatedMemberDefinition calcDef = (MDXCalculatedMemberDefinition)node.getAncestorOfCategory(1005);
        IHierarchy calcHierarchy = calcDef.getHierarchy();
        List<MDXCalculatedMemberReference> calcRefs = calcDef.getCalcMemberRefs();
        MDXCalculatedMemberReference calcRef = calcRefs.get(0);
        AbstractMDXNode parent = (AbstractMDXNode)calcRef.getParent();
        while (!parent.isOfTypes(GROUP_NEST_NODES)) {
            parent = (AbstractMDXNode)parent.getParent();
        }
        AbstractMDXSet newNode = (AbstractMDXSet)factory.createNode(parent.getType());
        newNode.setRefDataItemProperty(new UID().toString());
        AbstractMDXNode newScopeExpr = (AbstractMDXNode)factory.deepCopyNode(scopeExpr);
        newNode.addChild(newScopeExpr);
        int nestingDepth = 0;
        while (parent.getParent() != null && (parent.getParent().isOfCategory(1026) || parent.getParent().isOfCategory(1039)) && ((AbstractMDXNode)parent.getParent().getChild(0)).getHierarchyInfo().projectsHierarchy(calcHierarchy)) {
            parent = (AbstractMDXNode)parent.getParent();
            ++nestingDepth;
        }
        newNode.setPropertyValue(NESTING_DEPTH_OF_CONTEXT_FOR_PROPERTY, nestingDepth);
        while (parent.getParent() != null && parent.getParent().isOfTypes(GROUP_NEST_NODES) && (nDepth = (Integer)(parentGroup = (AbstractMDXSet)parent.getParent()).getPropertyValue(NESTING_DEPTH_OF_CONTEXT_FOR_PROPERTY)) != null && nDepth >= nestingDepth) {
            parent = (AbstractMDXNode)parent.getParent();
        }
        parent.insertParent(newNode);
        MDXCurrentMember member = MDXBuilder.buildMDXCurrentMemberExpr(factory, scopeHierarchy);
        mdxProperties.exchangeChildNode(scopeExpr, member);
        mdxProperties.setContextDone(true);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        CogMDXProperties mdxProperties = (CogMDXProperties)node;
        mdxProperties.throwOnInvalidChildCategories();
        StringBuilder reason = new StringBuilder();
        boolean propagationRequired = RemoveAndPropagateMDXPropertiesScopeSet.scopeSetNeedsToBePropagated(mdxProperties, reason);
        this.traceNodeCondition(propagationRequired, reason.toString(), trace);
        return propagationRequired;
    }

    public static boolean scopeSetNeedsToBePropagated(CogMDXProperties mdxProperties, StringBuilder reason) {
        MDXQuery query = (MDXQuery)mdxProperties.getAncestorOfType(1002);
        if (query == null || !query.isListReport()) {
            reason.append("The target CogMDXProperties is not in a list report.");
            return false;
        }
        IXQEQueryNode scopeExpr = mdxProperties.getChild(1);
        if (scopeExpr.isOfCategory(1021) && !((AbstractMDXSet)scopeExpr).isEmpty()) {
            boolean isCalculatedMeasure;
            MDXCalculatedMemberDefinition calcDef = (MDXCalculatedMemberDefinition)mdxProperties.getAncestorOfCategory(1005);
            IHierarchy calcHierarchy = null;
            if (calcDef != null) {
                calcHierarchy = calcDef.getHierarchy();
            }
            boolean bl = isCalculatedMeasure = calcDef != null && calcHierarchy.getDimension().isMeasuresDimension();
            if (isCalculatedMeasure) {
                IHierarchy scopeHierarchy = ((AbstractMDXNode)mdxProperties.getChild(1)).getHierarchyInfo().getProjectedHierarchy(0);
                if (mdxProperties.getContextHierarchyInfo().projectsHierarchy(scopeHierarchy)) {
                    reason.append("The hierarchy of the scope set is projected.");
                    return false;
                }
                List<MDXCalculatedMemberReference> calcRefs = calcDef.getCalcMemberRefs();
                if (calcRefs.size() != 1) {
                    mdxProperties.throwInternalError("Generated multiple references to a context dependant calculation");
                }
                if (calcRefs.get(0).getAncestorOfType(1080) != null || calcRefs.get(0).getAncestorOfType(1060) != null) {
                    reason.append("The property is in a summary.");
                    return false;
                }
                reason.append("The target CogMDXProperties has a second child node which is a set.");
                return true;
            }
            reason.append("The target MDXProperties has a second child node which is a set.");
            return false;
        }
        reason.append("The second child of the CogMDXProperties is not a set expression or is an empty set.");
        return false;
    }
}

