/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.finalization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.MDXEdge;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;

public final class RemoveEdgeSupressionWhenNoCellIterator
extends Transformation {
    public RemoveEdgeSupressionWhenNoCellIterator() {
        this.mName = "Remove Edge Null Suppression (NON_EMPTY) when no V5 cell iterator.";
        this.mPassNumbers = new int[]{50};
        this.mTypes = new int[]{1006};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        MDXEdge mdxEdge = (MDXEdge)node;
        mdxEdge.setMDXNonEmptyProperty(false);
        mdxEdge.setPowerCubeZeroSuppress(false);
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        MDXEdge mdxEdge = (MDXEdge)node;
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        if (mdxQuery.isDMR()) {
            this.traceQueryCondition(false, "Is DMR.", trace);
            return false;
        }
        if (mdxEdge.getMDXNonEmptyProperty()) {
            this.traceQueryCondition(true, "The edge have null suppression property set to true.", trace);
            return true;
        }
        this.traceQueryCondition(false, "The edge do not have null suppression property set to true.", trace);
        return false;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        if (mdxQuery.isSuppressNulls()) {
            this.traceNodeCondition(false, "Suppression required by V5 suppress query hint or model governor.", trace);
            return false;
        }
        if (mdxQuery.getAncestorOfType(601010) != null) {
            this.traceNodeCondition(false, "The MDX Query has a cell iterator.", trace);
            return false;
        }
        this.traceNodeCondition(true, "Null suppression set on one edge and the query has no cell iterator.", trace);
        return true;
    }

    @Override
    public void dumpSpecificationReferences(XQETrace trace) {
        String element = "element";
        trace.beginElement("specification", -1);
        trace.attribute("type", "schema");
        trace.attribute("category", element);
        trace.attribute(element, "V5EdgeSuppression");
        trace.endElement();
    }
}

