/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.finalization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.MDXEdge;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;

public final class RemoveUnsafeEdgeNullSuppression
extends Transformation {
    public RemoveUnsafeEdgeNullSuppression() {
        this.mName = "Remove the MDX null suppression property from the MDX Edge.";
        this.mPassNumbers = new int[]{50};
        this.mTypes = new int[]{1006};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        MDXEdge mdxEdge = (MDXEdge)node;
        mdxEdge.setMDXNonEmptyProperty(false);
        mdxEdge.setPowerCubeZeroSuppress(false);
    }

    @Override
    public boolean passesQueryCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        MDXEdge mdxEdge = (MDXEdge)node;
        MDXQuery mdxQuery = (MDXQuery)mdxEdge.getAncestorOfType(1002);
        if (mdxQuery.getSuppressNulls() != null) {
            this.traceNodeCondition(false, "Suppression is driven by either the V5 query hint or the model governor.", trace);
            return false;
        }
        if (mdxEdge.getMDXNonEmptyProperty()) {
            this.traceQueryCondition(true, "The edge have null suppression property set to true.", trace);
            return true;
        }
        this.traceQueryCondition(false, "The edge do not have null suppression property set to true.", trace);
        return false;
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        MDXEdge mdxEdge = (MDXEdge)node;
        MDXQuery mdxQuery = (MDXQuery)mdxEdge.getAncestorOfType(1002);
        if (mdxQuery.isRelationalStyleQuery() || mdxQuery.getMDXFrom().getCube().isDMR()) {
            this.traceNodeCondition(false, "No need for DMR Cube to remove NON_EMPTY since skipping filler tag.", trace);
            return false;
        }
        boolean bl = status = !mdxEdge.isSafeToApplyNonEmpty();
        if (status) {
            this.traceNodeCondition(true, "Remove the PROP_BOOLEAN_MDX_NON_EMPTY property from the MDXEdge.", trace);
            return true;
        }
        this.traceNodeCondition(false, "No need to remove the PROP_BOOLEAN_MDX_NON_EMPTY property from the MDXEdge.", trace);
        return false;
    }
}

