/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.intersecting_wds;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXMember;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.ITNodeAddMemberToContext;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberDefinition;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.util.MDXBuilder;

public final class AddDefMemberToContextDepCalcsAfterWDS
extends Transformation {
    public AddDefMemberToContextDepCalcsAfterWDS() {
        this.mName = "Add Default Member To Context Dependent Calculations after WDS applied.";
        this.mPassNumbers = new int[]{27};
        this.mTypes = new int[]{1005};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        MDXCalculatedMemberDefinition calcDef = (MDXCalculatedMemberDefinition)node;
        IHierarchy hierarchy = calcDef.getHierarchy();
        AbstractMDXMember memberToAdd = null;
        if (hierarchy.getDimension().isMeasuresDimension()) {
            MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
            memberToAdd = (AbstractMDXMember)factory.deepCopyNode(mdxQuery.getQueryDefaultMeasure());
        } else {
            memberToAdd = MDXBuilder.buildMDXDefaultMemberExpr((IXQENodeFactory)factory, calcDef.getHierarchy());
        }
        ITNodeAddMemberToContext tNode = MDXBuilder.insertTNodeAddMemberToContext(factory, (AbstractMDXNode)calcDef.getChild(0), memberToAdd);
        environment.enableLockNodeQueryPlanning(tNode.getType());
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (node.getChildrenOfType(1119).length != 0 || node.getDescendantsOfType(1121, false).length > 0) {
            this.traceNodeCondition(false, "Intersecting within detail summaries have not been applied yet for this calculation.", trace);
            return false;
        }
        MDXCalculatedMemberDefinition calcDef = (MDXCalculatedMemberDefinition)node;
        IHierarchy hierarchy = calcDef.getHierarchy();
        if (!calcDef.isContextDependent(hierarchy)) {
            this.traceNodeCondition(false, "The defintion is not context dependent on the hierarchy it's defined in.", trace);
            return false;
        }
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        if (mdxQuery == null) {
            this.traceNodeCondition(false, "The node is not a descendant of the MDXQuery node.", trace);
            return false;
        }
        this.traceNodeCondition(true, "The defintion is context dependent on the hierarchy it's defined in and the calculation is not a nested level calculation.", trace);
        return true;
    }
}

