/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.intersecting_wds;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.AbstractMDXMember;
import com.cognos.xqe.ast.olap.AbstractMDXNumericValueFunction;
import com.cognos.xqe.ast.olap.CogMDXAggregate;
import com.cognos.xqe.ast.olap.CogMDXGroup;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberDefinition;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberReference;
import com.cognos.xqe.ast.olap.MDXEdge;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.MDXSummaryFunction;
import com.cognos.xqe.ast.olap.MDXSummaryFunctionTypeEnum;
import com.cognos.xqe.ast.v5Exp.V5RollupAggregateEnum;
import com.cognos.xqe.transformation.olap.intersecting_wds.CheckLowerSOWDS;
import com.cognos.xqe.transformation.olap.util.CollectMeasuresIntersectingWithProjCalcUtil;
import com.cognos.xqe.util.CollectionCast;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class IntersectingWDSUtil {
    public static List<MDXCalculatedMemberReference> getSimpleProjectedLowerSOWDSCalcsOnOtherEdge(MDXCalculatedMemberReference calc) {
        return IntersectingWDSUtil.getProjectedLowerSOWDSCalcsOnOtherEdge(calc, 1);
    }

    public static List<MDXCalculatedMemberReference> getUnsupportedProjectedLowerSOWDSCalcsOnOtherEdge(MDXCalculatedMemberReference calc) {
        return IntersectingWDSUtil.getProjectedLowerSOWDSCalcsOnOtherEdge(calc, 2);
    }

    private static List<MDXCalculatedMemberReference> getProjectedLowerSOWDSCalcsOnOtherEdge(MDXCalculatedMemberReference calc, int checkType) {
        MDXQuery mdxQuery;
        ArrayList<IXQEQueryNode> wdsCalcs = new ArrayList<IXQEQueryNode>();
        MDXEdge mdxEdge = (MDXEdge)calc.getAncestorOfType(1006);
        if (mdxEdge != null && (mdxQuery = (MDXQuery)mdxEdge.getAncestorOfType(1002)) != null) {
            IXQEQueryNode[] edges = mdxQuery.getDescendantsOfType(1006, false);
            for (int i = 0; i < edges.length; ++i) {
                MDXEdge otherEdge = (MDXEdge)edges[i];
                if (otherEdge == mdxEdge) continue;
                CheckLowerSOWDS checkLowerSOWDS = new CheckLowerSOWDS(calc, otherEdge, checkType);
                int[] nodeTypes = new int[]{1013};
                checkLowerSOWDS.setNodeTypes(nodeTypes);
                otherEdge.getDescendantsForCondition(wdsCalcs, checkLowerSOWDS, false);
            }
        }
        return CollectionCast.downcast(wdsCalcs, IXQEQueryNode.class, MDXCalculatedMemberReference.class);
    }

    public static boolean isWithinDetailCalc(MDXCalculatedMemberReference calcRef) {
        return CheckLowerSOWDS.isSimpleWithinDetailCalc(calcRef) || CheckLowerSOWDS.isComplexWithinDetailCalc(calcRef);
    }

    public static List<MDXCalculatedMemberReference> filterCalcsThatRequireMerging(MDXCalculatedMemberReference calcRef, List<MDXCalculatedMemberReference> intWDSCalcs) {
        MDXQuery query = (MDXQuery)calcRef.getAncestorOfType(1002);
        ArrayList<MDXCalculatedMemberReference> mergeRequired = new ArrayList<MDXCalculatedMemberReference>();
        IXQEQueryNode[] cmRefs = query.getDescendantsOfType(1013, false);
        HashSet<MDXCalculatedMemberDefinition> definitions = new HashSet<MDXCalculatedMemberDefinition>();
        for (int i = 0; i < cmRefs.length; ++i) {
            MDXCalculatedMemberReference ref = (MDXCalculatedMemberReference)cmRefs[i];
            CogMDXGroup group = (CogMDXGroup)ref.getAncestorOfType(1027);
            if (group == null || group.getDetailProperty() != null && !group.getDetailProperty().equals("true") || ref.isReportSummary()) continue;
            definitions.add(ref.getDefinition());
        }
        List<IXQEQueryNode> funcs = calcRef.getDefinition().getDescendantsOfCategory(1088, false);
        ArrayList<AbstractMDXNumericValueFunction> summaries = new ArrayList<AbstractMDXNumericValueFunction>();
        for (int i = 0; i < funcs.size(); ++i) {
            AbstractMDXNumericValueFunction valueFunc = (AbstractMDXNumericValueFunction)funcs.get(i);
            if (!valueFunc.isWithinDetailCalc()) continue;
            summaries.add(valueFunc);
        }
        for (MDXCalculatedMemberReference intRef : intWDSCalcs) {
            if (!IntersectingWDSUtil.requiresMerging(calcRef, summaries, intRef, definitions, query)) continue;
            mergeRequired.add(intRef);
        }
        return mergeRequired;
    }

    private static boolean requiresMerging(MDXCalculatedMemberReference calcRef, List<AbstractMDXNumericValueFunction> valueFunctions, MDXCalculatedMemberReference intRef, Set<MDXCalculatedMemberDefinition> calcDefs, MDXQuery query) {
        if (intRef.isAlternateMeasureRef()) {
            return false;
        }
        AbstractMDXNumericValueFunction intValueFunc = (AbstractMDXNumericValueFunction)intRef.getDefinition().getChild(0);
        MDXSummaryFunctionTypeEnum intSummaryType = IntersectingWDSUtil.getAssociativeSummaryFunctionType(intValueFunc, intRef, query);
        if (intSummaryType == null) {
            return true;
        }
        for (AbstractMDXNumericValueFunction function : valueFunctions) {
            MDXSummaryFunctionTypeEnum summaryType = IntersectingWDSUtil.getAssociativeSummaryFunctionType(function, calcRef, query);
            if (summaryType != null && intSummaryType == summaryType) continue;
            return true;
        }
        int intRefSO = intRef.getDefinition().getSolveOrder();
        int calcRefSO = calcRef.getDefinition().getSolveOrder();
        for (MDXCalculatedMemberDefinition calcDef : calcDefs) {
            int solveOrder = calcDef.getSolveOrder();
            if ((intRefSO >= solveOrder || solveOrder >= calcRefSO) && (intRefSO <= solveOrder || solveOrder <= calcRefSO)) continue;
            return true;
        }
        return false;
    }

    private static MDXSummaryFunctionTypeEnum getAssociativeSummaryFunctionType(AbstractMDXNumericValueFunction valueFunc, MDXCalculatedMemberReference calc, MDXQuery mdxQuery) {
        if (valueFunc.isAssociativeSummaryFunction()) {
            return ((MDXSummaryFunction)valueFunc).getSummaryType();
        }
        if (valueFunc.getType() == 1012) {
            if (!(mdxQuery.getDataSourceType().equals("BW") || mdxQuery.getDataSourceType().equals("EB") || mdxQuery.getDataSourceType().equals("DO") || mdxQuery.getDataSourceType().equals("TM") || mdxQuery.getDataSourceType().equals("TMR"))) {
                return null;
            }
            CogMDXAggregate cogMDXAggregate = (CogMDXAggregate)valueFunc;
            if (cogMDXAggregate.getSummaryType() != MDXSummaryFunctionTypeEnum.AGGREGATE) {
                return null;
            }
            Set<AbstractMDXMember> intersectingMeasures = cogMDXAggregate.getIntersectingMeasures();
            if (intersectingMeasures.isEmpty()) {
                intersectingMeasures = CollectMeasuresIntersectingWithProjCalcUtil.collectMeasuresIntersectingWithProjCalc(calc.getDefinition(), mdxQuery);
            }
            MDXSummaryFunctionTypeEnum summaryType = null;
            for (AbstractMDXMember currMeasure : intersectingMeasures) {
                if (currMeasure.getParent() == null) continue;
                if (currMeasure.getType() == 1067) {
                    V5RollupAggregateEnum rollupAggregateType = currMeasure.getRollupAggregate();
                    MDXSummaryFunctionTypeEnum sType = MDXSummaryFunctionTypeEnum.convertRollupAggregateToMDXSummaryFunctionType(rollupAggregateType);
                    boolean isAssociativeSummary = MDXSummaryFunction.isAssociativeSummaryFunction(sType);
                    if (!isAssociativeSummary) {
                        return null;
                    }
                    if (summaryType == null) {
                        summaryType = sType;
                        continue;
                    }
                    if (summaryType == sType) continue;
                    return null;
                }
                return null;
            }
            return summaryType;
        }
        return null;
    }
}

