/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.list.context;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.CogMDXGroup;
import com.cognos.xqe.ast.olap.CogMDXNest;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.MDXSet;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.optimization.namedsets.RemoveNamedSetWithEmptySetOrSingleMemberSetDefinition;
import com.cognos.xqe.transformation.olap.util.MDXBuilder;
import java.util.ArrayList;
import java.util.List;

public final class SetCogMDXNestContextUsingNamedSet
extends Transformation {
    public SetCogMDXNestContextUsingNamedSet() {
        this.mName = "Create Named Sets For CogMDXNest Operands.";
        this.mPassNumbers = new int[]{11};
        this.mTypes = new int[]{1026};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        AbstractMDXSet definition = (AbstractMDXSet)node.getChild(0);
        int pos = node.getPositionOfChild(definition);
        node.detachChild(definition);
        node.addChild(MDXBuilder.buildMDXNamedSet(factory, mdxQuery, "", definition), pos);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        boolean status;
        XQETrace trace = environment.getTrace();
        List<IHierarchy> outerNestHierarchies = SetCogMDXNestContextUsingNamedSet.getHierarchyiesOfOuterCogMDXNestNodes((CogMDXNest)node);
        if (outerNestHierarchies.size() == 0) {
            this.traceNodeCondition(false, "The target CogMDXNest node is the outermost CogMDXNest node.", trace);
            return false;
        }
        IHierarchy outerGroupHierarchy = SetCogMDXNestContextUsingNamedSet.getHierarchyOfOuterCogMDXGroupNode((CogMDXNest)node);
        if (outerGroupHierarchy != null) {
            StringBuilder strBuff = new StringBuilder("This transformation is not applicable to CogMDXNest nodes that are");
            strBuff.append(" descendants of a CogMDXGroup node.");
            strBuff.append(" SetCogMDXNestContextUsingSetAlias should be applied instead.");
            this.traceNodeCondition(false, strBuff.toString(), trace);
            return false;
        }
        AbstractMDXSet set = (AbstractMDXSet)node.getChild(0);
        if (set.getType() == 1039 && (status = RemoveNamedSetWithEmptySetOrSingleMemberSetDefinition.nodeCondition((MDXSet)node.getChild(0)))) {
            this.traceNodeCondition(false, "The first set operand of the CogMDXNest node is an empty MDXSet node or an MDXSet node that projects a single member.", trace);
            return false;
        }
        MDXHierInfo setHierInfo = set.getHierarchyInfo();
        IHierarchy hierarchy = setHierInfo.getProjectedHierarchy(0);
        if (outerNestHierarchies.contains(hierarchy) && (set.isContextDependent(hierarchy) || SetCogMDXNestContextUsingNamedSet.containsFilteredContextDependentExpr(set))) {
            this.traceNodeCondition(true, "The first set operand of the CogMDXNest node is context dependent on the hierarchy that it projects, and the node is nested under another CogMDXNest node that projects a set from the same hierarchy.", trace);
            return true;
        }
        if (!set.isContextDependent(true)) {
            this.traceNodeCondition(false, "The first operand of the CogMDXNest node is not context dependent on any of the hierarchies referenced in the MDXQuery.", trace);
            return false;
        }
        for (int i = 0; i < outerNestHierarchies.size(); ++i) {
            IHierarchy outerNestHierarchy = outerNestHierarchies.get(i);
            if (outerGroupHierarchy != outerNestHierarchy || !set.isContextDependent(outerNestHierarchy)) continue;
            this.traceNodeCondition(true, "The target CogMDXNest node is nested under a CogMDXNest node that projects a set from the same hierarchy as the outer CogMDXGroup node, and the first operand of the target CogMDXNest node is context dependent on that hierarchy.", trace);
            return true;
        }
        this.traceNodeCondition(false, "The first operand of the target CogMDXNest node is either not context dependent, orthe context can be restricted using either SetCogMDXNestContextUsingDefaultMember.", trace);
        return false;
    }

    protected static IHierarchy getHierarchyOfOuterCogMDXGroupNode(CogMDXNest node) {
        CogMDXGroup cogMDXGroup = (CogMDXGroup)node.getAncestorOfType(1027);
        if (cogMDXGroup != null) {
            MDXHierInfo hierInfo = ((AbstractMDXSet)cogMDXGroup.getChild(0)).getHierarchyInfo();
            return hierInfo.getProjectedHierarchy(0);
        }
        return null;
    }

    protected static List<IHierarchy> getHierarchyiesOfOuterCogMDXNestNodes(CogMDXNest node) {
        ArrayList<IHierarchy> result = new ArrayList<IHierarchy>();
        IXQEQueryNode[] ancestorCogMDXNestNodes = node.getAncestorsOfType(1026);
        for (int i = 0; i < ancestorCogMDXNestNodes.length; ++i) {
            AbstractMDXSet set = (AbstractMDXSet)ancestorCogMDXNestNodes[i].getChild(0);
            MDXHierInfo hierInfo = set.getHierarchyInfo();
            result.add(hierInfo.getProjectedHierarchy(0));
        }
        return result;
    }

    protected static boolean containsFilteredContextDependentExpr(AbstractMDXSet set) {
        List<IXQEQueryNode> descendantSets = set.getDescendantsOfCategory(1021, true);
        for (IXQEQueryNode descendant : descendantSets) {
            AbstractMDXSet filteringSet = (AbstractMDXSet)descendant;
            if (!filteringSet.isFilteringOperator(false) || !set.isProjectedDescendant(filteringSet)) continue;
            return true;
        }
        return false;
    }
}

