/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.measure;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXLevel;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.MDXCurrentMember;
import com.cognos.xqe.ast.olap.MDXDefaultMember;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.util.MDXBuilder;

public final class AddContextToPeriodFunction
extends Transformation {
    private static final int PARALLELPERIOD_MAX_CHILDREN = 3;

    public AddContextToPeriodFunction() {
        this.mName = "Add context to period function";
        this.mPassNumbers = new int[]{3};
        this.mTypes = new int[]{1049, 1050};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        IHierarchy hierarchy = ((AbstractMDXLevel)node.getChild(0)).getLevel().getHierarchy();
        boolean hasContext = ((AbstractMDXNode)node).getContextHierarchyInfo().getProjectedHierarchies().contains(hierarchy);
        if (hasContext) {
            MDXCurrentMember currentMember = MDXBuilder.buildMDXCurrentMemberExpr(nodeFactory, hierarchy);
            node.addChild(currentMember);
        } else {
            MDXDefaultMember defaultMember = MDXBuilder.buildMDXDefaultMemberExpr((IXQENodeFactory)nodeFactory, hierarchy);
            defaultMember.setPropertyIsNoMember(false);
            node.addChild(defaultMember);
        }
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (node.getType() == 1049 && node.getNumberChildren() == 3) {
            this.traceNodeCondition(false, "The target parallel period function already has a member specified as its third argument.", trace);
            return false;
        }
        if (node.getType() == 1050 && node.getNumberChildren() == 2) {
            this.traceNodeCondition(false, "The target opening/closing period function already has a member specified as its second argument.", trace);
            return false;
        }
        this.traceNodeCondition(true, "The target opening/closing/parallel period does not already have a member parameter.", trace);
        return true;
    }
}

