/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.measure;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.BaseMember;
import com.cognos.xqe.ast.olap.CogMDXGroup;
import com.cognos.xqe.ast.olap.MDXEdge;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.util.MDXBuilder;
import java.util.ArrayList;

public final class ResolveQueryDefaultMeasure
extends Transformation {
    public ResolveQueryDefaultMeasure() {
        this.mName = "Resolve the MDX Query Default Measure.";
        this.mPassNumbers = new int[]{3};
        this.mTypes = new int[]{1002};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode defaultMeasure;
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        ArrayList<BaseMember> projectedBaseMeasures = new ArrayList<BaseMember>();
        IXQEQueryNode cogMDXDefaultMeasure = nodeFactory.createNode(1092);
        MDXEdge[] edges = ((MDXQuery)node).getEdges();
        for (int setIndex = 0; setIndex < edges.length; ++setIndex) {
            MDXEdge edge = edges[setIndex];
            IXQEQueryNode[] muns = edge.getDescendantsOfType(1067, false);
            for (int munIndex = 0; munIndex < muns.length; ++munIndex) {
                int measureIndex;
                CogMDXGroup group;
                BaseMember baseMember = (BaseMember)muns[munIndex];
                if (!baseMember.getHierarchy().getDimension().isMeasuresDimension() || baseMember.isValueExpressionOperand() || !edge.isProjectedDescendant(baseMember) || (group = (CogMDXGroup)baseMember.getAncestorOfType(1027)) != null && group.isNonDetailGroupBodyValue()) continue;
                for (measureIndex = 0; measureIndex < projectedBaseMeasures.size() && !baseMember.isSameExpression((IXQEQueryNode)projectedBaseMeasures.get(measureIndex), false); ++measureIndex) {
                }
                if (measureIndex != projectedBaseMeasures.size()) continue;
                projectedBaseMeasures.add(baseMember);
            }
        }
        if (projectedBaseMeasures.size() == 1) {
            defaultMeasure = nodeFactory.deepCopyNode((IXQEQueryNode)projectedBaseMeasures.get(0));
        } else {
            ICube cube = ((MDXQuery)node).getReferencedCube();
            IHierarchy measureHierarchy = cube.getMeasuresHierarchy();
            defaultMeasure = MDXBuilder.buildMDXDefaultMemberExpr((IXQENodeFactory)nodeFactory, measureHierarchy);
        }
        cogMDXDefaultMeasure.addChild(defaultMeasure);
        node.addChild(cogMDXDefaultMeasure);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        if (node.getFirstChildByType(1092) != null) {
            this.traceQueryCondition(false, "The MDXQuery already has a CogMDXDefaultMeasure child node.", trace);
            return false;
        }
        ICube cube = ((MDXQuery)node).getReferencedCube();
        IHierarchy measureHierarchy = cube.getMeasuresHierarchy();
        if (measureHierarchy == null) {
            this.traceQueryCondition(false, "The cube does not have a measures hierarchy.", trace);
            return false;
        }
        this.traceQueryCondition(true, "The MDXQuery does not have a CogMDXDefaultMeasure child node.", trace);
        return true;
    }

    @Override
    public void dumpSpecificationReferences(XQETrace trace) {
        trace.beginElement("specification", -1);
        trace.attribute("type", "schema");
        trace.attribute("category", "semantic");
        trace.attribute("element", "default_measure_resolution");
        trace.endElement();
    }
}

