/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.olap.nestedlevelcalculation;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.olap.AbstractMDXMember;
import com.cognos.xqe.ast.olap.AbstractMDXNode;
import com.cognos.xqe.ast.olap.AbstractMDXSet;
import com.cognos.xqe.ast.olap.CogMDXGroup;
import com.cognos.xqe.ast.olap.MDXCalculatedMemberReference;
import com.cognos.xqe.ast.olap.MDXCrossjoin;
import com.cognos.xqe.ast.olap.MDXDefaultMember;
import com.cognos.xqe.ast.olap.MDXEdge;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.olap.MDXSet;
import com.cognos.xqe.ast.olap.TNodeUnbCompensation;
import com.cognos.xqe.ast.olap.util.MDXHierInfo;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.olap.nestedlevelcalculation.Util;
import com.cognos.xqe.transformation.olap.util.MDXBuilder;
import java.util.List;

public final class AddHierarchyToEdgeWithNLC
extends Transformation {
    public AddHierarchyToEdgeWithNLC() {
        this.mName = "Add a Hierarchy to the Edge with a Nested Level Calculation.";
        this.mPassNumbers = new int[]{24};
        this.mTypes = new int[]{1013};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        MDXCalculatedMemberReference calcRef = (MDXCalculatedMemberReference)node;
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        AbstractMDXNode root = (AbstractMDXNode)node.getAncestorOfType(1006);
        IHierarchy unrefHierarchy = null;
        MDXEdge[] edges = mdxQuery.getEdges();
        IHierarchy measuresHierarchy = mdxQuery.getReferencedCube().getMeasuresHierarchy();
        unrefHierarchy = edges.length == 1 && !mdxQuery.getReferencedHierarchiesOnEdgesAndDimLine().contains(measuresHierarchy) ? measuresHierarchy : mdxQuery.getUnreferencedHierarchy();
        if (!root.isProjectedDescendant((AbstractMDXNode)node)) {
            root = (AbstractMDXNode)node;
            AbstractMDXNode parent = (AbstractMDXNode)root.getParent();
            while (parent.isProjectedDescendant(root)) {
                root = parent;
                parent = (AbstractMDXNode)parent.getParent();
            }
        }
        this.addProjectedHierarchy(factory, root, unrefHierarchy, mdxQuery, root, calcRef, environment);
        if (Util.getHierarchyToMoveTheCalculationTo(calcRef) == null) {
            node.throwInternalError("Error creating a hierarchy to move the nested level calculation to.");
        }
    }

    private void addProjectedHierarchy(IXQENodeFactory factory, AbstractMDXNode node, IHierarchy hierarchy, MDXQuery mdxQuery, AbstractMDXNode root, MDXCalculatedMemberReference calcRef, PlanningEnvironment environment) {
        MDXHierInfo mdxHierInfo = node.getHierarchyInfo();
        if (mdxHierInfo.projectsHierarchy(hierarchy)) {
            return;
        }
        IXQEQueryNode[] children = node.getChildren();
        for (int i = 0; i < children.length; ++i) {
            IXQEQueryNode newFillerMember;
            AbstractMDXNode child = (AbstractMDXNode)children[i];
            if (node.getType() == 1027 && i == 0) {
                if (node.getNumberChildren() != 1) continue;
                if (node.isProjectedDescendant(calcRef) || child.isOfCategory(1039) && child.getNumberChildren() > 0 && child.getNumberChildren() == child.getNumberChildrenOfCategory(1069) + child.getNumberChildrenOfCategory(1022)) {
                    this.addProjectedHierarchy(factory, (AbstractMDXNode)node.getChild(0), hierarchy, mdxQuery, root, calcRef, environment);
                    continue;
                }
                newFillerMember = this.buildFillerMember(factory, hierarchy, mdxQuery, environment);
                MDXSet newSet = (MDXSet)factory.createNode(1039);
                newSet.addChild(newFillerMember);
                CogMDXGroup newCogMDXGroup = (CogMDXGroup)factory.createNode(1027);
                newCogMDXGroup.addChild(newSet);
                node.addChild(newCogMDXGroup);
                continue;
            }
            if (!root.isProjectedDescendant(child) || node.getType() == 1113 && i == 0) continue;
            if (child.getType() == 1080) {
                if (child.getNumberChildren() == 1) {
                    this.addProjectedHierarchy(factory, (AbstractMDXNode)child.getChild(0), hierarchy, mdxQuery, root, calcRef, environment);
                    continue;
                }
                this.addProjectedHierarchy(factory, (AbstractMDXNode)child.getChild(1), hierarchy, mdxQuery, root, calcRef, environment);
                continue;
            }
            if (child.getType() == 1027) {
                boolean firstChildIsProjectedDescendant;
                AbstractMDXNode firstChild;
                List<IXQEQueryNode> unbCompensations;
                if (child.getNumberChildren() == 2 && !(unbCompensations = (firstChild = (AbstractMDXNode)child.getChild(0)).getDescendantsOfTypeOrdered(1113, true)).isEmpty() && (firstChildIsProjectedDescendant = firstChild.isProjectedDescendant((AbstractMDXNode)unbCompensations.get(0)))) {
                    TNodeUnbCompensation unbCompensation = (TNodeUnbCompensation)unbCompensations.get(0);
                    this.addProjectedHierarchy(factory, unbCompensation, hierarchy, mdxQuery, root, calcRef, environment);
                }
                this.addProjectedHierarchy(factory, child, hierarchy, mdxQuery, root, calcRef, environment);
                continue;
            }
            if (child.getType() == 1069) {
                MDXDefaultMember newDefaultMember = MDXBuilder.buildMDXDefaultMemberExpr(factory, hierarchy);
                child.addChild(newDefaultMember);
                continue;
            }
            if (child.isOfCategory(1022)) {
                MDXDefaultMember newDefaultMember;
                AbstractMDXSet ancestorSet = Util.getAncestorSetForMovingTheCalculationToDiffHierarchy((AbstractMDXMember)child);
                if (ancestorSet != null && ancestorSet.getType() == 1027 && ancestorSet.getNumberChildren() == 1 && !Util.isInASetOFCalculations((AbstractMDXMember)child)) {
                    CogMDXGroup group = (CogMDXGroup)factory.createNode(1027);
                    ancestorSet.addChild(group);
                    newDefaultMember = MDXBuilder.buildMDXDefaultMemberExpr(factory, hierarchy);
                    MDXSet set = MDXBuilder.buildMDXSetExpr(factory, newDefaultMember);
                    group.addChild(set);
                    StringBuilder propertyValue = new StringBuilder("defaultMember");
                    propertyValue.append("_");
                    group.setRefDataItemProperty(propertyValue.toString());
                    continue;
                }
                IXQEQueryNode tuple = factory.createNode(1069);
                child.insertParent(tuple);
                newDefaultMember = MDXBuilder.buildMDXDefaultMemberExpr(factory, hierarchy);
                tuple.addChild(newDefaultMember);
                continue;
            }
            if (child.getType() == 1039) {
                this.addProjectedHierarchy(factory, child, hierarchy, mdxQuery, root, calcRef, environment);
                continue;
            }
            if (Util.projectesNLC(child) && child.getType() != 1030) {
                this.addProjectedHierarchy(factory, child, hierarchy, mdxQuery, root, calcRef, environment);
                continue;
            }
            if (child.getType() == 1042 || child.getType() == 1083) {
                this.addProjectedHierarchy(factory, child, hierarchy, mdxQuery, root, calcRef, environment);
                continue;
            }
            if (child.getType() == 1030) {
                AbstractMDXSet mdxCrossjoinSecondChild = (AbstractMDXSet)child.getChild(1);
                this.addProjectedHierarchy(factory, mdxCrossjoinSecondChild, hierarchy, mdxQuery, root, calcRef, environment);
                continue;
            }
            newFillerMember = this.buildFillerMember(factory, hierarchy, mdxQuery, environment);
            MDXCrossjoin newXJoin = (MDXCrossjoin)factory.createNode(1030);
            if (child.isOfCategory(1068)) {
                MDXSet newMDXSet = (MDXSet)factory.createNode(1039);
                child.insertParent(newMDXSet);
                child = newMDXSet;
            }
            child.insertParent(newXJoin);
            MDXSet newSet = (MDXSet)factory.createNode(1039);
            newSet.addChild(newFillerMember);
            newXJoin.addChild(newSet);
        }
    }

    private IXQEQueryNode buildFillerMember(IXQENodeFactory factory, IHierarchy hierarchy, MDXQuery mdxQuery, PlanningEnvironment environment) {
        if (hierarchy.getDimension().isMeasuresDimension()) {
            return MDXBuilder.buildNormalizationMeasureExpr(factory, hierarchy, mdxQuery);
        }
        return MDXBuilder.buildMDXDefaultMemberExpr(factory, hierarchy);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        MDXCalculatedMemberReference calcRef = (MDXCalculatedMemberReference)node;
        if (calcRef.getPropertyValue("originalHierarchy") != null && !calcRef.getPropertyValue("originalHierarchy").equals(calcRef.getHierarchy())) {
            this.traceNodeCondition(false, "The calculated member hierarchy has been change already.", trace);
            return false;
        }
        if (!calcRef.getDefinition().isNestedLevelCalc()) {
            this.traceNodeCondition(false, "The calculated member is not a grouped nested level expression.", trace);
            return false;
        }
        MDXEdge edge = (MDXEdge)calcRef.getAncestorOfType(1006);
        if (edge == null) {
            this.traceNodeCondition(false, "The calculation is not defined on an edge.", trace);
            return false;
        }
        if (Util.isNestedExprDependentOnCalc(calcRef)) {
            this.traceNodeCondition(false, "The nested expression is dependent on this calc.  Do not add a new dimension yet.", trace);
            return false;
        }
        if (Util.getHierarchyToMoveTheCalculationTo(calcRef) != null) {
            this.traceNodeCondition(false, "There is already a default member on a different hierarchy to move the calculated member to.", trace);
            return false;
        }
        if (!edge.isProjectedDescendant((AbstractMDXNode)node)) {
            this.traceNodeCondition(false, "Calculation is not a projected descendant of the edge.", trace);
            return false;
        }
        MDXQuery mdxQuery = (MDXQuery)node.getAncestorOfType(1002);
        IHierarchy unrefHierarchy = null;
        MDXEdge[] edges = mdxQuery.getEdges();
        IHierarchy measuresHierarchy = mdxQuery.getReferencedCube().getMeasuresHierarchy();
        unrefHierarchy = edges.length == 1 && !mdxQuery.getReferencedHierarchiesOnEdgesAndDimLine().contains(measuresHierarchy) ? measuresHierarchy : mdxQuery.getUnreferencedHierarchy();
        if (unrefHierarchy == null) {
            this.traceNodeCondition(true, "The are no unreferenced hierarchies available, cannot add a hierarchy to the edge.", trace);
            return false;
        }
        this.traceNodeCondition(true, "The edge needs another hierarchy to move the nested level calculation to.", trace);
        return true;
    }
}

